/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.IUserAccountSearchFilter;
import com.sap.security.api.UMException;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.imp.Util;
import java.util.Date;

public class UserAccountSearchFilter
extends PrincipalSearchFilter
implements IUserAccountSearchFilter {
    private Date _loggedinbetween1;
    private Date _loggedinbetween2;
    private Date _failedlogonbetween1;
    private Date _failedlogonbetween2;
    private Date _createdbetween1;
    private Date _createdbetween2;
    private Date _pwdchangebetween1;
    private Date _pwdchangebetween2;
    private Date _validfrombetween1;
    private Date _validtobetween1;
    private Date _validfrombetween2;
    private Date _validtobetween2;
    private Date _logoutbetween1;
    private Date _logoutbetween2;
    private static final String LOCKREASON = "lockreason";
    private static final String FAILED_LOGON_ATTEMPS = "failedlogonattempts";
    private static final String IS_LOCKED = "islocked";
    private static final String REQUIRED_PASSWORD_CHANGE = "passwordchangerequired";

    public UserAccountSearchFilter() {
        super("UACC");
        this.setLogonUid("*", 1, false);
        this.initialSet = true;
    }

    public String getLogonUid() {
        if (this.getSearchAttributes("com.sap.security.core.usermanagement", "j_user").length > 0) {
            return this.getSearchAttributes("com.sap.security.core.usermanagement", "j_user")[0];
        }
        return null;
    }

    public Date getLoggedInBetweenDate1() {
        return this._loggedinbetween1;
    }

    public Date getLoggedInBetweenDate2() {
        return this._loggedinbetween2;
    }

    public Date getValidFromBetweenDate1() {
        return this._validfrombetween1;
    }

    public Date getValidFromBetweenDate2() {
        return this._validfrombetween2;
    }

    public Date getValidToBetweenDate1() {
        return this._validtobetween1;
    }

    public Date getValidToBetweenDate2() {
        return this._validtobetween2;
    }

    public Date getLogoutBetweenDate1() {
        return this._logoutbetween1;
    }

    public Date getLogoutBetweenDate2() {
        return this._logoutbetween2;
    }

    public Date getPasswordChangeBetweenDate1() {
        return this._pwdchangebetween1;
    }

    public Date getPasswordChangeBetweenDate2() {
        return this._pwdchangebetween2;
    }

    public Date getFailedLogonBetweenDate1() {
        return this._failedlogonbetween1;
    }

    public Date getFailedLogonBetweenDate2() {
        return this._failedlogonbetween2;
    }

    public Date getCreatedBetweenDate1() {
        return this._createdbetween1;
    }

    public Date getCreatedBetweenDate2() {
        return this._createdbetween2;
    }

    public Integer getFailedLogonAttempts() {
        if (this.getSearchAttributes("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPS).length > 0) {
            String result = this.getSearchAttributes("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPS)[0];
            if (result != null) {
                return Integer.valueOf(result);
            }
            return Integer.valueOf("0");
        }
        return Integer.valueOf("0");
    }

    public Boolean isLocked() {
        if (this.getSearchAttributes("com.sap.security.core.usermanagement", IS_LOCKED).length > 0) {
            return Boolean.valueOf(this.getSearchAttributes("com.sap.security.core.usermanagement", IS_LOCKED)[0]);
        }
        return Boolean.FALSE;
    }

    public Boolean isPasswordChangeRequired() {
        if (this.getSearchAttributes("com.sap.security.core.usermanagement", REQUIRED_PASSWORD_CHANGE).length > 0) {
            return Boolean.valueOf(this.getSearchAttributes("com.sap.security.core.usermanagement", REQUIRED_PASSWORD_CHANGE)[0]);
        }
        return Boolean.FALSE;
    }

    public SearchCriteria getSearchCriteriaForDisplayName() throws UMException {
        SearchCriteria sc = new SearchCriteria(true, this.getSearchPrincipalType());
        int operatore = -1;
        Object value = null;
        boolean caseSensitive = true;
        boolean found = false;
        int i = 0;
        while (i < this.getElementSize() && !found) {
            ISearchAttribute sElement = this.getSearchElementAt(i);
            if (sElement.getAttributeName().equals("uniquename") && sElement.getAttributeNameSpace().equals("com.sap.security.core.usermanagement")) {
                found = true;
                operatore = sElement.getOperator();
                value = sElement.getAttributeValue();
                caseSensitive = sElement.isCaseSensitive();
            }
            ++i;
        }
        if (!found) {
            throw new UMException("Displayname attribute in searchfilter not found!");
        }
        switch (operatore) {
            case 0: {
                sc.addEqualsElement("com.sap.security.core.usermanagement", "j_user", value, caseSensitive);
                sc.addEqualsElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 1: {
                sc.addLikeElement("com.sap.security.core.usermanagement", "j_user", value, caseSensitive);
                sc.addLikeElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 2: {
                sc.addGreaterThanElement("com.sap.security.core.usermanagement", "j_user", value, caseSensitive);
                sc.addGreaterThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 3: {
                sc.addLessThanElement("com.sap.security.core.usermanagement", "j_user", value, caseSensitive);
                sc.addLessThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
            }
        }
        return sc;
    }

    public Integer getLockReason() {
        if (this.getSearchAttributes("com.sap.security.core.usermanagement", LOCKREASON).length > 0) {
            String result = this.getSearchAttributes("com.sap.security.core.usermanagement", LOCKREASON)[0];
            if (result != null) {
                return Integer.valueOf(result);
            }
            return Integer.valueOf("0");
        }
        return Integer.valueOf("0");
    }

    public void setLogonUid(String val, int mode, boolean caseSensitive) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", "j_user", val, mode, caseSensitive);
    }

    public void setLockReason(int val) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", LOCKREASON, "" + val, 0, false);
    }

    public void setLocked(boolean lock) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", IS_LOCKED, "" + lock, 0, true);
    }

    public void setPasswordChangeRequired(boolean passwordchangerequired) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", REQUIRED_PASSWORD_CHANGE, "" + passwordchangerequired, 0, true);
    }

    public void setFailedLogonAttempts(int val) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPS, "" + val, 0, true);
    }

    public void setCreateBetween(Date date1, Date date2) {
        this._createdbetween1 = date1;
        this._createdbetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", Util.getTime(date2.getTime()), 3, true);
    }

    public void setLoggedInBetween(Date date1, Date date2) {
        this._loggedinbetween1 = date1;
        this._loggedinbetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastsuccessfullogon", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastsuccessfullogon", Util.getTime(date2.getTime()), 3, true);
    }

    public void setFailedLogonBetween(Date date1, Date date2) {
        this._failedlogonbetween1 = date1;
        this._failedlogonbetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastfailedlogon", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastfailedlogon", Util.getTime(date2.getTime()), 3, true);
    }

    public void setPasswordChangeBetween(Date date1, Date date2) {
        this._pwdchangebetween1 = date1;
        this._pwdchangebetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastpasswordchange", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastpasswordchange", Util.getTime(date2.getTime()), 3, true);
    }

    public void setValidFromBetween(Date date1, Date date2) {
        this._validfrombetween1 = date1;
        this._validfrombetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "validfrom", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "validfrom", Util.getTime(date2.getTime()), 3, true);
    }

    public void setValidToBetween(Date date1, Date date2) {
        this._validtobetween1 = date1;
        this._validtobetween2 = date2;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "validto", Util.getTime(date1.getTime()), 2, true);
        this.setSearchAttribute("com.sap.security.core.usermanagement", "validto", Util.getTime(date2.getTime()), 3, true);
    }

    public void setLogoutBetween(Date date1, Date date2) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastlogout", Util.getTime(date1.getTime()), 2, true);
        this._logoutbetween1 = date1;
        this.setSearchAttribute("com.sap.security.core.usermanagement", "lastlogout", Util.getTime(date2.getTime()), 3, true);
        this._logoutbetween2 = date2;
    }

    public void clear() {
        super.clear();
        this._loggedinbetween1 = null;
        this._loggedinbetween2 = null;
        this._failedlogonbetween1 = null;
        this._failedlogonbetween2 = null;
        this._createdbetween1 = null;
        this._createdbetween2 = null;
        this._pwdchangebetween1 = null;
        this._pwdchangebetween2 = null;
        this._validfrombetween1 = null;
        this._validtobetween1 = null;
        this._validfrombetween2 = null;
        this._validtobetween2 = null;
        this._logoutbetween1 = null;
        this._logoutbetween2 = null;
    }
}

