/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.AuthenticationFailedException;
import com.sap.security.api.IConfigurable;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.ISecurityPolicy;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserAccountSearchFilter;
import com.sap.security.api.NoSuchUserAccountException;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UserAccountAlreadyExistsException;
import com.sap.security.api.UserAccountListener;
import com.sap.security.api.UserLockedException;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSearchFilter;
import com.sap.security.core.imp.AbstractUserAccount;
import com.sap.security.core.imp.DBTextFileUserAccount;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.imp.UserAccountSearchFilter;
import com.sap.security.core.imp.UserAccountWrapper;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.SuperUser;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.core.util.imp.Util;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class UserAccountFactory
extends PrincipalFactory
implements IUserAccountFactory,
IConfigurable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserAccountFactory.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserAccountFactory.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    public static final String DEFAULT_USERACCOUNT_CACHING_TIME = "ume.cache.user_account.default_caching_time";
    public static final String INITIAL_USERACCOUNT_CACHE_SIZE = "ume.cache.user_account.initial_cache_size";
    private static ICache mCache;
    private static Vector mAddUserAccountListeners;
    private static Vector mDeleteUserAccountListeners;
    private static Vector mUserAccountLoggedOutListeners;
    private static Hashtable mMappingCaches;
    static /* synthetic */ Class class$com$sap$security$core$imp$UserAccountFactory;

    public synchronized void initialize(Properties properties) throws UMException {
    }

    public static ICache getCache() {
        return mCache;
    }

    private static String getLogonIDMapping(String logonid, String[] datasources) {
        ICache cache = (ICache)mMappingCaches.get(UserAccountFactory.calculateCacheKey(datasources));
        if (cache != null) {
            return (String)cache.get(logonid);
        }
        return null;
    }

    private static String calculateCacheKey(String[] datasources) {
        StringBuffer cacheKey = new StringBuffer();
        if (datasources != null) {
            int size = datasources.length;
            int i = 0;
            while (i < size) {
                cacheKey.append(datasources[i]);
                cacheKey.append("_");
                ++i;
            }
        } else {
            cacheKey.append("ALL_DATASOURCES_");
        }
        return cacheKey.toString();
    }

    private static void addLogonIDMapping(String logonid, String uniqueID, String[] datasources) {
        String cacheKey = UserAccountFactory.calculateCacheKey(datasources);
        ICache cache = (ICache)mMappingCaches.get(cacheKey);
        if (cache == null) {
            IUMParameters props = UMFactory.getProperties();
            int maxLifeTime = props.getNumber(DEFAULT_USERACCOUNT_CACHING_TIME, 28800);
            int initialSize = props.getNumber(INITIAL_USERACCOUNT_CACHE_SIZE, 500);
            cache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$UserAccountFactory == null ? (class$com$sap$security$core$imp$UserAccountFactory = UserAccountFactory.class$("com.sap.security.core.imp.UserAccountFactory")) : class$com$sap$security$core$imp$UserAccountFactory).getName() + "_mMappingCaches(" + cacheKey + ")");
        }
        cache.put(logonid, uniqueID);
        mMappingCaches.put(cacheKey, cache);
    }

    public static synchronized void invalidateCache() {
        mCache.invalidate();
        mMappingCaches = new Hashtable();
    }

    public static synchronized void invalidateLogonIDMapping(String logonID) {
        boolean allDone = false;
        while (!allDone) {
            try {
                Enumeration en = mMappingCaches.keys();
                while (en.hasMoreElements()) {
                    String cacheKey = (String)en.nextElement();
                    ICache dummy = (ICache)mMappingCaches.get(cacheKey);
                    dummy.invalidateLocally(logonID);
                }
                allDone = true;
            }
            catch (ConcurrentModificationException cmex) {
                allDone = false;
                if (!mTrace.beDebug()) continue;
                mTrace.debugT("invalidateLogonIDMapping", cmex);
            }
        }
    }

    public static synchronized void createLogonIDMapping(String logonID, String uniqueID) {
        UserAccountFactory.addLogonIDMapping(logonID, uniqueID, null);
    }

    public static synchronized void invalidateUserAccountInCache(String uniqueID) {
        mCache.invalidate(uniqueID);
    }

    public static synchronized void invalidateUserAccountInCacheLocally(String uniqueID) {
        mCache.invalidateLocally(uniqueID);
    }

    public void replaceUserAccountInCache(IUserAccount userAccount) {
        String id = userAccount.getUniqueID();
        mCache.invalidate(id);
        mCache.put(id, userAccount);
    }

    public void replaceUserAccountInCacheLocally(IUserAccount userAccount) {
        String id = userAccount.getUniqueID();
        mCache.invalidateLocally(id);
        mCache.put(id, userAccount);
    }

    public static void addUserAccountPerformed(String uniqueID) throws UMException {
        int size = mAddUserAccountListeners.size();
        int i = 0;
        while (i < size) {
            ((UserAccountListener)mAddUserAccountListeners.elementAt(i)).userAccountAdded(uniqueID);
            ++i;
        }
        PrincipalFactory.addPrincipalPerformed(uniqueID);
    }

    public static void removeUserAccountPerformed(String uniqueID) throws UMException {
        int size = mDeleteUserAccountListeners.size();
        int i = 0;
        while (i < size) {
            ((UserAccountListener)mDeleteUserAccountListeners.elementAt(i)).userAccountRemoved(uniqueID);
            ++i;
        }
        PrincipalFactory.removePrincipalPerformed(uniqueID);
    }

    public static void userAccountLogOutPerformed(String uniqueID) throws UMException {
        int size = mUserAccountLoggedOutListeners.size();
        int i = 0;
        while (i < size) {
            ((UserAccountListener)mUserAccountLoggedOutListeners.elementAt(i)).userAccountLogOut(uniqueID);
            ++i;
        }
    }

    public IUserAccount newUserAccount(String logonid, String user) throws UserAccountAlreadyExistsException, PersistenceException, UMException {
        ISecurityPolicy sp = UMFactory.getSecurityPolicy();
        if (!sp.isLogonIdValid(logonid)) {
            throw new UMException("INVALID_UID");
        }
        return this.newServiceUserAccount(logonid, user);
    }

    public IUserAccount newServiceUserAccount(String logonid, String user) throws UserAccountAlreadyExistsException, PersistenceException, UMException {
        DBTextFileUserAccount newUserAccount = new DBTextFileUserAccount();
        newUserAccount.setLogonUid(logonid);
        newUserAccount.assignUser(user);
        return newUserAccount;
    }

    public IUserAccount newUserAccount(String logonid) throws UMException {
        throw new UMException("Creation of user account without assigned user is not supported!!!");
    }

    private IUserAccount checkUserAccountByLogonId(String logonid) {
        IUserAccount ua;
        block2: {
            ua = null;
            try {
                ua = this.getUserAccountByLogonId(logonid);
            }
            catch (UMException ex) {
                ua = null;
                if (!mTrace.beDebug()) break block2;
                mTrace.debugT("checkUserAccountByLogonId", ex);
            }
        }
        return ua;
    }

    public IUserAccount getUserAccountByLogonId(String logonId, String[] dataSources, AttributeList attrlist) throws UMException {
        return this.getUserAccountByLogonId(logonId, dataSources, false, attrlist);
    }

    public IUserAccount getUserAccountByLogonId(String logonId, String[] dataSources, boolean readFromPersistence, AttributeList attrlist) throws UMException {
        String methodName = "getUserAccountByLogonId";
        if (mTrace.beDebug()) {
            mTrace.entering("getUserAccountByLogonId");
        }
        if (logonId == null) {
            throw new NoSuchUserAccountException("Cannot find user when logonid is null!");
        }
        IUserAccount userAccount = null;
        String uniqueID = UserAccountFactory.getLogonIDMapping(logonId, dataSources);
        if (uniqueID != null) {
            if (mTrace.beDebug()) {
                mTrace.debugT("getUserAccountByLogonId", "Found uniqueID for logonId " + logonId);
            }
            if (!readFromPersistence) {
                userAccount = (IUserAccount)mCache.get(uniqueID);
            }
            if (userAccount != null) {
                if (mTrace.beDebug()) {
                    mTrace.exiting("getUserAccountByLogonId", "userAccount from cache");
                }
                return new UserAccountWrapper(userAccount, attrlist);
            }
        }
        try {
            userAccount = uniqueID != null ? new DBTextFileUserAccount(uniqueID, attrlist, false) : (SuperUser.SUPERUSER_IS_ACTIVE ? (logonId.equalsIgnoreCase("SAP*") ? new DBTextFileUserAccount("UACC.SUPERUSER_DATASOURCE.SAPASTERISK", attrlist, false) : new DBTextFileUserAccount(logonId, attrlist, true, dataSources)) : new DBTextFileUserAccount(logonId, attrlist, true, dataSources));
        }
        catch (UMException umrex) {
            UserAccountFactory.invalidateLogonIDMapping(logonId);
            throw umrex;
        }
        if (readFromPersistence) {
            mCache.invalidate(userAccount.getUniqueID());
        }
        mCache.put(userAccount.getUniqueID(), userAccount);
        UserAccountFactory.addLogonIDMapping(logonId, userAccount.getUniqueID(), dataSources);
        if (mTrace.beDebug()) {
            mTrace.exiting("getUserAccountByLogonId");
        }
        return new UserAccountWrapper(userAccount, attrlist);
    }

    public IUserAccount getUserAccountByLogonId(String logonId) throws UMException {
        return this.getUserAccountByLogonId(logonId, null);
    }

    public IUserAccount getUserAccountByLogonId(String logonId, AttributeList attrlist) throws UMException {
        return this.getUserAccountByLogonId(logonId, null, attrlist);
    }

    public IUserAccount getUserAccount(String uniqueId) throws UMException {
        return this.getUserAccount(uniqueId, AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES);
    }

    public IUserAccount getUserAccount(String uniqueId, AttributeList attributeList) throws UMException {
        IUserAccount userAccount = this.getReadonlyUserAccount(uniqueId, attributeList);
        return new UserAccountWrapper(userAccount, attributeList);
    }

    public IUserAccount getReadonlyUserAccount(String uniqueId) throws UMException {
        return this.getReadonlyUserAccount(uniqueId, AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES);
    }

    public IUserAccount getReadonlyUserAccount(String uniqueId, AttributeList attrList) throws UMException {
        if (uniqueId == null) {
            throw new NoSuchUserAccountException("Cannot find user when uniqueID is null!");
        }
        if (attrList == null) {
            return this.getReadonlyUserAccount(uniqueId);
        }
        IUserAccount userAccount = (IUserAccount)mCache.get(uniqueId);
        AttributeList attributeToPopulate = attrList;
        if (userAccount == null || !((AbstractPrincipal)userAccount).allAttributesPopulated(attrList)) {
            if (userAccount != null) {
                attributeToPopulate = ((AbstractPrincipal)userAccount).getPopulatedAttributes().getNotContainedAttributes(attrList);
                if (attributeToPopulate.getSize() != 0) {
                    IPrincipalDatabag pdb = PrincipalDatabagFactory.getInstance().getPrincipalDatabag(userAccount.getUniqueID(), attributeToPopulate, true);
                    if (pdb == null) {
                        throw new NoSuchUserAccountException("User account \"" + userAccount.getUniqueID() + "\" doesn't exist.");
                    }
                    IPrincipalDatabag pd = ((AbstractPrincipal)userAccount).getPrincipalDatabag();
                    PrincipalDatabag npd = new PrincipalDatabag(userAccount.getUniqueID());
                    npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                    npd.mergePrincipalDatabag((IInternalPrincipalDatabag)pdb);
                    DBTextFileUserAccount uacc = new DBTextFileUserAccount(npd);
                    this.replaceUserAccountInCacheLocally(uacc);
                    userAccount = uacc;
                }
                return userAccount;
            }
            if (!"IUserAccount".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueId))) {
                throw new NoSuchUserAccountException("The given id \"" + uniqueId + "\"is not a unique id of a user account!");
            }
            userAccount = new DBTextFileUserAccount(uniqueId, attributeToPopulate, false);
            mCache.put(uniqueId, userAccount);
        }
        return userAccount;
    }

    public IUserAccount[] getUserAccounts(String uniqueIDOfUser) throws UMException {
        return this.getUserAccounts(uniqueIDOfUser, null);
    }

    public IUserAccount[] getUserAccounts(String uniqueIDOfUser, AttributeList attrlist) throws UMException {
        if (uniqueIDOfUser == null) {
            throw new UMException("No user given!");
        }
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        SearchCriteria sc = new SearchCriteria("UACC");
        sc.addEqualsElement("com.sap.security.core.usermanagement", "userid", uniqueIDOfUser, true);
        Vector searchResult = mFactory.searchPrincipalDatabags(sc);
        int size = searchResult.size();
        IUserAccount[] result = new IUserAccount[size];
        Vector<String> accountsToPopulate = new Vector<String>();
        IUserAccount uacc = null;
        int i = 0;
        while (i < size) {
            uacc = (IUserAccount)mCache.get((String)searchResult.elementAt(i));
            if (uacc != null) {
                result[i] = new UserAccountWrapper(uacc, attrlist);
            } else {
                accountsToPopulate.add((String)searchResult.elementAt(i));
            }
            ++i;
        }
        if (accountsToPopulate.size() != 0) {
            IPrincipalDatabag[] accounts = null;
            accounts = attrlist == null ? mFactory.getPrincipalDatabags(accountsToPopulate.toArray(new String[accountsToPopulate.size()]), AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES, true) : mFactory.getPrincipalDatabags(accountsToPopulate.toArray(new String[accountsToPopulate.size()]), attrlist, true);
            int dataBagCounter = 0;
            int i2 = 0;
            while (i2 < size) {
                if (result[i2] == null) {
                    if (accounts[dataBagCounter] != null) {
                        DBTextFileUserAccount nuacc = new DBTextFileUserAccount(accounts[dataBagCounter]);
                        result[i2] = new UserAccountWrapper(nuacc, attrlist);
                        mCache.put(nuacc.getUniqueID(), nuacc);
                    }
                    ++dataBagCounter;
                }
                ++i2;
            }
        }
        return result;
    }

    private IUserAccount getUserAccount(X509Certificate cert, String[] dataSources) throws CertificateException, UMException, TicketException {
        return this.getUserAccount(cert, AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES, dataSources, false);
    }

    private IUserAccount getUserAccount(X509Certificate cert, AttributeList attrlist, String[] dataSources, boolean readFromPersistence) throws CertificateException, UMException, TicketException {
        if (cert == null) {
            throw new NoSuchUserAccountException("NO_CERTIFICATE");
        }
        Vector sr = null;
        byte[] dummy = null;
        try {
            dummy = cert.getEncoded();
        }
        catch (CertificateException cex) {
            mTrace.errorT("getUserAccount", "Error while accessing certificate: " + cex.getMessage());
            throw new NoSuchUserAccountException("CERT_GET_ERROR");
        }
        SearchCriteria sc = new SearchCriteria(true, "UACC", dataSources);
        sc.addEqualsElement("com.sap.security.core.usermanagement", "certificatehash", Base64.encode(Util.createMD5HashValue(dummy)), true);
        sc.addEqualsElement("com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate", cert, true);
        try {
            sr = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        }
        catch (PersistenceException ex) {
            throw new UMException((Throwable)((Object)ex));
        }
        if (sr != null) {
            int size = sr.size();
            if (size == 0) {
                String errorMessage = "User account for certificate " + cert.toString() + " not found!";
                if (mTrace.beInfo()) {
                    mTrace.infoT("getUserAccount", errorMessage);
                }
                throw new NoSuchUserAccountException("NO_USER_CERTIFICATE");
            }
            if (size > 1) {
                throw new NoSuchUserAccountException("CERT_NOT_UNIQUE");
            }
            String internalID = (String)sr.firstElement();
            if (internalID == null) {
                throw new NoSuchUserAccountException("NO_USER_CERTIFICATE");
            }
            if (!readFromPersistence) {
                return this.getUserAccount(internalID, attrlist);
            }
            DBTextFileUserAccount uacc = new DBTextFileUserAccount(internalID, attrlist, false, dataSources);
            mCache.put(internalID, uacc);
            return new UserAccountWrapper(uacc, attrlist);
        }
        String errorMessage = "User account for certificate " + cert.toString() + " not found!";
        if (mTrace.beInfo()) {
            mTrace.infoT("getUserAccount", errorMessage);
        }
        throw new NoSuchUserAccountException("NO_USER_CERTIFICATE");
    }

    public IUserAccount getUserAccount(X509Certificate cert) throws CertificateException, UMException, TicketException {
        return this.getUserAccount(cert, null);
    }

    public IUserAccount getAuthenticatedUserAccount(Map credentials) throws UMException, AuthenticationFailedException, UserLockedException, CertificateException, TicketException {
        IUserAccount account = null;
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        if (credentials.containsKey("javax.servlet.request.X509Certificate")) {
            X509Certificate cert = (X509Certificate)credentials.get("javax.servlet.request.X509Certificate");
            String[] dataSources = (String[])credentials.get("dataSourceIDs");
            Hashtable<String, Object> cred = new Hashtable<String, Object>();
            cred.put("javax.servlet.request.X509Certificate", cert);
            if (dataSources != null) {
                cred.put("dataSourceIDs", dataSources);
            }
            if (!mFactory.checkCredentials(cred)) {
                throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException("No account found for certificate " + cert.toString())), "CERT_AUTH_FAILED");
            }
            account = this.getUserAccount(cert, AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES, dataSources, true);
            if (account.isLocked()) {
                throw new UserLockedException("ACCOUNT_LOCKED_ADMIN");
            }
        } else if (credentials.containsKey("j_user")) {
            String uniqueID;
            String login = (String)credentials.get("j_user");
            String password = (String)credentials.get("j_password");
            String testmode = (String)credentials.get("ume.testmode");
            String[] dataSources = (String[])credentials.get("dataSourceIDs");
            Hashtable<String, Object> cred = new Hashtable<String, Object>();
            cred.put("j_user", login);
            cred.put("j_password", password);
            if (dataSources != null) {
                cred.put("dataSourceIDs", dataSources);
            }
            if (SuperUser.SUPERUSER_IS_ACTIVE && testmode == null) {
                if (login.equalsIgnoreCase("SAP*")) {
                    account = this.getUserAccount("UACC.SUPERUSER_DATASOURCE.SAPASTERISK");
                    if (account != null) {
                        if (SuperUser.checkPassword(password)) {
                            return account;
                        }
                        throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException("Given password for account SAP* is wrong.")), "USER_AUTH_FAILED");
                    }
                    String errorMessage = "Cannot create UserAccount object for SAP*";
                    throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
                }
                String errorMessage = "SAP* is active on this system. No other other user can login unless SAP* is disabled!";
                if (mTrace.beWarning()) {
                    mTrace.warningT("getAuthenticatedUserAccount", errorMessage);
                }
                throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException(errorMessage)), "SAPSTAR_ACTIVATED");
            }
            if (account == null) {
                account = credentials.get("uniqueIDOfPrincipal") == null ? this.getUserAccountByLogonId(login, dataSources, true, null) : this.getUserAccount((String)credentials.get("uniqueIDOfPrincipal"));
            }
            if (account != null && (uniqueID = account.getUniqueID()) != null) {
                String[] idParts = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getPrincipalIdParts(uniqueID);
                cred.put("dataSourceIDs", new String[]{idParts[1]});
                cred.put("uniqueIDOfPrincipal", uniqueID);
            }
            ISecurityPolicy securityPolicy = UMFactory.getSecurityPolicy();
            if (!mFactory.checkCredentials(cred)) {
                if (account != null) {
                    IUserAccount musUAcc = this.getMutableUserAccount(account.getUniqueID());
                    musUAcc.incrementFailedLogonAttempts();
                    musUAcc.setLastFailedLogonDate(new Date());
                    if (securityPolicy.getLockAfterInvalidAttempts() > 0 && musUAcc.getFailedLogonAttempts() >= securityPolicy.getLockAfterInvalidAttempts()) {
                        musUAcc.setLocked(true, 1);
                    }
                    musUAcc.commit();
                }
                throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException("Account for \"" + login + "\" not found or the given password is wrong.")), "USER_AUTH_FAILED");
            }
            Date validFromDate = account.getValidFromDate();
            Date validToDate = account.getValidToDate();
            Date current = new Date();
            if (validFromDate != null && current.compareTo(validFromDate) < 0) {
                throw new AuthenticationFailedException((Throwable)new UMException("Useraccount " + login + " is not valid."), "USER_AUTH_FAILED");
            }
            if (validToDate != null && current.compareTo(validToDate) > 0) {
                throw new AuthenticationFailedException((Throwable)new UMException("Useraccount " + login + " is not valid."), "USER_AUTH_FAILED");
            }
            if (account.isLocked() && account.getLockReason() == 2) {
                throw new UserLockedException("ACCOUNT_LOCKED_ADMIN");
            }
            boolean bAutoLock = false;
            Date failedLogonDate = account.getLastFailedLogonDate();
            Date successfulLogonDate = account.getLastSuccessfulLogonDate();
            if (securityPolicy.getLockAfterInvalidAttempts() > 0 && account.getFailedLogonAttempts() >= securityPolicy.getLockAfterInvalidAttempts() && failedLogonDate != null && (successfulLogonDate == null || failedLogonDate.compareTo(successfulLogonDate) > 0)) {
                int unlockTimeInMinutes = securityPolicy.getAutoUnlockTime();
                if (current.getTime() - failedLogonDate.getTime() < (long)(unlockTimeInMinutes * 60 * 1000)) {
                    bAutoLock = true;
                }
            }
            if (bAutoLock) {
                IUserAccount musUAcc = this.getMutableUserAccount(account.getUniqueID());
                musUAcc.setLocked(true, 1);
                musUAcc.commit();
                throw new UserLockedException("ACCOUNT_LOCKED_LOGON");
            }
            if (1 == account.getLockReason()) {
                IUserAccount musUAcc = this.getMutableUserAccount(account.getUniqueID());
                musUAcc.setLocked(false, 1);
                musUAcc.commit();
            }
            if (account.isPasswordChangeRequired()) {
                throw new AuthenticationFailedException((Throwable)((Object)new PersistenceException("Password of account \"" + login + "\" has to be changed.")), "PASSWORD_EXPIRED");
            }
        }
        return account;
    }

    public IUserAccount getUserAccount(Map credentials) throws UMException, CertificateException {
        String login = (String)credentials.get("j_user");
        IUserAccount account = this.getUserAccountByLogonId(login, (String[])credentials.get("dataSourceIDs"), null);
        return account;
    }

    public void deleteUserAccount(String accountId) throws UMException {
        if (accountId == null) {
            throw new UMException("No user account given!");
        }
        IUserAccount account = this.getUserAccount(accountId);
        UserAccountFactory.invalidateLogonIDMapping(account.getLogonUid());
        ((AbstractUserAccount)((UserAccountWrapper)account).getWrappedPrincipal()).delete();
        Object var2_2 = null;
    }

    public ISearchResult search(IUserAccountSearchFilter uasf) throws UMException {
        if (((AbstractPrincipalSearchFilter)uasf).containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        SearchCriteria sc = null;
        if (((PrincipalSearchFilter)uasf).isDisplayNameSet()) {
            sc = ((PrincipalSearchFilter)uasf).getSearchCriteriaForDisplayName();
        } else {
            sc = uasf.getSearchMethod() == 0 ? new SearchCriteria(false, "UACC") : new SearchCriteria(true, "UACC");
            int i = 0;
            while (i < uasf.getElementSize()) {
                ISearchAttribute sElement = uasf.getSearchElementAt(i);
                String _nameSpace = sElement.getAttributeNameSpace();
                String _attributeName = sElement.getAttributeName();
                Object _attributeValue = sElement.getAttributeValue();
                switch (sElement.getOperator()) {
                    case 0: {
                        sc.addEqualsElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 1: {
                        sc.addLikeElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 3: {
                        sc.addLessThanElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 2: {
                        sc.addGreaterThanElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                    }
                }
                ++i;
            }
        }
        sc.setSearchSizeLimit(uasf.getMaxSearchResultSize());
        Vector results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(results, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
        principalIterator.setState(sc.getSearchStatus());
        return principalIterator;
    }

    public IUserAccount getMutableUserAccount(String uniqueId) throws UMException {
        if (uniqueId == null) {
            throw new NoSuchUserException("Cannot find user when uniqueID is null!");
        }
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IUserAccount u = this.getReadonlyUserAccount(uniqueId);
        IPrincipalDatabag p = null;
        if (u != null) {
            p = ((AbstractPrincipal)u).getPrincipalDatabag();
        } else {
            p = new PrincipalDatabag(uniqueId);
            if (!mFactory.principalDatabagExists(p)) {
                throw new NoSuchUserAccountException("user account " + uniqueId + " does not exist");
            }
        }
        DBTextFileUserAccount result = new DBTextFileUserAccount(mFactory.getModifyPrincipalDatabag(p));
        result.prepare();
        return result;
    }

    public IUserAccountSearchFilter getUserAccountSearchFilter() throws UMException {
        return new UserAccountSearchFilter();
    }

    public void registerListener(UserAccountListener userAccountListener, int modifier) {
        boolean registered = false;
        if ((modifier & 1) == 1) {
            mAddUserAccountListeners.add(userAccountListener);
            registered = true;
        }
        if ((modifier & 2) == 2) {
            mDeleteUserAccountListeners.add(userAccountListener);
            registered = true;
        }
        if ((modifier & 4) == 4) {
            mUserAccountLoggedOutListeners.add(userAccountListener);
            registered = true;
        }
        if (!registered) {
            mTrace.warningT("registerListener", "UserAccountListener " + userAccountListener + " could not be registered!");
        }
    }

    public void unregisterListener(UserAccountListener userAccountListener) {
        mAddUserAccountListeners.remove(userAccountListener);
        mDeleteUserAccountListeners.remove(userAccountListener);
        mUserAccountLoggedOutListeners.remove(userAccountListener);
    }

    public void invalidateCacheEntryByLogonId(String logonid) throws UMException {
        String uniqueID = UserAccountFactory.getLogonIDMapping(logonid, null);
        if (uniqueID == null) {
            SearchCriteria sc = new SearchCriteria(false, "UACC");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "j_user", logonid, false);
            Vector sr = null;
            try {
                sr = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            }
            catch (PersistenceException ex) {
                throw new UMException((Throwable)((Object)ex));
            }
            if (sr != null) {
                int size = sr.size();
                if (size == 1) {
                    uniqueID = (String)sr.elementAt(0);
                    mCache.invalidateLocally(uniqueID);
                    UserAccountFactory.addLogonIDMapping(logonid, uniqueID, null);
                } else {
                    UserAccountFactory.invalidateLogonIDMapping(logonid);
                    int i = 0;
                    while (i < size) {
                        uniqueID = (String)sr.elementAt(i);
                        mCache.invalidateLocally(uniqueID);
                        ++i;
                    }
                }
            }
        } else {
            mCache.invalidateLocally(uniqueID);
        }
    }

    public void invalidateCacheEntry(String uniqueid) throws UMException {
        mCache.invalidateLocally(uniqueid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = props.getNumber(DEFAULT_USERACCOUNT_CACHING_TIME, 28800);
        int initialSize = props.getNumber(INITIAL_USERACCOUNT_CACHE_SIZE, 500);
        mCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$UserAccountFactory == null ? (class$com$sap$security$core$imp$UserAccountFactory = UserAccountFactory.class$("com.sap.security.core.imp.UserAccountFactory")) : class$com$sap$security$core$imp$UserAccountFactory).getName() + "_mCache");
        mAddUserAccountListeners = new Vector();
        mDeleteUserAccountListeners = new Vector();
        mUserAccountLoggedOutListeners = new Vector();
        mMappingCaches = new Hashtable();
    }
}

