/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IRole;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.UserAdminHelper;
import com.sap.security.core.imp.Principal;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.UserMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.PermissionData;
import com.sap.security.core.role.imp.PermissionRoles;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class User
extends Principal
implements IUser {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/User.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/User.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    public static final String NAME = "name";
    public static final String SALUTATION = "salutation";
    public static final String TITLE = "title";
    public static final String JOBTITLE = "jobtitle";
    public static final String COMPANY = "company";
    public static final String COMPANYID = "companyid";
    public static final String DEPARTMENT = "department";
    public static final String POSITION = "position";
    public static final String CURRENCY = "currency";
    public static final String EMAIL = "email";
    public static final String TELEPHONE = "telephone";
    public static final String MOBILE = "mobile";
    public static final String FAX = "fax";
    public static final String STREETADDRESS = "streetaddress";
    public static final String CITY = "city";
    public static final String ZIP = "zip";
    public static final String POBOX = "pobox";
    public static final String COUNTRY = "country";
    public static final String STATE = "state";
    public static final String DATEFORMAT = "dateformat";
    public static final String LOCALE = "locale";
    public static final String TIMEZONE = "timezone";
    public static final String ACCESSIBILITYLEVEL = "accessibilitylevel";
    public static final String REFERENCEUSER = "referenceuser";
    public static final String ANONYMOUS = "anonymous";
    public static final String DISPLAYNAME_TEMPLATE = "ume.users.displayname_template";
    public static final String DEFAULT_DISPLAYNAME_TEMPLATE = "{lastname}, {firstname}";
    public static AttributeList USER_DEFAULT_ATTRIBUTES = new AttributeList(false);
    private transient Map _permissionsCache = null;
    private transient PermissionData[] _permissionsData = null;
    private Vector mAccountIDs = null;
    protected Locale mLocale = null;
    private TimeZone mTimeZone = null;

    public User(String uniqueID) {
        this(uniqueID, true);
    }

    public User(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public User(String uniqueID, boolean checkExistence) {
        super(uniqueID, checkExistence, null);
    }

    public User(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        super(uniqueID, checkExistence, populateAttributes);
    }

    public User(IPrincipalDatabag principal) {
        this.mPrincipalDatabag = principal;
    }

    public synchronized void refresh() throws UMException {
        super.refresh();
        this._permissionsCache = null;
        this._permissionsData = null;
    }

    protected synchronized void init(String uniqueID) {
        if (this.mAttributeList == null) {
            this.mAttributeList = USER_DEFAULT_ATTRIBUTES;
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
            boolean checkExistence = this.mAttributeList.getSize() != 1 || !this.mAttributeList.getNameSpaceOfAttributeAt(0).equals("com.sap.security.core.usermanagement") || !this.mAttributeList.getAttributeNameOfAttributeAt(0).equals("uniquename");
            this.mPrincipalDatabag = this.mFactory.getPrincipalDatabag(uniqueID, this.mAttributeList, checkExistence);
        }
        catch (PersistenceException ex) {
            if (trace.beError()) {
                trace.errorT("init", "Error while populating \"" + uniqueID + "\"", (Throwable)((Object)ex));
            }
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (this.mPrincipalDatabag == null) {
            throw new UMRuntimeException("User " + uniqueID + " doesn't exist!");
        }
        this.mExistenceNotChecked = false;
    }

    protected User() {
    }

    public void save() throws UMException {
        throw new UMRuntimeException("User " + this.getUniqueID() + " doesn't support the save() method!");
    }

    public void commit() throws UMException {
        throw new UMRuntimeException("User " + this.getUniqueID() + " doesn't support the commit() method!");
    }

    public String getUid() {
        return this.mPrincipalDatabag.getUniqueID();
    }

    public String getJobTitle() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", JOBTITLE);
    }

    public IUserAccount[] getUserAccounts() throws UMException {
        if (this.mAccountIDs == null || this.mAccountIDs.isEmpty()) {
            Vector<String> accountIDs = new Vector<String>();
            IUserAccount[] accounts = UMFactory.getUserAccountFactory().getUserAccounts(this.getUniqueID());
            if (accounts != null) {
                int i = 0;
                while (i < accounts.length) {
                    accountIDs.add(accounts[i].getUniqueID());
                    ++i;
                }
            }
            if (accountIDs.isEmpty() && trace.beWarning()) {
                trace.warningT("getUserAccounts", "User \"" + this.getUniqueID() + "\" (uniquename=\"" + this.getUniqueName() + "\") has no account assigned.");
            }
            this.mAccountIDs = accountIDs;
            return accounts;
        }
        Vector resultVector = (Vector)this.mAccountIDs.clone();
        int size = resultVector.size();
        IUserAccount[] result = new IUserAccount[size];
        int i = 0;
        while (i < size) {
            result[i] = UMFactory.getUserAccountFactory().getUserAccount((String)resultVector.elementAt(i));
            ++i;
        }
        return result;
    }

    public String getDepartment() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", DEPARTMENT);
    }

    public String getDisplayName() {
        String displayName;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((displayName = this.getAttributeValueString("com.sap.security.core.usermanagement", "displayname")) == null) {
            block18: {
                IUserAccount[] accounts;
                String displayNameTemplate = UMFactory.getProperties().get(DISPLAYNAME_TEMPLATE, DEFAULT_DISPLAYNAME_TEMPLATE);
                boolean allTokensOK = true;
                String currentToken = null;
                String[] currentValues = null;
                int startIndex = displayNameTemplate.indexOf(123);
                int endIndex = displayNameTemplate.indexOf(125, startIndex);
                boolean hasMoreTokens = endIndex > startIndex;
                StringBuffer result = new StringBuffer();
                int index = 0;
                while (hasMoreTokens && allTokensOK) {
                    block17: {
                        result.append(displayNameTemplate.substring(index, startIndex));
                        currentToken = displayNameTemplate.substring(startIndex + 1, endIndex);
                        if (currentToken.equals("j_user")) {
                            try {
                                accounts = this.getUserAccounts();
                                if (accounts != null && accounts.length > 0) {
                                    result.append(accounts[0].getLogonUid());
                                    break block17;
                                }
                                allTokensOK = false;
                            }
                            catch (UMException umex) {
                                allTokensOK = false;
                                if (trace.beDebug()) {
                                    trace.debugT("getDisplayName", umex);
                                }
                                break block17;
                            }
                        }
                        currentValues = this.getAttribute("com.sap.security.core.usermanagement", currentToken);
                        if (currentValues != null && currentValues.length != 0 && currentValues[0] != null) {
                            result.append(currentValues[0]);
                        } else {
                            allTokensOK = false;
                        }
                    }
                    index = endIndex + 1;
                    startIndex = displayNameTemplate.indexOf(123, index);
                    endIndex = displayNameTemplate.indexOf(125, startIndex);
                    boolean bl = hasMoreTokens = endIndex > startIndex && startIndex != -1;
                    if (hasMoreTokens) continue;
                    result.append(displayNameTemplate.substring(index, displayNameTemplate.length()));
                }
                if (index == 0) {
                    result.append(displayNameTemplate);
                }
                if (allTokensOK) {
                    return result.toString();
                }
                try {
                    accounts = this.getUserAccounts();
                    String logonid = null;
                    if (accounts != null && accounts.length > 0) {
                        int i = 0;
                        while (i < accounts.length) {
                            logonid = accounts[i].getLogonUid();
                            if (logonid != null) {
                                return logonid;
                            }
                            ++i;
                        }
                    }
                }
                catch (UMException umex) {
                    if (!trace.beDebug()) break block18;
                    trace.debugT("getDisplayName", umex);
                }
            }
            return this.getUniqueName();
        }
        return displayName;
    }

    public String getTitle() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", TITLE);
    }

    public String getSalutation() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", SALUTATION);
    }

    public String getFirstName() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", FIRSTNAME);
    }

    public String getLastName() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", LASTNAME);
    }

    public String getStreet() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", STREETADDRESS);
    }

    public String getCity() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", CITY);
    }

    public String getZip() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", ZIP);
    }

    public String getState() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", STATE);
    }

    public String getCountry() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", COUNTRY);
    }

    public Locale getLocale() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (this.mLocale != null) {
            return this.mLocale;
        }
        String localeString = this.getAttributeValueString("com.sap.security.core.usermanagement", LOCALE);
        if (localeString == null) {
            return null;
        }
        String language = null;
        String country = null;
        String variant = null;
        if (localeString.indexOf("_") == -1) {
            language = localeString;
            country = "";
        } else {
            language = localeString.substring(0, localeString.indexOf("_"));
            country = localeString.substring(localeString.indexOf("_") + 1);
            if (country.indexOf("_") == -1) {
                variant = null;
            } else {
                variant = country.substring(country.indexOf("_") + 1);
                country = country.substring(0, country.indexOf("_"));
            }
        }
        if (language != null && country != null && variant != null) {
            this.mLocale = new Locale(language, country, variant);
            return this.mLocale;
        }
        if (language != null && country != null) {
            this.mLocale = new Locale(language, country);
            return this.mLocale;
        }
        if (language != null) {
            this.mLocale = new Locale(language, "");
            return this.mLocale;
        }
        throw new UMRuntimeException("Locale \"" + localeString + "\" is invalid!");
    }

    public TimeZone getTimeZone() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        String timeZoneID = this.getAttributeValueString("com.sap.security.core.usermanagement", TIMEZONE);
        if (this.mTimeZone != null) {
            if (trace.beInfo()) {
                StringBuffer buf = new StringBuffer().append("TimeZone value for UniqueIdOfUser ").append(this.mPrincipalDatabag.getUniqueID()).append(": ").append(timeZoneID == null ? "null" : timeZoneID);
                trace.infoT("getTimeZone", buf.toString());
            }
            return this.mTimeZone;
        }
        if (timeZoneID == null) {
            return null;
        }
        this.mTimeZone = TimeZone.getTimeZone(timeZoneID);
        return this.mTimeZone;
    }

    public String getCurrency() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", CURRENCY);
    }

    public String getTelephone() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", TELEPHONE);
    }

    public String getCellPhone() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", MOBILE);
    }

    public String getFax() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", FAX);
    }

    public String getEmail() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", EMAIL);
    }

    public boolean isCompanyUser() {
        return this.getCompany() != null && !"".equals(this.getCompany());
    }

    public String getCompany() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return this.getAttributeValueString("com.sap.security.core.usermanagement", COMPANY);
    }

    public IUserFactory getUserFactory() {
        return UMFactory.getUserFactory();
    }

    protected IUserMaint prepare() throws UMException {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        return new UserMaint(this.mFactory.getModifyPrincipalDatabag(this.mPrincipalDatabag));
    }

    public boolean hasPermission(Permission permission) {
        User user = this;
        synchronized (user) {
            ClassLoader loader;
            Permissions permissions;
            if (null == this._permissionsCache) {
                this._permissionsCache = new HashMap();
            }
            if ((permissions = (Permissions)this._permissionsCache.get(loader = permission.getClass().getClassLoader())) == null) {
                if (this._permissionsData == null) {
                    this._permissionsData = User.getPermissionsData(this);
                }
                permissions = User.getPermissions(this._permissionsData, loader);
                this._permissionsCache.put(loader, permissions);
            }
            boolean bl = permissions.implies(permission);
            return bl;
        }
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        if (!this.hasPermission(permission)) {
            if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                HashMap<String, String> detailsMap = new HashMap<String, String>();
                detailsMap.put("Permission", permission.getName());
                SecurityAudit.log("ACCESS.ERROR", null, detailsMap);
            }
            throw new AccessControlException("no authorizations");
        }
        if (SecurityAudit.isLogged("ACCESS.OK")) {
            HashMap<String, String> detailsMap = new HashMap<String, String>();
            detailsMap.put("Permission", permission.getName());
            SecurityAudit.log("ACCESS.OK", null, detailsMap);
        }
    }

    public boolean equals(Object another) {
        if (!(another instanceof IUser)) {
            return false;
        }
        IUser u = (IUser)another;
        return this.mPrincipalDatabag.getUniqueID().equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mPrincipalDatabag.getUniqueID().hashCode();
    }

    public String getName() {
        return super.getUniqueName();
    }

    public int getAccessibilityLevel() {
        String level;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((level = this.getAttributeValueString("com.sap.security.core.usermanagement", ACCESSIBILITYLEVEL)) == null) {
            return 0;
        }
        return Integer.parseInt(level);
    }

    public void addToGroup(String id) throws UMException {
        UMFactory.getGroupFactory().addUserToGroup(this.getUniqueID(), id);
        if (this.mDirectGroups != null && !this.mDirectGroups.contains(id)) {
            this.mDirectGroups.add(id);
        }
        if (this.mAllGroups != null && !this.mAllGroups.contains(id)) {
            this.mAllGroups.add(id);
        }
        this.mAllRoles = null;
    }

    public void removeFromGroup(String id) throws UMException {
        UMFactory.getGroupFactory().removeUserFromGroup(this.getUniqueID(), id);
        if (this.mDirectGroups != null && this.mDirectGroups.contains(id)) {
            this.mDirectGroups.remove(id);
        }
        this.mAllGroups = null;
        this.mAllRoles = null;
    }

    public void addToRole(String id) throws UMException {
        UMFactory.getRoleFactory().addUserToRole(this.getUniqueID(), id);
        if (this.mDirectRoles != null && !this.mDirectRoles.contains(id)) {
            this.mDirectRoles.add(id);
        }
        if (this.mAllRoles != null && !this.mAllRoles.contains(id)) {
            this.mAllRoles.add(id);
        }
    }

    public void removeFromRole(String id) throws UMException {
        UMFactory.getRoleFactory().removeUserFromRole(this.getUniqueID(), id);
        if (this.mDirectRoles != null && this.mDirectRoles.contains(id)) {
            this.mDirectRoles.remove(id);
        }
        this.mAllRoles = null;
    }

    public Iterator getUserAccountUniqueIDs() throws UMException {
        if (this.mAccountIDs == null || this.mAccountIDs.isEmpty()) {
            Vector searchResult;
            SearchCriteria sc = new SearchCriteria("UACC");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "userid", this.getUniqueID(), true);
            this.mAccountIDs = searchResult = this.mFactory.searchPrincipalDatabags(sc);
        }
        return new PrincipalIteratorImpl(this.mAccountIDs, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    private static Permissions getPermissions(PermissionData[] permissionsData, ClassLoader loader) {
        String methodName = "getPermissions(PermissionData[]";
        trace.entering("getPermissions(PermissionData[]");
        Permissions permissions = new Permissions();
        int i = 0;
        while (i < permissionsData.length) {
            PermissionData permData = permissionsData[i];
            Permission perm = permData.get(loader);
            if (null != perm) {
                trace.debugT("getPermissions(PermissionData[]", "Adding permission: " + perm.toString());
                permissions.add(perm);
            }
            ++i;
        }
        trace.exiting("getPermissions(PermissionData[]");
        return permissions;
    }

    private static PermissionData[] getPermissionsData(IUser user) {
        Set permissionSet = User.calculatePermissions(user);
        PermissionData[] permissionData = new PermissionData[permissionSet.size()];
        return permissionSet.toArray(permissionData);
    }

    private static Set calculatePermissions(IUser user) {
        String methodName = "calculatePermissions()";
        trace.entering("calculatePermissions()");
        HashSet<PermissionData> permissionSet = new HashSet<PermissionData>();
        if (UMFactory.getProperties().getBoolean("ume.superadmin.activated", false) && user.getUniqueID().equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            permissionSet.add(new PermissionData("java.security.AllPermission", "AllPermission", "*"));
            trace.debugT("calculatePermissions()", "User is SuperAdmin; it has all permissions!");
            return permissionSet;
        }
        Iterator roles = user.getRoles(true);
        while (roles.hasNext()) {
            String uniqueID = (String)roles.next();
            try {
                IRole role = UMFactory.getRoleFactory().getRole(uniqueID);
                trace.debugT("calculatePermissions()", "Getting the role: " + role.getDisplayName());
                Iterator actionIter = PermissionRoles.getActions(role);
                while (actionIter.hasNext()) {
                    IServiceAction action = (IServiceAction)actionIter.next();
                    trace.debugT("calculatePermissions()", "Getting the Action: " + action.toString());
                    Iterator permIter = action.getPermissions();
                    while (permIter.hasNext()) {
                        permissionSet.add((PermissionData)permIter.next());
                    }
                }
            }
            catch (UMException e) {
                trace.errorT("calculatePermissions()", "Principal not found!", e);
            }
        }
        return permissionSet;
    }

    static {
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", FIRSTNAME, 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", LASTNAME, 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "displayname", 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "uniquename", 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", SALUTATION, 1);
        if (UserAdminHelper.isCompanyConceptEnabled()) {
            USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", COMPANY, 1);
        }
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", ACCESSIBILITYLEVEL, 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", LOCALE, 1);
        USER_DEFAULT_ATTRIBUTES.addAttribute("com.sapportals.portal.navigation", "uipmode", 1);
        String displayNameTemplate = UMFactory.getProperties().get(DISPLAYNAME_TEMPLATE, DEFAULT_DISPLAYNAME_TEMPLATE);
        boolean allTokensOK = true;
        String currentToken = null;
        int startIndex = displayNameTemplate.indexOf(123);
        int endIndex = displayNameTemplate.indexOf(125, startIndex);
        boolean hasMoreTokens = endIndex > startIndex;
        int index = 0;
        while (hasMoreTokens && allTokensOK) {
            currentToken = displayNameTemplate.substring(startIndex + 1, endIndex);
            if (!currentToken.equals("j_user")) {
                USER_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", currentToken, 1);
            }
            boolean bl = hasMoreTokens = (endIndex = displayNameTemplate.indexOf(125, startIndex = displayNameTemplate.indexOf(123, index = endIndex + 1))) > startIndex && startIndex != -1;
        }
    }
}

