/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IRole;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractPrincipalSet;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.RoleFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Iterator;

public class RoleWrapper
extends AbstractWrapper
implements IRole {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/RoleWrapper.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";

    public RoleWrapper(IRole role, AttributeList attrList) {
        super(role.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IRole>(role);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedRole().getParents(principalTypeIdentifiers, recursive);
    }

    public boolean equals(Object another) {
        if (!(another instanceof IRole)) {
            return false;
        }
        IRole u = (IRole)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public Iterator getUserMembers(boolean getChildMembers) {
        return this.getCachedRole().getUserMembers(getChildMembers);
    }

    public Iterator getGroupMembers(boolean getChildMembers) {
        return this.getCachedRole().getGroupMembers(getChildMembers);
    }

    public boolean isUserMember(String member, boolean checkChildren) {
        return this.getCachedRole().isUserMember(member, checkChildren);
    }

    public boolean isGroupMember(String member, boolean checkChildren) {
        return this.getCachedRole().isGroupMember(member, checkChildren);
    }

    public boolean addUserMember(String newMember) throws UMException {
        return this.getCachedRole().addUserMember(newMember);
    }

    public boolean addGroupMember(String newMember) throws UMException {
        return this.getCachedRole().addGroupMember(newMember);
    }

    public boolean removeUserMember(String oldMember) throws UMException {
        return this.getCachedRole().removeUserMember(oldMember);
    }

    public boolean removeGroupMember(String oldMember) throws UMException {
        return this.getCachedRole().removeGroupMember(oldMember);
    }

    public String getDescription() {
        return this.getCachedRole().getDescription();
    }

    public boolean setDescription(String description) throws UMException {
        return this.getCachedRole().setDescription(description);
    }

    public String getUniqueName() {
        return this.getCachedRole().getUniqueName();
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        return this.getCachedRole().setAttribute(namespace, name, values);
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        return this.getCachedRole().setBinaryAttribute(namespace, name, value);
    }

    public boolean isModified() {
        return this.getCachedRole().isModified();
    }

    public boolean setDisplayName(String displayName) throws UMException {
        return this.getCachedRole().setDisplayName(displayName);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedRole().toString());
        return res.toString();
    }

    public void commit() throws UMException {
        this.getCachedRole().commit();
    }

    public void rollback() {
        this.getCachedRole().rollback();
    }

    public void save() throws UMException {
        this.getCachedRole().save();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public Date created() {
        return this.getCachedRole().created();
    }

    public Date lastModified() {
        return this.getCachedRole().lastModified();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedRole().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedRole().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedRole().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedRole().getAttributeNames(namespace);
    }

    public String getDisplayName() {
        return this.getCachedRole().getDisplayName();
    }

    public boolean isExistenceChecked() {
        return this.getCachedRole().isExistenceChecked();
    }

    public void refresh() throws UMException {
        RoleFactory.invalidateRoleInCacheLocally(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IRole getCachedRole() {
        try {
            IRole r = null;
            if (this.mReadonlyPrincipal != null) {
                r = (IRole)this.mReadonlyPrincipal.get();
            }
            if (r == null) {
                r = this.mAttributeList == null ? ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRole(this.mUniqueID) : ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRole(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IRole>(r);
            }
            return r;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isMutable() {
        return this.getCachedRole().isMutable();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedRole().getAttributeType(namespace, attributeName);
    }

    public Iterator getMembers(boolean getChildMembers) {
        return ((AbstractPrincipalSet)this.getCachedRole()).getMembers(getChildMembers);
    }

    public boolean isMember(String member, boolean recursive) {
        return ((AbstractPrincipalSet)this.getCachedRole()).isMember(member, recursive);
    }

    public boolean addMember(String newMember) throws UMException {
        return ((AbstractPrincipalSet)this.getCachedRole()).addMember(newMember);
    }

    public boolean removeMember(String oldMember) throws UMException {
        return ((AbstractPrincipalSet)this.getCachedRole()).removeMember(oldMember);
    }
}

