/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IConfigurable;
import com.sap.security.api.IGroup;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IRoleSearchFilter;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.NoSuchPCDRoleException;
import com.sap.security.api.NoSuchRoleException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.RoleAlreadyExistsException;
import com.sap.security.api.RoleListener;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSearchFilter;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.imp.Role;
import com.sap.security.core.imp.RoleCleanupListener;
import com.sap.security.core.imp.RoleSearchFilter;
import com.sap.security.core.imp.RoleWrapper;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.NOPcdRoleException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class RoleFactory
implements IRoleFactory,
IConfigurable {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/RoleFactory.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final String DEFAULT_ROLE_CACHING_TIME = "ume.cache.role.default_caching_time";
    public static final String INITIAL_ROLE_CACHE_SIZE = "ume.cache.role.initial_cache_size";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/RoleFactory.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    protected static ICache mm_roleCache;
    private static ICache mUNCache;
    public static final String MAX_ROLE_NAME_LENGTH_PROP = "roleNameLength";
    public static final String MAX_ROLE_DESCRIPTION_LENGTH_PROP = "roleDescriptionLength";
    private static int mm_maxRoleNameLength;
    private static int mm_maxRoleDescriptionLength;
    private static Vector mAddRoleListeners;
    private static Vector mDeleteRoleListeners;
    private static Vector mAssignUserListeners;
    private static Vector mUnassignUserListeners;
    private static Vector mAssignGroupListeners;
    private static Vector mUnassignGroupListeners;
    private static Vector mLogOutRoleListener;
    static /* synthetic */ Class class$com$sap$security$core$imp$RoleFactory;

    public synchronized void initialize(Properties props) throws PersistenceException {
    }

    public RoleFactory() throws PersistenceException {
        PrincipalDatabagFactory.registerPersistenceNotificationListener(new RoleCleanupListener());
    }

    public static ICache getCache() {
        return mm_roleCache;
    }

    public static synchronized void invalidateCache() {
        mm_roleCache.invalidate();
    }

    public static synchronized void invalidateRoleInCache(String roleID) {
        mm_roleCache.invalidate(roleID);
    }

    public static synchronized void invalidateRoleInCacheLocally(String roleID) {
        mm_roleCache.invalidateLocally(roleID);
    }

    public void replaceRoleInCache(IRole role) {
        String id = role.getUniqueID();
        mm_roleCache.invalidate(id);
        mm_roleCache.put(id, role);
    }

    public void replaceRoleInCacheLocally(IRole role) {
        String id = role.getUniqueID();
        mm_roleCache.invalidateLocally(id);
        mm_roleCache.put(id, role);
    }

    public IRole getRole(String uniqueID, AttributeList attributeList) throws UMException {
        IRole role = this.getReadonlyRole(uniqueID, attributeList);
        return new RoleWrapper(role, attributeList);
    }

    public IRole getRoleWithoutExistenceCheck(String uniqueID, AttributeList attributeList) throws UMException {
        IRole role = this.getReadonlyRole(uniqueID, attributeList, false);
        return new RoleWrapper(role, attributeList);
    }

    public IRole getReadonlyRole(String uniqueID) throws NoSuchRoleException, PersistenceException {
        return this.getReadonlyRole(uniqueID, Role.ROLE_DEFAULT_ATTRIBUTES);
    }

    public IRole getReadonlyRole(String uniqueID, AttributeList attrList) throws NoSuchRoleException, PersistenceException {
        return this.getReadonlyRole(uniqueID, attrList, true);
    }

    public IRole getReadonlyRole(String uniqueID, AttributeList attrList, boolean checkExistence) throws NoSuchRoleException, PersistenceException {
        if (uniqueID == null) {
            throw new NoSuchRoleException("uniqueID is null.");
        }
        if (attrList == null) {
            return this.getReadonlyRole(uniqueID);
        }
        IRole _role = (IRole)mm_roleCache.get(uniqueID);
        AttributeList attributeToPopulate = attrList;
        if (_role == null || !((AbstractPrincipal)_role).allAttributesPopulated(attrList)) {
            try {
                if (!"IRole".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueID))) {
                    throw new NoSuchRoleException("The given id \"" + uniqueID + "\"is not a unique id of a role!");
                }
            }
            catch (UMException umex) {
                throw new NoSuchRoleException((Throwable)umex);
            }
            if (_role != null) {
                block14: {
                    attributeToPopulate = ((AbstractPrincipal)_role).getPopulatedAttributes().getNotContainedAttributes(attrList);
                    if (attributeToPopulate.getSize() != 0) {
                        try {
                            IPrincipalDatabag pdb = PrincipalDatabagFactory.getInstance().getPrincipalDatabag(_role.getUniqueID(), attributeToPopulate, checkExistence);
                            if (pdb == null) {
                                throw new NoSuchRoleException("Role \"" + _role.getUniqueID() + "\" doesn't exist.");
                            }
                            IPrincipalDatabag pd = ((AbstractPrincipal)_role).getPrincipalDatabag();
                            PrincipalDatabag npd = new PrincipalDatabag(_role.getUniqueID());
                            npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                            npd.mergePrincipalDatabag((IInternalPrincipalDatabag)pdb);
                            Role role = new Role(npd);
                            this.replaceRoleInCacheLocally(role);
                            _role = role;
                        }
                        catch (PersistenceException pex) {
                            if (checkExistence) {
                                throw pex;
                            }
                            if (!trace.beInfo()) break block14;
                            trace.infoT("getReadonlyRole", "Error while reading principal.", (Throwable)((Object)pex));
                        }
                    }
                }
                return _role;
            }
            try {
                _role = new Role(uniqueID, checkExistence, attributeToPopulate);
            }
            catch (UMRuntimeException e) {
                throw new NoSuchRoleException((Throwable)e);
            }
            mm_roleCache.put(uniqueID, _role);
        }
        return _role;
    }

    public IRole getRole(String uniqueID) throws UMException {
        return this.getRole(uniqueID, Role.ROLE_DEFAULT_ATTRIBUTES);
    }

    public IRole newRole(String uniqueName) throws RoleAlreadyExistsException {
        try {
            IRole role;
            block8: {
                role = null;
                try {
                    role = this.getRoleByUniqueName(uniqueName);
                }
                catch (NoSuchRoleException nsre) {
                    if (trace.beDebug()) {
                        trace.debugT("newRole", nsre);
                    }
                }
                catch (PersistenceException pe) {
                    if (!trace.beDebug()) break block8;
                    trace.debugT("newRole", (Throwable)((Object)pe));
                }
            }
            if (role != null) {
                throw new RoleAlreadyExistsException("Role with unique name " + uniqueName + " already exists!");
            }
            Role newRole = new Role();
            newRole.setUniqueName(uniqueName);
            return newRole;
        }
        catch (RoleAlreadyExistsException raeex) {
            throw raeex;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public IRole[] getRoles(String[] uniqueIDs, AttributeList attributeList) throws NoSuchRoleException, PersistenceException {
        IRole[] result = this.getReadonlyRoles(uniqueIDs, attributeList);
        int size = result.length;
        int i = 0;
        while (i < size) {
            result[i] = new RoleWrapper(result[i], attributeList);
            ++i;
        }
        return result;
    }

    public IRole[] getReadonlyRoles(String[] uniqueIDs, AttributeList attributeList) throws NoSuchRoleException, PersistenceException {
        IRole[] result = new IRole[uniqueIDs.length];
        IRole[] rolesToMerge = new IRole[uniqueIDs.length];
        Vector<String> rolesToPopulate = new Vector<String>();
        IRole role = null;
        AttributeList attributeToPopulate = new AttributeList(false);
        attributeToPopulate.addAttributeList(attributeList);
        int i = 0;
        while (i < uniqueIDs.length) {
            role = (IRole)mm_roleCache.get(uniqueIDs[i]);
            if (role == null) {
                try {
                    if (!"IRole".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueIDs[i]))) {
                        throw new NoSuchRoleException("The given id \"" + uniqueIDs[i] + "\"is not a unique id of a role!");
                    }
                }
                catch (UMException umex) {
                    throw new NoSuchRoleException((Throwable)umex);
                }
            }
            if (role != null && ((AbstractPrincipal)role).allAttributesPopulated(attributeList)) {
                result[i] = role;
            } else {
                if (role != null) {
                    rolesToMerge[i] = role;
                }
                rolesToPopulate.add(uniqueIDs[i]);
            }
            ++i;
        }
        if (rolesToPopulate.size() != 0) {
            try {
                IPrincipalDatabag[] roles = PrincipalDatabagFactory.getInstance().getPrincipalDatabags(rolesToPopulate.toArray(new String[rolesToPopulate.size()]), attributeToPopulate, true);
                int dataBagCounter = 0;
                int i2 = 0;
                while (i2 < uniqueIDs.length) {
                    if (result[i2] == null) {
                        Role nr;
                        if (roles[dataBagCounter] != null) {
                            if (rolesToMerge[i2] != null) {
                                PrincipalDatabag pdb = new PrincipalDatabag(rolesToMerge[i2].getUniqueID());
                                pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)((AbstractPrincipal)rolesToMerge[i2]).getPrincipalDatabag());
                                pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)roles[dataBagCounter]);
                                nr = new Role(pdb);
                            } else {
                                nr = new Role(roles[dataBagCounter]);
                            }
                        } else {
                            throw new NoSuchRoleException("Role with id " + uniqueIDs[i2] + " not found!");
                        }
                        result[i2] = nr;
                        mm_roleCache.put(nr.getUniqueID(), nr);
                        ++dataBagCounter;
                    }
                    ++i2;
                }
            }
            catch (NOPcdRoleException prex) {
                throw new NoSuchPCDRoleException((Throwable)((Object)prex));
            }
        }
        return result;
    }

    public IRole[] getRoles(String[] uniqueIDs) throws NoSuchRoleException, PersistenceException {
        return this.getRoles(uniqueIDs, AbstractPrincipal.ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES);
    }

    public IRole[] getReadonlyRoles(String[] uniqueIDs) throws NoSuchRoleException, NoSuchPCDRoleException, PersistenceException {
        return this.getReadonlyRoles(uniqueIDs, AbstractPrincipal.ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES);
    }

    public void deleteRole(String uniqueID) throws UMException {
        IRole role = this.getReadonlyRole(uniqueID);
        mUNCache.invalidate(role.getUniqueName());
        mm_roleCache.invalidate(uniqueID);
        try {
            PrincipalDatabag _principal = new PrincipalDatabag(uniqueID);
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IDistributedTransaction _dtrans = mFactory.createDistributedTransaction();
            mFactory.deletePrincipalDatabag(_principal, _dtrans);
            _dtrans.commit();
            RoleFactory.removeRolePerformed(uniqueID);
        }
        catch (NOPcdRoleException prex) {
            throw new NoSuchPCDRoleException((Throwable)((Object)prex));
        }
        catch (UMRuntimeException e) {
            throw new UMException((Throwable)e);
        }
    }

    public void saveRoles(IRole[] roles) throws UMException {
        if (roles == null) {
            return;
        }
        int i = 0;
        while (i < roles.length) {
            roles[i].save();
            ++i;
        }
    }

    public void commitRoles(IRole[] roles) throws UMException {
        if (roles == null) {
            return;
        }
        int size = roles.length;
        int i = 0;
        while (i < size) {
            roles[i].commit();
            ++i;
        }
    }

    public void rollbackRoles(IRole[] roles) {
        if (roles == null) {
            return;
        }
        int i = 0;
        while (i < roles.length) {
            roles[i].rollback();
            ++i;
        }
    }

    public ISearchResult searchRoles(IRoleSearchFilter filter) throws UMException {
        if (((AbstractPrincipalSearchFilter)filter).containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        SearchCriteria sc = null;
        if (((PrincipalSearchFilter)filter).isDisplayNameSet()) {
            sc = ((PrincipalSearchFilter)filter).getSearchCriteriaForDisplayName();
        } else {
            sc = filter.getSearchMethod() == 1 ? new SearchCriteria(true, "ROLE") : new SearchCriteria(false, "ROLE");
            int i = 0;
            while (i < filter.getElementSize()) {
                ISearchAttribute sElement = filter.getSearchElementAt(i);
                String _nameSpace = sElement.getAttributeNameSpace();
                String _attributeName = sElement.getAttributeName();
                Object _attributeValue = sElement.getAttributeValue();
                switch (sElement.getOperator()) {
                    case 0: {
                        sc.addEqualsElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 1: {
                        sc.addLikeElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 3: {
                        sc.addLessThanElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    case 2: {
                        sc.addGreaterThanElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                        break;
                    }
                    default: {
                        sc.addEqualsElement(_nameSpace, _attributeName, _attributeValue, sElement.isCaseSensitive());
                    }
                }
                ++i;
            }
        }
        sc.setSearchSizeLimit(filter.getMaxSearchResultSize());
        Vector results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(results, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
        principalIterator.setState(sc.getSearchStatus());
        return principalIterator;
    }

    public IRole getMutableRole(String uniqueID) throws NoSuchRoleException, PersistenceException {
        try {
            IRole r = this.getReadonlyRole(uniqueID);
            IPrincipalDatabag p = null;
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            if (r != null) {
                p = ((AbstractPrincipal)r).getPrincipalDatabag();
            } else {
                p = new PrincipalDatabag(uniqueID);
                if (!mFactory.principalDatabagExists(p)) {
                    throw new NoSuchRoleException("role " + uniqueID + " does not exist");
                }
            }
            return new Role(mFactory.getModifyPrincipalDatabag(p));
        }
        catch (NOPcdRoleException prex) {
            throw new NoSuchPCDRoleException((Throwable)((Object)prex));
        }
    }

    public int getMaxRoleNameLength() {
        return UMFactory.getProperties().getNumber(MAX_ROLE_NAME_LENGTH_PROP, mm_maxRoleNameLength);
    }

    public int getMaxRoleDescriptionLength() {
        return UMFactory.getProperties().getNumber(MAX_ROLE_DESCRIPTION_LENGTH_PROP, mm_maxRoleDescriptionLength);
    }

    public void registerListener(RoleListener roleListener, int modifier) {
        boolean registered = false;
        if ((modifier & 1) == 1) {
            mAddRoleListeners.add(roleListener);
            registered = true;
        }
        if ((modifier & 2) == 2) {
            mDeleteRoleListeners.add(roleListener);
            registered = true;
        }
        if ((modifier & 8) == 8) {
            mAssignGroupListeners.add(roleListener);
            registered = true;
        }
        if ((modifier & 0x20) == 32) {
            mUnassignGroupListeners.add(roleListener);
            registered = true;
        }
        if ((modifier & 4) == 4) {
            mAssignUserListeners.add(roleListener);
            registered = true;
        }
        if ((modifier & 0x10) == 16) {
            mUnassignUserListeners.add(roleListener);
            registered = true;
        }
        if (!registered) {
            trace.warningT("registerListener", "RoleListener " + roleListener + " could not be registered!");
        }
    }

    public void unregisterListener(RoleListener roleListener) {
        mAddRoleListeners.remove(roleListener);
        mDeleteRoleListeners.remove(roleListener);
        mUnassignGroupListeners.remove(roleListener);
        mUnassignUserListeners.remove(roleListener);
        mAssignGroupListeners.remove(roleListener);
        mAssignUserListeners.remove(roleListener);
        mLogOutRoleListener.remove(roleListener);
    }

    public String[] getUsersOfRole(String roleId, boolean recursive) {
        try {
            IRole role = this.getReadonlyRole(roleId);
            Iterator it = role.getUserMembers(recursive);
            Vector result = new Vector();
            while (it.hasNext()) {
                result.add(it.next());
            }
            return result.toArray(new String[0]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public String[] getGroupsOfRole(String roleId, boolean recursive) {
        try {
            IRole role = this.getReadonlyRole(roleId);
            Iterator it = role.getGroupMembers(recursive);
            Vector result = new Vector();
            while (it.hasNext()) {
                result.add(it.next());
            }
            return result.toArray(new String[0]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public String[] getRolesOfUser(String userId, boolean recursive) {
        try {
            IUser user = UMFactory.getUserFactory().getUser(userId);
            Iterator it = user.getRoles(recursive);
            Vector result = new Vector();
            while (it.hasNext()) {
                result.add(it.next());
            }
            return result.toArray(new String[0]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public String[] getRolesOfGroup(String groupId, boolean recursive) {
        try {
            IGroup group = UMFactory.getGroupFactory().getGroup(groupId);
            Iterator it = group.getRoles(recursive);
            Vector result = new Vector();
            while (it.hasNext()) {
                result.add(it.next());
            }
            return result.toArray(new String[0]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public void addUserToRole(String userId, String roleId) throws UMException {
        if (userId == null) {
            throw new UMException("Cannot add member which has unique id null.");
        }
        if (userId.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            throw new UMException("SAP* cannot be added to roles.");
        }
        IUser user = UMFactory.getUserFactory().getUser(userId);
        IRole role = UMFactory.getRoleFactory().getRole(roleId);
        if (!role.isUserMember(user.getUniqueID(), false)) {
            try {
                IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
                IPrincipalDatabag p = mFactory.getPrincipalDatabag(roleId, null, true);
                IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
                pm.addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", userId);
                IDistributedTransaction dt = mFactory.createDistributedTransaction();
                mFactory.updatePrincipalDatabag(pm, dt);
                dt.commit();
                UserFactory.invalidateUserInCache(userId);
                RoleFactory.invalidateRoleInCache(roleId);
                RoleFactory.assignUserPerformed(roleId, userId);
            }
            catch (NOPcdRoleException prex) {
                throw new NoSuchPCDRoleException((Throwable)((Object)prex));
            }
        }
    }

    public static void addRolePerformed(String uniqueID) throws UMException {
        int size = mAddRoleListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mAddRoleListeners.elementAt(i)).roleAdded(uniqueID);
            ++i;
        }
        PrincipalFactory.addPrincipalPerformed(uniqueID);
    }

    public static void removeRolePerformed(String uniqueID) throws UMException {
        int size = mDeleteRoleListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mDeleteRoleListeners.elementAt(i)).roleRemoved(uniqueID);
            ++i;
        }
        PrincipalFactory.removePrincipalPerformed(uniqueID);
    }

    public static void assignUserPerformed(String roleID, String userID) throws UMException {
        int size = mAssignUserListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mAssignUserListeners.elementAt(i)).userAssigned(roleID, userID);
            ++i;
        }
        PrincipalFactory.assignPrincipalPerformed(roleID, userID);
    }

    public static void assignGroupPerformed(String roleID, String groupID) throws UMException {
        int size = mAssignGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mAssignGroupListeners.elementAt(i)).groupAssigned(roleID, groupID);
            ++i;
        }
        PrincipalFactory.assignPrincipalPerformed(roleID, groupID);
    }

    public static void unassignUserPerformed(String roleID, String userID) throws UMException {
        int size = mUnassignUserListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mUnassignUserListeners.elementAt(i)).userUnAssigned(roleID, userID);
            ++i;
        }
        PrincipalFactory.unassignPrincipalPerformed(roleID, userID);
    }

    public static void unassignGroupPerformed(String roleID, String groupID) throws UMException {
        int size = mUnassignGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((RoleListener)mUnassignGroupListeners.elementAt(i)).groupUnAssigned(roleID, groupID);
            ++i;
        }
        PrincipalFactory.unassignPrincipalPerformed(roleID, groupID);
    }

    public void addGroupToRole(String groupId, String roleId) throws UMException {
        IGroup group = UMFactory.getGroupFactory().getGroup(groupId);
        IRole role = UMFactory.getRoleFactory().getRole(roleId);
        if (!role.isGroupMember(group.getUniqueID(), false)) {
            try {
                IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
                IPrincipalDatabag p = mFactory.getPrincipalDatabag(roleId, null, true);
                IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
                pm.addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", groupId);
                IDistributedTransaction dt = mFactory.createDistributedTransaction();
                mFactory.updatePrincipalDatabag(pm, dt);
                dt.commit();
                GroupFactory.invalidateGroupInCache(groupId);
                RoleFactory.invalidateRoleInCache(roleId);
                RoleFactory.assignGroupPerformed(roleId, groupId);
            }
            catch (NOPcdRoleException prex) {
                throw new NoSuchPCDRoleException((Throwable)((Object)prex));
            }
        }
    }

    public void removeUserFromRole(String userId, String roleId) throws UMException {
        IUser user = UMFactory.getUserFactory().getUser(userId);
        try {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            PrincipalDatabagMaint pm = new PrincipalDatabagMaint(roleId);
            pm.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", user.getUniqueID());
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            UserFactory.invalidateUserInCache(userId);
            RoleFactory.invalidateRoleInCache(roleId);
            RoleFactory.unassignUserPerformed(roleId, userId);
        }
        catch (NOPcdRoleException prex) {
            throw new NoSuchPCDRoleException((Throwable)((Object)prex));
        }
    }

    public void removeGroupFromRole(String groupId, String roleId) throws UMException {
        IGroup group = UMFactory.getGroupFactory().getGroup(groupId);
        try {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            PrincipalDatabagMaint pm = new PrincipalDatabagMaint(roleId);
            pm.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", group.getUniqueID());
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            GroupFactory.invalidateGroupInCache(groupId);
            RoleFactory.invalidateRoleInCache(roleId);
            RoleFactory.unassignGroupPerformed(roleId, groupId);
        }
        catch (NOPcdRoleException prex) {
            throw new NoSuchPCDRoleException((Throwable)((Object)prex));
        }
    }

    public IRoleSearchFilter getRoleSearchFilter() throws UMException {
        return new RoleSearchFilter();
    }

    public IRole getRoleByUniqueName(String uniqueName) throws UMException {
        if (uniqueName == null) {
            throw new NoSuchRoleException("unique name must not be null");
        }
        String uniqueID = (String)mUNCache.get(uniqueName);
        if (uniqueID != null) {
            return this.getRole(uniqueID);
        }
        SearchCriteria sc = new SearchCriteria("ROLE");
        sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueName, false);
        Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        if (result == null || result.size() == 0) {
            throw new NoSuchRoleException("Role with uniqueName " + uniqueName + " not found!");
        }
        if (result.size() > 1) {
            throw new UMException("Role found, but unique name \"" + uniqueName + "\"  is not unique!");
        }
        mUNCache.put(uniqueName, (String)result.firstElement());
        return this.getRole((String)result.firstElement());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mm_maxRoleNameLength = 20;
        mm_maxRoleDescriptionLength = 20;
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = props.getNumber(DEFAULT_ROLE_CACHING_TIME, 28800);
        int initialSize = props.getNumber(INITIAL_ROLE_CACHE_SIZE, 500);
        mm_roleCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$RoleFactory == null ? (class$com$sap$security$core$imp$RoleFactory = RoleFactory.class$("com.sap.security.core.imp.RoleFactory")) : class$com$sap$security$core$imp$RoleFactory).getName() + "_mm_roleCache");
        mUNCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$RoleFactory == null ? (class$com$sap$security$core$imp$RoleFactory = RoleFactory.class$("com.sap.security.core.imp.RoleFactory")) : class$com$sap$security$core$imp$RoleFactory).getName() + "_mUNCache");
        mAddRoleListeners = new Vector();
        mDeleteRoleListeners = new Vector();
        mAssignUserListeners = new Vector();
        mAssignGroupListeners = new Vector();
        mUnassignUserListeners = new Vector();
        mUnassignGroupListeners = new Vector();
        mLogOutRoleListener = new Vector();
    }
}

