/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.IRole;
import com.sap.security.api.NoSuchPrincipalException;
import com.sap.security.api.RoleAlreadyExistsException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSet;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.replication.imp.MessagingHandler;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class Role
extends AbstractPrincipalSet
implements IRole {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Role.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Role.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    public static AttributeList ROLE_DEFAULT_ATTRIBUTES = new AttributeList(false);

    public Role(String uniqueID) {
        this(uniqueID, true, null);
    }

    public Role(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public Role(String uniqueID, boolean checkExistence) {
        super(uniqueID, checkExistence, null);
    }

    public Role(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        super(uniqueID, checkExistence, populateAttributes);
    }

    public Role() {
        PrincipalDatabagMaint newPrincipal = new PrincipalDatabagMaint(null);
        newPrincipal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", this.convertToVector("ROLE"));
        this.mPrincipalDatabag = newPrincipal;
        this.mPrepared = true;
    }

    public Role(IPrincipalDatabag principal) {
        this.mPrincipalDatabag = principal;
    }

    public Role(IPrincipalDatabagMaint principalMaint) {
        this.mPrincipalDatabag = principalMaint;
        this.mPrepared = true;
    }

    public void save() throws UMException {
    }

    public boolean equals(Object another) {
        if (!(another instanceof IRole)) {
            return false;
        }
        IRole u = (IRole)another;
        return this.mPrincipalDatabag.getUniqueID().equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mPrincipalDatabag.getUniqueID().hashCode();
    }

    public void commit() throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method commit cannot be used because the role is not mutable!";
            throw new UMException(errorMessage);
        }
        if (this.mPrincipalDatabag.containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
        boolean isNewRole = this.mPrincipalDatabag.getUniqueID() == null;
        try {
            int i;
            int size;
            if (isNewRole) {
                block36: {
                    try {
                        IRole r = UMFactory.getRoleFactory().getRoleByUniqueName(this.getUniqueName());
                        if (r != null) {
                            throw new UMException("A role with the unique name " + this.getUniqueName() + " was created on the persistence in the meantime!");
                        }
                    }
                    catch (NoSuchPrincipalException nspex) {
                        if (!mTrace.beDebug()) break block36;
                        mTrace.debugT("commit", nspex);
                    }
                }
                this.mPrincipalDatabag = this.mFactory.createPrincipalDatabag(dTrans, (IPrincipalDatabagMaint)this.mPrincipalDatabag);
            } else {
                this.mFactory.updatePrincipalDatabag((IPrincipalDatabagMaint)this.mPrincipalDatabag, dTrans);
            }
            dTrans.commit();
            Vector<String> vUsers = new Vector<String>();
            Iterator it = ((AbstractList)this._users).iterator();
            while (it.hasNext()) {
                vUsers.add((String)it.next());
            }
            if (vUsers.size() > 0) {
                String[] users = new String[1];
                users = vUsers.toArray(users);
                MessagingHandler.getInstance().onRoleChangeMessage(users);
            }
            Vector vals = null;
            String id = null;
            String principalType = null;
            String uniqueID = this.mPrincipalDatabag.getUniqueID();
            if (isNewRole) {
                vals = this.mPrincipalDatabag.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            RoleFactory.assignUserPerformed(uniqueID, id);
                        } else if ("IGroup".equals(principalType)) {
                            RoleFactory.assignGroupPerformed(uniqueID, id);
                        }
                        ++i;
                    }
                }
            } else {
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0);
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            RoleFactory.assignUserPerformed(uniqueID, id);
                        } else if ("IGroup".equals(principalType)) {
                            RoleFactory.assignGroupPerformed(uniqueID, id);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            RoleFactory.assignUserPerformed(uniqueID, id);
                        } else if ("IGroup".equals(principalType)) {
                            RoleFactory.assignGroupPerformed(uniqueID, id);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            RoleFactory.unassignUserPerformed(uniqueID, id);
                        } else if ("IGroup".equals(principalType)) {
                            RoleFactory.unassignGroupPerformed(uniqueID, id);
                        }
                        ++i;
                    }
                }
            }
            if (isNewRole) {
                RoleFactory.addRolePerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
                this.mPrincipalDatabag = clearUpdateDatabag;
            } else {
                IRole r = ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRole(uniqueID, Util.EMPTY_ATTRIBUTE_LIST);
                IPrincipalDatabag pd = ((AbstractPrincipal)r).getPrincipalDatabag();
                PrincipalDatabag npd = new PrincipalDatabag(uniqueID);
                npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                npd.mergePrincipalDatabag((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag);
                Role nr = new Role(npd);
                ((RoleFactory)UMFactory.getRoleFactory()).replaceRoleInCache(nr);
                PrincipalFactory.invalidatePrincipalInCache(uniqueID);
                PrincipalFactory.editPrincipalPerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag(npd);
                this.mPrincipalDatabag = clearUpdateDatabag;
            }
        }
        catch (DuplicateKeyException dkex) {
            if (isNewRole) {
                throw new RoleAlreadyExistsException((Throwable)((Object)dkex), "Role with unique name \"" + this.getUniqueName() + "\" already exists.");
            }
            throw new AttributeValueAlreadyExistsException((Throwable)((Object)dkex));
        }
    }

    static {
        ROLE_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "uniquename", 1);
    }
}

