/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Iterator;

public class PrincipalWrapper
extends AbstractWrapper
implements IPrincipal {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalWrapper.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";

    public PrincipalWrapper(IPrincipal principal, AttributeList attrList) {
        super(principal.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IPrincipal>(principal);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedPrincipal().getParents(principalTypeIdentifiers, recursive);
    }

    public boolean equals(Object another) {
        if (!(another instanceof IPrincipal)) {
            return false;
        }
        IPrincipal u = (IPrincipal)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedPrincipal().toString());
        return res.toString();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public Date created() {
        return this.getCachedPrincipal().created();
    }

    public Date lastModified() {
        return this.getCachedPrincipal().lastModified();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedPrincipal().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedPrincipal().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedPrincipal().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedPrincipal().getAttributeNames(namespace);
    }

    public String getDisplayName() {
        return this.getCachedPrincipal().getDisplayName();
    }

    public boolean isExistenceChecked() {
        return this.getCachedPrincipal().isExistenceChecked();
    }

    public void refresh() throws UMException {
        PrincipalFactory.invalidatePrincipalInCacheLocally(this.mUniqueID);
        UserFactory.invalidateUserInCacheLocally(this.mUniqueID);
        GroupFactory.invalidateGroupInCacheLocally(this.mUniqueID);
        UserAccountFactory.invalidateUserAccountInCacheLocally(this.mUniqueID);
        RoleFactory.invalidateRoleInCacheLocally(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IPrincipal getCachedPrincipal() {
        try {
            IPrincipal p = null;
            if (this.mReadonlyPrincipal != null) {
                p = (IPrincipal)this.mReadonlyPrincipal.get();
            }
            if (p == null) {
                p = this.mAttributeList == null ? ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(this.mUniqueID) : ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IPrincipal>(p);
            }
            return p;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isMutable() {
        return this.getCachedPrincipal().isMutable();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedPrincipal().getAttributeType(namespace, attributeName);
    }
}

