/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Iterator;

public class PrincipalSetWrapper
extends AbstractWrapper
implements IPrincipalSet {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalSetWrapper.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";

    public PrincipalSetWrapper(IPrincipalSet principal, AttributeList attrList) {
        super(principal.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IPrincipalSet>(principal);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedPrincipalSet().getParents(principalTypeIdentifiers, recursive);
    }

    public boolean equals(Object another) {
        if (!(another instanceof IPrincipalSet)) {
            return false;
        }
        IPrincipalSet u = (IPrincipalSet)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedPrincipalSet().toString());
        return res.toString();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public Date created() {
        return this.getCachedPrincipalSet().created();
    }

    public Date lastModified() {
        return this.getCachedPrincipalSet().lastModified();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedPrincipalSet().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedPrincipalSet().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedPrincipalSet().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedPrincipalSet().getAttributeNames(namespace);
    }

    public String getDisplayName() {
        return this.getCachedPrincipalSet().getDisplayName();
    }

    public boolean isExistenceChecked() {
        return this.getCachedPrincipalSet().isExistenceChecked();
    }

    public void refresh() throws UMException {
        PrincipalFactory.invalidatePrincipalInCacheLocally(this.mUniqueID);
        UserFactory.invalidateUserInCacheLocally(this.mUniqueID);
        GroupFactory.invalidateGroupInCacheLocally(this.mUniqueID);
        UserAccountFactory.invalidateUserAccountInCacheLocally(this.mUniqueID);
        RoleFactory.invalidateRoleInCacheLocally(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IPrincipalSet getCachedPrincipalSet() {
        try {
            IPrincipalSet ps = null;
            if (this.mReadonlyPrincipal != null) {
                ps = (IPrincipalSet)this.mReadonlyPrincipal.get();
            }
            if (ps == null) {
                ps = this.mAttributeList == null ? (IPrincipalSet)((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(this.mUniqueID) : (IPrincipalSet)((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IPrincipalSet>(ps);
            }
            return ps;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isMutable() {
        return this.getCachedPrincipalSet().isMutable();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedPrincipalSet().getAttributeType(namespace, attributeName);
    }

    public void commit() throws UMException {
        this.getCachedPrincipalSet().commit();
    }

    public boolean isModified() {
        return this.getCachedPrincipalSet().isModified();
    }

    public void rollback() {
        this.getCachedPrincipalSet().rollback();
    }

    public void save() throws UMException {
        this.getCachedPrincipalSet().save();
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        return this.getCachedPrincipalSet().setAttribute(namespace, name, values);
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        return this.getCachedPrincipalSet().setBinaryAttribute(namespace, name, value);
    }

    public boolean setDisplayName(String displayname) throws UMException {
        return this.getCachedPrincipalSet().setDisplayName(displayname);
    }

    public boolean addMember(String newMember) throws UMException {
        return this.getCachedPrincipalSet().addMember(newMember);
    }

    public Iterator getMembers(boolean getChildMembers) {
        return this.getCachedPrincipalSet().getMembers(getChildMembers);
    }

    public boolean isMember(String member, boolean recursive) {
        return this.getCachedPrincipalSet().isMember(member, recursive);
    }

    public boolean removeMember(String oldMember) throws UMException {
        return this.getCachedPrincipalSet().removeMember(oldMember);
    }
}

