/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalMaint;
import com.sap.security.api.IPrincipalMetaData;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.Locale;
import java.util.Vector;

public class PrincipalMetaData
implements IPrincipalMetaData {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalMetaData.java#5 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final String DESCRIPTION = "description";
    public static final String TITLE = "title";
    public static final String SEMANTICAL_PRINCIPAL_TYPE = "semantical_type";
    public static final String TECHNICAL_PRINCIPAL_TYPE = "technical_type";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalMetaData.java#5 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    public static AttributeList PRINCIPAL_META_DATA_ATTRIBUTES = new AttributeList(false);
    private IPrincipalMaint mDelegate;

    public PrincipalMetaData(IPrincipalMaint principal) {
        this.mDelegate = principal;
    }

    private String calculateStringPrefixForLocale(Locale locale) {
        StringBuffer strb = new StringBuffer(9);
        String language = null;
        String country = null;
        String variant = null;
        if (locale != null) {
            language = locale.getLanguage();
            country = locale.getCountry();
            variant = locale.getVariant();
        }
        if (language == null || language.equals("")) {
            language = "00";
        }
        if (country == null || country.equals("")) {
            country = "00";
        }
        if (variant == null || variant.equals("")) {
            variant = "00";
        }
        strb.append(language);
        strb.append("_");
        strb.append(country);
        strb.append("_");
        strb.append(variant);
        strb.append("_");
        return strb.toString();
    }

    public String getDescription(Locale locale) {
        String[] description = this.getCachedPrincipalObject().getAttribute("com.sap.security.core.usermanagement", DESCRIPTION);
        if (description != null) {
            String localePrefix = this.calculateStringPrefixForLocale(locale);
            int size = description.length;
            int i = 0;
            while (i < size) {
                if (description[i].startsWith(localePrefix)) {
                    return description[i].substring(localePrefix.length());
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public int getPrincipalType() {
        int value = 0;
        String[] principalType = this.getCachedPrincipalObject().getAttribute("com.sap.security.core.usermanagement", SEMANTICAL_PRINCIPAL_TYPE);
        if (principalType != null && principalType.length > 0) {
            return Integer.parseInt(principalType[0]);
        }
        return value;
    }

    public String getPrincipalTypeIdentifier() {
        String value = null;
        String[] principalType = this.getCachedPrincipalObject().getAttribute("com.sap.security.core.usermanagement", TECHNICAL_PRINCIPAL_TYPE);
        if (principalType != null && principalType.length > 0) {
            value = principalType[0];
        }
        return value;
    }

    public String getTitle(Locale locale) {
        String[] title = this.getCachedPrincipalObject().getAttribute("com.sap.security.core.usermanagement", TITLE);
        if (title != null) {
            String localePrefix = this.calculateStringPrefixForLocale(locale);
            int size = title.length;
            int i = 0;
            while (i < size) {
                if (title[i].startsWith(localePrefix)) {
                    return title[i].substring(localePrefix.length());
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public void setDescription(String description, Locale locale) {
        String[] descriptionList = this.mDelegate.getAttribute("com.sap.security.core.usermanagement", DESCRIPTION);
        if (descriptionList != null) {
            String localePrefix = this.calculateStringPrefixForLocale(locale);
            int size = descriptionList.length;
            if (description == null) {
                Vector<String> newDescriptionList = new Vector<String>();
                int i = 0;
                while (i < size) {
                    if (!descriptionList[i].startsWith(localePrefix)) {
                        newDescriptionList.add(descriptionList[i]);
                    }
                    ++i;
                }
                if (newDescriptionList.size() < size) {
                    this.mDelegate.setAttribute("com.sap.security.core.usermanagement", DESCRIPTION, newDescriptionList.toArray(new String[newDescriptionList.size()]));
                }
            } else {
                boolean found = false;
                Vector<String> newDescriptionList = new Vector<String>();
                int i = 0;
                while (i < size) {
                    if (descriptionList[i].startsWith(localePrefix)) {
                        found = true;
                        newDescriptionList.add(localePrefix + description);
                    } else {
                        newDescriptionList.add(descriptionList[i]);
                    }
                    ++i;
                }
                if (!found) {
                    newDescriptionList.add(localePrefix + description);
                }
                this.mDelegate.setAttribute("com.sap.security.core.usermanagement", DESCRIPTION, newDescriptionList.toArray(new String[newDescriptionList.size()]));
            }
        } else if (description != null) {
            descriptionList = new String[]{this.calculateStringPrefixForLocale(locale) + description};
            this.mDelegate.setAttribute("com.sap.security.core.usermanagement", DESCRIPTION, descriptionList);
        }
    }

    public void setTitle(String title, Locale locale) {
        String[] titleList = this.mDelegate.getAttribute("com.sap.security.core.usermanagement", TITLE);
        if (titleList != null) {
            String localePrefix = this.calculateStringPrefixForLocale(locale);
            int size = titleList.length;
            if (title == null) {
                Vector<String> newTitleList = new Vector<String>();
                int i = 0;
                while (i < size) {
                    if (!titleList[i].startsWith(localePrefix)) {
                        newTitleList.add(titleList[i]);
                    }
                    ++i;
                }
                if (newTitleList.size() < size) {
                    this.mDelegate.setAttribute("com.sap.security.core.usermanagement", TITLE, newTitleList.toArray(new String[newTitleList.size()]));
                }
            } else {
                boolean found = false;
                Vector<String> newTitleList = new Vector<String>();
                int i = 0;
                while (i < size) {
                    if (titleList[i].startsWith(localePrefix)) {
                        found = true;
                        newTitleList.add(localePrefix + title);
                    } else {
                        newTitleList.add(titleList[i]);
                    }
                    ++i;
                }
                if (!found) {
                    newTitleList.add(localePrefix + title);
                }
                this.mDelegate.setAttribute("com.sap.security.core.usermanagement", TITLE, newTitleList.toArray(new String[newTitleList.size()]));
            }
        } else if (title != null) {
            titleList = new String[]{this.calculateStringPrefixForLocale(locale) + title};
            this.mDelegate.setAttribute("com.sap.security.core.usermanagement", TITLE, titleList);
        }
    }

    public void save() throws UMException {
        this.mDelegate.save();
    }

    public void commit() throws UMException {
        this.mDelegate.commit();
    }

    public String toString() {
        return this.getCachedPrincipalObject().toString();
    }

    public String getUniqueID() {
        return this.mDelegate.getUniqueID();
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        return this.mDelegate.setAttribute(namespace, name, values);
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        return this.mDelegate.setBinaryAttribute(namespace, name, value);
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedPrincipalObject().getAttributeType(namespace, attributeName);
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedPrincipalObject().getAttributeNames(namespace);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedPrincipalObject().getAttributeNamespaces();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedPrincipalObject().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedPrincipalObject().getBinaryAttribute(namespace, name);
    }

    private IPrincipal getCachedPrincipalObject() {
        try {
            String uniqueID = this.mDelegate.getUniqueID();
            if (uniqueID != null) {
                return ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(uniqueID);
            }
            return this.mDelegate;
        }
        catch (UMException umex) {
            throw new PrincipalNotAccessibleException((Throwable)umex);
        }
    }

    static {
        PRINCIPAL_META_DATA_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", DESCRIPTION);
        PRINCIPAL_META_DATA_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", TITLE);
        PRINCIPAL_META_DATA_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", SEMANTICAL_PRINCIPAL_TYPE);
        PRINCIPAL_META_DATA_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", TECHNICAL_PRINCIPAL_TYPE);
    }
}

