/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PrincipalIteratorImpl
extends PrincipalIterator
implements ISearchResult {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalIteratorImpl.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static int TYPE_UNIQUEIDS_CHECKED = PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_CHECKED;
    public static int TYPE_UNIQUEIDS_NOT_CHECKED = PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED;
    public static int TYPE_PRINCIPALS = PrincipalIterator.ITERATOR_TYPE_PRINCIPALS;
    private final int NEXT_NOT_CALLED = 0;
    private final int NEXT_CALLED_SUCCESSFUL = 1;
    private final int NEXT_CALLED_FAILED = 2;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalIteratorImpl.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    public static final String RETURN_BROKEN_RELATIONS = "ume.principal.return_broken_relations";
    private boolean mReturnBrokenRelations = UMFactory.getProperties().getBoolean("ume.principal.return_broken_relations", false);
    private Collection mUniqueIds;
    private IPrincipal mLastPrincipalChecked;
    private String mLastPrincipalID;
    private int mNextCallState;
    private int mState;
    private Iterator mIterator;

    public PrincipalIteratorImpl(Collection uniqueIDs) {
        this.mUniqueIds = uniqueIDs != null ? uniqueIDs : new Vector();
        this.mIterator = this.mUniqueIds.iterator();
        this.mNextCallState = 0;
        this.mState = 0;
    }

    public PrincipalIteratorImpl(Collection uniqueIDs, int type) {
        this(uniqueIDs);
        this.mType = type;
    }

    public boolean contains(Object o) {
        return this.mUniqueIds.contains(o);
    }

    public void setState(int state) {
        this.mState = state;
    }

    public boolean hasNext() {
        if (this.mNextCallState == 0) {
            while (this.mIterator.hasNext()) {
                this.mLastPrincipalID = (String)this.mIterator.next();
                if (this.mReturnBrokenRelations || this.mType == PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED) {
                    this.mNextCallState = 1;
                    return true;
                }
                try {
                    this.mLastPrincipalChecked = this.mType == PrincipalIterator.ITERATOR_TYPE_PRINCIPALS ? UMFactory.getPrincipalFactory().getPrincipal(this.mLastPrincipalID) : ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(this.mLastPrincipalID);
                    this.mNextCallState = 1;
                    return true;
                }
                catch (UMException nspex) {
                    if (!mTrace.beDebug()) continue;
                    mTrace.debugT("hasNext", "Checking principal \"" + this.mLastPrincipalID + "\" failed.", nspex);
                }
            }
            this.mLastPrincipalChecked = null;
            this.mLastPrincipalID = null;
            this.mNextCallState = 2;
            return false;
        }
        return this.mNextCallState == 1;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public Object next() {
        if (this.hasNext()) {
            this.mNextCallState = 0;
            if (this.mReturnBrokenRelations || this.mType == PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED) {
                return this.mLastPrincipalID;
            }
            if (this.mType == PrincipalIterator.ITERATOR_TYPE_PRINCIPALS) {
                return this.mLastPrincipalChecked;
            }
            return this.mLastPrincipalID;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException("Removing elements is not supported.");
    }

    public int getState() {
        return this.mState;
    }

    public int size() {
        return this.mUniqueIds.size();
    }
}

