/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroup;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.IPrincipalMaint;
import com.sap.security.api.IPrincipalMetaData;
import com.sap.security.api.IPrincipalSearchFilter;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.IRole;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.NoSuchObjectException;
import com.sap.security.api.NoSuchPrincipalException;
import com.sap.security.api.ObjectAlreadyExistsException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.PrincipalListener;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSearchFilter;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.GroupWrapper;
import com.sap.security.core.imp.Principal;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.PrincipalMetaData;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.imp.PrincipalSetWrapper;
import com.sap.security.core.imp.PrincipalWrapper;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.RoleWrapper;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserAccountWrapper;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.imp.UserWrapper;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.core.util.imp.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PrincipalFactory
implements IPrincipalFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/PrincipalFactory.java#4 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    public static final String DEFAULT_PRINCIPAL_CACHING_TIME = "ume.cache.principal.default_caching_time";
    public static final String INITIAL_PRINCIPAL_CACHE_SIZE = "ume.cache.principal.initial_cache_size";
    public static final String PRINCIPAL_METADATA_TYPE = "ROOT";
    private static IUMTrace mTrace;
    private static ICache mCache;
    private static ICache mMetaDataCache;
    private static String METADATA_CACHE_KEY;
    private static String PRINCIPAL_SET_TYPES_KEY;
    private static Vector mAddPrincipalsListeners;
    private static Vector mRemovePrincipalsListeners;
    private static Vector mModifyPrincipalsListeners;
    private static Vector mEditPrincipalsListeners;
    private static Vector mAssignPrincipalsListeners;
    private static Vector mUnAssignPrincipalsListeners;
    DummyDataSource dummyDataSource = null;
    static /* synthetic */ Class class$com$sap$security$core$imp$PrincipalFactory;

    public PrincipalFactory() {
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        this.dummyDataSource = new DummyDataSource();
        try {
            PrincipalDatabagFactory.getInstance();
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public boolean isPrincipalAttributeModifiable(String uniqueId, String namespace, String attributename) throws UMException {
        if (namespace == null) {
            namespace = "THIS_IS_A_NAMESPACE_PLACEHOLDER_FOR_NULL_NAMESPACES";
        }
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        return mFactory.isPrincipalDatabagAttributeModifiable(new PrincipalDatabag(uniqueId), namespace, attributename);
    }

    public String getPrincipalType(String uniqueId) throws UMException {
        String principalType;
        block14: {
            principalType = null;
            String[] parts = this.dummyDataSource.splitPrincipalDatabagID(uniqueId);
            if (parts != null && parts[0] != null) {
                if (parts[0].equalsIgnoreCase("USER")) {
                    principalType = "IUser";
                } else if (parts[0].equalsIgnoreCase("GRUP")) {
                    principalType = "IGroup";
                } else if (parts[0].equalsIgnoreCase("UACC")) {
                    principalType = "IUserAccount";
                } else if (parts[0].equalsIgnoreCase("ROLE")) {
                    principalType = "IRole";
                } else {
                    IPrincipalMetaData pmd = null;
                    try {
                        pmd = this.getPrincipalMetaData(parts[0]);
                        switch (pmd.getPrincipalType()) {
                            case 1: {
                                principalType = "IPrincipalSet";
                                break;
                            }
                            default: {
                                principalType = "IPrincipal";
                                break;
                            }
                        }
                    }
                    catch (NoSuchObjectException nsoex) {
                        principalType = "IPrincipal";
                        if (!mTrace.beDebug()) break block14;
                        mTrace.debugT("getPrincipalType", nsoex);
                    }
                }
            }
        }
        return principalType;
    }

    public static ICache getCache() {
        return mCache;
    }

    public static synchronized void invalidateCache() {
        mCache.invalidate();
    }

    public static synchronized void invalidatePrincipalInCache(String uniqueID) {
        mCache.invalidate(uniqueID);
    }

    public static synchronized void invalidatePrincipalInCacheLocally(String uniqueID) {
        mCache.invalidateLocally(uniqueID);
    }

    public void replacePrincipalInCache(IPrincipal cuo) {
        String id = cuo.getUniqueID();
        mCache.invalidate(id);
        mCache.put(id, cuo);
    }

    public void replacePrincipalInCacheLocally(IPrincipal cuo) {
        String id = cuo.getUniqueID();
        mCache.invalidateLocally(id);
        mCache.put(id, cuo);
    }

    public boolean isPrincipalModifiable(String uniqueId) throws UMException {
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        return mFactory.isPrincipalDatabagModifiable(uniqueId);
    }

    public boolean isPrincipalDeletable(String uniqueId) throws UMException {
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        return mFactory.isPrincipalDatabagDeletable(uniqueId);
    }

    public String[] getPrincipalIdParts(String uniqueId) throws UMException {
        return this.dummyDataSource.splitPrincipalDatabagID(uniqueId);
    }

    public IPrincipal getPrincipal(String uniqueID, AttributeList attributeList) throws UMException {
        if (uniqueID == null) {
            String errorMessage = "Cannot find principal when uniqueID is null!";
            throw new NoSuchPrincipalException(errorMessage);
        }
        try {
            if (uniqueID.startsWith("GRUP")) {
                return UMFactory.getGroupFactory().getGroup(uniqueID, attributeList);
            }
            if (uniqueID.startsWith("USER")) {
                return UMFactory.getUserFactory().getUser(uniqueID, attributeList);
            }
            if (uniqueID.startsWith("ROLE")) {
                return UMFactory.getRoleFactory().getRole(uniqueID, attributeList);
            }
            if (uniqueID.startsWith("UACC")) {
                return UMFactory.getUserAccountFactory().getUserAccount(uniqueID, attributeList);
            }
        }
        catch (UMException umex) {
            throw new NoSuchPrincipalException((Throwable)umex);
        }
        IPrincipal object = this.getReadonlyPrincipal(uniqueID, attributeList);
        try {
            IPrincipalMetaData pmd = null;
            try {
                pmd = this.getPrincipalMetaData(this.getPrincipalTypeIdentifier(uniqueID));
                switch (pmd.getPrincipalType()) {
                    case 1: {
                        return new PrincipalSetWrapper((IPrincipalSet)object, attributeList);
                    }
                }
                return new PrincipalWrapper(object, attributeList);
            }
            catch (NoSuchObjectException nsoex) {
                if (mTrace.beDebug()) {
                    mTrace.debugT("getPrincipal", nsoex);
                }
                return new PrincipalWrapper(object, attributeList);
            }
        }
        catch (UMException umex) {
            if (mTrace.beError()) {
                mTrace.errorT("getPrincipal", umex.getMessage(), umex);
            }
            return new PrincipalWrapper(object, attributeList);
        }
    }

    public IPrincipal getPrincipal(String uniqueID) throws UMException {
        return this.getPrincipal(uniqueID, null);
    }

    public IPrincipal getReadonlyPrincipal(String uniqueID) throws UMException {
        return this.getReadonlyPrincipal(uniqueID, null);
    }

    public IPrincipal getReadonlyPrincipal(String uniqueID, AttributeList attrlist) throws UMException {
        return this.getReadonlyPrincipal(uniqueID, attrlist, true);
    }

    public IPrincipal getReadonlyPrincipal(String uniqueID, AttributeList attrlist, boolean checkExistence) throws UMException {
        IPrincipal object;
        block17: {
            if (uniqueID == null) {
                String errorMessage = "Cannot find principal when uniqueID is null!";
                throw new NoSuchPrincipalException(errorMessage);
            }
            try {
                if (uniqueID.startsWith("GRUP")) {
                    return ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroup(uniqueID, attrlist);
                }
                if (uniqueID.startsWith("USER")) {
                    return ((UserFactory)UMFactory.getUserFactory()).getReadonlyUser(uniqueID, attrlist);
                }
                if (uniqueID.startsWith("ROLE")) {
                    return ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRole(uniqueID, attrlist, checkExistence);
                }
                if (uniqueID.startsWith("UACC")) {
                    return ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount(uniqueID, attrlist);
                }
            }
            catch (UMException umex) {
                throw new NoSuchPrincipalException((Throwable)umex);
            }
            if (attrlist == null) {
                attrlist = Util.EMPTY_ATTRIBUTE_LIST;
            }
            object = (IPrincipal)mCache.get(uniqueID);
            AttributeList attributeToPopulate = attrlist;
            if (object == null || !((AbstractPrincipal)object).allAttributesPopulated(attrlist)) {
                if (object != null) {
                    attributeToPopulate = ((AbstractPrincipal)object).getPopulatedAttributes().getNotContainedAttributes(attrlist);
                    if (attributeToPopulate.getSize() != 0) {
                        IPrincipalDatabag pdb = PrincipalDatabagFactory.getInstance().getPrincipalDatabag(object.getUniqueID(), attributeToPopulate, true);
                        if (pdb == null) {
                            throw new NoSuchPrincipalException("Principal \"" + object.getUniqueID() + "\" doesn't exist.");
                        }
                        IPrincipalDatabag pd = ((AbstractPrincipal)object).getPrincipalDatabag();
                        PrincipalDatabag npd = new PrincipalDatabag(object.getUniqueID());
                        npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                        npd.mergePrincipalDatabag((IInternalPrincipalDatabag)pdb);
                        Principal princ = new Principal(npd);
                        this.replacePrincipalInCacheLocally(princ);
                        object = princ;
                    }
                    return object;
                }
                try {
                    object = new Principal(uniqueID, true, attributeToPopulate);
                }
                catch (UMRuntimeException umrex) {
                    throw new NoSuchPrincipalException((Throwable)umrex);
                }
                try {
                    String type = this.getPrincipalType(object.getUniqueID());
                    if (type.equals("IPrincipal")) {
                        mCache.put(uniqueID, object);
                    }
                }
                catch (UMException umex) {
                    if (!mTrace.beError()) break block17;
                    mTrace.errorT("getReadonlyPrincipal", umex.getMessage(), umex);
                }
            }
        }
        return object;
    }

    public void addPrincipalToParent(String customObjectId, String parentPrincipalId) throws UMException {
        if (customObjectId == null) {
            throw new UMException("Cannot add member which has unique id null.");
        }
        if (customObjectId.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            throw new UMException("SAP* cannot be added to principals.");
        }
        IPrincipal cuo1 = this.getPrincipal(customObjectId);
        IPrincipal cuo2 = this.getPrincipal(parentPrincipalId);
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IPrincipalDatabag p = mFactory.getPrincipalDatabag(cuo2.getUniqueID(), null, true);
        IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
        pm.addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", cuo1.getUniqueID());
        IDistributedTransaction dt = mFactory.createDistributedTransaction();
        mFactory.updatePrincipalDatabag(pm, dt);
        dt.commit();
        PrincipalFactory.invalidatePrincipalInCache(customObjectId);
        PrincipalFactory.invalidatePrincipalInCache(parentPrincipalId);
        PrincipalFactory.assignPrincipalPerformed(parentPrincipalId, customObjectId);
    }

    public void removePrincipalFromParent(String customObjectId, String parentPrincipalId) throws UMException {
        IPrincipal cuo1 = this.getPrincipal(customObjectId);
        IPrincipal cuo2 = this.getPrincipal(parentPrincipalId);
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IPrincipalDatabag p = mFactory.getPrincipalDatabag(cuo2.getUniqueID(), null, true);
        IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
        pm.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", cuo1.getUniqueID());
        IDistributedTransaction dt = mFactory.createDistributedTransaction();
        mFactory.updatePrincipalDatabag(pm, dt);
        dt.commit();
        PrincipalFactory.invalidatePrincipalInCache(customObjectId);
        PrincipalFactory.invalidatePrincipalInCache(parentPrincipalId);
        PrincipalFactory.unassignPrincipalPerformed(parentPrincipalId, customObjectId);
    }

    public String getPrincipalTypeIdentifier(String uniqueId) throws UMException {
        if (uniqueId.length() < 7 || uniqueId.charAt(4) != '.') {
            throw new UMException("Invalid uniqueID \"" + uniqueId + "\".");
        }
        return uniqueId.substring(0, 4);
    }

    public IPrincipal[] getPrincipals(String[] uniqueIDs, AttributeList attributeList) throws NoSuchPrincipalException {
        IPrincipal[] principals = null;
        try {
            principals = this.getReadonlyPrincipals(uniqueIDs, attributeList);
        }
        catch (UMException exc) {
            throw new NoSuchPrincipalException((Throwable)exc);
        }
        int size = principals.length;
        int i = 0;
        while (i < size) {
            block18: {
                try {
                    String objectTypeIdentifier = this.getPrincipalTypeIdentifier(principals[i].getUniqueID());
                    if (objectTypeIdentifier.equals("GRUP")) {
                        principals[i] = new GroupWrapper((IGroup)principals[i], attributeList);
                    } else if (objectTypeIdentifier.equals("ROLE")) {
                        principals[i] = new RoleWrapper((IRole)principals[i], attributeList);
                    } else if (objectTypeIdentifier.equals("TEAM")) {
                        principals[i] = new PrincipalSetWrapper((IPrincipalSet)principals[i], attributeList);
                    } else if (objectTypeIdentifier.equals("USER")) {
                        principals[i] = new UserWrapper((IUser)principals[i], attributeList);
                    } else if (objectTypeIdentifier.equals("UACC")) {
                        principals[i] = new UserAccountWrapper((IUserAccount)principals[i], attributeList);
                    } else {
                        String[] principalSettypes = this.getKnownPrincipalSetTypes();
                        int length = principalSettypes.length;
                        boolean found = false;
                        int k = 0;
                        while (k < length && !found) {
                            if (principalSettypes[k].equals(objectTypeIdentifier)) {
                                principals[i] = new PrincipalSetWrapper((IPrincipalSet)principals[i], attributeList);
                                found = true;
                            }
                            ++k;
                        }
                        if (!found) {
                            principals[i] = new PrincipalWrapper(principals[i], attributeList);
                        }
                    }
                }
                catch (UMException umex) {
                    if (!mTrace.beError()) break block18;
                    mTrace.errorT("getPrincipals", umex.getMessage(), umex);
                }
            }
            ++i;
        }
        return principals;
    }

    public IPrincipal[] getReadonlyPrincipals(String[] uniqueIDs, AttributeList attributeList) throws UMException {
        Vector<String> dummy;
        String type;
        int i;
        if (uniqueIDs == null) {
            String errorMessage = "Cannot find principals, when list of ids is null!";
            throw new NoSuchPrincipalException(errorMessage);
        }
        Vector<String> users = new Vector<String>();
        Vector<String> groups = new Vector<String>();
        Vector<String> roles = new Vector<String>();
        Vector<String> userAccounts = new Vector<String>();
        Vector<String> rest = new Vector<String>();
        int i2 = 0;
        while (i2 < uniqueIDs.length) {
            if (uniqueIDs[i2] == null) {
                throw new NoSuchPrincipalException("At least one of the given unique ids is null.");
            }
            if (uniqueIDs[i2].startsWith("GRUP")) {
                groups.add(uniqueIDs[i2]);
            } else if (uniqueIDs[i2].startsWith("USER")) {
                users.add(uniqueIDs[i2]);
            } else if (uniqueIDs[i2].startsWith("ROLE")) {
                roles.add(uniqueIDs[i2]);
            } else if (uniqueIDs[i2].startsWith("UACC")) {
                userAccounts.add(uniqueIDs[i2]);
            } else {
                rest.add(uniqueIDs[i2]);
            }
            ++i2;
        }
        IUser[] populatedUsers = new IUser[]{};
        IGroup[] populatedGroups = new IGroup[]{};
        IRole[] populatedRoles = new IRole[]{};
        IUserAccount[] populatedUserAccounts = new IUserAccount[]{};
        if (attributeList != null && attributeList != Util.EMPTY_ATTRIBUTE_LIST) {
            populatedUsers = ((UserFactory)UMFactory.getUserFactory()).getReadonlyUsers(users.toArray(new String[users.size()]), attributeList);
            populatedGroups = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroups(groups.toArray(new String[groups.size()]), attributeList);
            populatedRoles = ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRoles(roles.toArray(new String[roles.size()]), attributeList);
            populatedUserAccounts = new IUserAccount[userAccounts.size()];
            i = 0;
            while (i < userAccounts.size()) {
                populatedUserAccounts[i] = ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount((String)userAccounts.elementAt(i), attributeList);
                ++i;
            }
        } else {
            populatedUsers = ((UserFactory)UMFactory.getUserFactory()).getReadonlyUsers(users.toArray(new String[users.size()]));
            populatedGroups = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroups(groups.toArray(new String[groups.size()]));
            populatedRoles = ((RoleFactory)UMFactory.getRoleFactory()).getReadonlyRoles(roles.toArray(new String[roles.size()]));
            populatedUserAccounts = new IUserAccount[userAccounts.size()];
            i = 0;
            while (i < userAccounts.size()) {
                populatedUserAccounts[i] = ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount((String)userAccounts.elementAt(i));
                ++i;
            }
        }
        if (attributeList == null) {
            attributeList = new AttributeList(false);
        }
        IPrincipal[] result = new IPrincipal[rest.size()];
        IPrincipal[] principalsToMerge = new IPrincipal[rest.size()];
        Vector<String> customObjectsToPopulate = new Vector<String>();
        IPrincipal customObject = null;
        AttributeList attributeToPopulate = new AttributeList(false);
        attributeToPopulate.addAttributeList(attributeList);
        int i3 = 0;
        while (i3 < rest.size()) {
            if (rest.elementAt(i3) == null) {
                String errorMessage = "At least one id in the list of ids is null!";
                throw new NoSuchPrincipalException(errorMessage);
            }
            customObject = (IPrincipal)mCache.get((String)rest.elementAt(i3));
            if (customObject != null && ((AbstractPrincipal)customObject).allAttributesPopulated(attributeList)) {
                result[i3] = customObject;
            } else {
                if (customObject != null) {
                    principalsToMerge[i3] = customObject;
                }
                customObjectsToPopulate.add((String)rest.elementAt(i3));
            }
            ++i3;
        }
        Hashtable<String, Vector<String>> objectsByType = new Hashtable<String, Vector<String>>();
        IPrincipalDatabag[] customObjects = new IPrincipalDatabag[customObjectsToPopulate.size()];
        int i4 = 0;
        while (i4 < customObjectsToPopulate.size()) {
            String id = (String)customObjectsToPopulate.elementAt(i4);
            if (id != null) {
                try {
                    type = this.getPrincipalTypeIdentifier(id);
                }
                catch (UMException e) {
                    throw new UMRuntimeException((Throwable)e);
                }
                dummy = (Vector<String>)objectsByType.get(type);
                if (dummy == null) {
                    dummy = new Vector<String>();
                }
            } else {
                throw new NoSuchPrincipalException("Cannot get Principals because at least one unique id is null!");
            }
            dummy.add(id);
            objectsByType.put(type, dummy);
            ++i4;
        }
        if (customObjectsToPopulate.size() != 0) {
            try {
                Hashtable<String, IPrincipalDatabag> populatedPrincipals = new Hashtable<String, IPrincipalDatabag>();
                Enumeration en = objectsByType.keys();
                while (en.hasMoreElements()) {
                    type = (String)en.nextElement();
                    dummy = (Vector)objectsByType.get(type);
                    IPrincipalDatabag[] dummy2 = PrincipalDatabagFactory.getInstance().getPrincipalDatabags(dummy.toArray(new String[dummy.size()]), attributeToPopulate, true);
                    int i5 = 0;
                    while (i5 < dummy2.length) {
                        populatedPrincipals.put(dummy2[i5].getUniqueID(), dummy2[i5]);
                        ++i5;
                    }
                }
                int size = customObjectsToPopulate.size();
                int i6 = 0;
                while (i6 < size) {
                    customObjects[i6] = (IPrincipalDatabag)populatedPrincipals.get((String)customObjectsToPopulate.elementAt(i6));
                    ++i6;
                }
            }
            catch (PersistenceException ex) {
                throw new UMRuntimeException((Throwable)((Object)ex));
            }
            int dataBagCounter = 0;
            int i7 = 0;
            while (i7 < rest.size()) {
                if (result[i7] == null) {
                    if (customObjects[dataBagCounter] != null) {
                        if (principalsToMerge[i7] != null) {
                            PrincipalDatabag pdb = new PrincipalDatabag(principalsToMerge[i7].getUniqueID());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)((AbstractPrincipal)principalsToMerge[i7]).getPrincipalDatabag());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)customObjects[dataBagCounter]);
                            result[i7] = new Principal(pdb);
                        } else {
                            result[i7] = new Principal(customObjects[dataBagCounter]);
                        }
                        try {
                            this.getPrincipalTypeIdentifier(result[i7].getUniqueID());
                            mCache.put(result[i7].getUniqueID(), result[i7]);
                        }
                        catch (UMException ncoex) {
                            if (mTrace.beDebug()) {
                                mTrace.debugT("getReadonlyPrincipals", ncoex);
                            }
                        }
                    } else {
                        throw new NoSuchPrincipalException("Custom Object with id " + rest.elementAt(i7) + " not found!");
                    }
                    ++dataBagCounter;
                }
                ++i7;
            }
        }
        IPrincipal[] finalResult = new IPrincipal[uniqueIDs.length];
        int populatedUsersCounter = 0;
        int populatedGroupsCounter = 0;
        int populatedRolesCounter = 0;
        int populatedUserAccountsCounter = 0;
        int populatedRestCounter = 0;
        int i8 = 0;
        while (i8 < uniqueIDs.length) {
            if (uniqueIDs[i8].startsWith("GRUP")) {
                finalResult[i8] = populatedGroups[populatedGroupsCounter];
                ++populatedGroupsCounter;
            } else if (uniqueIDs[i8].startsWith("USER")) {
                finalResult[i8] = populatedUsers[populatedUsersCounter];
                ++populatedUsersCounter;
            } else if (uniqueIDs[i8].startsWith("ROLE")) {
                finalResult[i8] = populatedRoles[populatedRolesCounter];
                ++populatedRolesCounter;
            } else if (uniqueIDs[i8].startsWith("UACC")) {
                finalResult[i8] = populatedUserAccounts[populatedUserAccountsCounter];
                ++populatedUserAccountsCounter;
            } else {
                finalResult[i8] = result[populatedRestCounter];
                ++populatedRestCounter;
            }
            ++i8;
        }
        return finalResult;
    }

    public IPrincipal[] getPrincipals(String[] uniqueIDs) throws NoSuchPrincipalException {
        return this.getPrincipals(uniqueIDs, null);
    }

    public IPrincipal[] getReadonlyPrincipals(String[] uniqueIDs) throws UMException {
        return this.getReadonlyPrincipals(uniqueIDs, Util.EMPTY_ATTRIBUTE_LIST);
    }

    public IPrincipalSet newPrincipalSet(String principalTypeIdentifier) {
        return (IPrincipalSet)this.newPrincipal(principalTypeIdentifier);
    }

    public IPrincipalMaint newPrincipal(String principalTypeIdentifier) {
        String errorMessage = null;
        if (principalTypeIdentifier == null) {
            errorMessage = "No object type given.";
        } else if (principalTypeIdentifier.length() != 4) {
            errorMessage = "Given object type " + principalTypeIdentifier + " doesn't consist of exactly 4 letters.";
        }
        if (principalTypeIdentifier.indexOf(".") != -1) {
            errorMessage = "Given object type " + principalTypeIdentifier + " contains illegal character \"" + "." + "\"!";
        }
        if (errorMessage != null) {
            throw new UMRuntimeException(errorMessage);
        }
        Principal object = new Principal(principalTypeIdentifier);
        return object;
    }

    public IPrincipalSet newPrincipalSet(IPrincipalSet copyFrom) {
        return (IPrincipalSet)this.newPrincipal((IPrincipal)copyFrom);
    }

    public IPrincipalMaint newPrincipal(IPrincipal copyFrom) {
        if (copyFrom == null) {
            String errorMessage = "No template given.";
            throw new UMRuntimeException(errorMessage);
        }
        Principal obj = (Principal)copyFrom;
        IPrincipalDatabag templatesDatabag = obj.getPrincipalDatabag();
        Vector principalTypeIdentifier = templatesDatabag.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        Principal object = new Principal((String)principalTypeIdentifier.firstElement());
        PrincipalDatabag newDatabag = new PrincipalDatabag(null);
        newDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)templatesDatabag);
        object.setPrincipalDatabag(newDatabag);
        return object;
    }

    public void deletePrincipal(String uniqueID) throws UMException {
        String methodName = "deletePrincipal(String)";
        if (uniqueID == null) {
            throw new UMException("Given unique ID is null!");
        }
        mCache.invalidate(uniqueID);
        try {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IDistributedTransaction distTrans = mFactory.createDistributedTransaction();
            mFactory.deletePrincipalDatabag(new PrincipalDatabag(uniqueID), distTrans);
            distTrans.commit();
            String[] aclManagers = UMFactory.getAllAclManagers();
            if (aclManagers.length > 0) {
                mTrace.infoT("deletePrincipal(String)", "Deleting principal from ACL's: " + uniqueID);
                UMFactory.getAclManager((String)aclManagers[0]).deletePrincipal(uniqueID);
            }
            PrincipalFactory.removePrincipalPerformed(uniqueID);
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void commitPrincipals(IPrincipalMaint[] objects) throws UMException {
        int size = objects.length;
        try {
            int i = 0;
            while (i < size) {
                objects[i].commit();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void rollbackPrincipals(IPrincipalMaint[] objects) {
        int size = objects.length;
        int i = 0;
        while (i < size) {
            objects[i].rollback();
            ++i;
        }
    }

    public ISearchResult searchPrincipals(IPrincipalSearchFilter filter) throws UMException {
        SearchCriteria sc;
        if (((AbstractPrincipalSearchFilter)filter).containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        Vector results = null;
        boolean orMode = ((PrincipalSearchFilter)filter).getSearchMethod() == 1;
        String principalTypeIdentifier = ((PrincipalSearchFilter)filter).getSearchPrincipalType();
        if (((PrincipalSearchFilter)filter).isDisplayNameSet()) {
            sc = ((PrincipalSearchFilter)filter).getSearchCriteriaForDisplayName();
        } else {
            sc = new SearchCriteria(orMode, principalTypeIdentifier);
            int size = ((PrincipalSearchFilter)filter).getElementSize();
            ISearchAttribute se = null;
            int i = 0;
            while (i < size) {
                se = ((AbstractPrincipalSearchFilter)filter).getSearchElementAt(i);
                switch (se.getOperator()) {
                    case 0: {
                        sc.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), se.getAttributeValue(), se.isCaseSensitive());
                        break;
                    }
                    case 1: {
                        sc.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), se.getAttributeValue(), se.isCaseSensitive());
                        break;
                    }
                    case 2: {
                        sc.addGreaterThanElement(se.getAttributeNameSpace(), se.getAttributeName(), se.getAttributeValue(), se.isCaseSensitive());
                        break;
                    }
                    case 3: {
                        sc.addLessThanElement(se.getAttributeNameSpace(), se.getAttributeName(), se.getAttributeValue(), se.isCaseSensitive());
                        break;
                    }
                    default: {
                        String errorMessage = "Unsupported operator in object search filter.";
                        throw new UMRuntimeException(errorMessage);
                    }
                }
                ++i;
            }
        }
        PrincipalIteratorImpl result = null;
        if (sc.getElementSize() > 0) {
            try {
                sc.setSearchSizeLimit(filter.getMaxSearchResultSize());
                results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            }
            catch (PersistenceException ex) {
                throw new UMRuntimeException((Throwable)((Object)ex));
            }
            result = new PrincipalIteratorImpl(results, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
            result.setState(sc.getSearchStatus());
            return result;
        }
        return result;
    }

    public void savePrincipals(IPrincipalMaint[] objects) throws UMException {
        int size = objects.length;
        try {
            int i = 0;
            while (i < size) {
                objects[i].save();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public IPrincipalMaint[] newPrincipals(String principalTypeIdentifier, int num) {
        String errorMessage = null;
        if (principalTypeIdentifier == null) {
            errorMessage = "No object type given.";
        } else if (principalTypeIdentifier.length() != 4) {
            errorMessage = "Given object type " + principalTypeIdentifier + " doesn't consist of exactly 4 letters.";
        }
        if (errorMessage != null) {
            throw new UMRuntimeException(errorMessage);
        }
        IPrincipalMaint[] result = new IPrincipalMaint[num];
        int i = 0;
        while (i < num) {
            result[i] = new Principal(principalTypeIdentifier);
            ++i;
        }
        return result;
    }

    public IPrincipalMaint getMutablePrincipal(String uniqueId) throws UMException {
        block10: {
            if (uniqueId == null) {
                String errorMessage = "Cannot find principal when uniqueID is null!";
                throw new NoSuchPrincipalException(errorMessage);
            }
            try {
                if (uniqueId.startsWith("GRUP")) {
                    return UMFactory.getGroupFactory().getMutableGroup(uniqueId);
                }
                if (uniqueId.startsWith("USER")) {
                    return UMFactory.getUserFactory().getMutableUser(uniqueId);
                }
                if (uniqueId.startsWith("ROLE")) {
                    return UMFactory.getRoleFactory().getMutableRole(uniqueId);
                }
                if (uniqueId.startsWith("UACC")) {
                    return UMFactory.getUserAccountFactory().getMutableUserAccount(uniqueId);
                }
            }
            catch (UMException umex) {
                if (!mTrace.beError()) break block10;
                mTrace.errorT("getMutablePrincipal", umex);
            }
        }
        IPrincipal o = this.getReadonlyPrincipal(uniqueId);
        IPrincipalDatabag p = null;
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        if (o != null) {
            p = ((AbstractPrincipal)o).getPrincipalDatabag();
        } else {
            p = new PrincipalDatabag(uniqueId);
            if (!mFactory.principalDatabagExists(p)) {
                String errorMessage = "object " + uniqueId + " does not exist";
                throw new NoSuchPrincipalException(errorMessage);
            }
        }
        Principal result = new Principal(mFactory.getModifyPrincipalDatabag(p));
        return result;
    }

    public IPrincipalSearchFilter getPrincipalSearchFilter(boolean orMode, String principalTypeIdentifier) throws UMException {
        int op = 0;
        if (orMode) {
            op = 1;
        }
        PrincipalSearchFilter sf = new PrincipalSearchFilter(op, principalTypeIdentifier);
        return sf;
    }

    public static void addPrincipalPerformed(String uniqueID) throws UMException {
        int size = mAddPrincipalsListeners.size();
        int i = 0;
        while (i < size) {
            ((PrincipalListener)mAddPrincipalsListeners.elementAt(i)).objectAdded(uniqueID);
            ++i;
        }
    }

    public static void removePrincipalPerformed(String uniqueID) throws UMException {
        int size = mRemovePrincipalsListeners.size();
        int i = 0;
        while (i < size) {
            ((PrincipalListener)mRemovePrincipalsListeners.elementAt(i)).objectRemoved(uniqueID);
            ++i;
        }
    }

    public static void assignPrincipalPerformed(String uniqueID, String assignedPrincipalID) throws UMException {
        int size = mAssignPrincipalsListeners.size();
        int i = 0;
        while (i < size) {
            ((PrincipalListener)mAssignPrincipalsListeners.elementAt(i)).objectAssigned(uniqueID, assignedPrincipalID);
            ++i;
        }
    }

    public static void unassignPrincipalPerformed(String uniqueID, String unassignedPrincipalID) throws UMException {
        int size = mUnAssignPrincipalsListeners.size();
        int i = 0;
        while (i < size) {
            ((PrincipalListener)mUnAssignPrincipalsListeners.elementAt(i)).objectUnAssigned(uniqueID, unassignedPrincipalID);
            ++i;
        }
    }

    public static void editPrincipalPerformed(String uniqueID) throws UMException {
        int size = mEditPrincipalsListeners.size();
        int i = 0;
        while (i < size) {
            ((PrincipalListener)mEditPrincipalsListeners.elementAt(i)).objectEdited(uniqueID);
            ++i;
        }
    }

    public void registerListener(PrincipalListener objectListener, int modifier) {
        boolean registered = false;
        if ((modifier & 1) != 0) {
            mAddPrincipalsListeners.add(objectListener);
            registered = true;
        }
        if ((modifier & 2) != 0) {
            mRemovePrincipalsListeners.add(objectListener);
            registered = true;
        }
        if ((modifier & 4) != 0) {
            mEditPrincipalsListeners.add(objectListener);
            registered = true;
        }
        if ((modifier & 0x10) != 0) {
            mAssignPrincipalsListeners.add(objectListener);
            registered = true;
        }
        if ((modifier & 0x20) != 0) {
            mUnAssignPrincipalsListeners.add(objectListener);
            registered = true;
        }
        if (!registered) {
            mTrace.warningT("registerListener", "PrincipalListener " + objectListener + " could not be registered!");
        }
    }

    public void unregisterListener(PrincipalListener objectListener) {
        mAddPrincipalsListeners.remove(objectListener);
        mRemovePrincipalsListeners.remove(objectListener);
        mEditPrincipalsListeners.remove(objectListener);
        mAssignPrincipalsListeners.remove(objectListener);
        mUnAssignPrincipalsListeners.remove(objectListener);
    }

    public void initialize(Properties properties) throws UMException {
    }

    public void deregisterPrincipalMetaData(String principalTypeIdentifier) throws UMException {
        SearchCriteria sc = new SearchCriteria(PRINCIPAL_METADATA_TYPE);
        sc.addEqualsElement("com.sap.security.core.usermanagement", "technical_type", principalTypeIdentifier, true);
        try {
            Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            int size = result.size();
            int i = 0;
            while (i < size) {
                this.deletePrincipal((String)result.elementAt(i));
                ++i;
            }
            mMetaDataCache.invalidate(METADATA_CACHE_KEY);
            mMetaDataCache.invalidate(PRINCIPAL_SET_TYPES_KEY);
            mMetaDataCache.put(PRINCIPAL_SET_TYPES_KEY, this.getKnownPrincipalSetTypesInternally());
        }
        catch (PersistenceException pex) {
            throw new UMException((Throwable)((Object)pex));
        }
    }

    private String[] getPrincipalMetaDataIds() throws UMException {
        String[] metaDataIds = (String[])mMetaDataCache.get(METADATA_CACHE_KEY);
        if (metaDataIds == null) {
            SearchCriteria sc = new SearchCriteria(PRINCIPAL_METADATA_TYPE);
            sc.addLikeElement("com.sap.security.core.usermanagement", "technical_type", "*", false);
            try {
                Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
                metaDataIds = result.toArray(new String[result.size()]);
                mMetaDataCache.put(METADATA_CACHE_KEY, metaDataIds);
            }
            catch (PersistenceException pex) {
                throw new UMException((Throwable)((Object)pex));
            }
        }
        return metaDataIds;
    }

    public IPrincipalMetaData[] getAvailablePrincipalMetaData() throws UMException {
        String[] metaDataIds = this.getPrincipalMetaDataIds();
        int size = metaDataIds.length;
        IPrincipalMetaData[] pmdList = new IPrincipalMetaData[size];
        int i = 0;
        while (i < size) {
            pmdList[i] = new PrincipalMetaData(this.getMutablePrincipal(metaDataIds[i]));
            ++i;
        }
        return pmdList;
    }

    public String[] getKnownPrincipalSetTypes() throws UMException {
        String[] knownPrincipalSets = (String[])mMetaDataCache.get(PRINCIPAL_SET_TYPES_KEY);
        if (knownPrincipalSets == null) {
            knownPrincipalSets = this.getKnownPrincipalSetTypesInternally();
        }
        mMetaDataCache.put(PRINCIPAL_SET_TYPES_KEY, knownPrincipalSets);
        return knownPrincipalSets;
    }

    private String[] getKnownPrincipalSetTypesInternally() throws UMException {
        IPrincipalMetaData[] pmd = this.getAvailablePrincipalMetaData();
        Vector<String> principalSets = new Vector<String>();
        int i = 0;
        while (i < pmd.length) {
            if (pmd[i].getPrincipalType() == 1) {
                principalSets.add(pmd[i].getPrincipalTypeIdentifier());
            }
            ++i;
        }
        if (!principalSets.contains("GRUP")) {
            principalSets.add("GRUP");
        }
        if (!principalSets.contains("ROLE")) {
            principalSets.add("ROLE");
        }
        String[] setTypes = principalSets.toArray(new String[principalSets.size()]);
        return setTypes;
    }

    public IPrincipalMetaData getPrincipalMetaData(String principalTypeIdentifier) throws NoSuchObjectException, UMException {
        String[] metaDataIds = this.getPrincipalMetaDataIds();
        int size = metaDataIds.length;
        int i = 0;
        while (i < size) {
            String[] principalType;
            IPrincipal p = (IPrincipal)mCache.get(metaDataIds[i]);
            if (p == null) {
                p = new Principal(metaDataIds[i], true, PrincipalMetaData.PRINCIPAL_META_DATA_ATTRIBUTES);
            }
            if ((principalType = p.getAttribute("com.sap.security.core.usermanagement", "technical_type")) != null && principalType.length > 0) {
                String techType = principalType[0];
                if (techType.equals(principalTypeIdentifier)) {
                    return new PrincipalMetaData(this.getMutablePrincipal(metaDataIds[i]));
                }
            } else if (mTrace.beWarning()) {
                mTrace.warningT("getPrincipalMetaData", "PrincipalMetaData object \"" + metaDataIds[i] + "\" has no technical type.");
            }
            ++i;
        }
        String errorMessage = "IPrincipalMetaData object for principal type identifier \"" + principalTypeIdentifier + "\" doesn't exist!";
        if (mTrace.beInfo()) {
            mTrace.infoT("getPrincipalMetaData", errorMessage);
        }
        throw new NoSuchObjectException(errorMessage);
    }

    public IPrincipalMetaData newPrincipalMetaData(String principalTypeIdentifier, int principalType) throws UMException {
        SearchCriteria sc = new SearchCriteria(PRINCIPAL_METADATA_TYPE);
        sc.addEqualsElement("com.sap.security.core.usermanagement", "technical_type", principalTypeIdentifier, true);
        try {
            Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            if (result.size() > 0) {
                throw new ObjectAlreadyExistsException("MetaData object for \"" + principalTypeIdentifier + "\" already exists.");
            }
        }
        catch (PersistenceException pex) {
            throw new UMException((Throwable)((Object)pex));
        }
        IPrincipalMaint p = this.newPrincipal(PRINCIPAL_METADATA_TYPE);
        p.setAttribute("com.sap.security.core.usermanagement", "semantical_type", new String[]{"" + principalType});
        p.setAttribute("com.sap.security.core.usermanagement", "technical_type", new String[]{principalTypeIdentifier});
        PrincipalMetaData pmd = new PrincipalMetaData(p);
        return pmd;
    }

    public void registerPrincipalMetaData(IPrincipalMetaData metadata) throws UMException {
        ((PrincipalMetaData)metadata).save();
        ((PrincipalMetaData)metadata).commit();
        mMetaDataCache.invalidate(METADATA_CACHE_KEY);
        mMetaDataCache.invalidate(PRINCIPAL_SET_TYPES_KEY);
        mMetaDataCache.put(PRINCIPAL_SET_TYPES_KEY, this.getKnownPrincipalSetTypesInternally());
    }

    public void addDataSource(InputStream configuration) throws UMException {
        PrincipalDatabagFactory.getInstance().addDataSource(configuration);
    }

    public static void invalidateMetaDataCache() {
        mMetaDataCache.invalidate(METADATA_CACHE_KEY);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        METADATA_CACHE_KEY = "UMEPrincipalMetaData";
        PRINCIPAL_SET_TYPES_KEY = "UMEPrincipalSetTypes";
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = props.getNumber(DEFAULT_PRINCIPAL_CACHING_TIME, 28800);
        int initialSize = props.getNumber(INITIAL_PRINCIPAL_CACHE_SIZE, 500);
        mCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$PrincipalFactory == null ? (class$com$sap$security$core$imp$PrincipalFactory = PrincipalFactory.class$("com.sap.security.core.imp.PrincipalFactory")) : class$com$sap$security$core$imp$PrincipalFactory).getName() + "_mCache");
        mMetaDataCache = InternalUMFactory.getCache(4, 2, -1, (class$com$sap$security$core$imp$PrincipalFactory == null ? (class$com$sap$security$core$imp$PrincipalFactory = PrincipalFactory.class$("com.sap.security.core.imp.PrincipalFactory")) : class$com$sap$security$core$imp$PrincipalFactory).getName() + "_mMetaDataCache");
        mAddPrincipalsListeners = new Vector();
        mRemovePrincipalsListeners = new Vector();
        mModifyPrincipalsListeners = new Vector();
        mEditPrincipalsListeners = new Vector();
        mAssignPrincipalsListeners = new Vector();
        mUnAssignPrincipalsListeners = new Vector();
    }

    public static class DummyDataSource
    extends DataSourceBaseImplementation {
        protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
            return null;
        }

        public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
            return null;
        }

        public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
            return false;
        }

        public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        }

        public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
            return false;
        }

        public IDataSourceTransaction beginTransaction() throws PersistenceException {
            return null;
        }

        public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
            return false;
        }

        public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
            return null;
        }

        public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        }

        public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
            return null;
        }

        public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
            return null;
        }
    }
}

