/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalMaint;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.PrincipalAlreadyExistsException;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Principal
extends AbstractPrincipal
implements IPrincipal,
IPrincipalMaint,
IPrincipalSet {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Principal.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Principal.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    private Vector mDirectChildren;

    public Principal(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public Principal(String uniqueID, boolean checkExistence) {
        super(uniqueID, checkExistence, null);
    }

    public Principal(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        super(uniqueID, checkExistence, populateAttributes);
    }

    public Principal(IPrincipalDatabagMaint principalMaint) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{principalMaint});
        }
        this.mPrincipalDatabag = principalMaint;
        this.mPrepared = true;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public boolean equals(Object another) {
        if (!(another instanceof IPrincipal)) {
            return false;
        }
        IPrincipal u = (IPrincipal)another;
        return this.mPrincipalDatabag.getUniqueID().equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mPrincipalDatabag.getUniqueID().hashCode();
    }

    public Principal(IPrincipalDatabag principal) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{principal});
        }
        this.mPrincipalDatabag = principal;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public Principal() {
    }

    public boolean addMember(String newMember) throws UMException {
        if (newMember == null) {
            throw new UMException("Cannot add member which has unique id null.");
        }
        if (newMember.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            throw new UMException("SAP* cannot be member of groups and roles.");
        }
        if (!this.mPrepared) {
            String errorMessage = "Maint method addMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", newMember);
        if (this.mDirectChildren != null && !this.mDirectChildren.contains(newMember)) {
            this.mDirectChildren.add(newMember);
        }
        return true;
    }

    public boolean removeMember(String oldMember) throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method removeMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", oldMember);
        if (this.mDirectChildren != null && !this.mDirectChildren.contains(oldMember)) {
            this.mDirectChildren.remove(oldMember);
        }
        return true;
    }

    public boolean isMember(String member, boolean recursive) {
        if (member != null) {
            if (this.mPrepared && this.mPrincipalDatabag instanceof IInternalPrincipalDatabagMaint) {
                Vector vals = null;
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1);
                if (vals != null && vals.contains(member)) {
                    return false;
                }
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0);
                if (vals != null && vals.contains(member)) {
                    return true;
                }
                Enumeration en = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributesOnNamespace("com.sap.security.core.usermanagement.relation", 3);
                while (en.hasMoreElements()) {
                    String attributeName = (String)en.nextElement();
                    if (!attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) continue;
                    return false;
                }
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2);
                if (vals != null && vals.contains(member)) {
                    return true;
                }
            }
            try {
                Principal theMemberObject = (Principal)((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(member);
                return theMemberObject.isMemberOfPrincipalSet(this.getUniqueID(), recursive);
            }
            catch (UMException umex) {
                throw new PrincipalNotAccessibleException((Throwable)umex);
            }
        }
        return false;
    }

    public boolean isMemberOfPrincipalSet(String principalSet, boolean recursive) throws UMException {
        String[] setTypes = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getKnownPrincipalSetTypes();
        Iterator it = this.getParents(setTypes, recursive, false);
        while (it.hasNext()) {
            if (!it.next().equals(principalSet)) continue;
            it = null;
            return true;
        }
        it = null;
        return false;
    }

    protected boolean isMember_CheckedBySearch(String member) {
        try {
            if (this.mPrepared && this.mPrincipalDatabag instanceof IInternalPrincipalDatabagMaint) {
                int i;
                int size;
                Vector vals = null;
                String id = null;
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1);
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        if (id.equals(member)) {
                            return false;
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        if (id.equals(member)) {
                            return true;
                        }
                        ++i;
                    }
                }
                Enumeration en = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributesOnNamespace("com.sap.security.core.usermanagement.relation", 3);
                while (en.hasMoreElements()) {
                    String attributeName = (String)en.nextElement();
                    if (!attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) continue;
                    return false;
                }
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2);
                if (vals != null) {
                    int size2 = vals.size();
                    int i2 = 0;
                    while (i2 < size2) {
                        id = (String)vals.elementAt(i2);
                        if (id.equals(member)) {
                            return true;
                        }
                        ++i2;
                    }
                }
            }
            SearchCriteria sc = new SearchCriteria(UMFactory.getPrincipalFactory().getPrincipalTypeIdentifier(this.getUniqueID()));
            sc.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", member, true);
            Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            return result.contains(this.getUniqueID());
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public Iterator getMembers(boolean getChildMembers) {
        return this.getMembers(getChildMembers, true);
    }

    public Iterator getMembers(boolean getChildMembers, boolean checkExistence) {
        Vector alreadyProcessedPrincipals = new Vector();
        if (checkExistence) {
            return new PrincipalIteratorImpl((Vector)this.getMembersInternal(getChildMembers, alreadyProcessedPrincipals).clone(), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(this.getMembersInternal(getChildMembers, alreadyProcessedPrincipals), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    public Iterator getMembers(boolean getChildMembers, Vector alreadyProcessedPrincipals, boolean checkExistence) {
        if (checkExistence) {
            return new PrincipalIteratorImpl((Vector)this.getMembersInternal(getChildMembers, alreadyProcessedPrincipals).clone(), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(this.getMembersInternal(getChildMembers, alreadyProcessedPrincipals), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    private Vector getMembersInternal(boolean getChildMembers, Vector alreadyProcessedPrincipals) {
        if (!getChildMembers) {
            if (this.mDirectChildren == null) {
                this.setDirectChildrenInternal();
            }
            return this.mDirectChildren;
        }
        if (this.mDirectChildren == null) {
            this.setDirectChildrenInternal();
        }
        Vector mAllChildren = (Vector)this.mDirectChildren.clone();
        int size = alreadyProcessedPrincipals.size();
        int i = 0;
        while (i < size) {
            Object o = alreadyProcessedPrincipals.elementAt(i);
            if (mAllChildren.contains(o)) {
                mAllChildren.remove(o);
            }
            ++i;
        }
        size = mAllChildren.size();
        int i2 = 0;
        while (i2 < size) {
            alreadyProcessedPrincipals.add(mAllChildren.elementAt(i2));
            ++i2;
        }
        Iterator tempPrincipals = null;
        try {
            AttributeList pa = new AttributeList(false);
            pa.addAttribute("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
            IPrincipal[] dummy = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipals(mAllChildren.toArray(new String[mAllChildren.size()]), pa);
            int i3 = 0;
            while (i3 < dummy.length) {
                tempPrincipals = ((Principal)dummy[i3]).getMembers(getChildMembers, alreadyProcessedPrincipals, false);
                while (tempPrincipals.hasNext()) {
                    String objectID = (String)tempPrincipals.next();
                    if (mAllChildren.contains(objectID)) continue;
                    mAllChildren.add(objectID);
                }
                ++i3;
            }
        }
        catch (UMException umex) {
            mAllChildren = null;
            throw new UMRuntimeException((Throwable)umex);
        }
        return mAllChildren;
    }

    private void setDirectChildrenInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        String[] result = this.getAttributeValuesStringArray("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
        this.mDirectChildren = new Vector();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                this.mDirectChildren.add(result[i]);
                ++i;
            }
        }
    }

    public Principal(String objectTypeIdentifier) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{objectTypeIdentifier});
        }
        String errorMessage = null;
        if (objectTypeIdentifier.equalsIgnoreCase("UACC")) {
            errorMessage = "Object type MUST NOT be UACC!";
        }
        if (objectTypeIdentifier.equalsIgnoreCase("COMP")) {
            errorMessage = "Object type MUST NOT be COMP!";
        }
        if (objectTypeIdentifier.equalsIgnoreCase("GRUP")) {
            errorMessage = "Object type MUST NOT be GRUP!";
        }
        if (objectTypeIdentifier.equalsIgnoreCase("ROLE")) {
            errorMessage = "Object type MUST NOT be ROLE!";
        }
        if (objectTypeIdentifier.equalsIgnoreCase("TEAM")) {
            errorMessage = "Object type MUST NOT be TEAM!";
        }
        if (objectTypeIdentifier.equalsIgnoreCase("USER")) {
            errorMessage = "Object type MUST NOT be USER!";
        }
        if (errorMessage != null) {
            throw new UMRuntimeException(errorMessage);
        }
        PrincipalDatabagMaint newPrincipal = new PrincipalDatabagMaint(null);
        newPrincipal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", this.convertToVector(objectTypeIdentifier));
        this.mPrincipalDatabag = newPrincipal;
        this.mPrepared = true;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public void save() throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method save cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
    }

    protected void init(String uniqueID) {
        if (this.mAttributeList == null) {
            this.mAttributeList = new AttributeList(false);
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
            this.mPrincipalDatabag = this.mFactory.getPrincipalDatabag(uniqueID, this.mAttributeList, true);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (this.mPrincipalDatabag == null) {
            throw new UMRuntimeException("Principal " + uniqueID + " doesn't exist!");
        }
        this.mExistenceNotChecked = false;
    }

    public void commit() throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method commit cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        if (this.mPrincipalDatabag.containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
        boolean isNewObject = this.mPrincipalDatabag.getUniqueID() == null;
        try {
            int i;
            int size;
            if (isNewObject) {
                this.mPrincipalDatabag = this.mFactory.createPrincipalDatabag(dTrans, (IPrincipalDatabagMaint)this.mPrincipalDatabag);
            } else {
                this.mFactory.updatePrincipalDatabag((IPrincipalDatabagMaint)this.mPrincipalDatabag, dTrans);
            }
            dTrans.commit();
            Vector vals = null;
            String id = null;
            String principalType = null;
            String uniqueID = this.mPrincipalDatabag.getUniqueID();
            if (isNewObject) {
                vals = this.mPrincipalDatabag.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        PrincipalFactory.assignPrincipalPerformed(uniqueID, id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            UserFactory.invalidateUserInCache(id);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.invalidateGroupInCache(id);
                        } else if ("IRole".equals(principalType)) {
                            RoleFactory.invalidateRoleInCache(id);
                        } else if ("IUserAccount".equals(principalType)) {
                            UserAccountFactory.invalidateUserAccountInCache(id);
                        }
                        ++i;
                    }
                }
            } else {
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0);
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        PrincipalFactory.assignPrincipalPerformed(uniqueID, id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            UserFactory.invalidateUserInCache(id);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.invalidateGroupInCache(id);
                        } else if ("IRole".equals(principalType)) {
                            RoleFactory.invalidateRoleInCache(id);
                        } else if ("IUserAccount".equals(principalType)) {
                            UserAccountFactory.invalidateUserAccountInCache(id);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        PrincipalFactory.assignPrincipalPerformed(uniqueID, id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            UserFactory.invalidateUserInCache(id);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.invalidateGroupInCache(id);
                        } else if ("IRole".equals(principalType)) {
                            RoleFactory.invalidateRoleInCache(id);
                        } else if ("IUserAccount".equals(principalType)) {
                            UserAccountFactory.invalidateUserAccountInCache(id);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        PrincipalFactory.unassignPrincipalPerformed(uniqueID, id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            UserFactory.invalidateUserInCache(id);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.invalidateGroupInCache(id);
                        } else if ("IRole".equals(principalType)) {
                            RoleFactory.invalidateRoleInCache(id);
                        } else if ("IUserAccount".equals(principalType)) {
                            UserAccountFactory.invalidateUserAccountInCache(id);
                        }
                        ++i;
                    }
                }
            }
            if (isNewObject) {
                PrincipalFactory.addPrincipalPerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
                this.mPrincipalDatabag = clearUpdateDatabag;
            } else {
                IPrincipal cuo = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipal(uniqueID, Util.EMPTY_ATTRIBUTE_LIST);
                IPrincipalDatabag pd = ((AbstractPrincipal)cuo).getPrincipalDatabag();
                PrincipalDatabag npd = new PrincipalDatabag(uniqueID);
                npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                npd.mergePrincipalDatabag((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag);
                Principal co = new Principal(npd);
                ((PrincipalFactory)UMFactory.getPrincipalFactory()).replacePrincipalInCache(co);
                PrincipalFactory.editPrincipalPerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag(npd);
                this.mPrincipalDatabag = clearUpdateDatabag;
            }
        }
        catch (DuplicateKeyException dkex) {
            if (isNewObject) {
                throw new PrincipalAlreadyExistsException((Throwable)((Object)dkex), "Error in guid generation for IPrincipal object.");
            }
            throw new AttributeValueAlreadyExistsException((Throwable)((Object)dkex));
        }
    }
}

