/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroup;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractPrincipalSet;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.GroupFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Iterator;

public class GroupWrapper
extends AbstractWrapper
implements IGroup {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/GroupWrapper.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";

    public GroupWrapper(IGroup group, AttributeList attrList) {
        super(group.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IGroup>(group);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedGroup().getParents(principalTypeIdentifiers, recursive);
    }

    public Iterator getUserMembers(boolean getChildMembers) {
        return this.getCachedGroup().getUserMembers(getChildMembers);
    }

    public Iterator getGroupMembers(boolean getChildMembers) {
        return this.getCachedGroup().getGroupMembers(getChildMembers);
    }

    public boolean isUserMember(String member, boolean checkParents) {
        return this.getCachedGroup().isUserMember(member, checkParents);
    }

    public boolean isGroupMember(String member, boolean checkParents) {
        return this.getCachedGroup().isGroupMember(member, checkParents);
    }

    public boolean addUserMember(String newMember) throws UMException {
        return this.getCachedGroup().addUserMember(newMember);
    }

    public boolean addGroupMember(String newMember) throws UMException {
        return this.getCachedGroup().addGroupMember(newMember);
    }

    public boolean removeUserMember(String oldMember) throws UMException {
        return this.getCachedGroup().removeUserMember(oldMember);
    }

    public boolean removeGroupMember(String oldMember) throws UMException {
        return this.getCachedGroup().removeGroupMember(oldMember);
    }

    public Iterator getRoles(boolean recursive) {
        return this.getCachedGroup().getRoles(recursive);
    }

    public Iterator getParentGroups(boolean recursive) {
        return this.getCachedGroup().getParentGroups(recursive);
    }

    public boolean isMemberOfRole(String roleId, boolean recursive) {
        return this.getCachedGroup().isMemberOfRole(roleId, recursive);
    }

    public boolean isMemberOfGroup(String groupId, boolean recursive) {
        return this.getCachedGroup().isMemberOfGroup(groupId, recursive);
    }

    public void addToGroup(String id) throws UMException {
        this.getCachedGroup().addToGroup(id);
    }

    public void removeFromGroup(String id) throws UMException {
        this.getCachedGroup().removeFromGroup(id);
    }

    public void addToRole(String id) throws UMException {
        this.getCachedGroup().addToRole(id);
    }

    public void removeFromRole(String id) throws UMException {
        this.getCachedGroup().removeFromRole(id);
    }

    public String getDescription() {
        return this.getCachedGroup().getDescription();
    }

    public boolean setDescription(String description) throws UMException {
        return this.getCachedGroup().setDescription(description);
    }

    public String getUniqueName() {
        return this.getCachedGroup().getUniqueName();
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        return this.getCachedGroup().setAttribute(namespace, name, values);
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        return this.getCachedGroup().setBinaryAttribute(namespace, name, value);
    }

    public boolean isModified() {
        return this.getCachedGroup().isModified();
    }

    public boolean setDisplayName(String displayName) throws UMException {
        return this.getCachedGroup().setDisplayName(displayName);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedGroup().toString());
        return res.toString();
    }

    public void commit() throws UMException {
        this.getCachedGroup().commit();
    }

    public void rollback() {
        this.getCachedGroup().rollback();
    }

    public void save() throws UMException {
        this.getCachedGroup().save();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public Date created() {
        return this.getCachedGroup().created();
    }

    public Date lastModified() {
        return this.getCachedGroup().lastModified();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedGroup().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedGroup().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedGroup().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedGroup().getAttributeNames(namespace);
    }

    public String getDisplayName() {
        return this.getCachedGroup().getDisplayName();
    }

    public boolean isExistenceChecked() {
        return this.getCachedGroup().isExistenceChecked();
    }

    public void refresh() throws UMException {
        UMFactory.getGroupFactory().invalidateCacheEntry(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IGroup getCachedGroup() {
        try {
            IGroup g = null;
            if (this.mReadonlyPrincipal != null) {
                g = (IGroup)this.mReadonlyPrincipal.get();
            }
            if (g == null) {
                g = this.mAttributeList == null ? ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroup(this.mUniqueID) : ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroup(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IGroup>(g);
            }
            return g;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isMutable() {
        return this.getCachedGroup().isMutable();
    }

    public boolean equals(Object another) {
        if (!(another instanceof IGroup)) {
            return false;
        }
        IGroup u = (IGroup)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedGroup().getAttributeType(namespace, attributeName);
    }

    public Iterator getMembers(boolean getChildMembers) {
        return ((AbstractPrincipalSet)this.getCachedGroup()).getMembers(getChildMembers);
    }

    public boolean isMember(String member, boolean recursive) {
        return ((AbstractPrincipalSet)this.getCachedGroup()).isMember(member, recursive);
    }

    public boolean addMember(String newMember) throws UMException {
        return ((AbstractPrincipalSet)this.getCachedGroup()).addMember(newMember);
    }

    public boolean removeMember(String oldMember) throws UMException {
        return ((AbstractPrincipalSet)this.getCachedGroup()).removeMember(oldMember);
    }
}

