/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.GroupAlreadyExistsException;
import com.sap.security.api.GroupListener;
import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IGroupSearchFilter;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.NoSuchGroupException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSearchFilter;
import com.sap.security.core.imp.Group;
import com.sap.security.core.imp.GroupSearchFilter;
import com.sap.security.core.imp.GroupWrapper;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.R3RoleDataSource;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class GroupFactory
implements IGroupFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/GroupFactory.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/GroupFactory.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    public static final String DEFAULT_GROUP_CACHING_TIME = "ume.cache.group.default_caching_time";
    public static final String INITIAL_GROUP_CACHE_SIZE = "ume.cache.group.initial_cache_size";
    private static ICache mCache;
    private static ICache mUNCache;
    private static Vector mAddGroupListeners;
    private static Vector mDeleteGroupListeners;
    private static Vector mAssignGroupListeners;
    private static Vector mUnassignGroupListeners;
    private static Vector mAssignUserListeners;
    private static Vector mUnassignUserListeners;
    static /* synthetic */ Class class$com$sap$security$core$imp$GroupFactory;

    public synchronized void initialize(Properties properties) {
    }

    public static ICache getCache() {
        return mCache;
    }

    public static synchronized void invalidateCache() {
        GroupFactory.invalidateCache(true);
    }

    public static synchronized void invalidateCache(boolean invalidateR3RoleDataSource) {
        if (invalidateR3RoleDataSource) {
            R3RoleDataSource.refreshRoleBuffer(false);
        }
        mCache.invalidate();
    }

    public static synchronized void invalidateGroupInCache(String uniqueID) {
        mCache.invalidate(uniqueID);
    }

    public static synchronized void invalidateGroupInCacheLocally(String uniqueID) {
        mCache.invalidateLocally(uniqueID);
    }

    public void replaceGroupInCache(IGroup group) {
        String id = group.getUniqueID();
        mCache.invalidate(id);
        mCache.put(id, group);
    }

    public void replaceGroupInCacheLocally(IGroup group) {
        String id = group.getUniqueID();
        mCache.invalidateLocally(id);
        mCache.put(id, group);
    }

    public IGroup getGroup(String uniqueID) throws NoSuchGroupException, PersistenceException {
        return this.getGroup(uniqueID, Group.GROUP_DEFAULT_ATTRIBUTES);
    }

    public IGroup getReadonlyGroup(String uniqueID) throws NoSuchGroupException, PersistenceException {
        return this.getReadonlyGroup(uniqueID, Group.GROUP_DEFAULT_ATTRIBUTES);
    }

    public IGroup getReadonlyGroup(String uniqueID, AttributeList attrlist) throws NoSuchGroupException, PersistenceException {
        if (uniqueID == null) {
            throw new NoSuchGroupException("Cannot find group when uniqueID is null!");
        }
        if (attrlist == null) {
            return this.getReadonlyGroup(uniqueID);
        }
        IGroup group = (IGroup)mCache.get(uniqueID);
        AttributeList attributeToPopulate = attrlist;
        if (group == null || !((AbstractPrincipal)group).allAttributesPopulated(attrlist)) {
            try {
                if (!"IGroup".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueID))) {
                    throw new NoSuchGroupException("The given id \"" + uniqueID + "\"is not a unique id of a group!");
                }
            }
            catch (UMException umex) {
                throw new NoSuchGroupException((Throwable)umex);
            }
            if (group != null) {
                attributeToPopulate = ((AbstractPrincipal)group).getPopulatedAttributes().getNotContainedAttributes(attrlist);
                if (attributeToPopulate.getSize() != 0) {
                    IPrincipalDatabag pdb = PrincipalDatabagFactory.getInstance().getPrincipalDatabag(group.getUniqueID(), attributeToPopulate, true);
                    if (pdb == null) {
                        throw new NoSuchGroupException("Group \"" + group.getUniqueID() + "\" doesn't exist.");
                    }
                    IPrincipalDatabag pd = ((AbstractPrincipal)group).getPrincipalDatabag();
                    PrincipalDatabag npd = new PrincipalDatabag(group.getUniqueID());
                    npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                    npd.mergePrincipalDatabag((IInternalPrincipalDatabag)pdb);
                    Group grp = new Group(npd);
                    this.replaceGroupInCacheLocally(grp);
                    group = grp;
                }
                return group;
            }
            try {
                group = new Group(uniqueID, attributeToPopulate);
            }
            catch (UMRuntimeException umrex) {
                throw new NoSuchGroupException((Throwable)umrex);
            }
            mCache.put(uniqueID, group);
        }
        return group;
    }

    public IGroup getGroup(String uniqueID, AttributeList attributeList) throws NoSuchGroupException, PersistenceException {
        IGroup group = this.getReadonlyGroup(uniqueID, attributeList);
        return new GroupWrapper(group, attributeList);
    }

    public IGroup[] getGroups(String[] uniqueIDs) throws NoSuchGroupException, PersistenceException {
        return this.getGroups(uniqueIDs, AbstractPrincipal.ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES);
    }

    public IGroup[] getGroups(String[] uniqueIDs, AttributeList attributeList) throws NoSuchGroupException, PersistenceException {
        IGroup[] result = this.getReadonlyGroups(uniqueIDs, attributeList);
        int size = result.length;
        int i = 0;
        while (i < size) {
            result[i] = new GroupWrapper(result[i], attributeList);
            ++i;
        }
        return result;
    }

    public IGroup[] getReadonlyGroups(String[] uniqueIDs) throws NoSuchGroupException, PersistenceException {
        return this.getReadonlyGroups(uniqueIDs, AbstractPrincipal.ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES);
    }

    public IGroup[] getReadonlyGroups(String[] uniqueIDs, AttributeList attributeList) throws NoSuchGroupException, PersistenceException {
        IGroup[] result = new IGroup[uniqueIDs.length];
        IGroup[] groupstoMerge = new IGroup[uniqueIDs.length];
        Vector<String> groupsToPopulate = new Vector<String>();
        IGroup group = null;
        AttributeList attributeToPopulate = new AttributeList(false);
        attributeToPopulate.addAttributeList(attributeList);
        int i = 0;
        while (i < uniqueIDs.length) {
            group = (IGroup)mCache.get(uniqueIDs[i]);
            if (group == null) {
                try {
                    if (!"IGroup".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueIDs[i]))) {
                        throw new NoSuchGroupException("The given id \"" + uniqueIDs[i] + "\"is not a unique id of a group!");
                    }
                }
                catch (UMException umex) {
                    throw new NoSuchGroupException((Throwable)umex);
                }
            }
            if (group != null && ((AbstractPrincipal)group).allAttributesPopulated(attributeList)) {
                result[i] = group;
            } else {
                if (group != null) {
                    groupstoMerge[i] = group;
                }
                groupsToPopulate.add(uniqueIDs[i]);
            }
            ++i;
        }
        Group ng = null;
        if (groupsToPopulate.size() != 0) {
            IPrincipalDatabag[] groups = PrincipalDatabagFactory.getInstance().getPrincipalDatabags(groupsToPopulate.toArray(new String[groupsToPopulate.size()]), attributeToPopulate, true);
            int dataBagCounter = 0;
            int i2 = 0;
            while (i2 < uniqueIDs.length) {
                if (result[i2] == null) {
                    if (groups[dataBagCounter] != null) {
                        if (groupstoMerge[i2] != null) {
                            PrincipalDatabag pdb = new PrincipalDatabag(groupstoMerge[i2].getUniqueID());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)((AbstractPrincipal)groupstoMerge[i2]).getPrincipalDatabag());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)groups[dataBagCounter]);
                            ng = new Group(pdb);
                        } else {
                            ng = new Group(groups[dataBagCounter]);
                        }
                    } else {
                        throw new NoSuchGroupException("Group with id " + uniqueIDs[i2] + " not found!");
                    }
                    mCache.put(ng.getUniqueID(), ng);
                    result[i2] = ng;
                    ++dataBagCounter;
                }
                ++i2;
            }
        }
        return result;
    }

    public IGroup newGroup(String uniqueName) throws GroupAlreadyExistsException {
        try {
            IGroup group;
            block6: {
                group = null;
                try {
                    group = this.getGroupByUniqueName(uniqueName);
                }
                catch (NoSuchGroupException nsge) {
                    if (!mTrace.beDebug()) break block6;
                    mTrace.debugT("newGroup", nsge);
                }
            }
            if (group != null) {
                throw new GroupAlreadyExistsException("Group with unique name " + uniqueName + " already exists!");
            }
            Group newGroup = new Group();
            newGroup.setUniqueName(uniqueName);
            return newGroup;
        }
        catch (GroupAlreadyExistsException gaeex) {
            throw gaeex;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public void deleteGroup(String uniqueID) throws UMException {
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IGroup group = this.getReadonlyGroup(uniqueID);
        mUNCache.invalidate(group.getUniqueName());
        mCache.invalidate(uniqueID);
        try {
            SearchCriteria scGroups = new SearchCriteria("GRUP");
            scGroups.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
            Vector groups = mFactory.searchPrincipalDatabags(scGroups);
            SearchCriteria scRoles = new SearchCriteria("ROLE");
            scRoles.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
            Vector roles = mFactory.searchPrincipalDatabags(scRoles);
            IDistributedTransaction distTrans = mFactory.createDistributedTransaction();
            PrincipalDatabagMaint pdbMaint = null;
            int groupsSize = groups.size();
            int rolesSize = roles.size();
            int j = 0;
            while (j < groupsSize) {
                if (UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable((String)groups.elementAt(j), "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                    pdbMaint = new PrincipalDatabagMaint((String)groups.elementAt(j));
                    pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
                    mFactory.updatePrincipalDatabag(pdbMaint, distTrans);
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < rolesSize) {
                if (UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable((String)roles.elementAt(j2), "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                    pdbMaint = new PrincipalDatabagMaint((String)roles.elementAt(j2));
                    pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
                    mFactory.updatePrincipalDatabag(pdbMaint, distTrans);
                }
                ++j2;
            }
            mFactory.deletePrincipalDatabag(new PrincipalDatabag(uniqueID), distTrans);
            distTrans.commit();
            String[] aclManagers = UMFactory.getAllAclManagers();
            if (aclManagers.length > 0) {
                mTrace.infoT("deleteGroup(String)", "Deleting group from ACL's: " + uniqueID);
                UMFactory.getAclManager((String)aclManagers[0]).deletePrincipal(uniqueID);
            }
            GroupFactory.removeGroupPerformed(uniqueID);
            int j3 = 0;
            while (j3 < groupsSize) {
                GroupFactory.unassignGroupPerformed(uniqueID, (String)groups.elementAt(j3));
                GroupFactory.invalidateGroupInCache((String)groups.elementAt(j3));
                ++j3;
            }
            int j4 = 0;
            while (j4 < rolesSize) {
                RoleFactory.unassignGroupPerformed((String)roles.elementAt(j4), uniqueID);
                RoleFactory.invalidateRoleInCache((String)roles.elementAt(j4));
                ++j4;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void commitGroups(IGroup[] groups) throws UMException {
        int size = groups.length;
        try {
            int i = 0;
            while (i < size) {
                groups[i].commit();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void rollbackGroups(IGroup[] groups) {
        int size = groups.length;
        int i = 0;
        while (i < size) {
            groups[i].rollback();
            ++i;
        }
    }

    public void saveGroups(IGroup[] groups) throws UMException {
        int size = groups.length;
        try {
            int i = 0;
            while (i < size) {
                groups[i].save();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public ISearchResult searchGroups(IGroupSearchFilter filter) throws UMException {
        if (((AbstractPrincipalSearchFilter)filter).containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        SearchCriteria sc = null;
        if (((PrincipalSearchFilter)filter).isDisplayNameSet()) {
            sc = ((PrincipalSearchFilter)filter).getSearchCriteriaForDisplayName();
        } else {
            sc = filter.getSearchMethod() == 1 ? new SearchCriteria(true, "GRUP") : new SearchCriteria(false, "GRUP");
            int i = 0;
            while (i < filter.getElementSize()) {
                ISearchAttribute sElement = filter.getSearchElementAt(i);
                String _namespace = sElement.getAttributeNameSpace();
                String _name = sElement.getAttributeName();
                Object _value = sElement.getAttributeValue();
                switch (sElement.getOperator()) {
                    case 1: {
                        sc.addLikeElement(_namespace, _name, _value, sElement.isCaseSensitive());
                        break;
                    }
                    case 0: {
                        sc.addEqualsElement(_namespace, _name, _value, sElement.isCaseSensitive());
                        break;
                    }
                    case 2: {
                        sc.addGreaterThanElement(_namespace, _name, _value, sElement.isCaseSensitive());
                        break;
                    }
                    case 3: {
                        sc.addLessThanElement(_namespace, _name, _value, sElement.isCaseSensitive());
                        break;
                    }
                    default: {
                        sc.addEqualsElement(_namespace, _name, _value, sElement.isCaseSensitive());
                    }
                }
                ++i;
            }
        }
        sc.setSearchSizeLimit(filter.getMaxSearchResultSize());
        Vector results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(results, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
        principalIterator.setState(sc.getSearchStatus());
        return principalIterator;
    }

    public IGroup getMutableGroup(String groupId) throws NoSuchGroupException, PersistenceException {
        IGroup g = this.getReadonlyGroup(groupId);
        IPrincipalDatabag p = null;
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        if (g != null) {
            p = ((AbstractPrincipal)g).getPrincipalDatabag();
        } else {
            p = new PrincipalDatabag(groupId);
            if (!mFactory.principalDatabagExists(p)) {
                throw new NoSuchGroupException("group " + groupId + " does not exist");
            }
        }
        return new Group(mFactory.getModifyPrincipalDatabag(p));
    }

    public static void addGroupPerformed(String uniqueID) throws UMException {
        int size = mAddGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mAddGroupListeners.elementAt(i)).groupAdded(uniqueID);
            ++i;
        }
        PrincipalFactory.addPrincipalPerformed(uniqueID);
    }

    public static void removeGroupPerformed(String uniqueID) throws UMException {
        int size = mDeleteGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mDeleteGroupListeners.elementAt(i)).groupRemoved(uniqueID);
            ++i;
        }
        PrincipalFactory.removePrincipalPerformed(uniqueID);
    }

    public static void assignGroupPerformed(String uniqueIdOfGroup, String uniqueIdOfParentGroup) throws UMException {
        int size = mAssignGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mAssignGroupListeners.elementAt(i)).groupAssigned(uniqueIdOfParentGroup, uniqueIdOfGroup);
            ++i;
        }
        PrincipalFactory.assignPrincipalPerformed(uniqueIdOfParentGroup, uniqueIdOfGroup);
    }

    public static void unassignGroupPerformed(String uniqueIdOfGroup, String uniqueIdOfParentGroup) throws UMException {
        int size = mUnassignGroupListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mUnassignGroupListeners.elementAt(i)).groupUnAssigned(uniqueIdOfParentGroup, uniqueIdOfGroup);
            ++i;
        }
        PrincipalFactory.unassignPrincipalPerformed(uniqueIdOfParentGroup, uniqueIdOfGroup);
    }

    public static void assignUserPerformed(String uniqueIdOfUser, String uniqueIdOfGroup) throws UMException {
        int size = mAssignUserListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mAssignUserListeners.elementAt(i)).userAssigned(uniqueIdOfGroup, uniqueIdOfUser);
            ++i;
        }
        PrincipalFactory.assignPrincipalPerformed(uniqueIdOfGroup, uniqueIdOfUser);
    }

    public static void unassignUserPerformed(String uniqueIdOfUser, String uniqueIdOfGroup) throws UMException {
        int size = mUnassignUserListeners.size();
        int i = 0;
        while (i < size) {
            ((GroupListener)mUnassignUserListeners.elementAt(i)).userUnAssigned(uniqueIdOfGroup, uniqueIdOfUser);
            ++i;
        }
        PrincipalFactory.unassignPrincipalPerformed(uniqueIdOfGroup, uniqueIdOfUser);
    }

    public void registerListener(GroupListener groupListener, int modifier) {
        boolean registered = false;
        if ((modifier & 1) == 1) {
            mAddGroupListeners.add(groupListener);
            registered = true;
        }
        if ((modifier & 2) == 2) {
            mDeleteGroupListeners.add(groupListener);
            registered = true;
        }
        if ((modifier & 8) == 8) {
            mAssignGroupListeners.add(groupListener);
            registered = true;
        }
        if ((modifier & 0x20) == 32) {
            mUnassignGroupListeners.add(groupListener);
            registered = true;
        }
        if ((modifier & 4) == 4) {
            mAssignUserListeners.add(groupListener);
            registered = true;
        }
        if ((modifier & 0x10) == 16) {
            mUnassignUserListeners.add(groupListener);
            registered = true;
        }
        if (!registered) {
            mTrace.warningT("registerListener", "GroupListener " + groupListener + " could not be registered!");
        }
    }

    public void unregisterListener(GroupListener groupListener) {
        mAddGroupListeners.remove(groupListener);
        mDeleteGroupListeners.remove(groupListener);
        mAssignGroupListeners.remove(groupListener);
        mUnassignGroupListeners.remove(groupListener);
        mAssignUserListeners.remove(groupListener);
        mUnassignUserListeners.remove(groupListener);
    }

    public String[] getParentGroups(String groupId, boolean includeParents) {
        try {
            IGroup g = this.getReadonlyGroup(groupId);
            Iterator it = g.getParentGroups(includeParents);
            Vector v = new Vector();
            while (it.hasNext()) {
                v.add(it.next());
            }
            return v.toArray(new String[0]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public String[] getChildGroups(String groupId, boolean getChildMembers) {
        try {
            IGroup g = this.getReadonlyGroup(groupId);
            Iterator it = g.getGroupMembers(getChildMembers);
            Vector v = new Vector();
            while (it.hasNext()) {
                v.add(it.next());
            }
            return v.toArray(new String[v.size()]);
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public void addGroupToParent(String groupId, String parentGroupId) throws UMException {
        IGroup g1 = UMFactory.getGroupFactory().getGroup(groupId);
        IGroup g2 = UMFactory.getGroupFactory().getGroup(parentGroupId);
        if (!g2.isGroupMember(g1.getUniqueID(), false)) {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IPrincipalDatabag p = mFactory.getPrincipalDatabag(parentGroupId, null, true);
            IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
            pm.addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", groupId);
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            GroupFactory.invalidateGroupInCache(parentGroupId);
            GroupFactory.invalidateGroupInCache(groupId);
            GroupFactory.assignGroupPerformed(groupId, parentGroupId);
        }
    }

    public void addUserToGroup(String userId, String groupId) throws UMException {
        if (userId == null) {
            throw new UMException("Cannot add member which has unique id null.");
        }
        if (userId.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            throw new UMException("SAP* cannot be added to groups.");
        }
        IUser user = UMFactory.getUserFactory().getUser(userId);
        IGroup group = UMFactory.getGroupFactory().getGroup(groupId);
        if (!group.isUserMember(user.getUniqueID(), false)) {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IPrincipalDatabag p = mFactory.getPrincipalDatabag(groupId, null, true);
            IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
            pm.addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", userId);
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            UserFactory.invalidateUserInCache(userId);
            GroupFactory.invalidateGroupInCache(groupId);
            GroupFactory.assignUserPerformed(userId, groupId);
        }
    }

    public void removeGroupFromParent(String groupId, String parentGroupId) throws UMException {
        IGroup g1 = UMFactory.getGroupFactory().getGroup(groupId);
        IGroup g2 = UMFactory.getGroupFactory().getGroup(parentGroupId);
        if (g2.isGroupMember(g1.getUniqueID(), false)) {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IPrincipalDatabag p = mFactory.getPrincipalDatabag(parentGroupId, null, true);
            IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
            pm.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", groupId);
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            GroupFactory.invalidateGroupInCache(parentGroupId);
            GroupFactory.invalidateGroupInCache(groupId);
            GroupFactory.unassignGroupPerformed(groupId, parentGroupId);
        }
    }

    public void removeUserFromGroup(String uniqueIdOfUser, String uniqueIdOfGroup) throws UMException {
        IUser user = UMFactory.getUserFactory().getUser(uniqueIdOfUser);
        IGroup group = UMFactory.getGroupFactory().getGroup(uniqueIdOfGroup);
        if (group.isUserMember(user.getUniqueID(), false)) {
            IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
            IPrincipalDatabag p = mFactory.getPrincipalDatabag(uniqueIdOfGroup, null, true);
            IPrincipalDatabagMaint pm = mFactory.getModifyPrincipalDatabag(p);
            pm.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueIdOfUser);
            IDistributedTransaction dt = mFactory.createDistributedTransaction();
            mFactory.updatePrincipalDatabag(pm, dt);
            dt.commit();
            UserFactory.invalidateUserInCache(uniqueIdOfUser);
            GroupFactory.invalidateGroupInCache(uniqueIdOfGroup);
            GroupFactory.unassignUserPerformed(uniqueIdOfUser, uniqueIdOfGroup);
        }
    }

    public IGroupSearchFilter getGroupSearchFilter() throws UMException {
        return new GroupSearchFilter();
    }

    public IGroup getGroupByUniqueName(String uniqueName) throws UMException {
        if (uniqueName == null) {
            throw new NoSuchGroupException("unique name must not be null");
        }
        String uniqueID = (String)mUNCache.get(uniqueName);
        if (uniqueID != null) {
            return this.getGroup(uniqueID);
        }
        SearchCriteria sc = new SearchCriteria("GRUP");
        sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueName, false);
        Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        if (result == null || result.size() == 0) {
            throw new NoSuchGroupException("Group \"" + uniqueName + "\" does not exist.");
        }
        if (result.size() > 1) {
            throw new UMException("Group found, but unique name \"" + uniqueName + "\" is not unique!");
        }
        mUNCache.put(uniqueName, (String)result.firstElement());
        return this.getGroup((String)result.firstElement());
    }

    public void invalidateCacheEntryByUniqueName(String uniqueName) throws UMException {
        String uniqueID = (String)mUNCache.get(uniqueName);
        if (uniqueID == null) {
            SearchCriteria sc = new SearchCriteria(false, "GRUP");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueName, false);
            Vector sr = null;
            try {
                sr = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            }
            catch (PersistenceException ex) {
                throw new UMException((Throwable)((Object)ex));
            }
            if (sr != null) {
                int size = sr.size();
                if (size == 1) {
                    uniqueID = (String)sr.elementAt(0);
                    mCache.invalidateLocally(uniqueID);
                    mUNCache.put(uniqueName, uniqueID);
                } else {
                    mUNCache.invalidateLocally(uniqueName);
                    int i = 0;
                    while (i < size) {
                        uniqueID = (String)sr.elementAt(i);
                        mCache.invalidateLocally(uniqueID);
                        ++i;
                    }
                }
            }
        } else {
            mCache.invalidateLocally(uniqueID);
        }
    }

    public void invalidateCacheEntry(String uniqueid) throws UMException {
        mCache.invalidateLocally(uniqueid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = props.getNumber(DEFAULT_GROUP_CACHING_TIME, 28800);
        int initialSize = props.getNumber(INITIAL_GROUP_CACHE_SIZE, 500);
        mCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$GroupFactory == null ? (class$com$sap$security$core$imp$GroupFactory = GroupFactory.class$("com.sap.security.core.imp.GroupFactory")) : class$com$sap$security$core$imp$GroupFactory).getName() + "_mCache");
        mUNCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$GroupFactory == null ? (class$com$sap$security$core$imp$GroupFactory = GroupFactory.class$("com.sap.security.core.imp.GroupFactory")) : class$com$sap$security$core$imp$GroupFactory).getName() + "_mUNCache");
        mAddGroupListeners = new Vector();
        mDeleteGroupListeners = new Vector();
        mAssignGroupListeners = new Vector();
        mUnassignGroupListeners = new Vector();
        mAssignUserListeners = new Vector();
        mUnassignUserListeners = new Vector();
    }
}

