/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.GroupAlreadyExistsException;
import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.NoSuchPrincipalException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.UserAdminHelper;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSet;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class Group
extends AbstractPrincipalSet
implements IGroup {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Group.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/Group.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    public static AttributeList GROUP_DEFAULT_ATTRIBUTES = new AttributeList(false);

    public Group(String uniqueID) {
        this(uniqueID, true, null);
    }

    public Group(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public Group(String uniqueID, boolean checkExistence) {
        super(uniqueID, checkExistence, null);
    }

    public Group(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        super(uniqueID, checkExistence, populateAttributes);
    }

    public Group(IPrincipalDatabag principal) {
        this.mPrincipalDatabag = principal;
    }

    public Group(IPrincipalDatabagMaint principalMaint) {
        this.mPrincipalDatabag = principalMaint;
        this.mPrepared = true;
    }

    protected synchronized void init(String uniqueID) {
        if (this.mAttributeList == null) {
            this.mAttributeList = GROUP_DEFAULT_ATTRIBUTES;
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
            this.mPrincipalDatabag = this.mFactory.getPrincipalDatabag(uniqueID, this.mAttributeList, true);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (this.mPrincipalDatabag == null) {
            throw new UMRuntimeException("Group " + uniqueID + " doesn't exist!");
        }
        this.mExistenceNotChecked = false;
    }

    protected Group() {
        PrincipalDatabagMaint newPrincipal = new PrincipalDatabagMaint(null);
        newPrincipal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", this.convertToVector("GRUP"));
        this.mPrincipalDatabag = newPrincipal;
        this.mPrepared = true;
    }

    public IGroupFactory getGroupFactory() {
        return UMFactory.getGroupFactory();
    }

    public boolean equals(Object another) {
        if (!(another instanceof IGroup)) {
            return false;
        }
        IGroup u = (IGroup)another;
        return this.mPrincipalDatabag.getUniqueID().equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mPrincipalDatabag.getUniqueID().hashCode();
    }

    private void checkForCycle() throws UMException {
        Iterator iter;
        Vector vals = null;
        String id = null;
        String uniqueID = this.mPrincipalDatabag.getUniqueID();
        IGroup g = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroup(uniqueID);
        PrincipalIteratorImpl it = (PrincipalIteratorImpl)((Object)g.getParentGroups(true));
        vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0);
        if (vals != null) {
            iter = ((AbstractList)vals).iterator();
            while (iter.hasNext()) {
                id = (String)iter.next();
                if (!id.startsWith("GRUP") || !it.contains(id) && !uniqueID.equals(id)) continue;
                throw new UMException("Adding member \"" + id + "\" to group \"" + uniqueID + "\" is not allowed, because this would create a cycle.");
            }
        }
        if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2)) != null) {
            iter = ((AbstractList)vals).iterator();
            while (iter.hasNext()) {
                id = (String)iter.next();
                if (!id.startsWith("GRUP") || !it.contains(id) && !uniqueID.equals(id)) continue;
                throw new UMException("Adding member \"" + id + "\" to group \"" + uniqueID + "\" is not allowed, because this would create a cycle.");
            }
        }
    }

    public void commit() throws UMException {
        boolean isNewGroup;
        if (!this.mPrepared) {
            String errorMessage = "Maint method commit cannot be used because the group is not mutable!";
            throw new UMException(errorMessage);
        }
        if (this.mPrincipalDatabag.containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        boolean bl = isNewGroup = this.mPrincipalDatabag.getUniqueID() == null;
        if (!isNewGroup) {
            this.checkForCycle();
        }
        try {
            int i;
            int size;
            IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
            if (isNewGroup) {
                block35: {
                    try {
                        IGroup g = UMFactory.getGroupFactory().getGroupByUniqueName(this.getUniqueName());
                        if (g != null) {
                            throw new UMException("A group with the unique name " + this.getUniqueName() + " was created on the persistence in the meantime!");
                        }
                    }
                    catch (NoSuchPrincipalException nspex) {
                        if (!mTrace.beDebug()) break block35;
                        mTrace.debugT("commit", nspex);
                    }
                }
                this.mPrincipalDatabag = this.mFactory.createPrincipalDatabag(dTrans, (IPrincipalDatabagMaint)this.mPrincipalDatabag);
            } else {
                this.mFactory.updatePrincipalDatabag((IPrincipalDatabagMaint)this.mPrincipalDatabag, dTrans);
            }
            dTrans.commit();
            Vector vals = null;
            String id = null;
            String principalType = null;
            String uniqueID = this.mPrincipalDatabag.getUniqueID();
            if (isNewGroup) {
                vals = this.mPrincipalDatabag.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            GroupFactory.assignUserPerformed(id, uniqueID);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.assignGroupPerformed(id, uniqueID);
                        }
                        ++i;
                    }
                }
            } else {
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0);
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            GroupFactory.assignUserPerformed(id, uniqueID);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.assignGroupPerformed(id, uniqueID);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            GroupFactory.assignUserPerformed(id, uniqueID);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.assignGroupPerformed(id, uniqueID);
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        PrincipalFactory.invalidatePrincipalInCache(id);
                        UserFactory.invalidateUserInCache(id);
                        GroupFactory.invalidateGroupInCache(id);
                        principalType = UMFactory.getPrincipalFactory().getPrincipalType(id);
                        if ("IUser".equals(principalType)) {
                            GroupFactory.unassignUserPerformed(id, uniqueID);
                        } else if ("IGroup".equals(principalType)) {
                            GroupFactory.unassignGroupPerformed(id, uniqueID);
                        }
                        ++i;
                    }
                }
            }
            if (isNewGroup) {
                GroupFactory.addGroupPerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
                this.mPrincipalDatabag = clearUpdateDatabag;
            } else {
                IGroup g = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroup(uniqueID, Util.EMPTY_ATTRIBUTE_LIST);
                IPrincipalDatabag pd = ((AbstractPrincipal)g).getPrincipalDatabag();
                PrincipalDatabag npd = new PrincipalDatabag(uniqueID);
                npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                npd.mergePrincipalDatabag((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag);
                Group gr = new Group(npd);
                ((GroupFactory)UMFactory.getGroupFactory()).replaceGroupInCache(gr);
                PrincipalFactory.invalidatePrincipalInCache(uniqueID);
                PrincipalFactory.editPrincipalPerformed(uniqueID);
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag(npd);
                this.mPrincipalDatabag = clearUpdateDatabag;
            }
        }
        catch (DuplicateKeyException dkex) {
            if (isNewGroup) {
                throw new GroupAlreadyExistsException((Throwable)((Object)dkex), "Group with unique name \"" + this.getUniqueName() + "\" already exists.");
            }
            throw new AttributeValueAlreadyExistsException((Throwable)((Object)dkex));
        }
    }

    public void save() throws UMException {
    }

    public void addToGroup(String id) throws UMException {
        UMFactory.getGroupFactory().addGroupToParent(this.getUniqueID(), id);
        if (this.mDirectGroups != null && !this.mDirectGroups.contains(id)) {
            this.mDirectGroups.add(id);
        }
        this.mAllGroups = null;
        this.mAllRoles = null;
    }

    public void removeFromGroup(String id) throws UMException {
        UMFactory.getGroupFactory().removeGroupFromParent(this.getUniqueID(), id);
        this.mAllGroups = null;
        this.mAllRoles = null;
    }

    public void addToRole(String id) throws UMException {
        UMFactory.getRoleFactory().addGroupToRole(this.getUniqueID(), id);
        if (this.mDirectRoles != null && !this.mDirectRoles.contains(id)) {
            this.mDirectRoles.add(id);
        }
        if (this.mAllRoles != null && !this.mAllRoles.contains(id)) {
            this.mAllRoles.add(id);
        }
    }

    public void removeFromRole(String id) throws UMException {
        UMFactory.getRoleFactory().removeGroupFromRole(this.getUniqueID(), id);
        if (this.mDirectRoles != null && this.mDirectRoles.contains(id)) {
            this.mDirectRoles.remove(id);
        }
        this.mAllRoles = null;
    }

    static {
        GROUP_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "uniquename", 1);
        if (UserAdminHelper.isCompanyConceptEnabled()) {
            GROUP_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "company", 1);
        }
    }
}

