/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.ISecurityPolicy;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.InvalidPasswordException;
import com.sap.security.api.NoSuchUserAccountException;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.UserAccountAlreadyExistsException;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.ticket.TicketVerifyException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.DBTextFileUserAccount;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.User;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.imp.UserWrapper;
import com.sap.security.core.logon.imp.SecurityPolicyFactory;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.persistence.replication.imp.MessagingHandler;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractUserAccount
extends AbstractPrincipal
implements IUserAccount {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractUserAccount.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    public static final String INTERNAL_ID = "internalid";
    public static final String VALID_FROM = "validfrom";
    public static final String VALID_TO = "validto";
    public static final String IS_LOCKED = "islocked";
    public static final String LOCK_REASON = "lockreason";
    public static final String LOCK_DATE = "lockdate";
    public static final String LAST_FAILED_LOGON = "lastfailedlogon";
    public static final String LAST_LOGOUT = "lastlogout";
    public static final String FAILED_LOGON_ATTEMPTS = "failedlogonattempts";
    public static final String LAST_SUCCESSFUL_LOGON = "lastsuccessfullogon";
    public static final String PREVIOUS_SUCCESSFUL_LOGON = "previoussuccessfullogon";
    public static final String SUCCESSFUL_LOGON_COUNT = "successfullogoncount";
    public static final String PASSWORD_CHANGE_REQUIRED = "passwordchangerequired";
    public static final String LAST_PASSWORD_CHANGE = "lastpasswordchange";
    public static final String ACCOUNT_USER_ID = "userid";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String CERTIFICATE_HASH = "certificatehash";
    public static final String CERTIFICATE = "javax.servlet.request.X509Certificate";
    public static final String OLD_PASSWORD = "oldpassword";
    public static final String LOGON_ATTRIBUTES = "ume.account.suppress_notification.attributes";
    protected Date mValidFrom;
    protected Date mValidTo;
    protected boolean mIsLocked;
    protected int mLockReason;
    protected Date mLockDate;
    protected Date mLastFailedLogon;
    protected int mFailedLogonAttempts;
    protected Date mLastLogout;
    protected Date mLastSuccessfulLogon;
    protected Date mPreviousSuccessfulLogon;
    protected int mSuccessfulLogonCount;
    protected boolean mPasswordChangeRequired;
    protected Date mLastPasswordChange;
    protected String[] mDates;
    protected String mLogonUid;
    protected String mHashedPassword;
    protected X509Certificate[] mCertificates;
    protected String mInternalUserID;
    protected boolean mIsCurrentlyRefreshing;
    protected boolean mLockSet;
    protected boolean mPasswordSet;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractUserAccount.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    public static AttributeList ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES = new AttributeList(false);
    private static AttributeList accountAttributesWhichDontRequireExistenceCheck;
    private static Vector mSetAttributesToCheck;
    private ISecurityPolicy mSecPol;

    public AbstractUserAccount(X509Certificate cert) throws UMException, TicketException {
        this(cert, null);
    }

    public AbstractUserAccount(X509Certificate cert, String[] dataSources) throws UMException, TicketException {
        this(cert, null, dataSources);
    }

    public AbstractUserAccount(X509Certificate cert, AttributeList attrList, String[] dataSources) throws UMException, TicketException {
        Vector sr = null;
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{cert});
        }
        this.mLockSet = false;
        this.mPasswordSet = false;
        if (cert == null) {
            throw new TicketException("NO_CERTIFICATE");
        }
        byte[] dummy = null;
        try {
            dummy = cert.getEncoded();
        }
        catch (CertificateException cex) {
            mTrace.errorT("Constructor", "Error while accessing certificate: " + cex.getMessage());
            throw new TicketVerifyException("CERT_GET_ERROR");
        }
        SearchCriteria sc = new SearchCriteria(true, "UACC", dataSources);
        sc.addEqualsElement("com.sap.security.core.usermanagement", CERTIFICATE_HASH, Base64.encode(Util.createMD5HashValue(dummy)), true);
        sc.addEqualsElement("com.sap.security.core.usermanagement", CERTIFICATE, cert, true);
        try {
            sr = this.mFactory.searchPrincipalDatabags(sc);
        }
        catch (PersistenceException ex) {
            throw new UMException((Throwable)((Object)ex));
        }
        if (sr != null) {
            int size = sr.size();
            if (size == 0) {
                String errorMessage = "User account for certificate " + cert.toString() + " not found!";
                if (mTrace.beInfo()) {
                    mTrace.infoT("constructor", errorMessage);
                }
                throw new TicketException("NO_USER_CERTIFICATE");
            }
            if (size > 1) {
                throw new TicketVerifyException("CERT_NOT_UNIQUE");
            }
            String internalID = (String)sr.firstElement();
            if (internalID == null) {
                throw new TicketException("NO_USER_CERTIFICATE");
            }
            this.mAttributeList = attrList;
            try {
                this.init(internalID);
            }
            catch (UMRuntimeException umrex) {
                throw new NoSuchUserAccountException((Throwable)umrex);
            }
            if (mTrace.bePath()) {
                mTrace.exiting("constructor");
            }
        } else {
            throw new TicketException("NO_USER_CERTIFICATE");
        }
    }

    public AbstractUserAccount(IPrincipalDatabag dataBag) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{dataBag});
        }
        this.mPrincipalDatabag = dataBag;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
        this.mLockSet = false;
        this.mPasswordSet = false;
    }

    public AbstractUserAccount(String id, boolean isLogonId) throws UMException {
        this(id, null, isLogonId, null);
    }

    public AbstractUserAccount(String id, boolean isLogonId, String[] datasources) throws UMException {
        this(id, null, isLogonId, datasources);
    }

    public AbstractUserAccount(String id, AttributeList populateAttributes, boolean isLogonId) throws UMException {
        this(id, populateAttributes, isLogonId, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractUserAccount(String id, AttributeList populateAttributes, boolean isLogonId, String[] dataSources) throws UMException {
        Vector sr = null;
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{id});
        }
        if (id == null) {
            throw new UMException("No unique ID given!");
        }
        this.mLockSet = false;
        this.mPasswordSet = false;
        if (isLogonId) {
            SearchCriteria sc = new SearchCriteria(true, "UACC", dataSources);
            sc.addEqualsElement("com.sap.security.core.usermanagement", "j_user", id, false);
            try {
                sr = this.mFactory.searchPrincipalDatabags(sc);
            }
            catch (PersistenceException ex) {
                throw new UMException((Throwable)((Object)ex));
            }
            if (sr != null) {
                int size = sr.size();
                if (size == 0) {
                    String errorMessage = "User account for logonid \"" + id + "\" not found!";
                    throw new NoSuchUserAccountException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
                }
                if (size > 1) {
                    String errorMessage = "Logonid \"" + id + "\" is not unique!";
                    throw new UMException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
                }
                String internalID = (String)sr.firstElement();
                if (internalID == null) {
                    String errorMessage = "User account for logonid \"" + id + "\" found, but unique id is null!";
                    throw new NoSuchUserAccountException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
                }
                this.mAttributeList = populateAttributes;
                try {
                    this.init(internalID);
                }
                catch (UMRuntimeException umrex) {
                    throw new NoSuchUserAccountException((Throwable)umrex);
                }
                if (!mTrace.bePath()) return;
                mTrace.exiting("constructor");
                return;
            }
            String errorMessage = "User account for logonid \"" + id + "\" not found!";
            if (!mTrace.beInfo()) throw new NoSuchUserAccountException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
            mTrace.infoT("constructor", errorMessage);
            throw new NoSuchUserAccountException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
        }
        this.mAttributeList = populateAttributes;
        try {
            this.init(id);
        }
        catch (UMRuntimeException umrex) {
            throw new NoSuchUserAccountException((Throwable)umrex);
        }
        if (!mTrace.bePath()) return;
        mTrace.exiting("constructor");
    }

    public AbstractUserAccount() {
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        this.prepare();
        PrincipalDatabagMaint newPrincipal = new PrincipalDatabagMaint(null);
        newPrincipal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", this.convertToVector("UACC"));
        this.mPrincipalDatabag = newPrincipal;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
        this.mLockSet = false;
        this.mPasswordSet = false;
    }

    protected synchronized void init(String internalAccountID) {
        if (this.mAttributeList == null) {
            this.mAttributeList = ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES;
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        try {
            boolean checkExistence = !this.mAttributeList.isSubsetOf(accountAttributesWhichDontRequireExistenceCheck);
            this.mPrincipalDatabag = this.mFactory.getPrincipalDatabag(internalAccountID, this.mAttributeList, checkExistence);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (this.mPrincipalDatabag == null) {
            String errorMessage = "Account " + internalAccountID + " doesn't exist!";
            throw new UMRuntimeException((Throwable)((Object)new PersistenceException(errorMessage)), "USER_AUTH_FAILED");
        }
    }

    public String getAssignedUserID() {
        if (this.mInternalUserID == null) {
            String uid = this.getAttributeValueString("com.sap.security.core.usermanagement", ACCOUNT_USER_ID);
            this.mInternalUserID = uid == null || uid.equals("") ? null : uid;
        }
        return this.mInternalUserID;
    }

    public String getLogonUid() {
        if (this.mLogonUid == null) {
            this.mLogonUid = this.getAttributeValueString("com.sap.security.core.usermanagement", "j_user");
            if (this.mLogonUid == null && !this.mPrepared) {
                UserAccountFactory.invalidateUserAccountInCache(this.getUniqueID());
                throw new PrincipalNotAccessibleException("User account \"" + this.getUniqueID() + "\" is not accessible because the logonid is not available.");
            }
        }
        return this.mLogonUid;
    }

    public Date getValidFromDate() {
        if (this.mValidFrom == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", VALID_FROM);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mValidFrom = dat;
        }
        return this.mValidFrom;
    }

    public void setValidFromDate(Date date) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setValidFromDate cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", VALID_FROM, this.convertToVector(Util.getTime(date.getTime())));
        this.mValidFrom = date;
    }

    public Date getValidToDate() {
        if (this.mValidTo == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", VALID_TO);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mValidTo = dat;
        }
        if (this.mValidTo == null) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            try {
                this.mValidTo = df.parse("12/31/2500");
            }
            catch (Exception e) {
                mTrace.debugT("getValidToDate", e.getMessage(), e);
            }
        }
        return this.mValidTo;
    }

    public void setValidToDate(Date date) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setValidToDate cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", VALID_TO, this.convertToVector(Util.getTime(date.getTime())));
        this.mValidTo = date;
    }

    public boolean isLocked() {
        String isLocked = this.getAttributeValueString("com.sap.security.core.usermanagement", IS_LOCKED);
        if (isLocked == null) {
            isLocked = FALSE;
        }
        this.mIsLocked = isLocked.equalsIgnoreCase(TRUE);
        if (this.mIsLocked && this.getLockReason() == 1) {
            boolean bAutoLock = false;
            Date failedLogonDate = this.getLastFailedLogonDate();
            Date current = new Date();
            ISecurityPolicy securityPolicy = UMFactory.getSecurityPolicy();
            if (failedLogonDate != null) {
                int unlockTimeInMinutes = securityPolicy.getAutoUnlockTime();
                if (current.getTime() - failedLogonDate.getTime() >= (long)(unlockTimeInMinutes * 60 * 1000)) {
                    this.mIsLocked = false;
                    IUserAccount musUAcc = null;
                    try {
                        musUAcc = UMFactory.getUserAccountFactory().getMutableUserAccount(this.getUniqueID());
                        musUAcc.setFailedLogonAttempts(0);
                        musUAcc.setLocked(false, 0);
                        musUAcc.commit();
                    }
                    catch (UMException umex) {
                        mTrace.infoT("isLocked", "Error committing auto unlock to mutable useraccount.", umex);
                    }
                }
            }
        }
        return this.mIsLocked;
    }

    public void setLocked(boolean lock, int reason) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setLocked cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (!lock) {
            reason = 0;
        }
        if (reason == 1 && lock && this.isLocked() && this.getLockReason() != 0) {
            return;
        }
        this.mLockSet = true;
        String isLocked = null;
        if (lock) {
            isLocked = TRUE;
        } else {
            isLocked = FALSE;
            this.mLockDate = null;
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", IS_LOCKED, this.convertToVector(isLocked));
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LOCK_REASON, this.convertToVector("" + reason));
        this.mIsLocked = lock;
        this.mLockReason = reason;
    }

    public int getLockReason() {
        String lockReason = this.getAttributeValueString("com.sap.security.core.usermanagement", LOCK_REASON);
        this.mLockReason = lockReason == null ? 0 : Integer.parseInt(lockReason);
        return this.mLockReason;
    }

    public Date getLastFailedLogonDate() {
        if (this.mLastFailedLogon == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", LAST_FAILED_LOGON);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mLastFailedLogon = dat;
        }
        return this.mLastFailedLogon;
    }

    public void setLastFailedLogonDate(Date timeStamp) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setLastFailedLogonDate cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LAST_FAILED_LOGON, this.convertToVector(Util.getTime(timeStamp.getTime())));
        this.mLastFailedLogon = timeStamp;
    }

    public int getFailedLogonAttempts() {
        String failedLogonAttempts = this.getAttributeValueString("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPTS);
        this.mFailedLogonAttempts = failedLogonAttempts == null ? 0 : Integer.parseInt(failedLogonAttempts);
        return this.mFailedLogonAttempts;
    }

    public void setFailedLogonAttempts(int i) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setFailedLogonAttempts cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPTS, this.convertToVector("" + i));
        this.mFailedLogonAttempts = i;
    }

    public void incrementFailedLogonAttempts() {
        if (!this.mPrepared) {
            String errorMessage = "Maint method incrementFailedLogonAttempts cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        this.mFailedLogonAttempts = this.getFailedLogonAttempts();
        ++this.mFailedLogonAttempts;
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPTS, this.convertToVector("" + this.mFailedLogonAttempts));
    }

    public void resetFailedLogonAttempts() {
        if (!this.mPrepared) {
            String errorMessage = "Maint method resetFailedLogonAttempts cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        this.mFailedLogonAttempts = 0;
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPTS, this.convertToVector("" + this.mFailedLogonAttempts));
    }

    public Date getLastSuccessfulLogonDate() {
        if (this.mLastSuccessfulLogon == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", LAST_SUCCESSFUL_LOGON);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mLastSuccessfulLogon = dat;
        }
        return this.mLastSuccessfulLogon;
    }

    public Date getLastLogoutDate() {
        if (this.mLastLogout == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", LAST_LOGOUT);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mLastLogout = dat;
        }
        return this.mLastLogout;
    }

    public Date getPreviousSuccessfulLogonDate() {
        if (this.mPreviousSuccessfulLogon == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", PREVIOUS_SUCCESSFUL_LOGON);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mPreviousSuccessfulLogon = dat;
        }
        return this.mPreviousSuccessfulLogon;
    }

    public void setLastSuccessfulLogonDate(Date timeStamp) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setLastSuccessfulLogonDate cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        Date lastSuccess = this.getLastSuccessfulLogonDate();
        if (lastSuccess != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", PREVIOUS_SUCCESSFUL_LOGON, this.convertToVector(Util.getTime(lastSuccess.getTime())));
            this.mPreviousSuccessfulLogon = lastSuccess;
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LAST_SUCCESSFUL_LOGON, this.convertToVector(Util.getTime(timeStamp.getTime())));
        this.mLastSuccessfulLogon = timeStamp;
    }

    public void setLastLogoutDate(Date timeStamp) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setLastLogoutDate cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LAST_LOGOUT, this.convertToVector(Util.getTime(timeStamp.getTime())));
        this.mLastLogout = timeStamp;
    }

    public int getSuccessfulLogonCounts() {
        String successfulLogonCount = this.getAttributeValueString("com.sap.security.core.usermanagement", SUCCESSFUL_LOGON_COUNT);
        this.mSuccessfulLogonCount = successfulLogonCount == null ? 0 : Integer.parseInt(successfulLogonCount);
        return this.mSuccessfulLogonCount;
    }

    public void incrementSuccessfulLogonCounts() {
        if (!this.mPrepared) {
            String errorMessage = "Maint method incrementSuccessfulLogonCounts cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        this.mSuccessfulLogonCount = this.getSuccessfulLogonCounts();
        ++this.mSuccessfulLogonCount;
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", SUCCESSFUL_LOGON_COUNT, this.convertToVector("" + this.mSuccessfulLogonCount));
    }

    public void setSuccessfulLogonCounts(int i) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setSuccessfulLogonCounts cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", SUCCESSFUL_LOGON_COUNT, this.convertToVector("" + i));
        this.mSuccessfulLogonCount = i;
    }

    public boolean isPasswordChangeRequired() {
        Date lastPwdChangeDate;
        if (!this.getSecPol().getPasswordChangeAllowed()) {
            return false;
        }
        String pwdChangeRequired = this.getAttributeValueString("com.sap.security.core.usermanagement", PASSWORD_CHANGE_REQUIRED);
        if (pwdChangeRequired == null) {
            pwdChangeRequired = FALSE;
        } else {
            this.mPasswordChangeRequired = pwdChangeRequired.equalsIgnoreCase(TRUE);
        }
        if (!this.mPasswordChangeRequired && (lastPwdChangeDate = this.getLastPasswordChangedDate()) != null) {
            long lastTime = lastPwdChangeDate.getTime();
            long thisTime = new Date().getTime();
            long diffTime = thisTime - lastTime;
            long diffDays = diffTime / 1000L / 60L / 60L / 24L;
            if (diffDays > (long)this.getSecPol().getPasswordExpiredDays()) {
                return true;
            }
        }
        return this.mPasswordChangeRequired;
    }

    public Date getLastPasswordChangedDate() {
        if (this.mLastPasswordChange == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", LAST_PASSWORD_CHANGE);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mLastPasswordChange = dat;
        }
        return this.mLastPasswordChange;
    }

    public void setPasswordChangeRequired(boolean chng) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setPasswordChangeRequired cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        String pwdChangeRequired = null;
        pwdChangeRequired = chng ? TRUE : FALSE;
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", PASSWORD_CHANGE_REQUIRED, this.convertToVector(pwdChangeRequired));
        this.mPasswordChangeRequired = chng;
    }

    public void setPassword(String pass) throws InvalidPasswordException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setPassword cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (!this.getSecPol().isPasswordValid(pass, this.mLogonUid)) {
            throw new InvalidPasswordException("NEW_PASSWORD_INVALID");
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "j_password", this.convertToVector(pass));
        this.mHashedPassword = null;
        this.mPasswordSet = true;
        this.setPasswordChangeRequired(true);
    }

    public void setLogonUid(String logonuid) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setLogonUid cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "j_user", this.convertToVector(logonuid));
        this.mLogonUid = logonuid;
    }

    public void assignUser(String userId) throws NoSuchUserException {
        Object user = null;
        if (!this.mPrepared) {
            String errorMessage = "Maint method assignUser cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (userId == null) {
            String errorMessage = "Cannot assign user to user account because the user is null or does not have a unique id!";
            throw new NoSuchUserException(errorMessage);
        }
        try {
            if (UserFactory.getCache().get(userId) == null && !this.mFactory.principalDatabagExists(new PrincipalDatabag(userId))) {
                throw new NoSuchUserException("USER_AUTH_FAILED");
            }
        }
        catch (UMException umex) {
            throw new NoSuchUserException((Throwable)umex, "USER_AUTH_FAILED");
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", ACCOUNT_USER_ID, this.convertToVector(userId));
        this.mInternalUserID = userId;
    }

    public IUser getAssignedUser() throws UMException {
        String uid = this.getAssignedUserID();
        if (uid == null) {
            IUser foundUser;
            block4: {
                IUserSearchFilter usf = UMFactory.getUserFactory().getUserSearchFilter();
                usf.setSearchAttribute("com.sap.security.core.usermanagement", "j_user", this.getLogonUid(), 0, false);
                ISearchResult res = UMFactory.getUserFactory().searchUsers(usf);
                foundUser = null;
                if (res.hasNext()) {
                    try {
                        foundUser = UMFactory.getUserFactory().getUser((String)res.next());
                    }
                    catch (NoSuchUserException nsuex) {
                        foundUser = null;
                        if (!mTrace.beDebug()) break block4;
                        mTrace.debugT("getAssignedUser", nsuex);
                    }
                }
            }
            return foundUser;
        }
        IUser user = UMFactory.getUserFactory().getUser(uid);
        return user;
    }

    public boolean isUserAssigned() {
        String uid = this.getAssignedUserID();
        boolean isAssigned = uid != null && !uid.equals("");
        return isAssigned;
    }

    public void setPassword(String oldpass, String newpass) throws InvalidPasswordException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setPassword cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (!this.getSecPol().getPasswordChangeAllowed()) {
            throw new InvalidPasswordException("CHANGE_PASSWORD_NOT_ALLOWED");
        }
        if (!this.getSecPol().isPasswordValid(newpass, this.mLogonUid)) {
            throw new InvalidPasswordException("NEW_PASSWORD_INVALID");
        }
        if (!this.getSecPol().getOldInNewAllowed() && -1 != newpass.indexOf(oldpass)) {
            throw new InvalidPasswordException("OLDPASSWORD_IN_NEWPASSWORD");
        }
        Hashtable<String, Object> credentials = new Hashtable<String, Object>();
        credentials.put("j_user", this.getLogonUid());
        credentials.put("j_password", oldpass);
        String uniqueID = this.mPrincipalDatabag.getUniqueID();
        if (uniqueID != null) {
            try {
                String[] idParts = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getPrincipalIdParts(uniqueID);
                credentials.put("dataSourceIDs", new String[]{idParts[1]});
            }
            catch (UMException umex) {
                throw new UMRuntimeException((Throwable)umex);
            }
        }
        try {
            if (!this.mFactory.checkCredentials(credentials)) {
                String errorMessage = "Wrong old password, cannot set the new password for user account \"" + this.mLogonUid + "\" because the provided old password is not ok!";
                if (mTrace.beInfo()) {
                    mTrace.infoT("setPassword", errorMessage);
                }
                throw new InvalidPasswordException("WRONG_PASSWORD");
            }
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "j_password", this.convertToVector(newpass));
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", OLD_PASSWORD, this.convertToVector(oldpass));
        this.mHashedPassword = null;
        this.mPasswordSet = true;
        this.setPasswordChangeRequired(false);
    }

    public void save() throws UMException {
    }

    public X509Certificate[] getCertificates() throws CertificateException, UMException {
        if (this.mCertificates == null) {
            Vector certificates = this.getAttributeValuesBlobArray("com.sap.security.core.usermanagement", CERTIFICATE);
            X509Certificate[] results = null;
            if (certificates == null || certificates.isEmpty()) {
                return new X509Certificate[0];
            }
            int size = certificates.size();
            results = new X509Certificate[size];
            ByteArrayInputStream bais = null;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (i < size) {
                bais = new ByteArrayInputStream((byte[])certificates.elementAt(i));
                results[i] = (X509Certificate)cf.generateCertificate(bais);
                ++i;
            }
            this.mCertificates = results;
        }
        return this.mCertificates;
    }

    public void setCertificates(X509Certificate[] certificate) throws CertificateException, UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setCertificates cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (certificate != null) {
            byte[] dummy = null;
            Vector<byte[]> certs = new Vector<byte[]>();
            Vector<String> certHashes = new Vector<String>();
            int size = certificate.length;
            int i = 0;
            while (i < size) {
                dummy = certificate[i].getEncoded();
                certs.add(dummy);
                certHashes.add(Base64.encode(Util.createMD5HashValue(dummy)));
                ++i;
            }
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE, certs);
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE_HASH, certHashes);
            this.mCertificates = certificate;
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE, new Vector());
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE_HASH, new Vector());
            this.mCertificates = new X509Certificate[0];
        }
    }

    public void deleteCertificates(X509Certificate[] certificate) throws CertificateException, UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method deleteCertificates cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (certificate != null) {
            int size = certificate.length;
            byte[] dummy = null;
            Vector<byte[]> leftCertificates = new Vector<byte[]>();
            Vector<String> leftCertificateHashes = new Vector<String>();
            X509Certificate[] dummy2 = this.getCertificates();
            if (dummy2 != null) {
                int j = 0;
                while (j < dummy2.length) {
                    boolean found = false;
                    int i = 0;
                    while (i < size && !found) {
                        if (dummy2[j].equals(certificate[i])) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        dummy = dummy2[j].getEncoded();
                        leftCertificates.add(dummy);
                        leftCertificateHashes.add(Base64.encode(Util.createMD5HashValue(dummy)));
                    }
                    ++j;
                }
                if (leftCertificates.size() > 0) {
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE, leftCertificates);
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE_HASH, leftCertificateHashes);
                } else {
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE);
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE_HASH);
                }
            }
            this.mCertificates = null;
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE, new Vector());
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", CERTIFICATE_HASH, new Vector());
            this.mCertificates = new X509Certificate[0];
        }
    }

    public boolean checkPassword(String pass) {
        Hashtable<String, Object> credentials;
        boolean valid;
        block4: {
            valid = false;
            String logonUid = this.getLogonUid();
            credentials = new Hashtable<String, Object>();
            credentials.put("j_user", logonUid);
            credentials.put("j_password", pass);
            try {
                String[] idParts = this.mPrincipalDatabag.getIDParts();
                credentials.put("dataSourceIDs", new String[]{idParts[1]});
            }
            catch (PersistenceException pex) {
                if (!mTrace.beInfo()) break block4;
                mTrace.infoT("", "Could not get idparts of uniqueid. Maybe uniqueid is not set yet.", (Throwable)((Object)pex));
            }
        }
        try {
            valid = this.mFactory.checkCredentials(credentials);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        return valid;
    }

    public synchronized void prepare() {
        if (!this.mPrepared) {
            PrincipalDatabagMaint maintPrincipalDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
            maintPrincipalDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
            this.mPrincipalDatabag = maintPrincipalDatabag;
            this.mPrepared = true;
        }
    }

    public void delete() throws UMException {
        UserAccountFactory.invalidateLogonIDMapping(this.getLogonUid());
        UserAccountFactory.invalidateUserAccountInCache(this.getUniqueID());
        IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
        this.mFactory.deletePrincipalDatabag(this.mPrincipalDatabag, dTrans);
        dTrans.commit();
        UserAccountFactory.removeUserAccountPerformed(this.mPrincipalDatabag.getUniqueID());
    }

    public void commit() throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method commit cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        if (this.mPrincipalDatabag.containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        boolean isNewUserAccount = this.mPrincipalDatabag.getUniqueID() == null;
        try {
            IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
            String now = Util.getTimeStamp();
            if (this.mLockSet && this.isLocked()) {
                this.mLockDate = new Date(Long.parseLong(now));
                ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LOCK_DATE, this.convertToVector(now));
            }
            if (isNewUserAccount) {
                this.mLastPasswordChange = new Date(Long.parseLong(now));
                ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LAST_PASSWORD_CHANGE, this.convertToVector(now));
                this.mPrincipalDatabag = this.mFactory.createPrincipalDatabag(dTrans, (IPrincipalDatabagMaint)this.mPrincipalDatabag);
            } else {
                if (this.mPasswordSet) {
                    this.mLastPasswordChange = new Date(Long.parseLong(now));
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", LAST_PASSWORD_CHANGE, this.convertToVector(now));
                }
                this.mFactory.updatePrincipalDatabag((IPrincipalDatabagMaint)this.mPrincipalDatabag, dTrans);
            }
            dTrans.commit();
            this.mPasswordSet = false;
            if (((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement", ACCOUNT_USER_ID, 2) != null) {
                UserFactory.invalidateUserInCache(this.getAssignedUserID());
            }
            if (isNewUserAccount) {
                UserAccountFactory.addUserAccountPerformed(this.mPrincipalDatabag.getUniqueID());
                PrincipalFactory.addPrincipalPerformed(this.mPrincipalDatabag.getUniqueID());
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
                this.mPrincipalDatabag = clearUpdateDatabag;
            } else {
                IUserAccount uacc = ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount(this.mPrincipalDatabag.getUniqueID(), Util.EMPTY_ATTRIBUTE_LIST);
                IPrincipalDatabag pd = ((AbstractPrincipal)uacc).getPrincipalDatabag();
                PrincipalDatabag npd = new PrincipalDatabag(this.mPrincipalDatabag.getUniqueID());
                npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                npd.mergePrincipalDatabag((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag);
                DBTextFileUserAccount usa = new DBTextFileUserAccount(npd);
                boolean isLogonLogoffModification = false;
                if (!(((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getNameSpaces(3).hasMoreElements() || ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getNameSpaces(0).hasMoreElements() || ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getNameSpaces(1).hasMoreElements())) {
                    isLogonLogoffModification = true;
                    Enumeration en = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getNameSpaces(2);
                    while (en.hasMoreElements() && isLogonLogoffModification) {
                        String namespace = (String)en.nextElement();
                        if (namespace.equals("com.sap.security.core.usermanagement") && !en.hasMoreElements()) {
                            Enumeration en2 = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributesOnNamespace(namespace, 2);
                            while (en2.hasMoreElements() && isLogonLogoffModification) {
                                String attribute = (String)en2.nextElement();
                                if (mSetAttributesToCheck.contains(attribute)) continue;
                                isLogonLogoffModification = false;
                            }
                            continue;
                        }
                        isLogonLogoffModification = false;
                    }
                }
                if (isLogonLogoffModification) {
                    ((UserAccountFactory)UMFactory.getUserAccountFactory()).replaceUserAccountInCacheLocally(usa);
                } else {
                    ((UserAccountFactory)UMFactory.getUserAccountFactory()).replaceUserAccountInCache(usa);
                }
                PrincipalFactory.editPrincipalPerformed(this.mPrincipalDatabag.getUniqueID());
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag(npd);
                this.mPrincipalDatabag = clearUpdateDatabag;
            }
            UserAccountFactory.createLogonIDMapping(this.getLogonUid(), this.getUniqueID());
            if (isNewUserAccount) {
                MessagingHandler.getInstance().onCreateMessage(new IUser[]{new UserWrapper(this.getAssignedUserID(), User.USER_DEFAULT_ATTRIBUTES)});
            }
        }
        catch (DuplicateKeyException dkex) {
            if (isNewUserAccount) {
                throw new UserAccountAlreadyExistsException((Throwable)((Object)dkex), "UserAccount with logonuid \"" + this.getLogonUid() + "\" already exists.");
            }
            throw new AttributeValueAlreadyExistsException((Throwable)((Object)dkex));
        }
    }

    public void rollback() {
        if (!this.mPrepared) {
            String errorMessage = "Maint method rollback cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).undoChanges();
    }

    public void setApprove(boolean approved, String companyname, String department) {
        throw new UnsupportedOperationException("Method setApprove() not yet implemented.");
    }

    public Date lockDate() {
        if (this.mLockDate == null) {
            String date = this.getAttributeValueString("com.sap.security.core.usermanagement", LOCK_DATE);
            Date dat = null;
            if (date != null && !date.equalsIgnoreCase("")) {
                long millis = Long.parseLong(date);
                dat = new Date(millis);
            }
            this.mLockDate = dat;
        }
        return this.mLockDate;
    }

    public String getHashedPassword() {
        if (this.mPasswordSet) {
            return null;
        }
        if (this.mHashedPassword == null) {
            this.mHashedPassword = this.getAttributeValueString("com.sap.security.core.usermanagement", "j_password");
        }
        return this.mHashedPassword;
    }

    public void addToGroup(String id) throws UMException {
        UMFactory.getGroupFactory().addUserToGroup(this.getUniqueID(), id);
    }

    public void removeFromGroup(String id) throws UMException {
        UMFactory.getGroupFactory().removeUserFromGroup(this.getUniqueID(), id);
    }

    public void addToRole(String id) throws UMException {
        UMFactory.getRoleFactory().addUserToRole(this.getUniqueID(), id);
    }

    public void removeFromRole(String id) throws UMException {
        UMFactory.getRoleFactory().removeUserFromRole(this.getUniqueID(), id);
    }

    public String getDisplayName() {
        String result;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((result = this.getAttributeValueString("com.sap.security.core.usermanagement", "displayname")) == null) {
            result = this.getLogonUid();
        }
        if (result == null) {
            result = this.getUniqueID();
        }
        return result;
    }

    protected ISecurityPolicy getSecPol() {
        if (this.mSecPol == null) {
            this.mSecPol = SecurityPolicyFactory.getInstance().getSecurityPolicy();
        }
        return this.mSecPol;
    }

    static {
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "j_user", 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", VALID_FROM, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", VALID_TO, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", IS_LOCKED, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", FAILED_LOGON_ATTEMPTS, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", PREVIOUS_SUCCESSFUL_LOGON, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", SUCCESSFUL_LOGON_COUNT, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", PASSWORD_CHANGE_REQUIRED, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", LAST_PASSWORD_CHANGE, 1);
        ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", ACCOUNT_USER_ID, 1);
        accountAttributesWhichDontRequireExistenceCheck = new AttributeList(false);
        accountAttributesWhichDontRequireExistenceCheck.addAttribute("com.sap.security.core.usermanagement", "j_user", 1);
        accountAttributesWhichDontRequireExistenceCheck.addAttribute("com.sap.security.core.usermanagement", ACCOUNT_USER_ID, 1);
        mSetAttributesToCheck = new Vector();
        String logonAttributes = UMFactory.getProperties().get(LOGON_ATTRIBUTES, "failedlogonattempts,PRINCIPAL_MODIFY_DATE,lastsuccessfullogon,successfullogoncount,lastlogout");
        StringTokenizer strt = new StringTokenizer(logonAttributes, ",", false);
        while (strt.hasMoreTokens()) {
            mSetAttributesToCheck.add(strt.nextToken());
        }
    }
}

