/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroup;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.NoSuchPCDRoleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.Group;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.Principal;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.Role;
import com.sap.security.core.logon.imp.AnonymousUser;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.NOPcdRoleException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.CompanyGroups;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractPrincipalSet
extends Principal {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractPrincipalSet.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractPrincipalSet.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    protected Vector _users = new Vector();
    protected Vector mDirectChildUsers;
    protected Vector mDirectChildGroups;
    protected Vector mAllDirectMembers;

    public AbstractPrincipalSet(String uniqueID) {
        this(uniqueID, true);
    }

    public AbstractPrincipalSet(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public AbstractPrincipalSet(String uniqueID, boolean checkExistence) {
        super(uniqueID, checkExistence, null);
    }

    public AbstractPrincipalSet(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        super(uniqueID, checkExistence, populateAttributes);
    }

    public AbstractPrincipalSet() {
    }

    public AbstractPrincipalSet(IPrincipalDatabag principal) {
        super(principal);
    }

    public AbstractPrincipalSet(IPrincipalDatabagMaint principalMaint) {
        super(principalMaint);
    }

    protected synchronized void init(String uniqueID) {
        if (this.mAttributeList == null) {
            this.mAttributeList = uniqueID.startsWith("ROLE") ? Role.ROLE_DEFAULT_ATTRIBUTES : Group.GROUP_DEFAULT_ATTRIBUTES;
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
            this.mPrincipalDatabag = this.mFactory.getPrincipalDatabag(uniqueID, this.mAttributeList, true);
        }
        catch (NOPcdRoleException nprex) {
            throw new NoSuchPCDRoleException((Throwable)((Object)nprex));
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (this.mPrincipalDatabag == null) {
            throw new UMRuntimeException("Principal set " + uniqueID + " doesn't exist!");
        }
        this.mExistenceNotChecked = false;
    }

    public abstract void commit() throws UMException;

    public abstract void save() throws UMException;

    public Iterator getUserMembers(boolean getChildMembers) {
        return this.getUserMembers(getChildMembers, true);
    }

    public Iterator getUserMembers(boolean getChildMembers, boolean checkExistence) {
        SearchCriteria sc;
        block21: {
            try {
                String[] idParts = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getPrincipalIdParts(this.mPrincipalDatabag.getUniqueID());
                if (CompanyGroups.isCompanyGroupDatasource(idParts[1])) {
                    try {
                        SearchCriteria sc2 = new SearchCriteria("USER");
                        if (!idParts[2].equals("GUEST_USERS_COMPANY")) {
                            sc2.addEqualsElement("com.sap.security.core.usermanagement", "company", idParts[2], true);
                        } else {
                            sc2.addEqualsElement("com.sap.security.core.usermanagement", "company", "", true);
                        }
                        if (checkExistence) {
                            return new PrincipalIteratorImpl(this.mFactory.searchPrincipalDatabags(sc2), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
                        }
                        return new PrincipalIteratorImpl(this.mFactory.searchPrincipalDatabags(sc2), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
                    }
                    catch (NOPcdRoleException nprex) {
                        throw new NoSuchPCDRoleException((Throwable)((Object)nprex));
                    }
                    catch (PersistenceException ex) {
                        throw new UMRuntimeException((Throwable)((Object)ex));
                    }
                }
            }
            catch (UMException umex) {
                if (!mTrace.beError()) break block21;
                mTrace.errorT("getUserMembers", "The unique id of this PrincipalSet is not valid: " + this.mPrincipalDatabag.getUniqueID(), umex);
            }
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE".equals(this.mPrincipalDatabag.getUniqueID())) {
            try {
                sc = new SearchCriteria("USER");
                sc.addLikeElement("com.sap.security.core.usermanagement", "uniquename", "*", false);
                if (checkExistence) {
                    return new PrincipalIteratorImpl(this.mFactory.searchPrincipalDatabags(sc), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
                }
                return new PrincipalIteratorImpl(this.mFactory.searchPrincipalDatabags(sc), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
            }
            catch (NOPcdRoleException nprex) {
                throw new NoSuchPCDRoleException((Throwable)((Object)nprex));
            }
            catch (PersistenceException ex) {
                throw new UMRuntimeException((Throwable)((Object)ex));
            }
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS".equals(this.mPrincipalDatabag.getUniqueID())) {
            try {
                sc = new SearchCriteria("USER");
                sc.addLikeElement("com.sap.security.core.usermanagement", "uniquename", "*", false);
                Vector authList = this.mFactory.searchPrincipalDatabags(sc);
                Collection guestList = this.getGuestList();
                if (guestList != null) {
                    authList.removeAll(guestList);
                }
                if (checkExistence) {
                    return new PrincipalIteratorImpl(authList, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
                }
                return new PrincipalIteratorImpl(authList, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
            }
            catch (NOPcdRoleException nprex) {
                throw new NoSuchPCDRoleException((Throwable)((Object)nprex));
            }
            catch (PersistenceException ex) {
                throw new UMRuntimeException((Throwable)((Object)ex));
            }
        }
        Vector processedGroups = new Vector();
        if (checkExistence) {
            return new PrincipalIteratorImpl(this.getUserMembersInternal(getChildMembers, processedGroups), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(this.getUserMembersInternal(getChildMembers, processedGroups), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    private Iterator getUserMembers(boolean getChildMembers, Vector alreadyProcessedGroups) {
        return ((AbstractList)((Vector)this.getUserMembersInternal(getChildMembers, alreadyProcessedGroups).clone())).iterator();
    }

    private Collection getGuestList() {
        Collection col = null;
        try {
            AnonymousUser anonym = AnonymousUser.getInstance();
            if (anonym != null) {
                col = anonym.getGuestUserUniqueIds();
            }
        }
        catch (UMException umex) {
            mTrace.infoT("getGuestList", "Can't receive Guest List from AnonymousUserFactory.", umex);
        }
        return col;
    }

    public Iterator getGroupMembers(boolean getChildMembers) {
        return this.getGroupMembers(getChildMembers, true);
    }

    public Iterator getGroupMembers(boolean getChildMembers, boolean checkExistence) {
        if ("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE".equals(this.mPrincipalDatabag.getUniqueID())) {
            return new PrincipalIteratorImpl(new Vector(), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS".equals(this.mPrincipalDatabag.getUniqueID())) {
            return new PrincipalIteratorImpl(new Vector(), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
        }
        Vector processedGroups = new Vector();
        if (checkExistence) {
            return new PrincipalIteratorImpl(this.getGroupMembersInternal(getChildMembers, processedGroups), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(this.getGroupMembersInternal(getChildMembers, processedGroups), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    private Iterator getGroupMembers(boolean getChildMembers, Vector alreadyProcessedGroups) {
        return ((AbstractList)((Vector)this.getGroupMembersInternal(getChildMembers, alreadyProcessedGroups).clone())).iterator();
    }

    protected boolean isMember_CheckedBySearch(String member) {
        try {
            if (this.mPrepared && this.mPrincipalDatabag instanceof IInternalPrincipalDatabagMaint) {
                int i;
                int size;
                Vector vals = null;
                String id = null;
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1);
                if (vals != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        if (id.equals(member)) {
                            return false;
                        }
                        ++i;
                    }
                }
                if ((vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 0)) != null) {
                    size = vals.size();
                    i = 0;
                    while (i < size) {
                        id = (String)vals.elementAt(i);
                        if (id.equals(member)) {
                            return true;
                        }
                        ++i;
                    }
                }
                Enumeration en = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributesOnNamespace("com.sap.security.core.usermanagement.relation", 3);
                while (en.hasMoreElements()) {
                    String attributeName = (String)en.nextElement();
                    if (!attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) continue;
                    return false;
                }
                vals = ((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag).getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 2);
                if (vals != null) {
                    int size2 = vals.size();
                    int i2 = 0;
                    while (i2 < size2) {
                        id = (String)vals.elementAt(i2);
                        if (id.equals(member)) {
                            return true;
                        }
                        ++i2;
                    }
                }
            }
            SearchCriteria sc = new SearchCriteria(UMFactory.getPrincipalFactory().getPrincipalTypeIdentifier(this.getUniqueID()));
            sc.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", member, true);
            Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            return result.contains(this.getUniqueID());
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isUserMember(String member, boolean recursive) {
        if ("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE".equals(this.mPrincipalDatabag.getUniqueID())) {
            return true;
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS".equals(this.mPrincipalDatabag.getUniqueID())) {
            boolean found = false;
            Collection guestList = this.getGuestList();
            if (guestList != null) {
                found = guestList.contains(member);
            }
            return !found;
        }
        return this.isMember(member, recursive);
    }

    public boolean isGroupMember(String member, boolean recursive) {
        if ("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE".equals(this.mPrincipalDatabag.getUniqueID())) {
            return false;
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS".equals(this.mPrincipalDatabag.getUniqueID())) {
            return false;
        }
        return this.isMember(member, recursive);
    }

    private void setDirectChildrenInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        String[] result = this.getAttributeValuesStringArray("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
        this.mDirectChildGroups = new Vector();
        this.mDirectChildUsers = new Vector();
        this.mAllDirectMembers = new Vector();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                if (result[i].startsWith("GRUP")) {
                    this.mDirectChildGroups.add(result[i]);
                } else if (result[i].startsWith("USER")) {
                    this.mDirectChildUsers.add(result[i]);
                }
                this.mAllDirectMembers.add(result[i]);
                ++i;
            }
        }
    }

    private Vector getGroupMembersInternal(boolean getChildMembers, Vector alreadyProcessedGroups) {
        if (!getChildMembers) {
            if (this.mDirectChildGroups == null) {
                this.setDirectChildrenInternal();
            }
            return this.mDirectChildGroups;
        }
        if (this.mDirectChildGroups == null) {
            this.setDirectChildrenInternal();
        }
        Vector mAllChildGroups = (Vector)this.mDirectChildGroups.clone();
        int size = alreadyProcessedGroups.size();
        int i = 0;
        while (i < size) {
            Object o = alreadyProcessedGroups.elementAt(i);
            if (mAllChildGroups.contains(o)) {
                mAllChildGroups.remove(o);
            }
            ++i;
        }
        size = mAllChildGroups.size();
        int i2 = 0;
        while (i2 < size) {
            alreadyProcessedGroups.add(mAllChildGroups.elementAt(i2));
            ++i2;
        }
        Iterator tempGroups = null;
        try {
            IGroup[] dummy = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroups(mAllChildGroups.toArray(new String[mAllChildGroups.size()]));
            int i3 = 0;
            while (i3 < dummy.length) {
                tempGroups = ((AbstractPrincipalSet)dummy[i3]).getGroupMembers(getChildMembers, alreadyProcessedGroups);
                while (tempGroups.hasNext()) {
                    String groupID = (String)tempGroups.next();
                    if (mAllChildGroups.contains(groupID)) continue;
                    mAllChildGroups.add(groupID);
                }
                ++i3;
            }
        }
        catch (UMException umex) {
            mAllChildGroups = null;
            throw new UMRuntimeException((Throwable)umex);
        }
        return mAllChildGroups;
    }

    private Vector getUserMembersInternal(boolean getChildMembers, Vector alreadyProcessedGroups) {
        if (!getChildMembers) {
            if (this.mDirectChildUsers == null) {
                this.setDirectChildrenInternal();
            }
            return this.mDirectChildUsers;
        }
        if (this.mDirectChildUsers == null) {
            this.setDirectChildrenInternal();
        }
        Vector mAllChildUsers = (Vector)this.mDirectChildUsers.clone();
        Vector mAllChildGroups = (Vector)this.mDirectChildGroups.clone();
        int size = alreadyProcessedGroups.size();
        int i = 0;
        while (i < size) {
            Object o = alreadyProcessedGroups.elementAt(i);
            if (mAllChildGroups.contains(o)) {
                mAllChildGroups.remove(o);
            }
            ++i;
        }
        size = mAllChildGroups.size();
        int i2 = 0;
        while (i2 < size) {
            alreadyProcessedGroups.add(mAllChildGroups.elementAt(i2));
            ++i2;
        }
        Iterator tempUsers = null;
        try {
            IGroup[] dummy = ((GroupFactory)UMFactory.getGroupFactory()).getReadonlyGroups(mAllChildGroups.toArray(new String[mAllChildGroups.size()]));
            int i3 = 0;
            while (i3 < dummy.length) {
                tempUsers = ((AbstractPrincipalSet)dummy[i3]).getUserMembers(getChildMembers, alreadyProcessedGroups);
                while (tempUsers.hasNext()) {
                    String userID = (String)tempUsers.next();
                    if (mAllChildUsers.contains(userID)) continue;
                    mAllChildUsers.add(userID);
                }
                ++i3;
            }
        }
        catch (UMException umex) {
            mAllChildUsers = null;
            throw new UMRuntimeException((Throwable)umex);
        }
        return mAllChildUsers;
    }

    private Vector getMembersInternal(boolean getChildMembers, Vector alreadyProcessedMembers) {
        if (!getChildMembers) {
            if (this.mAllDirectMembers == null) {
                this.setDirectChildrenInternal();
            }
            return this.mAllDirectMembers;
        }
        if (this.mAllDirectMembers == null) {
            this.setDirectChildrenInternal();
        }
        Vector mAllChildren = (Vector)this.mAllDirectMembers.clone();
        int size = alreadyProcessedMembers.size();
        int i = 0;
        while (i < size) {
            Object o = alreadyProcessedMembers.elementAt(i);
            if (mAllChildren.contains(o)) {
                mAllChildren.remove(o);
            }
            ++i;
        }
        size = mAllChildren.size();
        int i2 = 0;
        while (i2 < size) {
            alreadyProcessedMembers.add(mAllChildren.elementAt(i2));
            ++i2;
        }
        Iterator tempMembers = null;
        try {
            IPrincipal[] dummy = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getReadonlyPrincipals(mAllChildren.toArray(new String[mAllChildren.size()]));
            int i3 = 0;
            while (i3 < dummy.length) {
                tempMembers = ((Principal)dummy[i3]).getMembers(getChildMembers, alreadyProcessedMembers, false);
                while (tempMembers.hasNext()) {
                    String memberID = (String)tempMembers.next();
                    if (mAllChildren.contains(memberID)) continue;
                    mAllChildren.add(memberID);
                }
                ++i3;
            }
        }
        catch (UMException umex) {
            mAllChildren = null;
            throw new UMRuntimeException((Throwable)umex);
        }
        return mAllChildren;
    }

    public boolean addUserMember(String newMember) throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method addUserMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        if (newMember == null) {
            throw new UMException("Cannot add member which has unique id null.");
        }
        if (newMember.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
            throw new UMException("SAP* cannot be added to groups and roles.");
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", newMember);
        if (this.mDirectChildUsers != null && !this.mDirectChildUsers.contains(newMember)) {
            this.mDirectChildUsers.add(newMember);
        }
        if (this.mAllDirectMembers != null && !this.mAllDirectMembers.contains(newMember)) {
            this.mAllDirectMembers.add(newMember);
        }
        this._users.add(newMember);
        return true;
    }

    public boolean addGroupMember(String newMember) throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method addGroupMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", newMember);
        if (this.mDirectChildGroups != null && !this.mDirectChildGroups.contains(newMember)) {
            this.mDirectChildGroups.add(newMember);
        }
        if (this.mAllDirectMembers != null && !this.mAllDirectMembers.contains(newMember)) {
            this.mAllDirectMembers.add(newMember);
        }
        return true;
    }

    public synchronized void refresh() throws UMException {
        String uniqueID = this.mPrincipalDatabag.getUniqueID();
        this.mPrincipalDatabag = null;
        this.mAllGroups = null;
        this.mAllRoles = null;
        this.mCreationDate = null;
        this.mModifyDate = null;
        this.mDirectGroups = null;
        this.mDirectRoles = null;
        this.mDirectChildGroups = null;
        this.mDirectChildUsers = null;
        this.mAllDirectMembers = null;
        this.mFactory = PrincipalDatabagFactory.getInstance();
        if (!this.mExistenceNotChecked) {
            this.init(uniqueID);
        } else {
            this.mPrincipalDatabag = new PrincipalDatabag(uniqueID);
        }
    }

    public boolean removeUserMember(String oldMember) throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method removeUserMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", oldMember);
        if (this.mDirectChildUsers != null && this.mDirectChildUsers.contains(oldMember)) {
            this.mDirectChildUsers.remove(oldMember);
        }
        if (this.mAllDirectMembers != null && this.mAllDirectMembers.contains(oldMember)) {
            this.mAllDirectMembers.remove(oldMember);
        }
        return true;
    }

    public boolean removeGroupMember(String oldMember) throws UMException {
        if (!this.mPrepared) {
            String errorMessage = "Maint method removeGroupMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", oldMember);
        if (this.mDirectChildGroups != null && this.mDirectChildGroups.contains(oldMember)) {
            this.mDirectChildGroups.remove(oldMember);
        }
        if (this.mAllDirectMembers != null && this.mAllDirectMembers.contains(oldMember)) {
            this.mAllDirectMembers.remove(oldMember);
        }
        return true;
    }

    public Iterator getMembers(boolean getChildMembers) {
        return this.getMembers(getChildMembers, true);
    }

    public Iterator getMembers(boolean getChildMembers, boolean checkExistence) {
        if ("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE".equals(this.mPrincipalDatabag.getUniqueID())) {
            return this.getUserMembers(getChildMembers);
        }
        if ("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS".equals(this.mPrincipalDatabag.getUniqueID())) {
            return this.getUserMembers(getChildMembers);
        }
        Vector processedMembers = new Vector();
        if (checkExistence) {
            return new PrincipalIteratorImpl(this.getMembersInternal(getChildMembers, processedMembers), PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(this.getMembersInternal(getChildMembers, processedMembers), PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    public boolean addMember(String newMember) throws UMException {
        if (newMember.startsWith("USER")) {
            return this.addUserMember(newMember);
        }
        if (newMember.startsWith("GRUP")) {
            return this.addGroupMember(newMember);
        }
        if (!this.mPrepared) {
            String errorMessage = "Maint method addMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).addAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", newMember);
        if (this.mAllDirectMembers != null && !this.mAllDirectMembers.contains(newMember)) {
            this.mAllDirectMembers.add(newMember);
        }
        return true;
    }

    public boolean removeMember(String oldMember) throws UMException {
        if (oldMember.startsWith("USER")) {
            return this.removeUserMember(oldMember);
        }
        if (oldMember.startsWith("GRUP")) {
            return this.removeGroupMember(oldMember);
        }
        if (!this.mPrepared) {
            String errorMessage = "Maint method removeMember cannot be used because the principal is not mutable!";
            throw new UMException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", oldMember);
        if (this.mAllDirectMembers != null && this.mAllDirectMembers.contains(oldMember)) {
            this.mAllDirectMembers.remove(oldMember);
        }
        return true;
    }
}

