/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.IPrincipalSearchFilter;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMException;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.persistence.ISearchElement;
import com.sap.security.core.persistence.imp.SearchCriteria;
import java.util.Vector;

public abstract class AbstractPrincipalSearchFilter
implements IPrincipalSearchFilter {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractPrincipalSearchFilter.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private Vector _allSearchElements = null;
    private int _searchMethod = 0;
    private int _resultSize = 0;
    private String _searchPrincipal = null;
    protected boolean initialSet = false;
    protected boolean displayNameSet = false;

    public AbstractPrincipalSearchFilter(String searchPrincipal, int searchMethod) {
        if (this._allSearchElements == null) {
            this._allSearchElements = new Vector();
        }
        if (this._searchPrincipal == null) {
            this._searchPrincipal = searchPrincipal;
        }
        this._searchMethod = searchMethod;
    }

    public AbstractPrincipalSearchFilter(String searchPrincipal) {
        this(searchPrincipal, 0);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("***************************************************************************\n");
        res.append("* ");
        res.append(this.getClass().getName());
        res.append("\n");
        res.append("* looking for:");
        res.append(this._searchPrincipal);
        res.append(".\n");
        if (this._searchMethod == 1) {
            res.append("* Using OR mode.\n");
        } else {
            res.append("* Using AND mode.\n");
        }
        res.append("*\n");
        int i = 0;
        while (i < this._allSearchElements.size()) {
            res.append("* ");
            res.append(((ISearchAttribute)this._allSearchElements.get(i)).toString());
            res.append("\n");
            ++i;
        }
        res.append("***************************************************************************\n");
        return res.toString();
    }

    public void setSearchMethod(int searchMethod) {
        if (searchMethod == 0 && this._resultSize > 0 && this._allSearchElements.size() > 1) {
            throw new UMRuntimeException("can not specify search method AND as size limit is set and more than one attribute is specified");
        }
        this._searchMethod = searchMethod;
    }

    public void setDirectChild(String principalID, int mode, boolean caseSensitive) {
        this.setSearchAttribute("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", principalID, mode, caseSensitive);
    }

    public boolean isEmpty() {
        return this.initialSet;
    }

    public boolean isDisplayNameSet() {
        return this.displayNameSet;
    }

    protected boolean isIllegalString(String value) {
        return value.startsWith(" ") || value.endsWith(" ");
    }

    public boolean containsIllegalData() {
        int size = this._allSearchElements.size();
        int i = 0;
        while (i < size) {
            Object value = ((ISearchAttribute)this._allSearchElements.elementAt(i)).getAttributeValue();
            if (this.isIllegalString(((ISearchAttribute)this._allSearchElements.elementAt(i)).getAttributeNameSpace()) || this.isIllegalString(((ISearchAttribute)this._allSearchElements.elementAt(i)).getAttributeName()) || value instanceof String && this.isIllegalString((String)value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setSearchAttribute(String namespace, String attribute, String value, int mode, boolean caseSensitive) {
        if (this.displayNameSet) {
            throw new UMRuntimeException("If search attribute displayname is used, no other attribute can be used!");
        }
        if (this.initialSet) {
            this._allSearchElements.clear();
            this.initialSet = false;
        }
        if (this._resultSize > 0 && this._allSearchElements.size() >= 1 && this._searchMethod == 0) {
            throw new UMRuntimeException("can not specify a new attribute when one attribute and a result limit is specified");
        }
        this._allSearchElements.add(new InternalSearchElement(namespace, attribute, value, mode, caseSensitive));
    }

    public String getSearchPrincipalType() {
        return this._searchPrincipal;
    }

    public String[] getSearchNamespaces() {
        Vector<String> ns = new Vector<String>();
        if (this._allSearchElements != null) {
            int i = 0;
            while (i < this._allSearchElements.size()) {
                InternalSearchElement ise = (InternalSearchElement)this._allSearchElements.elementAt(i);
                if (!ns.contains(ise.getAttributeNameSpace())) {
                    ns.add(ise.getAttributeNameSpace());
                }
                ++i;
            }
            return ns.toArray(new String[ns.size()]);
        }
        return null;
    }

    public String[] getSearchAttributeNames(String namespace) {
        Vector<String> an = new Vector<String>();
        if (this._allSearchElements != null) {
            int i = 0;
            while (i < this._allSearchElements.size()) {
                InternalSearchElement ise = (InternalSearchElement)this._allSearchElements.elementAt(i);
                if (ise.getAttributeNameSpace().equals(namespace) && !an.contains(ise.getAttributeName())) {
                    an.add(ise.getAttributeName());
                }
                ++i;
            }
            return an.toArray(new String[an.size()]);
        }
        return null;
    }

    public String[] getSearchAttributes(String namespace, String attributeName) {
        Vector<Object> a = new Vector<Object>();
        int i = 0;
        while (i < this._allSearchElements.size()) {
            InternalSearchElement ise = (InternalSearchElement)this._allSearchElements.elementAt(i);
            if (ise.getAttributeNameSpace().equals(namespace) && ise.getAttributeName().equals(attributeName) && !a.contains(ise.getAttributeValue())) {
                a.add(ise.getAttributeValue());
            }
            ++i;
        }
        if (a.isEmpty()) {
            Object s = null;
            a.add(s);
        }
        return a.toArray(new String[a.size()]);
    }

    public int getSearchOperator(String namespace, String attributeName, Object attribute) {
        int mode = -1;
        if (this._allSearchElements != null) {
            int i = 0;
            while (i < this._allSearchElements.size()) {
                InternalSearchElement ise = (InternalSearchElement)this._allSearchElements.elementAt(i);
                if (ise.getAttributeNameSpace().equals(namespace) && ise.getAttributeName().equals(attributeName) && ise.getAttributeValue().equals(attribute)) {
                    mode = ise.getOperator();
                    break;
                }
                ++i;
            }
        }
        return mode;
    }

    public int getSearchMethod() {
        return this._searchMethod;
    }

    public void clear() {
        this._allSearchElements.clear();
        this.displayNameSet = false;
        this._searchMethod = 0;
        if (this._searchPrincipal.equals("UACC")) {
            this.setSearchAttribute("com.sap.security.core.usermanagement", "j_user", "*", 1, false);
        } else {
            this.setSearchAttribute("com.sap.security.core.usermanagement", "uniquename", "*", 1, false);
        }
        this.initialSet = true;
    }

    public int getElementSize() {
        if (this._allSearchElements != null) {
            return this._allSearchElements.size();
        }
        return -1;
    }

    public ISearchElement getElementAt(int i) {
        if (this._allSearchElements != null) {
            return (ISearchElement)this._allSearchElements.elementAt(i);
        }
        return null;
    }

    public ISearchAttribute getSearchElementAt(int i) {
        if (this._allSearchElements != null) {
            return (ISearchAttribute)this._allSearchElements.elementAt(i);
        }
        return null;
    }

    public void setUniqueName(String uniqueName, int mode, boolean caseSensitive) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", "uniquename", uniqueName, mode, caseSensitive);
    }

    public String getUniqueName() {
        return this.getSearchAttributes("com.sap.security.core.usermanagement", "uniquename")[0];
    }

    public String getDisplayName() {
        return this.getSearchAttributes("com.sap.security.core.usermanagement", "displayname")[0];
    }

    public void setDisplayName(String displayname, int mode, boolean caseSensitive) {
        if (!this.isEmpty()) {
            throw new UMRuntimeException("Search attribute displayname can only be used, if no other attribute is set before!");
        }
        this.setSearchAttribute("com.sap.security.core.usermanagement", "displayname", displayname, mode, caseSensitive);
        this.displayNameSet = true;
    }

    public void setDescription(String description, int mode, boolean caseSensitive) {
        this.setSearchAttribute("com.sap.security.core.usermanagement", "description", description, mode, caseSensitive);
    }

    public String getDescription() {
        return this.getSearchAttributes("com.sap.security.core.usermanagement", "description")[0];
    }

    public SearchCriteria getSearchCriteriaForDisplayName() throws UMException {
        SearchCriteria sc = new SearchCriteria(true, this.getSearchPrincipalType());
        int operatore = -1;
        Object value = null;
        boolean caseSensitive = true;
        boolean found = false;
        int i = 0;
        while (i < this.getElementSize() && !found) {
            ISearchAttribute sElement = this.getSearchElementAt(i);
            if (sElement.getAttributeName().equals("displayname") && sElement.getAttributeNameSpace().equals("com.sap.security.core.usermanagement")) {
                found = true;
                operatore = sElement.getOperator();
                value = sElement.getAttributeValue();
                caseSensitive = sElement.isCaseSensitive();
            }
            ++i;
        }
        if (!found) {
            throw new UMException("Displayname attribute in searchfilter not found!");
        }
        switch (operatore) {
            case 0: {
                sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                sc.addEqualsElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 1: {
                sc.addLikeElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                sc.addLikeElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 2: {
                sc.addGreaterThanElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                sc.addGreaterThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                break;
            }
            case 3: {
                sc.addLessThanElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                sc.addLessThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
            }
        }
        return sc;
    }

    public void setMaxSearchResultSize(int resultSize) {
        if (resultSize > 0 && this._allSearchElements.size() > 1 && this._searchMethod == 0) {
            throw new UMRuntimeException("max search result can only be set if only one attribute is set");
        }
        this._resultSize = resultSize;
    }

    public int getMaxSearchResultSize() {
        return this._resultSize;
    }

    public class InternalSearchElement
    implements ISearchAttribute,
    ISearchElement {
        private final String nameSpace;
        private final String attributeName;
        private final Object attributeValue;
        private final int op;
        private final boolean mcaseSensitive;

        public InternalSearchElement(String nameSpace, String attributeName, Object attributeValue, int op, boolean caseSensitive) {
            this.nameSpace = nameSpace;
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
            this.op = op;
            this.mcaseSensitive = caseSensitive;
        }

        public InternalSearchElement(String nameSpace, String attributeName, Object attributeValue, int op) {
            this(nameSpace, attributeName, attributeValue, op, false);
        }

        public InternalSearchElement(String nameSpace, String attributeName, Object attributeValue) {
            this(nameSpace, attributeName, attributeValue, 0, false);
        }

        public boolean isCaseSensitive() {
            return this.mcaseSensitive;
        }

        public String getAttributeNameSpace() {
            return this.nameSpace;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public int getOperator() {
            return this.op;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append(this.nameSpace);
            res.append("|->");
            res.append(this.attributeName);
            if (this.attributeValue == null) {
                res.append(" NOT_SET ");
            } else {
                switch (this.op) {
                    case 1: {
                        res.append(" LIKE ");
                        break;
                    }
                    case 3: {
                        res.append(" LESS_THAN ");
                        break;
                    }
                    case 2: {
                        res.append(" GREATER_THAN ");
                        break;
                    }
                    case 0: {
                        res.append(" EQUALS ");
                    }
                }
                res.append(this.attributeValue);
                if (this.mcaseSensitive) {
                    res.append(" (case sensitive)");
                } else {
                    res.append(" (not case sensitive)");
                }
            }
            return res.toString();
        }
    }
}

