/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalMaint;
import com.sap.security.api.NoSuchGroupException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.Group;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.Principal;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.Role;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractPrincipal
implements IPrincipal,
IPrincipalMaint {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/AbstractPrincipal.java#10 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final String ALLOW_NESTED_ROLES = "ume.allow_nested_roles";
    public static final String CACHE_GROUP_HIERARCHY = "ume.principal.cache_group_hierarchy";
    public static final String CACHE_ROLE_HIERARCHY = "ume.principal.cache_role_hierarchy";
    public static final String CACHE_INDIRECT_PARENTS = "ume.principal.cache_indirect_parents";
    public static final String ALLOW_NESTED_GROUPS = "ume.allow_nested_groups";
    public static final String NULL_NAMESPACE = "THIS_IS_A_NAMESPACE_PLACEHOLDER_FOR_NULL_NAMESPACES";
    public static AttributeList ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES;
    protected Vector mDirectRoles;
    protected Vector mAllRoles;
    protected Vector mDirectGroups;
    protected Vector mAllGroups;
    protected Hashtable mDirectParents;
    protected Hashtable mAllParents;
    protected String mCreationDate;
    protected String mModifyDate;
    protected boolean mExistenceNotChecked;
    protected IPrincipalDatabag mPrincipalDatabag;
    protected IInternalPrincipalDatabag mTransientPrincipalDatabag;
    protected IPrincipalDatabagFactory mFactory;
    protected AttributeList mAttributeList;
    protected boolean mPrepared;
    private static IUMTrace mTrace;
    private static boolean mNestedRolesActivated;
    private static boolean mCacheGroupHierarchy;
    private static boolean mCacheRoleHierarchy;
    private static boolean mAllowNestedGroups;
    private static boolean mCacheAllParents;
    public static String[] mGroupTypeArray;
    public static String[] mRoleTypeArray;

    public AbstractPrincipal(String uniqueID) {
        this(uniqueID, true, null);
    }

    public AbstractPrincipal(String uniqueID, AttributeList populateAttributes) {
        this(uniqueID, true, populateAttributes);
    }

    public AbstractPrincipal(String uniqueID, boolean checkExistence, AttributeList populateAttributes) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{uniqueID, new Boolean(checkExistence)});
        }
        this.mAttributeList = populateAttributes;
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        if (checkExistence) {
            this.init(uniqueID);
            this.mExistenceNotChecked = false;
        } else {
            this.mPrincipalDatabag = new PrincipalDatabag(uniqueID);
            this.mExistenceNotChecked = true;
        }
        this.mPrepared = false;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public AbstractPrincipal() {
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        try {
            this.mFactory = PrincipalDatabagFactory.getInstance();
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        this.mPrincipalDatabag = new PrincipalDatabag(null);
        this.mPrepared = false;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public boolean allAttributesPopulated(AttributeList populateAttributes) {
        if (populateAttributes == null) {
            return true;
        }
        int size = populateAttributes.getSize();
        boolean allPopulated = true;
        int i = 0;
        while (i < size && allPopulated) {
            String namespace = populateAttributes.getNameSpaceOfAttributeAt(i);
            String attribute = populateAttributes.getAttributeNameOfAttributeAt(i);
            allPopulated = allPopulated && this.mPrincipalDatabag.getAttributeValues(namespace, attribute) != null;
            ++i;
        }
        return allPopulated;
    }

    public boolean isExistenceChecked() {
        return !this.mExistenceNotChecked;
    }

    protected abstract void init(String var1);

    public String[] getAttribute(String namespace, String name) {
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ("oldpassword".equals(name) && "com.sap.security.core.usermanagement".equals(namespace)) {
            return null;
        }
        Vector values = this.getPrincipalDatabagValues(namespace, name);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return null;
        }
        if (values.firstElement() instanceof byte[]) {
            throw new UMRuntimeException("Binary attribute \"" + namespace + "\"-->\"" + name + "\" must be read using IPrincipal.getBinaryAttribute(" + namespace + "," + name + ")");
        }
        if (!(values.firstElement() instanceof String)) {
            throw new UMRuntimeException("Attribute \"" + namespace + "\"-->\"" + name + "\" doesn't contain String objects.");
        }
        String[] result = values.toArray(new String[values.size()]);
        return result;
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        Vector values;
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((values = this.getPrincipalDatabagValues(namespace, name)) == null) {
            return null;
        }
        byte[] result = null;
        if (values != null && !values.isEmpty()) {
            Object o = values.firstElement();
            if (o instanceof String) {
                throw new UMRuntimeException("String attribute \"" + namespace + "\"-->\"" + name + "\" must be read using IPrincipal.getAttribute(" + namespace + "," + name + ")");
            }
            if (!(o instanceof byte[])) {
                throw new UMRuntimeException("Attribute \"" + namespace + "\"-->\"" + name + "\" doesn't contain a binary object.");
            }
            result = (byte[])o;
        }
        return result;
    }

    public Object getTransientAttribute(String namespace, String name) {
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        Object values = this.getTransientPrincipalDatabagValues(namespace, name);
        return values;
    }

    public String[] getAttributeNamespaces() {
        Vector nameSpaces = null;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        try {
            nameSpaces = this.mFactory.getAttributeNamespaces(this.mPrincipalDatabag);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        int indexOfNullNamespace = nameSpaces.indexOf(NULL_NAMESPACE);
        String[] result = nameSpaces.toArray(new String[0]);
        if (indexOfNullNamespace >= 0) {
            result[indexOfNullNamespace] = null;
        }
        return result;
    }

    public String[] getAttributeNames(String namespace) {
        Vector attributes = null;
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        try {
            attributes = this.mFactory.getAttributeNames(this.mPrincipalDatabag, namespace);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        String[] result = attributes.toArray(new String[0]);
        return result;
    }

    public String getAttributeType(String namespace, String attributeName) {
        Vector dummy = this.getPrincipalDatabagValues(namespace, attributeName);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        if (!dummy.isEmpty()) {
            Object value = dummy.firstElement();
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return "String";
            }
            if (value instanceof byte[]) {
                return "Byte";
            }
            return null;
        }
        return null;
    }

    public String getDisplayName() {
        String result;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((result = this.getAttributeValueString("com.sap.security.core.usermanagement", "displayname")) == null) {
            result = this.getUniqueName();
        }
        if (result == null) {
            result = this.getUniqueID();
        }
        return result;
    }

    public String getDescription() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        String result = this.getAttributeValueString("com.sap.security.core.usermanagement", "description");
        return result;
    }

    public String getUniqueName() {
        String uniqueID;
        String result;
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if ((result = this.getAttributeValueString("com.sap.security.core.usermanagement", "uniquename")) == null && !this.mPrepared && (uniqueID = this.mPrincipalDatabag.getUniqueID()) != null && (uniqueID.startsWith("USER") || uniqueID.startsWith("GRUP") || uniqueID.startsWith("ROLE") || uniqueID.startsWith("TEAM"))) {
            UserFactory.invalidateUserInCache(uniqueID);
            GroupFactory.invalidateGroupInCache(uniqueID);
            RoleFactory.invalidateRoleInCache(uniqueID);
            PrincipalFactory.invalidatePrincipalInCache(uniqueID);
            throw new PrincipalNotAccessibleException("Principal \"" + uniqueID + "\" is not accessible because the unique name is not available.");
        }
        return result;
    }

    public HashMap getRawUserMappingData(String application) {
        Vector attributes = null;
        if (mTrace.bePath()) {
            mTrace.entering("getRawUserMappingData", new Object[]{application});
        }
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        String nameSpace = "$usermapping$_" + application;
        try {
            attributes = this.mFactory.getAttributeNames(this.mPrincipalDatabag, nameSpace);
        }
        catch (PersistenceException ex) {
            throw new UMRuntimeException((Throwable)((Object)ex));
        }
        int size = attributes.size();
        HashMap result = new HashMap(size);
        int i = 0;
        while (i < size) {
            result.put(attributes.elementAt(i), this.getAttributeValue(nameSpace, (String)attributes.elementAt(i)));
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getRawUserMappingData", result);
        }
        return result;
    }

    public synchronized void refresh() throws UMException {
        if (!this.mPrepared) {
            throw new UMException("Refreshing is not available on readonly principal " + this.getUniqueID());
        }
        String uniqueID = this.mPrincipalDatabag.getUniqueID();
        this.mPrincipalDatabag = new PrincipalDatabag(uniqueID);
        this.mAllGroups = null;
        this.mAllRoles = null;
        this.mCreationDate = null;
        this.mModifyDate = null;
        this.mDirectGroups = null;
        this.mDirectRoles = null;
        this.mDirectParents = null;
        this.mFactory = PrincipalDatabagFactory.getInstance();
        if (!this.mExistenceNotChecked) {
            this.init(uniqueID);
        }
    }

    public Iterator getRoles(boolean recursive) {
        return this.getRoles(recursive, true);
    }

    public Iterator getRoles(boolean recursive, boolean checkExistence) {
        Vector result = null;
        result = recursive ? this.getAllRolesInternal() : this.getDirectRolesInternal();
        if (checkExistence) {
            return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    protected synchronized void setDirectParentsInternal(String[] principalTypeIdentifiers) {
        if (this.mDirectParents != null) {
            Vector<String> parentsToPopulate = null;
            int k = 0;
            while (k < principalTypeIdentifiers.length) {
                String currentPTID = principalTypeIdentifiers[k];
                Vector si = (Vector)this.mDirectParents.get(currentPTID);
                if (si == null) {
                    if (parentsToPopulate == null) {
                        parentsToPopulate = new Vector<String>();
                    }
                    parentsToPopulate.add(currentPTID);
                }
                ++k;
            }
            if (parentsToPopulate != null) {
                try {
                    String[] parentTypes = parentsToPopulate.toArray(new String[parentsToPopulate.size()]);
                    Collection c = this.mFactory.getDirectParents(this.getUniqueID(), parentTypes);
                    this.setDirectParents(c, parentTypes);
                }
                catch (PersistenceException pex) {
                    throw new UMRuntimeException((Throwable)((Object)pex));
                }
            }
        } else {
            try {
                Collection c = this.mFactory.getDirectParents(this.getUniqueID(), principalTypeIdentifiers);
                this.setDirectParents(c, principalTypeIdentifiers);
            }
            catch (PersistenceException pex) {
                throw new UMRuntimeException((Throwable)((Object)pex));
            }
        }
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getParents(principalTypeIdentifiers, recursive, true);
    }

    public boolean parentsAlreadyPopulated(String[] principalTypeIdentifiers, boolean recursive) {
        if (!recursive) {
            if (this.mDirectParents == null || this.mDirectParents.isEmpty()) {
                return false;
            }
            int k = 0;
            while (k < principalTypeIdentifiers.length) {
                String currentPTID = principalTypeIdentifiers[k];
                if (this.mDirectParents.get(currentPTID) == null) {
                    return false;
                }
                ++k;
            }
            return true;
        }
        if (this.mAllParents == null || this.mAllParents.isEmpty()) {
            return false;
        }
        AllParentsCacheKey cacheKey = new AllParentsCacheKey(principalTypeIdentifiers);
        return this.mAllParents.get(cacheKey) != null;
    }

    /*
     * Unable to fully structure code
     */
    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive, boolean checkExistence) {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (AbstractPrincipal.mCacheAllParents && recursive && this.mAllParents != null && (result = (Vector)this.mAllParents.get(cacheKey = new AllParentsCacheKey(principalTypeIdentifiers))) != null) {
            if (checkExistence) {
                return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
            }
            return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
        }
        this.setDirectParentsInternal(principalTypeIdentifiers);
        principalsToProcess = new Vector<String>();
        k = 0;
        while (k < principalTypeIdentifiers.length) {
            currentPTID = principalTypeIdentifiers[k];
            principalsToProcess.addAll((Vector)this.mDirectParents.get(currentPTID));
            ++k;
        }
        if (!recursive) {
            if (checkExistence) {
                return new PrincipalIteratorImpl(principalsToProcess, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
            }
            return new PrincipalIteratorImpl(principalsToProcess, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
        }
        allParents = new Vector<String>();
        processedPrincipals = new Vector<String>();
        pf = UMFactory.getPrincipalFactory();
        block5: while (principalsToProcess.size() > 0) {
            size = principalsToProcess.size();
            pids = principalsToProcess.toArray(new String[size]);
            principalsToProcess.clear();
            i = 0;
            while (i < size) {
                currentUniqueID = pids[i];
                processedPrincipals.add(currentUniqueID);
                if (!allParents.contains(currentUniqueID)) {
                    allParents.add(currentUniqueID);
                }
                ++i;
            }
            try {
                ps = ((PrincipalFactory)pf).getReadonlyPrincipals(pids, null);
                tempCont = null;
                i = 0;
                while (i < size) {
                    if (!((AbstractPrincipal)ps[i]).parentsAlreadyPopulated(principalTypeIdentifiers, false)) {
                        if (tempCont == null) {
                            tempCont = new Vector<String>();
                        }
                        tempCont.add(pids[i]);
                    }
                    ++i;
                }
                parents = null;
                if (tempCont != null) {
                    tempContSize = tempCont.size();
                    parents = this.mFactory.getDirectParents(tempCont.toArray(new String[tempContSize]), principalTypeIdentifiers);
                }
                parentsCounter = 0;
                i = 0;
                while (i < size) {
                    if (parents != null && parentsCounter < parents.length && pids[i].equals(tempCont.elementAt(parentsCounter))) {
                        ((AbstractPrincipal)ps[i]).setDirectParents(parents[parentsCounter], principalTypeIdentifiers);
                        ++parentsCounter;
                    }
                    it = new PrincipalIterator(ps[i].getParents(principalTypeIdentifiers, false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                    while (it.hasNext()) {
                        currentUniqueID = (String)it.next();
                        if (!processedPrincipals.contains(currentUniqueID) && !principalsToProcess.contains(currentUniqueID)) {
                            principalsToProcess.add(currentUniqueID);
                        }
                        if (allParents.contains(currentUniqueID)) continue;
                        allParents.add(currentUniqueID);
                    }
                    ++i;
                }
                continue;
            }
            catch (UMException nspex) {
                if (AbstractPrincipal.mTrace.beDebug()) {
                    AbstractPrincipal.mTrace.debugT("getParents", nspex);
                }
                i = 0;
                ** while (i < size)
            }
lbl-1000:
            // 1 sources

            {
                block28: {
                    try {
                        p = ((PrincipalFactory)pf).getReadonlyPrincipal(pids[i], null, checkExistence);
                        it = new PrincipalIterator(((Principal)p).getParents(principalTypeIdentifiers, false, checkExistence), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                        while (it.hasNext()) {
                            currentUniqueID = (String)it.next();
                            if (!processedPrincipals.contains(currentUniqueID) && !principalsToProcess.contains(currentUniqueID)) {
                                principalsToProcess.add(currentUniqueID);
                            }
                            if (allParents.contains(currentUniqueID)) continue;
                            allParents.add(currentUniqueID);
                        }
                    }
                    catch (UMException umex) {
                        if (!AbstractPrincipal.mTrace.beInfo()) break block28;
                        AbstractPrincipal.mTrace.infoT("getParents", "Linked parent \"" + pids[i] + "\" not accessible.", nspex);
                    }
                }
                ++i;
                continue;
lbl96:
                // 1 sources

            }
        }
        if (AbstractPrincipal.mCacheAllParents) {
            if (this.mAllParents == null) {
                this.mAllParents = new Hashtable<K, V>();
            }
            cacheKey = new AllParentsCacheKey(principalTypeIdentifiers);
            this.mAllParents.put(cacheKey, allParents);
        }
        if (checkExistence) {
            return new PrincipalIteratorImpl(allParents, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(allParents, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator getParentGroups(boolean recursive) {
        Iterator iterator;
        String MONITOR_STRING = "UME:AbstractPrincipal:getParentGroups";
        IMonitor monitor = null;
        try {
            monitor = TaskMonitor.getRequestMonitor((String)this.getUniqueName(), (String)"UME:AbstractPrincipal:getParentGroups");
            monitor.startComponent("UME:AbstractPrincipal:getParentGroups");
            iterator = this.getParentGroups(recursive, true);
            Object var6_5 = null;
            if (monitor == null) return iterator;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:AbstractPrincipal:getParentGroups");
            monitor.endRequest("UME:AbstractPrincipal:getParentGroups");
            throw throwable;
        }
        monitor.endComponent("UME:AbstractPrincipal:getParentGroups");
        monitor.endRequest("UME:AbstractPrincipal:getParentGroups");
        return iterator;
    }

    public Iterator getParentGroups(boolean recursive, boolean checkExistence) {
        Vector result = null;
        result = recursive ? this.getAllGroupsInternal() : this.getDirectGroupsInternal();
        if (checkExistence) {
            return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_CHECKED);
        }
        return new PrincipalIteratorImpl(result, PrincipalIteratorImpl.TYPE_UNIQUEIDS_NOT_CHECKED);
    }

    private synchronized Vector getDirectGroupsInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (this.mDirectGroups != null) {
            return this.mDirectGroups;
        }
        this.setDirectParentsInternal(new String[]{"GRUP"});
        this.mDirectGroups = (Vector)this.mDirectParents.get("GRUP");
        return this.mDirectGroups;
    }

    public synchronized void setDirectParents(Collection parents, String[] principalTypes) {
        if (this.mDirectParents == null) {
            this.mDirectParents = new Hashtable();
        }
        int size = principalTypes.length;
        int i = 0;
        while (i < size) {
            Vector dummy = (Vector)this.mDirectParents.get(principalTypes[i]);
            if (dummy == null) {
                this.mDirectParents.put(principalTypes[i], new Vector());
            } else {
                dummy.clear();
            }
            ++i;
        }
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            ((Vector)this.mDirectParents.get(id.substring(0, 4))).add(id);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Vector getAllGroupsInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (AbstractPrincipal.mCacheGroupHierarchy && this.mAllGroups != null) {
            return this.mAllGroups;
        }
        dummy = new Vector<E>();
        processedGroups = new HashSet<String>();
        groupsToProcess = new Vector();
        groupsToProcess = (Vector)this.getDirectGroupsInternal().clone();
        if (!AbstractPrincipal.mAllowNestedGroups) {
            if (groupsToProcess != null && groupsToProcess.size() > 0) {
                i = 0;
                while (i < groupsToProcess.size()) {
                    groupID = (String)groupsToProcess.elementAt(i);
                    if (groupID.startsWith("GRUP") && !dummy.contains(groupID)) {
                        dummy.add(groupsToProcess.elementAt(i));
                    }
                    ++i;
                }
            }
            this.mAllGroups = dummy;
            return this.mAllGroups;
        }
        gf = UMFactory.getGroupFactory();
        block6: while (groupsToProcess.size() > 0) {
            size = groupsToProcess.size();
            pids = groupsToProcess.toArray(new String[size]);
            i = 0;
            while (i < size) {
                currentGroupID = (String)groupsToProcess.elementAt(i);
                processedGroups.add(currentGroupID);
                if (!dummy.contains(currentGroupID)) {
                    dummy.add(currentGroupID);
                }
                ++i;
            }
            groupsToProcess.clear();
            try {
                gs = ((GroupFactory)gf).getReadonlyGroups(pids, Group.GROUP_DEFAULT_ATTRIBUTES);
                tempCont = null;
                i = 0;
                while (i < size) {
                    if (!((AbstractPrincipal)gs[i]).parentsAlreadyPopulated(AbstractPrincipal.mGroupTypeArray, false)) {
                        if (tempCont == null) {
                            tempCont = new Vector<String>();
                        }
                        tempCont.add(pids[i]);
                    }
                    ++i;
                }
                parents = null;
                if (tempCont != null) {
                    tempContSize = tempCont.size();
                    parents = this.mFactory.getDirectParents(tempCont.toArray(new String[tempContSize]), AbstractPrincipal.mGroupTypeArray);
                }
                parentsCounter = 0;
                i = 0;
                while (i < size) {
                    if (parents != null && parentsCounter < parents.length && pids[i].equals(tempCont.elementAt(parentsCounter))) {
                        ((AbstractPrincipal)gs[i]).setDirectParents(parents[parentsCounter], AbstractPrincipal.mGroupTypeArray);
                        ++parentsCounter;
                    }
                    it = new PrincipalIterator(gs[i].getParentGroups(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                    while (it.hasNext()) {
                        currentGroupID = (String)it.next();
                        if (!processedGroups.contains(currentGroupID) && !groupsToProcess.contains(currentGroupID)) {
                            groupsToProcess.add(currentGroupID);
                        }
                        if (!currentGroupID.startsWith("GRUP") || dummy.contains(currentGroupID)) continue;
                        dummy.add(currentGroupID);
                    }
                    ++i;
                }
                continue;
            }
            catch (NoSuchGroupException nsgex) {
                if (AbstractPrincipal.mTrace.beDebug()) {
                    AbstractPrincipal.mTrace.debugT("getAllGroupsInternal", nsgex);
                }
                i = 0;
                ** while (i < size)
            }
lbl-1000:
            // 1 sources

            {
                block26: {
                    try {
                        g = ((GroupFactory)gf).getReadonlyGroup(pids[i], Group.GROUP_DEFAULT_ATTRIBUTES);
                        it = new PrincipalIterator(g.getParentGroups(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                        while (it.hasNext()) {
                            currentGroupID = (String)it.next();
                            if (!processedGroups.contains(currentGroupID) && !groupsToProcess.contains(currentGroupID)) {
                                groupsToProcess.add(currentGroupID);
                            }
                            if (!currentGroupID.startsWith("GRUP") || dummy.contains(currentGroupID)) continue;
                            dummy.add(currentGroupID);
                        }
                    }
                    catch (UMException nsgexsingle) {
                        if (!AbstractPrincipal.mTrace.beInfo()) break block26;
                        AbstractPrincipal.mTrace.infoT("getAllGroupsInternal", "Linked parent group \"" + pids[i] + "\" not found.", nsgexsingle);
                    }
                }
                ++i;
                continue;
lbl95:
                // 1 sources

                continue block6;
            }
            catch (UMException umex) {
                throw new UMRuntimeException((Throwable)umex);
            }
        }
        this.mAllGroups = dummy;
        return this.mAllGroups;
    }

    private synchronized Vector getDirectRolesInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (this.mDirectRoles != null) {
            return this.mDirectRoles;
        }
        this.setDirectParentsInternal(new String[]{"ROLE"});
        this.mDirectRoles = (Vector)this.mDirectParents.get("ROLE");
        return this.mDirectRoles;
    }

    /*
     * Unable to fully structure code
     */
    private Vector getAllRolesInternal() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (AbstractPrincipal.mCacheRoleHierarchy && this.mAllRoles != null) {
            return this.mAllRoles;
        }
        currentAllRoles = (Vector)this.getDirectRolesInternal().clone();
        principalsToProcess = (Vector)this.getAllGroupsInternal().clone();
        if (AbstractPrincipal.mNestedRolesActivated) {
            principalsToProcess.addAll(currentAllRoles);
        }
        processedPrincipals = new Vector<String>();
        roleP = null;
        rf = UMFactory.getRoleFactory();
        gf = UMFactory.getGroupFactory();
        block8: while (principalsToProcess.size() > 0) {
            block41: {
                size = principalsToProcess.size();
                if (AbstractPrincipal.mNestedRolesActivated) {
                    roleP = new Vector<String>();
                }
                groupP = new Vector<String>();
                i = 0;
                while (i < size) {
                    currentID = (String)principalsToProcess.elementAt(i);
                    if (AbstractPrincipal.mNestedRolesActivated && currentID.startsWith("ROLE")) {
                        roleP.add(currentID);
                        if (!currentAllRoles.contains(currentID)) {
                            currentAllRoles.add(currentID);
                        }
                    } else if (currentID.startsWith("GRUP")) {
                        groupP.add(currentID);
                    }
                    processedPrincipals.add(currentID);
                    ++i;
                }
                principalsToProcess.clear();
                if (AbstractPrincipal.mNestedRolesActivated && !roleP.isEmpty()) {
                    size = roleP.size();
                    try {
                        rolePArray = roleP.toArray(new String[size]);
                        rs = ((RoleFactory)rf).getReadonlyRoles(rolePArray, Role.ROLE_DEFAULT_ATTRIBUTES);
                        tempCont = null;
                        i = 0;
                        while (i < size) {
                            if (!((AbstractPrincipal)rs[i]).parentsAlreadyPopulated(AbstractPrincipal.mRoleTypeArray, false)) {
                                if (tempCont == null) {
                                    tempCont = new Vector<String>();
                                }
                                tempCont.add(rolePArray[i]);
                            }
                            ++i;
                        }
                        parents = null;
                        if (tempCont != null) {
                            tempContSize = tempCont.size();
                            parents = this.mFactory.getDirectParents(tempCont.toArray(new String[tempContSize]), AbstractPrincipal.mRoleTypeArray);
                        }
                        parentsCounter = 0;
                        i = 0;
                        while (i < size) {
                            if (parents != null && parentsCounter < parents.length && rolePArray[i].equals(tempCont.elementAt(parentsCounter))) {
                                ((AbstractPrincipal)rs[i]).setDirectParents(parents[parentsCounter], AbstractPrincipal.mRoleTypeArray);
                                ++parentsCounter;
                            }
                            it = new PrincipalIterator(((AbstractPrincipal)rs[i]).getRoles(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                            while (it.hasNext()) {
                                currentID = (String)it.next();
                                if (processedPrincipals.contains(currentID) || principalsToProcess.contains(currentID)) continue;
                                principalsToProcess.add(currentID);
                            }
                            ++i;
                        }
                        break block41;
                    }
                    catch (UMException nsrex) {
                        if (AbstractPrincipal.mTrace.beDebug()) {
                            AbstractPrincipal.mTrace.debugT("getAllRolesInternal", nsrex);
                        }
                        i = 0;
                        ** while (i < size)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block42: {
                            try {
                                r = ((RoleFactory)rf).getReadonlyRole((String)roleP.elementAt(i), Role.ROLE_DEFAULT_ATTRIBUTES);
                                it = new PrincipalIterator(((AbstractPrincipal)r).getRoles(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                                while (it.hasNext()) {
                                    currentID = (String)it.next();
                                    if (processedPrincipals.contains(currentID) || principalsToProcess.contains(currentID)) continue;
                                    principalsToProcess.add(currentID);
                                }
                            }
                            catch (UMException nsrex2) {
                                if (!AbstractPrincipal.mTrace.beInfo()) break block42;
                                AbstractPrincipal.mTrace.infoT("getAllRolesInternal", "Linked parent role \"" + (String)roleP.elementAt(i) + "\" not found.", nsrex2);
                            }
                        }
                        ++i;
                        continue;
                    }
                }
            }
            if (groupP.isEmpty()) continue;
            size = groupP.size();
            try {
                groupPArray = groupP.toArray(new String[size]);
                gs = ((GroupFactory)gf).getReadonlyGroups(groupPArray, null);
                tempCont = null;
                i = 0;
                while (i < size) {
                    if (!((AbstractPrincipal)gs[i]).parentsAlreadyPopulated(AbstractPrincipal.mRoleTypeArray, false)) {
                        if (tempCont == null) {
                            tempCont = new Vector<String>();
                        }
                        tempCont.add(groupPArray[i]);
                    }
                    ++i;
                }
                parents = null;
                if (tempCont != null) {
                    tempContSize = tempCont.size();
                    parents = this.mFactory.getDirectParents(tempCont.toArray(new String[tempContSize]), AbstractPrincipal.mRoleTypeArray);
                }
                parentsCounter = 0;
                i = 0;
                while (i < size) {
                    if (parents != null && parentsCounter < parents.length && groupPArray[i].equals(tempCont.elementAt(parentsCounter))) {
                        ((AbstractPrincipal)gs[i]).setDirectParents(parents[parentsCounter], AbstractPrincipal.mRoleTypeArray);
                        ++parentsCounter;
                    }
                    it = new PrincipalIterator(gs[i].getRoles(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                    while (it.hasNext()) {
                        currentID = (String)it.next();
                        if (!processedPrincipals.contains(currentID) && AbstractPrincipal.mNestedRolesActivated) {
                            principalsToProcess.add(currentID);
                        }
                        if (!currentID.startsWith("ROLE") || currentAllRoles.contains(currentID)) continue;
                        currentAllRoles.add(currentID);
                    }
                    ++i;
                }
                continue;
            }
            catch (UMException nsgex) {
                if (AbstractPrincipal.mTrace.beDebug()) {
                    AbstractPrincipal.mTrace.debugT("getAllRolesInternal", nsgex);
                }
                i = 0;
                ** while (i < size)
            }
lbl-1000:
            // 1 sources

            {
                block43: {
                    try {
                        g = ((GroupFactory)gf).getReadonlyGroup((String)groupP.elementAt(i), null);
                        it = new PrincipalIterator(g.getRoles(false), PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                        while (it.hasNext()) {
                            currentID = (String)it.next();
                            if (!processedPrincipals.contains(currentID) && AbstractPrincipal.mNestedRolesActivated) {
                                principalsToProcess.add(currentID);
                            }
                            if (!currentID.startsWith("ROLE") || currentAllRoles.contains(currentID)) continue;
                            currentAllRoles.add(currentID);
                        }
                    }
                    catch (UMException nsgex2) {
                        if (!AbstractPrincipal.mTrace.beInfo()) break block43;
                        AbstractPrincipal.mTrace.infoT("getAllRolesInternal", "Linked parent group \"" + (String)groupP.elementAt(i) + "\" not found.", nsgex2);
                    }
                }
                ++i;
                continue;
lbl156:
                // 1 sources

            }
        }
        this.mAllRoles = currentAllRoles;
        return this.mAllRoles;
    }

    public boolean isMemberOfRole(String parentId, boolean recursive) {
        boolean isMember = false;
        if (recursive) {
            Vector allRoles = this.getAllRolesInternal();
            isMember = allRoles.contains(parentId);
        } else {
            Vector directRoles = this.getDirectRolesInternal();
            isMember = directRoles.contains(parentId);
        }
        return isMember;
    }

    public boolean isMemberOfGroup(String parentId, boolean recursive) {
        boolean isMember = false;
        if (recursive) {
            Vector allGroups = this.getAllGroupsInternal();
            isMember = allGroups.contains(parentId);
        } else {
            Vector directGroups = this.getDirectGroupsInternal();
            isMember = directGroups.contains(parentId);
        }
        return isMember;
    }

    public String getUniqueID() {
        String result = this.mPrincipalDatabag.getUniqueID();
        return result;
    }

    public AttributeList getPopulatedAttributes() {
        return this.mPrincipalDatabag.getPopulatedAttributes();
    }

    public Date created() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (this.mCreationDate == null) {
            Vector dates = this.getPrincipalDatabagValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE");
            if (dates == null) {
                if (mTrace.beInfo()) {
                    mTrace.infoT("created", "PRINCIPAL_CREATION_DATE attribute is not set for principal databag \"" + this.mPrincipalDatabag.getUniqueID() + "\"");
                }
                return null;
            }
            int size = dates.size();
            if (size > 0) {
                this.mCreationDate = (String)dates.firstElement();
            }
        }
        Date dat = null;
        if (this.mCreationDate != null) {
            long millis = Long.parseLong(this.mCreationDate);
            dat = new Date(millis);
        }
        return dat;
    }

    public String toString() {
        String result = this.mPrincipalDatabag.toString();
        return result;
    }

    public Date lastModified() {
        if (this.mExistenceNotChecked) {
            this.init(this.mPrincipalDatabag.getUniqueID());
        }
        if (this.mModifyDate == null) {
            Vector dates = this.getPrincipalDatabagValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE");
            if (dates == null) {
                if (mTrace.beInfo()) {
                    mTrace.infoT("lastModified", "PRINCIPAL_MODIFY_DATE attribute is not set for principal databag \"" + this.mPrincipalDatabag.getUniqueID() + "\"");
                }
                return null;
            }
            if (dates.size() > 0) {
                this.mModifyDate = (String)dates.firstElement();
            }
        }
        Date dat = null;
        if (this.mModifyDate != null) {
            long millis = Long.parseLong(this.mModifyDate);
            dat = new Date(millis);
        }
        return dat;
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        if (!this.mPrepared) {
            String errorMessage = "Maint method setAttribute cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        Vector<String> val = new Vector<String>();
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    val.add(values[i]);
                }
                ++i;
            }
        }
        if (!val.isEmpty()) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues(namespace, name, val);
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues(namespace, name);
        }
        return true;
    }

    public boolean setTransientAttribute(String namespace, String name, Object o) {
        if (!this.mPrepared) {
            throw new UMRuntimeException("Setting transient attributes is not available on readonly principal " + this.getUniqueID());
        }
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        Vector<Object> val = new Vector<Object>();
        if (this.mTransientPrincipalDatabag == null) {
            this.mTransientPrincipalDatabag = new PrincipalDatabag(this.mPrincipalDatabag.getUniqueID());
        }
        if (o != null) {
            val.add(o);
            this.mTransientPrincipalDatabag.setAttributeValues(namespace, name, val);
        } else {
            this.mTransientPrincipalDatabag.deleteAttributeValues(namespace, name);
        }
        return true;
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        if (namespace == null) {
            namespace = NULL_NAMESPACE;
        }
        if (!this.mPrepared) {
            String errorMessage = "Maint method setAttribute cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        Vector<byte[]> val = new Vector<byte[]>();
        if (value != null) {
            val.add(value);
        }
        if (!val.isEmpty()) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues(namespace, name, val);
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues(namespace, name);
        }
        return true;
    }

    public boolean isMutable() {
        return this.mPrepared;
    }

    public boolean isModified() {
        boolean result = false;
        if (this.mPrepared) {
            result = !((IPrincipalDatabagMaint)this.mPrincipalDatabag).isNew();
        }
        return result;
    }

    public boolean setDisplayName(String displayname) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setDisplayName cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (displayname != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector(displayname));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "displayname");
        }
        return true;
    }

    public boolean setDescription(String description) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setDescription cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        if (description != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "description", this.convertToVector(description));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "description");
        }
        return true;
    }

    public boolean setUniqueName(String uniqueName) {
        if (!this.mPrepared) {
            String errorMessage = "Maint method setUniqueName cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        String id = this.mPrincipalDatabag.getUniqueID();
        if (id != null && id.startsWith("USER")) {
            throw new UMRuntimeException("Unique name of users must not be changed!");
        }
        if (uniqueName == null) {
            throw new UMRuntimeException("Cannot set unique name to null!");
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector(uniqueName));
        return true;
    }

    public abstract void commit() throws UMException;

    public void rollback() {
        if (!this.mPrepared) {
            String errorMessage = "Maint method rollback cannot be used because the principal is not mutable!";
            throw new UMRuntimeException(errorMessage);
        }
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).undoChanges();
    }

    public abstract void save() throws UMException;

    public IPrincipalDatabag getPrincipalDatabag() {
        return this.mPrincipalDatabag;
    }

    public void setPrincipalDatabag(IPrincipalDatabag newDatabag) {
        this.mPrincipalDatabag = newDatabag;
    }

    protected Object getTransientPrincipalDatabagValues(String namespace, String name) {
        if (this.mTransientPrincipalDatabag == null) {
            return null;
        }
        Vector dummy = this.mTransientPrincipalDatabag.getAttributeValues(namespace, name);
        if (dummy == null) {
            return null;
        }
        if (!dummy.isEmpty()) {
            return dummy.firstElement();
        }
        return null;
    }

    protected Vector getPrincipalDatabagValues(String namespace, String name) {
        Vector values = this.mPrincipalDatabag.getAttributeValues(namespace, name);
        if (values != null && ((IInternalPrincipalDatabag)this.mPrincipalDatabag).isExpired(namespace, name) && !((IInternalPrincipalDatabag)this.mPrincipalDatabag).isOnlyOnceReadable(namespace, name)) {
            values = null;
        }
        if (values == null && this.mPrincipalDatabag.getUniqueID() != null) {
            try {
                if (mTrace.beDebug()) {
                    Exception e = new Exception("LazyFetch: \"" + this.mPrincipalDatabag.getUniqueID() + "\"-->\"" + namespace + "\",\"" + name + "\".");
                    mTrace.debugT("getPrincipalDatabagValues", e);
                }
                this.mFactory.populatePrincipalDatabagAttribute(this.mPrincipalDatabag, namespace, name);
            }
            catch (PersistenceException ex) {
                throw new PrincipalNotAccessibleException((Throwable)((Object)ex));
            }
        } else {
            return values;
        }
        values = this.mPrincipalDatabag.getAttributeValues(namespace, name);
        if (values == null && this.mPrincipalDatabag.getUniqueID() != null) {
            try {
                Vector availableNameSpaces = this.mFactory.getAttributeNamespaces(this.mPrincipalDatabag);
                if (!availableNameSpaces.contains(namespace)) {
                    return values;
                }
                Vector availableAttributesOnNamespace = this.mFactory.getAttributeNames(this.mPrincipalDatabag, namespace);
                if (!availableAttributesOnNamespace.contains(name)) {
                    return values;
                }
            }
            catch (PersistenceException ex) {
                throw new PrincipalNotAccessibleException((Throwable)((Object)ex));
            }
            throw new UMRuntimeException("Populate of " + namespace + "," + name + " failed for principal " + this.mPrincipalDatabag.getUniqueID() + "!");
        }
        return values;
    }

    protected String getAttributeValueString(String nameSpace, String attribute) {
        Vector dummy = this.getPrincipalDatabagValues(nameSpace, attribute);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        if (!dummy.isEmpty()) {
            return (String)dummy.firstElement();
        }
        return null;
    }

    protected Object getAttributeValue(String nameSpace, String attribute) {
        Vector dummy = this.getPrincipalDatabagValues(nameSpace, attribute);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        if (!dummy.isEmpty()) {
            return dummy.firstElement();
        }
        return null;
    }

    protected String[] getAttributeValuesStringArray(String nameSpace, String attribute) {
        Vector dummy = this.getPrincipalDatabagValues(nameSpace, attribute);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        return dummy.toArray(new String[0]);
    }

    protected byte[] getAttributeValueBlob(String nameSpace, String attribute) {
        Vector dummy = this.getPrincipalDatabagValues(nameSpace, attribute);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        if (!dummy.isEmpty()) {
            return (byte[])dummy.firstElement();
        }
        return null;
    }

    protected Vector getAttributeValuesBlobArray(String nameSpace, String attribute) {
        Vector dummy = this.getPrincipalDatabagValues(nameSpace, attribute);
        if (dummy == null || dummy.size() == 0) {
            return null;
        }
        return dummy;
    }

    protected Vector convertToVector(Object o) {
        Vector<Object> newVector = new Vector<Object>();
        if (o == null) {
            return newVector;
        }
        newVector.add(o);
        return newVector;
    }

    public int hashCode() {
        return this.mPrincipalDatabag.getUniqueID().hashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof IPrincipal)) {
            return false;
        }
        IPrincipal u = (IPrincipal)another;
        return this.mPrincipalDatabag.getUniqueID().equals(u.getUniqueID());
    }

    static {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES = new AttributeList(false);
        ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "description", 1);
        ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "uniquename", 1);
        ABSTRACT_PRINCIPAL_DEFAULT_ATTRIBUTES.addAttribute("com.sap.security.core.usermanagement", "displayname", 1);
        mNestedRolesActivated = UMFactory.getProperties().getBoolean(ALLOW_NESTED_ROLES, false);
        mCacheGroupHierarchy = UMFactory.getProperties().getBoolean(CACHE_GROUP_HIERARCHY, true);
        mCacheRoleHierarchy = UMFactory.getProperties().getBoolean(CACHE_ROLE_HIERARCHY, true);
        mAllowNestedGroups = UMFactory.getProperties().getBoolean(ALLOW_NESTED_GROUPS, true);
        mCacheAllParents = UMFactory.getProperties().getBoolean(CACHE_INDIRECT_PARENTS, true);
        mGroupTypeArray = new String[]{"GRUP"};
        mRoleTypeArray = new String[]{"ROLE"};
    }

    class AllParentsCacheKey {
        private String mTypes;

        public AllParentsCacheKey(String[] principalTypeIdentifiers) {
            int size = principalTypeIdentifiers.length;
            String[] types = new String[size];
            System.arraycopy(principalTypeIdentifiers, 0, types, 0, size);
            Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
            StringBuffer strb = new StringBuffer(types.length * 4);
            int i = 0;
            while (i < size) {
                strb.append(types[i]);
                ++i;
            }
            this.mTypes = strb.toString();
            types = null;
            strb = null;
        }

        public int hashCode() {
            return this.mTypes.hashCode();
        }

        public String getTypes() {
            return this.mTypes;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof AllParentsCacheKey) {
                return ((AllParentsCacheKey)o).getTypes().equals(this.mTypes);
            }
            return false;
        }
    }
}

