/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.admin;

import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.permissions.UMAdminPermissions;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.HashMap;

public class UserAdminHelper {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/admin/UserAdminHelper.java#7 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/admin/UserAdminHelper.java#7 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    public static final String VIEW_MY_PROFILE = "USER_VIEWMYPROFILE";
    public static final String CHANGE_MY_PROFILE = "USER_CHANGEMYPROFILE";
    private static final String SELF_MANAGEMENT_ENABLED = "ume.admin.allow_selfmanagement";
    public static final String CREATE_USERS = "USER_CREATE";
    public static final String APPROVE_USERS = "USER_APPROVE";
    public static final String DELETE_USERS = "USER_DELETE";
    public static final String LOCK_USERS = "USER_LOCK";
    public static final String UNLOCK_USERS = "USER_UNLOCK";
    public static final String SEARCH_USERS = "USER_SEARCH";
    public static final String VIEW_PROFILE = "USER_VIEWPROFILE";
    public static final String CHANGE_PROFILE = "USER_CHANGEPROFILE";
    public static final String CHANGE_PASSWORD = "USER_CHANGEPASSWORD";
    public static final String VIEW_GROUPS = "GROUPS_VIEW";
    public static final String ADD_GROUPS = "GROUPS_ADD";
    public static final String MODIFY_GROUPS = "GROUPS_MODIFY";
    public static final String DELETE_GROUPS = "GROUPS_DELETE";
    public static final String ASSIGN_GROUPS = "GROUPS_ASSIGN";
    public static final String VIEW_ROLES = "ROLES_VIEW";
    public static final String ADD_ROLES = "ROLES_ADD";
    public static final String MODIFY_ROLES = "ROLES_MODIFY";
    public static final String DELETE_ROLES = "ROLES_DELETE";
    public static final String ASSIGN_ROLES = "ROLES_ASSIGN";
    public static final String MANAGE_ALL_COMPANIES = "MANAGE_ALL_COMPANIES";
    public static final String ASSIGN_USERS_TO_DIFF_COM = "USERS_ASSIGN_TO_DIFF_COM";
    public static final String BATCH_ADMIN = "BATCH_ADMIN";
    public static final String MONITOR_PERFORMANCE = "MONITOR_PERFORMANCE";
    public static final String MONITOR_CACHE = "MONITOR_CACHE";
    public static final String SYNC_ADMIN = "SYNC_ADMIN";
    public static final String TPD_DEFAULT_CLASS = "com.sap.security.core.tpd.SimpleTPD";
    public static final String TPD_IMP_PROPERTY = "ume.tpd.imp.class";
    public static final String TPD_COMPANIES = "ume.tpd.companies";
    public static final String TPD_COMPANIES_DEFAULT_VALUE = "0";

    public static void checkAccess(IUser performer, String action) throws AccessControlException {
        trace.entering("checkAccess(IUser,String)");
        if (!UserAdminHelper.hasAccess(performer, action)) {
            if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                HashMap<String, String> detailsMap = new HashMap<String, String>();
                detailsMap.put("Permission", action);
                SecurityAudit.log("ACCESS.ERROR", null, detailsMap);
            }
            throw new AccessControlException("NO_ACCESS");
        }
        if (SecurityAudit.isLogged("ACCESS.OK")) {
            HashMap<String, String> detailsMap = new HashMap<String, String>();
            detailsMap.put("Permission", action);
            SecurityAudit.log("ACCESS.OK", null, detailsMap);
        }
    }

    public static void checkAccess(IUser performer, IUser subjugatedUser, String action) throws AccessControlException {
        trace.entering("checkAccess(IUser,IUser,String)");
        if (!UserAdminHelper.hasAccess(performer, subjugatedUser, action)) {
            if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                HashMap<String, String> detailsMap = new HashMap<String, String>();
                detailsMap.put("Permission", action);
                SecurityAudit.log("ACCESS.ERROR", subjugatedUser.getUniqueID(), detailsMap);
            }
            throw new AccessControlException("NO_ACCESS");
        }
        if (SecurityAudit.isLogged("ACCESS.OK")) {
            HashMap<String, String> detailsMap = new HashMap<String, String>();
            detailsMap.put("Permission", action);
            SecurityAudit.log("ACCESS.OK", subjugatedUser.getUniqueID(), detailsMap);
        }
    }

    public static void checkAccess(IUser performer, String subjugatedCompanyID, String action) throws AccessControlException {
        HashMap<String, String> detailsMap;
        if (trace.beDebug()) {
            StringBuffer tStrBuf = new StringBuffer(performer.getDisplayName());
            tStrBuf.append(" performs ").append(action).append(" on ");
            if (subjugatedCompanyID == null || "".equals(subjugatedCompanyID)) {
                tStrBuf.append("GuestUsers");
            } else {
                tStrBuf.append(subjugatedCompanyID);
            }
            trace.debugT("checkAccess(IUser,String,String)", tStrBuf.toString());
        }
        if (!UserAdminHelper.hasAccess(performer, subjugatedCompanyID, action)) {
            if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                detailsMap = new HashMap<String, String>();
                detailsMap.put("Permission", action);
                SecurityAudit.log("ACCESS.ERROR", subjugatedCompanyID, detailsMap);
            }
            throw new AccessControlException("NO_ACCESS");
        }
        if (SecurityAudit.isLogged("ACCESS.OK")) {
            detailsMap = new HashMap();
            detailsMap.put("Permission", action);
            SecurityAudit.log("ACCESS.OK", subjugatedCompanyID, detailsMap);
        }
    }

    public static boolean hasAccess(IUser performer, String action) {
        String methodName = "hasAccess(IUser,String)";
        if (trace.beDebug()) {
            StringBuffer tStrBuf = new StringBuffer("performer ");
            tStrBuf.append(performer.getDisplayName()).append(" performs ").append(action);
            trace.debugT("hasAccess(IUser,String)", tStrBuf.toString());
        }
        if ((VIEW_MY_PROFILE.equals(action) || CHANGE_MY_PROFILE.equals(action)) && UMFactory.getProperties().getBoolean(SELF_MANAGEMENT_ENABLED)) {
            trace.exiting("hasAccess(IUser,String)", "default rights enabled - succeeded");
            return true;
        }
        boolean status = performer.hasPermission((Permission)new UMAdminPermissions(action));
        trace.exiting("hasAccess(IUser,String)", new Boolean(status));
        return status;
    }

    public static boolean hasAccess(IUser performer, IUser subjugatedUser, String action) {
        String methodName = "hasAccess(IUser,IUser,String)";
        if (subjugatedUser.equals(performer)) {
            if (action != null) {
                return UserAdminHelper.hasAccess(subjugatedUser, action);
            }
            return true;
        }
        if (trace.beDebug()) {
            StringBuffer tStrBuf = new StringBuffer("performer ");
            tStrBuf.append(performer.getDisplayName()).append(" performs ").append(action);
            tStrBuf.append(" on ").append(subjugatedUser.getDisplayName());
            trace.debugT("hasAccess(IUser,IUser,String)", tStrBuf.toString());
        }
        return UserAdminHelper.hasAccess(performer, subjugatedUser.getCompany(), action);
    }

    public static boolean hasAccess(IUser performer, String subjugatedCompanyID, String action) {
        String methodName = "hasAccess(IUser,String,String)";
        if (action != null && !performer.hasPermission((Permission)new UMAdminPermissions(action))) {
            trace.exiting("hasAccess(IUser,String,String)", "failed - doesn't have action " + action);
            return false;
        }
        if (performer.hasPermission((Permission)new UMAdminPermissions(MANAGE_ALL_COMPANIES))) {
            trace.exiting("hasAccess(IUser,String,String)", "succeeded with MANAGE_ALL_COMPANIES");
            return true;
        }
        if (!performer.isCompanyUser()) {
            boolean subCompIsGuestComp = subjugatedCompanyID == null || "".equals(subjugatedCompanyID);
            trace.exiting("hasAccess(IUser,String,String)", new Boolean(subCompIsGuestComp));
            return subCompIsGuestComp;
        }
        if (performer.getCompany().equals(subjugatedCompanyID)) {
            trace.exiting("hasAccess(IUser,String,String)", new Boolean(true));
            return true;
        }
        trace.exiting("hasAccess(IUser,String,String)", new Boolean(false));
        return false;
    }

    public static boolean isCompanyConceptEnabled() {
        IUMParameters properties = UMFactory.getProperties();
        String tpdClass = properties.get(TPD_IMP_PROPERTY, TPD_DEFAULT_CLASS);
        String tpdCompanies = properties.get(TPD_COMPANIES, TPD_COMPANIES_DEFAULT_VALUE);
        if ("".equals(tpdClass)) {
            return false;
        }
        if (!TPD_DEFAULT_CLASS.equals(tpdClass)) {
            return true;
        }
        return !TPD_COMPANIES_DEFAULT_VALUE.equals(tpdCompanies) && !"".equals(tpdCompanies);
    }

    public static boolean isDefaultTPDEnabled() {
        IUMParameters properties = UMFactory.getProperties();
        String tpdClass = properties.get(TPD_IMP_PROPERTY, TPD_DEFAULT_CLASS);
        return UserAdminHelper.isCompanyConceptEnabled() && TPD_DEFAULT_CLASS.equals(tpdClass);
    }
}

