/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclPermissionImpl;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IAclPermissionListIterator;
import com.sap.security.core.acl.imp.wcm.PermissionExistsException;
import com.sap.security.core.acl.imp.wcm.PermissionUsedException;
import com.sap.security.core.acl.imp.wcm.PredefinedPermissionException;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.util.IUMTrace;
import java.util.HashSet;
import java.util.Set;

public final class JDBCPermission
extends AclPermissionImpl {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCPermission.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCPermission.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private final JDBCDatabaseConnectionUncached m_databaseConnection;
    private final String m_name;
    private final boolean m_isPredefined;
    private IAclPermissionList m_members = null;

    protected JDBCPermission(JDBCDatabaseConnectionUncached databaseConnection, String name, boolean isPredefined, IAclPermissionList members) {
        String mn = "protected constructor";
        if (databaseConnection == null || name == null || members == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{databaseConnection, name, members});
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Creating JDBCPermission");
        }
        this.m_databaseConnection = databaseConnection;
        this.m_name = name;
        this.m_isPredefined = isPredefined;
        this.m_members = members;
        if (trace.bePath()) {
            trace.exiting(mn);
        }
    }

    public boolean isAtomic() throws AclPersistenceException {
        return this.m_members.size() == 0;
    }

    public boolean isMember(IAclPermission permission) throws AclPersistenceException {
        String mn = "isMember(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        IAclPermissionListIterator iterator = this.m_members.iterator();
        while (iterator != null && iterator.hasNext()) {
            IAclPermission listPermission = iterator.next();
            if (listPermission == null || !listPermission.equals(permission)) continue;
            return true;
        }
        return false;
    }

    public IAclPermissionList getMembers() throws AclPersistenceException {
        return this.m_members;
    }

    public boolean isContained(IAclPermission other) throws AclPersistenceException {
        String mn = "isContained(IAclPermission other)";
        if (other == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (this.m_name.equals("fullcontrol")) {
            return true;
        }
        if (this.m_name.equals(other.getName())) {
            return true;
        }
        if (this.isAtomic()) {
            return false;
        }
        HashSet myAtomicPermissions = new HashSet(7);
        this.collectAtomicPermissions(this, myAtomicPermissions);
        if (other.isAtomic()) {
            return myAtomicPermissions.contains(other);
        }
        HashSet hisAtomicPermissions = new HashSet(7);
        this.collectAtomicPermissions(other, hisAtomicPermissions);
        return myAtomicPermissions.containsAll(hisAtomicPermissions);
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isPredefined() {
        return this.m_isPredefined;
    }

    public boolean addMember(IAclPermission permission) throws AclPersistenceException, PermissionExistsException, PredefinedPermissionException, PermissionUsedException {
        String mn = "addMember(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (this.m_isPredefined) {
            return false;
        }
        if (!this.m_databaseConnection.addPermissionMember(this.m_name, permission)) {
            return false;
        }
        this.m_members = this.m_databaseConnection.getPermissionMembers(this.m_name);
        return true;
    }

    public boolean removeMember(IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removeMember(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (this.m_isPredefined) {
            return false;
        }
        if (!this.m_databaseConnection.removePermissionMember(this.m_name, permission)) {
            return false;
        }
        this.m_members = this.m_databaseConnection.getPermissionMembers(this.m_name);
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof JDBCPermission) {
            return this.m_name.equals(((JDBCPermission)other).m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("JDBCPermission[").append(this.m_name);
        if (this.m_members.size() > 0) {
            sb.append(", ").append(this.m_members);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(IAclPermission permission) throws AclPersistenceException {
        return this.m_name.equals(permission.getName());
    }

    private void collectAtomicPermissions(IAclPermission permission, Set set) throws AclPersistenceException {
        if (permission.isAtomic()) {
            set.add(permission);
            return;
        }
        IAclPermissionList members = permission.getMembers();
        IAclPermissionListIterator iterator = members.iterator();
        while (iterator.hasNext()) {
            IAclPermission memberPermission = iterator.next();
            this.collectAtomicPermissions(memberPermission, set);
        }
    }
}

