/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.ip.basecomps.util.UUID;
import com.sap.security.api.AttributeList;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclEntryList;
import com.sap.security.core.acl.imp.wcm.AclExistsException;
import com.sap.security.core.acl.imp.wcm.AclLoadClassException;
import com.sap.security.core.acl.imp.wcm.AclPermissionList;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.AlreadyAssignedToAclException;
import com.sap.security.core.acl.imp.wcm.IAclEntryList;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IAclPermissionListIterator;
import com.sap.security.core.acl.imp.wcm.IObjectType;
import com.sap.security.core.acl.imp.wcm.IObjectTypeList;
import com.sap.security.core.acl.imp.wcm.IPrincipalList;
import com.sap.security.core.acl.imp.wcm.InvalidClassException;
import com.sap.security.core.acl.imp.wcm.LastOwnerException;
import com.sap.security.core.acl.imp.wcm.ObjectType;
import com.sap.security.core.acl.imp.wcm.ObjectTypeList;
import com.sap.security.core.acl.imp.wcm.PermissionExistsException;
import com.sap.security.core.acl.imp.wcm.PermissionUsedException;
import com.sap.security.core.acl.imp.wcm.PredefinedPermissionException;
import com.sap.security.core.acl.imp.wcm.PrincipalList;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAcl;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAclEntry;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCPermission;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.util.Escape;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.core.util.imp.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public final class JDBCDatabaseConnectionUncached {
    private static final String ACL_TABLE_NAME = "UME_ACL_ACL";
    private static final String ACL_ENTRY_TABLE_NAME = "UME_ACL_ACLENTRY";
    private static final String ACL_OWNER_TABLE_NAME = "UME_ACL_OWNER";
    private static final String ACL_PERMISSION_TABLE_NAME = "UME_ACL_PERM";
    private static final String ACL_SUPPORTED_PERMISSION_TABLE_NAME = "UME_ACL_SUP_PERM";
    private static final String ACL_PERMISSION_MEMBER_TABLE_NAME = "UME_ACL_PERM_MEM";
    private static final String ACL_MANAGER_TABLE_NAME = "UME_ACL_MANAGER";
    private static final String ACL_MANAGER_APP_COL = "APP";
    private static final String ACL_MANAGER_MANAGER_COL = "MANAGER";
    private static final String ACL_MANAGER_ID_COL = "ID";
    private static final String ACL_RID_COL = "RID";
    private static final String ACL_OWNERID_COL = "OWNERID";
    private static final String ACL_RIDSTART_COL = "RIDSTART";
    private static final String ACL_RIDSTART_HASH_COL = "RIDSTARTH";
    private static final int RID_START_LENGTH = 255;
    private static final int RID_MAX_ESCAPED_LENGTH = 255;
    private static final String ACL_HASH_COL = "HASH";
    private static final String ACL_CHANGE_LEVEL_COL = "CHANGE_LEVEL";
    private static final String ACL_OBJECT_TYPE_COL = "OBJECT_TYPE";
    private static final String ACL_OBJECT_TYPE_HASH_COL = "OBJECT_TYPEH";
    private static final int OBJECT_TYPE_LENGTH = 127;
    private static final String ACL_ENTRY_ID_COL = "ID";
    private static final String ACL_PRINCIPAL_NAME_COL = "PRINCIPAL_NAME";
    private static final int PRINCIPAL_NAME_LENGTH = 255;
    private static final String ACL_PRINCIPAL_TYPE_COL = "PRINCIPAL_TYPE";
    private static final String ACL_LOCKING_USER_COL = "LOCKING_USER";
    private static final String ACL_SORT_INDEX_COL = "SORT_INDEX";
    private static final String ACL_IS_NEGATIVE_COL = "IS_NEGATIVE";
    private static final String ACL_IS_PROPAGATED_COL = "IS_PROPAGATED";
    private static final String ACL_PERMISSION_NAME_COL = "PERMISSION_NAME";
    private static final String ACL_PERMISSION_NAME_HASH_COL = "PERMISSION_NAMEH";
    private static final int PERMISSION_NAME_LENGTH = 127;
    private static final String ACL_IS_PREDEFINED_COL = "IS_PREDEFINED";
    private static final String ACL_PERMISSION_MEMBER_COL = "MEMBER_NAME";
    private static final int PERMISSION_MEMBER_LENGTH = 127;
    private static final String SEPARATOR = "-";
    private static final String KEY_PERMISSION_PREFIX = "p";
    private static final String KEY_SUPPORTED_PERMISSIONS_PREFIX = "s";
    private static final int PRINCIPAL_TYPE_TAG = -1;
    private static final String APP_AND_MANAGER_SEL_CONDITION = "\"OWNERID\"=?";
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCDatabaseConnectionUncached.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCDatabaseConnectionUncached.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    private String m_applicationID = null;
    private String m_managerID = null;
    private String m_poolID = null;
    private int m_owner;
    private ICache m_permissionCache = null;
    private IConnectionPool conPool = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCDatabaseConnectionUncached(String applicationID, String managerID, String poolID, ICache permissionCache) throws AclLoadClassException, AclPersistenceException {
        String mn = "Constructor";
        if (applicationID == null || managerID == null || poolID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.errorT(mn, iae);
            throw iae;
        }
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{applicationID, managerID, poolID});
        }
        this.m_applicationID = applicationID;
        this.m_managerID = managerID;
        this.m_poolID = poolID;
        if (trace.beDebug()) {
            this.logDebug("JDBCDatabaseConnectionUncached", "applicationID " + applicationID + ", managerID " + managerID + ", poolID " + poolID);
        }
        this.m_permissionCache = permissionCache;
        this.conPool = InternalUMFactory.getJdbcConnectionPool();
        if (this.conPool == null) {
            trace.errorT("JDBCDatabaseConnectionUncached(...)", "No JDBC connection pool found, which is needed for ACL's!");
            throw new AclPersistenceException("InternalUMFactory.getJdbcConnectionPool() failed");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                block29: {
                    conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.constructor");
                    try {
                        try {
                            String query = "SELECT \"ID\" FROM \"UME_ACL_MANAGER\" WHERE \"APP\"=? AND \"MANAGER\"=?";
                            if (trace.beInfo()) {
                                trace.infoT(mn, query);
                            }
                            st = conn.prepareStatement(query);
                            st.setString(1, this.trim(Escape.escapeSqlString(this.m_applicationID, 127)));
                            st.setString(2, this.trim(Escape.escapeSqlString(this.m_managerID, 127)));
                            rs = st.executeQuery();
                            if (rs.next()) {
                                this.m_owner = rs.getInt(1);
                            } else {
                                rs.close();
                                rs = null;
                                st.close();
                                st = null;
                                query = "SELECT MAX( \"ID\" ) FROM \"UME_ACL_MANAGER\"";
                                if (trace.beInfo()) {
                                    trace.infoT(mn, query);
                                }
                                if ((rs = (st = conn.prepareStatement(query)).executeQuery()).next()) {
                                    this.m_owner = rs.getInt(1);
                                    ++this.m_owner;
                                }
                                st = null;
                                rs = null;
                                query = "INSERT INTO \"UME_ACL_MANAGER\" ( \"ID\" , \"APP\" , \"MANAGER\" ) VALUES (?,?,?)";
                                if (trace.beInfo()) {
                                    trace.infoT(mn, query);
                                }
                                st = conn.prepareStatement(query);
                                st.setInt(1, this.m_owner);
                                st.setString(2, this.trim(Escape.escapeSqlString(this.m_applicationID, 127)));
                                st.setString(3, this.trim(Escape.escapeSqlString(this.m_managerID, 127)));
                                st.executeUpdate();
                                st.close();
                                st = null;
                                query = "SELECT \"ID\" FROM \"UME_ACL_MANAGER\" WHERE \"APP\"=? AND \"MANAGER\"=?";
                                if (trace.beInfo()) {
                                    trace.infoT(mn, query);
                                }
                                st = conn.prepareStatement(query);
                                st.setString(1, this.trim(Escape.escapeSqlString(this.m_applicationID, 127)));
                                st.setString(2, this.trim(Escape.escapeSqlString(this.m_managerID, 127)));
                                rs = st.executeQuery();
                                if (!rs.next()) {
                                    AclPersistenceException ape = new AclPersistenceException("Can't insert entry for manager='" + managerID + "' and application '" + applicationID + " mapped to '" + this.trim(Escape.escapeSqlString(this.m_managerID, 127)) + "'/'" + this.trim(Escape.escapeSqlString(this.m_applicationID, 127)) + "' in poolID '" + poolID + "'");
                                    trace.errorT(mn, (Throwable)((Object)ape));
                                    throw ape;
                                }
                                this.m_owner = rs.getInt(1);
                            }
                            this.ensureHash(conn, ACL_TABLE_NAME);
                            this.ensureHash(conn, ACL_ENTRY_TABLE_NAME);
                            this.ensureHash(conn, ACL_OWNER_TABLE_NAME);
                            this.checkInsertInitialPermissions(conn);
                            if (trace.bePath()) {
                                trace.exiting(mn);
                            }
                        }
                        catch (SQLException e) {
                            AclPersistenceException ace = new AclPersistenceException(e);
                            trace.infoT(mn, (Throwable)((Object)ace));
                            throw ace;
                        }
                        Object var12_16 = null;
                        if (rs == null) break block29;
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sqlex) {
                                AclPersistenceException ace = new AclPersistenceException(sqlex);
                                trace.infoT(mn, (Throwable)((Object)ace));
                                throw ace;
                            }
                        }
                        if (st == null) throw throwable;
                        try {
                            st.close();
                            throw throwable;
                        }
                        catch (SQLException sqlex) {
                            AclPersistenceException ace = new AclPersistenceException(sqlex);
                            trace.infoT(mn, (Throwable)((Object)ace));
                            throw ace;
                        }
                    }
                    try {}
                    catch (SQLException sqlex) {
                        AclPersistenceException ace = new AclPersistenceException(sqlex);
                        trace.infoT(mn, (Throwable)((Object)ace));
                        throw ace;
                    }
                    rs.close();
                }
                if (st != null) {
                    try {}
                    catch (SQLException sqlex) {
                        AclPersistenceException ace = new AclPersistenceException(sqlex);
                        trace.infoT(mn, (Throwable)((Object)ace));
                        throw ace;
                    }
                    st.close();
                }
                Object var16_27 = null;
                if (conn == null) return;
                this.conPool.releaseConnection(conn);
                return;
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ace = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)ace));
                throw ace;
            }
        }
        catch (Throwable throwable) {
            Object var16_28 = null;
            if (conn == null) throw throwable;
            this.conPool.releaseConnection(conn);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private void ensureHash(Connection con, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean runningInJTATransaction() {
        if (this.conPool.isJTASupportEnabled()) {
            block8: {
                try {
                    InitialContext ctx = new InitialContext();
                    UserTransaction userTransaction = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
                    if (userTransaction != null && userTransaction.getStatus() != 6) {
                        if (trace.beInfo()) {
                            trace.infoT("runningInJTATransaction", "Open JTA transaction found.");
                        }
                        return true;
                    }
                }
                catch (Exception ex) {
                    if (!trace.beDebug()) break block8;
                    trace.debugT("runningInJTATransaction", ex);
                }
            }
            if (trace.beInfo()) {
                trace.infoT("runningInJTATransaction", "No JTA transaction found.");
            }
        } else if (trace.beInfo()) {
            trace.infoT("runningInJTATransaction", "JTA support not enabled.");
        }
        return false;
    }

    public JDBCAcl getAcl(String externalAclID) throws AclPersistenceException {
        String mn = "getAcl(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getAcl", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.constructor");
                try {
                    JDBCAcl result = null;
                    AclRec acl = this.uncommittedGetAcl(conn, externalAclID);
                    if (acl != null) {
                        IPrincipalList owners = this.uncommittedGetOwners(conn, externalAclID);
                        IAclEntryList entries = this.uncommittedGetAclEntries(conn, externalAclID);
                        result = new JDBCAcl(this, externalAclID, new ObjectType(acl.getObjectTypeName()), owners, entries, acl.getChangeLevel());
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    JDBCAcl jDBCAcl = result;
                    Object var11_16 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return jDBCAcl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var11_17 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public JDBCAcl[] getAcls(String[] externalAclIDs) throws AclPersistenceException {
        String mn = "getAcls(String[] externalAclIDs)";
        if (externalAclIDs == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getAcls", "externalAclIDs-length " + externalAclIDs.length);
        }
        if (externalAclIDs.length == 0) {
            return new JDBCAcl[0];
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAcls(String[] externalAclIDs)");
                try {
                    JDBCAcl[] result = new JDBCAcl[externalAclIDs.length];
                    String[] internalIDs = this.uncommittedGetInternalAclIDs(conn, externalAclIDs);
                    AclRec[] acls = this.uncommittedGetAcls(conn, internalIDs, externalAclIDs);
                    IPrincipalList[] owners = this.uncommittedGetOwners(conn, acls);
                    IAclEntryList[] entries = this.uncommittedGetAclEntries(conn, acls);
                    int i = 0;
                    while (i < externalAclIDs.length) {
                        result[i] = acls[i] != null ? new JDBCAcl(this, externalAclIDs[i], new ObjectType(acls[i].getObjectTypeName()), owners[i], entries[i], acls[i].getChangeLevel()) : null;
                        ++i;
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    JDBCAcl[] jDBCAclArray = result;
                    Object var14_19 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return jDBCAclArray;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block15: {
                Object var14_20 = null;
                if (conn == null || connReleased) break block15;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IAclEntryList getAclEntries(String externalAclID) throws AclPersistenceException {
        String mn = "getAclEntries(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getAclEntries", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAclEntries(String externalAclID)");
                try {
                    IAclEntryList result = this.uncommittedGetAclEntries(conn, externalAclID);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IAclEntryList iAclEntryList = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iAclEntryList;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean setAclEntrySortIndex(String aclEntryID, int sortIndex) throws AclPersistenceException {
        String mn = "setAclEntrySortIndex(String aclEntryID, int sortIndex)";
        if (aclEntryID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("setAclEntrySortIndex", "aclEntryID " + aclEntryID + ", sortIndex " + sortIndex);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.setAclEntrySortIndex(String aclEntryID, int sortIndex)");
                try {
                    boolean result = this.uncommittedSetAclEntrySortIndex(conn, aclEntryID, sortIndex);
                    if (result) {
                        this.uncommittedIncreaseAclChangeLevel(conn, this.uncommittedGetInternalAclIDFromEntryID(conn, aclEntryID));
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean setAclEntryPropagation(String aclEntryID, boolean propagate) throws AclPersistenceException {
        String mn = "setAclEntryPropagation(String aclEntryID, boolean propagate)";
        if (aclEntryID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("setAclEntryPropagation", "aclEntryID " + aclEntryID + ", propagate " + propagate);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.setAclEntryPropagation(String aclEntryID, boolean propagate)");
                try {
                    boolean result = this.uncommittedSetAclEntryPropagation(conn, aclEntryID, propagate);
                    if (result) {
                        this.uncommittedIncreaseAclChangeLevel(conn, this.uncommittedGetInternalAclIDFromEntryID(conn, aclEntryID));
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IObjectTypeList getSupportedObjectTypes() {
        if (trace.beDebug()) {
            trace.debugT("getSupportedObjectTypes", "");
        }
        ObjectTypeList objectTypes = new ObjectTypeList();
        objectTypes.add(new ObjectType("node"));
        objectTypes.add(new ObjectType("leaf"));
        return objectTypes;
    }

    public IAclPermissionList getSupportedPermissions(IObjectType objectType) throws AclPersistenceException {
        IAclPermissionList supportedPermissions;
        String mn = "getSupportedPermissions(IObjectType objectType)";
        if (objectType == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getSupportedPermissions", "objectType " + objectType.getName());
        }
        if ((supportedPermissions = this.cacheGetSupportedPermissions(objectType.getName())) != null) {
            return supportedPermissions;
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getSupportedPermissions(IObjectType objectType)");
                try {
                    IAclPermissionList permissions = this.uncommittedGetSupportedPermissions(conn, objectType.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IAclPermissionList iAclPermissionList = permissions;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iAclPermissionList;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IPrincipalList getOwners(String externalAclID) throws AclPersistenceException {
        String mn = "getOwners(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getOwners", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getOwners(String externalAclID)");
                try {
                    IPrincipalList result = this.uncommittedGetOwners(conn, externalAclID);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IPrincipalList iPrincipalList = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iPrincipalList;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IAclPermissionList getPermissionMembers(String permissionName) throws AclPersistenceException {
        String mn = "getPermissionMembers(String permissionName)";
        if (permissionName == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getPermissionMembers", "permissionName " + permissionName);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getPermissionMembers(String permissionName)");
                try {
                    IAclPermissionList members = this.uncommittedGetPermissionMembers(conn, permissionName);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IAclPermissionList iAclPermissionList = members;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iAclPermissionList;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean isPermissionUsedInAcl(IAclPermission permission) throws AclPersistenceException {
        String mn = "isPermissionUsedInAcl(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("isPermissionUsedInAcl", "permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.isPermissionUsedInAcl(IAclPermission permission)");
                try {
                    boolean result = this.uncommittedIsUsedPermission(conn, permission.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public List getAffectedAclIDs(IAclPermission permission) throws AclPersistenceException {
        String mn = "getAffectedAclIDs(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getAffectedAclIDs", "permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAffectedAclIDs(IAclPermission permission)");
                try {
                    List result = this.uncommittedGetAffectedAclIDs(conn, permission.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    List list = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return list;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IAclPermission getPermission(String permissionName) throws AclPersistenceException {
        IAclPermission permission;
        String mn = "getPermission(String permissionName)";
        if (permissionName == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getPermission", "permissionName " + permissionName);
        }
        if ((permission = this.cacheGetPermission(permissionName)) != null) {
            return permission;
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getPermission(String permissionName)");
                try {
                    IAclPermission result = this.uncommittedGetPermission(conn, permissionName);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IAclPermission iAclPermission = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iAclPermission;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean isAclLocked(String externalAclID) throws AclPersistenceException {
        String mn = "isAclLocked(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("externalAclID", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.isAclLocked(String externalAclID)");
                try {
                    boolean result = this.uncommittedIsAclLocked(conn, externalAclID);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IUser getAclLockingUser(String externalAclID) throws AclPersistenceException {
        String mn = "getAclLockingUser(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getAclLockingUser", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAclLockingUser(String externalAclID)");
                try {
                    IUser result = this.uncommittedGetAclLockingUser(conn, externalAclID);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    IUser iUser = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return iUser;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public List getDescendantsWithAcl(String externalAclIDRoot) throws AclPersistenceException {
        String mn = "getDescendantsWithAcl(String externalAclIDRoot)";
        if (externalAclIDRoot == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("getDescendantsWithAcl", "externalAclIDRoot " + externalAclIDRoot);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getDescendantsWithAcl(String externalAclIDRoot)");
                try {
                    List result = this.uncommittedGetDescendantsWithAcl(conn, externalAclIDRoot);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    List list = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return list;
                }
                catch (Exception e) {
                    if (!jtaUsed) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sqlException) {
                            trace.infoT(mn, sqlException);
                        }
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public JDBCAcl createAcl(IPrincipal owner, String externalAclID, IObjectType objectType) throws AclPersistenceException, AclExistsException {
        String mn = "createAcl(IPrincipal owner, String externalAclID, IObjectType objectType)";
        if (owner == null || externalAclID == null || objectType == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("createAcl", "owner " + owner.getUniqueID() + ", externalAclID " + externalAclID + ", objectType " + objectType);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.createAcl(IPrincipal owner, String externalAclID, IObjectType objectType)");
                try {
                    if (this.uncommittedCheckAcl(conn, externalAclID)) {
                        throw new AclExistsException();
                    }
                    this.uncommittedRemoveAclEntries(conn, externalAclID);
                    this.uncommittedRemoveOwners(conn, externalAclID);
                    Escape.escapeSqlString(externalAclID, 255);
                    if (!this.uncommittedAddOwner(conn, externalAclID, owner)) {
                        throw new Exception("can't create owner");
                    }
                    if (!this.uncommittedAddAcl(conn, externalAclID, objectType)) {
                        throw new Exception("can't create acl");
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                }
                catch (AclExistsException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
                PrincipalList owners = new PrincipalList();
                owners.add(owner);
                JDBCAcl e = new JDBCAcl(this, externalAclID, objectType, owners, new AclEntryList(), 0L);
                Object var12_18 = null;
                if (conn != null && !connReleased) {
                    this.conPool.releaseConnection(conn);
                }
                return e;
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block20: {
                Object var12_19 = null;
                if (conn == null || connReleased) break block20;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public String addAclEntry(String externalAclID, JDBCAclEntry entry) throws AclPersistenceException, AlreadyAssignedToAclException {
        String mn = "addAclEntry(String externalAclID, JDBCAclEntry entry)";
        if (externalAclID == null || entry == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("addAclEntry", "externalAclID " + externalAclID + ", entryID " + entry.getID());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.addAclEntry(String externalAclID, JDBCAclEntry entry)");
                try {
                    String result = null;
                    result = this.uncommittedAddAclEntry(conn, externalAclID, entry);
                    if (result != null) {
                        this.uncommittedIncreaseAclChangeLevel(conn, externalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    String string = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return string;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removeAcl(String externalAclID) throws AclPersistenceException {
        String mn = "removeAcl(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removeAcl", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removeAcl(String externalAclID)");
                try {
                    boolean result = false;
                    if (this.uncommittedGetAcl(conn, externalAclID) != null) {
                        this.uncommittedRemoveAclEntries(conn, externalAclID);
                        this.uncommittedRemoveOwners(conn, externalAclID);
                        this.uncommittedRemoveAcl(conn, externalAclID);
                        result = true;
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removeAclEntry(JDBCAclEntry entry) throws AclPersistenceException {
        String mn = "removeAclEntry(JDBCAclEntry entry)";
        if (entry == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removeAclEntry", "entryID " + entry.getID());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removeAclEntry(JDBCAclEntry entry)");
                try {
                    boolean result = false;
                    String internalAclID = this.uncommittedGetInternalAclIDFromEntryID(conn, entry.getID());
                    if (internalAclID != null && (result = this.uncommittedRemoveAclEntry(conn, entry.getID()))) {
                        this.uncommittedIncreaseAclChangeLevel(conn, internalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean addSupportedPermission(IObjectType objectType, IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException {
        String mn = "addSupportedPermission(IObjectType objectType, IAclPermission permission)";
        if (objectType == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("addSupportedPermission", "objectType " + objectType.getName() + ", permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.addSupportedPermission(IObjectType objectType, IAclPermission permission)");
                try {
                    if (this.uncommittedIsPredefinedPermission(conn, permission.getName())) {
                        throw new PredefinedPermissionException();
                    }
                    boolean result = false;
                    if (!this.uncommittedIsSupportedPermission(conn, permission.getName(), objectType.getName())) {
                        result = this.uncommittedAddSupportedPermission(conn, permission.getName(), objectType.getName());
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var11_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (PredefinedPermissionException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block19: {
                Object var11_16 = null;
                if (conn == null || connReleased) break block19;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removeSupportedPermission(IObjectType objectType, IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removeSupportedPermission(IObjectType objectType, IAclPermission permission)";
        if (objectType == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removeSupportedPermission", "objectType " + objectType.getName() + ", permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removeSupportedPermission(IObjectType objectType, IAclPermission permission)");
                try {
                    if (this.uncommittedIsPredefinedPermission(conn, permission.getName())) {
                        throw new PredefinedPermissionException();
                    }
                    if (this.uncommittedIsUsedPermission(conn, permission.getName())) {
                        throw new PermissionUsedException();
                    }
                    boolean result = false;
                    if (this.uncommittedIsSupportedPermission(conn, permission.getName(), objectType.getName())) {
                        result = this.uncommittedRemoveSupportedPermission(conn, permission.getName(), objectType.getName());
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var12_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (PredefinedPermissionException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (PermissionUsedException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block24: {
                Object var12_16 = null;
                if (conn == null || connReleased) break block24;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public IAclPermission createPermission(String name) throws AclPersistenceException, PermissionExistsException {
        String mn = "createPermission(String name)";
        if (name == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("createPermission", "name " + name);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.createPermission(String name)");
                try {
                    if (this.uncommittedCheckPermission(conn, name)) {
                        throw new PermissionExistsException();
                    }
                    this.uncommittedRemovePermissionMembers(conn, name);
                    this.uncommittedRemoveSupportedPermission(conn, name, "leaf");
                    this.uncommittedRemoveSupportedPermission(conn, name, "node");
                    this.uncommittedAddPermission(conn, name, false);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    JDBCPermission jDBCPermission = new JDBCPermission(this, name, false, new AclPermissionList());
                    Object var10_10 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return jDBCPermission;
                }
                catch (PermissionExistsException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block18: {
                Object var10_11 = null;
                if (conn == null || connReleased) break block18;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removePermission(IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removePermission(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removePermission", "permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removePermission(IAclPermission permission)");
                try {
                    if (this.uncommittedIsPredefinedPermission(conn, permission.getName())) {
                        throw new PredefinedPermissionException();
                    }
                    if (this.uncommittedIsUsedPermission(conn, permission.getName())) {
                        throw new PermissionUsedException();
                    }
                    this.uncommittedRemovePermissionMembers(conn, permission.getName());
                    this.uncommittedRemoveSupportedPermission(conn, permission.getName(), "leaf");
                    this.uncommittedRemoveSupportedPermission(conn, permission.getName(), "node");
                    boolean result = this.uncommittedRemovePermission(conn, permission.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var11_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (PredefinedPermissionException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (PermissionUsedException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block23: {
                Object var11_15 = null;
                if (conn == null || connReleased) break block23;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean addPermissionMember(String permissionName, IAclPermission permission) throws AclPersistenceException, PermissionExistsException, PredefinedPermissionException, PermissionUsedException {
        String mn = "addPermissionMember(String permissionName, IAclPermission permission)";
        if (permissionName == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("addPermissionMember", "permissionName " + permissionName + ", permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.addPermissionMember(String permissionName, IAclPermission permission)");
                try {
                    IAclPermission parent = this.uncommittedGetPermission(conn, permissionName);
                    if (this.isPermissionMember(parent, permission)) {
                        throw new PermissionExistsException();
                    }
                    if (this.isPermissionMember(permission, parent)) {
                        throw new PermissionExistsException();
                    }
                    if (this.uncommittedIsPredefinedPermission(conn, permissionName)) {
                        throw new PredefinedPermissionException();
                    }
                    if (this.uncommittedIsUsedPermission(conn, permissionName)) {
                        throw new PermissionUsedException();
                    }
                    boolean result = this.uncommittedAddPermissionMember(conn, permissionName, permission.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var13_18 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (PermissionExistsException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (PredefinedPermissionException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (PermissionUsedException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block29: {
                Object var13_19 = null;
                if (conn == null || connReleased) break block29;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removePermissionMember(String permissionName, IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removePermissionMember(String permissionName, IAclPermission permission)";
        if (permissionName == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removePermissionMember", "permissionName " + permissionName + ", permission " + permission.getName());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removePermissionMember(String permissionName, IAclPermission permission)");
                try {
                    if (this.uncommittedIsPredefinedPermission(conn, permissionName)) {
                        throw new PredefinedPermissionException();
                    }
                    if (this.uncommittedIsUsedPermission(conn, permissionName)) {
                        throw new PermissionUsedException();
                    }
                    boolean result = this.uncommittedRemovePermissionMember(conn, permissionName, permission.getName());
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var12_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (PredefinedPermissionException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (PermissionUsedException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block23: {
                Object var12_16 = null;
                if (conn == null || connReleased) break block23;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean addOwner(String externalAclID, IPrincipal owner) throws AclPersistenceException {
        String mn = "addOwner(String externalAclID, IPrincipal owner)";
        if (externalAclID == null || owner == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("addOwner", "externalAclID " + externalAclID + ", owner " + owner.getUniqueID());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.addOwner(String externalAclID, IPrincipal owner)");
                try {
                    boolean result = false;
                    if (!this.uncommittedIsOwner(conn, externalAclID, owner) && (result = this.uncommittedAddOwner(conn, externalAclID, owner))) {
                        this.uncommittedIncreaseAclChangeLevel(conn, externalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean removeOwner(String externalAclID, IPrincipal owner) throws AclPersistenceException, LastOwnerException {
        String mn = "removeOwner(String externalAclID, IPrincipal owner)";
        if (externalAclID == null || owner == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removeOwner", "externalAclID " + externalAclID + ", owner " + owner.getUniqueID());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removeOwner(String externalAclID, IPrincipal owner)");
                try {
                    boolean result = false;
                    if (this.uncommittedIsLastOwner(conn, externalAclID, owner)) {
                        throw new LastOwnerException();
                    }
                    result = this.uncommittedRemoveOwner(conn, externalAclID, owner);
                    if (result) {
                        this.uncommittedIncreaseAclChangeLevel(conn, externalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var11_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (LastOwnerException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    trace.infoT(mn, (Throwable)((Object)e));
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block19: {
                Object var11_16 = null;
                if (conn == null || connReleased) break block19;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public void deletePrincipal(String principalID) throws AclPersistenceException {
        String mn = "deletePrincipal(String principalID)";
        if (principalID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("deletePrincipal", "principal " + principalID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.deletePrincipal(IPrincipal principal)");
                try {
                    this.uncommittedRemoveOwnerGlobal(conn, principalID);
                    this.uncommittedRemoveAclEntriesGlobal(conn, principalID);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
                Object var9_12 = null;
                if (conn != null && !connReleased) {
                    this.conPool.releaseConnection(conn);
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (conn != null && !connReleased) {
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean lockAcl(String externalAclID, IPrincipal lockingUser) throws AclPersistenceException {
        String mn = "lockAcl(String externalAclID, IPrincipal lockingUser)";
        if (lockingUser == null || externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("lockAcl", "externalAclID " + externalAclID + ", lockingUser " + lockingUser.getUniqueID());
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.lockAcl(String externalAclID, IPrincipal lockingUser)");
                try {
                    boolean result = false;
                    if (!this.uncommittedIsAclLocked(conn, externalAclID) && (result = this.uncommittedLockAcl(conn, externalAclID, lockingUser))) {
                        this.uncommittedIncreaseAclChangeLevel(conn, externalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var10_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var10_16 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean unlockAcl(String externalAclID) throws AclPersistenceException {
        String mn = "unlockAcl(String externalAclID)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("unlockAcl", "externalAclID " + externalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.unlockAcl(String externalAclID)");
                try {
                    boolean result = false;
                    result = this.uncommittedUnlockAcl(conn, externalAclID);
                    if (result) {
                        this.uncommittedIncreaseAclChangeLevel(conn, externalAclID);
                    }
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var9_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var9_15 = null;
                if (conn == null || connReleased) break block14;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean changeAclID(String oldExternalAclID, String newExternalAclID) throws AclPersistenceException, AclExistsException {
        String mn = "changeAclID(String oldExternalAclID, String newExternalAclID)";
        if (oldExternalAclID == null || newExternalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("changeAclID", "oldExternalAclID " + oldExternalAclID + ", newExternalAclID " + newExternalAclID);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.changeAclID(String oldExternalAclID, String newExternalAclID)");
                try {
                    if (oldExternalAclID.equals(newExternalAclID)) {
                        throw new AclExistsException();
                    }
                    boolean result = false;
                    if (this.uncommittedGetAcl(conn, newExternalAclID) != null) {
                        throw new AclExistsException();
                    }
                    if (this.uncommittedCheckAcl(conn, newExternalAclID)) {
                        throw new AclExistsException();
                    }
                    if (this.uncommittedCheckAclEntries(conn, newExternalAclID)) {
                        throw new AclExistsException();
                    }
                    if (this.uncommittedCheckOwners(conn, newExternalAclID)) {
                        throw new AclExistsException();
                    }
                    if (!this.uncommittedChangeAclID_in_AclTable(conn, oldExternalAclID, newExternalAclID)) {
                        throw new Exception("can't change acl id in acl table");
                    }
                    if (this.uncommittedCheckAclEntries(conn, oldExternalAclID) && !this.uncommittedChangeAclID_in_AclEntryTable(conn, oldExternalAclID, newExternalAclID)) {
                        throw new Exception("can't change acl id in acl entry table");
                    }
                    if (!this.uncommittedChangeAclID_in_OwnerTable(conn, oldExternalAclID, newExternalAclID)) {
                        throw new Exception("can't change acl id in owner table");
                    }
                    result = true;
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var11_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (AclExistsException e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block25: {
                Object var11_16 = null;
                if (conn == null || connReleased) break block25;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeMultipleAclIDs(String oldAclIdPrefix, String newAclIdPrefix) throws AclPersistenceException, AclExistsException {
        String mn = "changeMultipleAclIDs(String oldAclIdPrefix, String newAclIdPrefix)";
        if (oldAclIdPrefix == null || newAclIdPrefix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("changeMultipleAclIDs", "oldAclIdPrefix " + oldAclIdPrefix + ", newAclIdPrefix " + newAclIdPrefix);
        }
        Connection conn = null;
        boolean connReleased = false;
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.changeMultipleAclIDs(String oldAclIdPrefix, String newAclIdPrefix)");
                List descendants = this.getDescendantsWithAcl(oldAclIdPrefix);
                if (descendants == null) {
                    Object var10_9 = null;
                    if (conn == null) return;
                    if (connReleased) return;
                    this.conPool.releaseConnection(conn);
                    return;
                }
                Iterator iterator = descendants.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    if (id == null) continue;
                    this.changeAclID(id, newAclIdPrefix + id.substring(oldAclIdPrefix.length()));
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (conn == null) throw throwable;
            if (connReleased) throw throwable;
            this.conPool.releaseConnection(conn);
            throw throwable;
        }
        Object var10_10 = null;
        if (conn == null) return;
        if (connReleased) return;
        this.conPool.releaseConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMultipleAcls(String aclIdPrefix) throws AclPersistenceException {
        String mn = "removeMultipleAcls(String aclIdPrefix)";
        if (aclIdPrefix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("removeMultipleAcls", "aclIdPrefix " + aclIdPrefix);
        }
        Connection conn = null;
        boolean connReleased = false;
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.removeMultipleAcls(String aclIdPrefix)");
                List descendants = this.getDescendantsWithAcl(aclIdPrefix);
                if (descendants == null) {
                    Object var9_8 = null;
                    if (conn == null) return;
                    if (connReleased) return;
                    this.conPool.releaseConnection(conn);
                    return;
                }
                Iterator iterator = descendants.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    if (id == null) continue;
                    this.removeAcl(id);
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (conn == null) throw throwable;
            if (connReleased) throw throwable;
            this.conPool.releaseConnection(conn);
            throw throwable;
        }
        Object var9_9 = null;
        if (conn == null) return;
        if (connReleased) return;
        this.conPool.releaseConnection(conn);
    }

    public boolean hasDescendantsWithAcl(String externalAclIDRoot) throws AclPersistenceException {
        return false;
    }

    private List uncommittedGetDescendantsWithAcl(Connection connection, String externalAclIDRoot) throws SQLException {
        String s;
        String mn = "uncommittedGetDescendantsWithAcl(Connection connection, String externalAclIDRoot)";
        LinkedList<String> result = new LinkedList<String>();
        StringBuffer query = new StringBuffer(120);
        query = new StringBuffer();
        query.append("SELECT \"RID\" FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"RIDSTART\"");
        String t = s = Escape.escapeSqlString(externalAclIDRoot, 0).trim() + '%';
        if (t.length() > 255) {
            t = t.substring(0, 255);
            query.append("=?");
        } else {
            query.append(" LIKE ?");
        }
        query.append(" AND \"RIDSTARTH\"=?");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        PreparedStatement st = connection.prepareStatement(query.toString());
        st.setString(2, t);
        st.setLong(3, Util.getHash(t));
        SqlResult queryResult = this.query(connection, st);
        if (queryResult != null) {
            try {
                while (queryResult.m_result.next()) {
                    String externalAclID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(1)));
                    if (!externalAclID.startsWith(externalAclIDRoot)) continue;
                    result.add(externalAclID);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    public boolean isAclUpToDate(String externalAclID, long changeLevel) throws AclPersistenceException {
        String mn = "isAclUpToDate(String externalAclID, long changeLevel)";
        if (externalAclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("isAclUpToDate", "externalAclID " + externalAclID + ", changeLevel " + changeLevel);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.isAclUpToDate(String externalAclID, long changeLevel)");
                try {
                    boolean result = this.uncommittedIsAclUpToDate(conn, externalAclID, changeLevel);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean bl = result;
                    Object var11_15 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return bl;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var11_16 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public boolean[] areAclsUpToDate(String[] externalAclIDs, long[] changeLevels) throws AclPersistenceException {
        String mn = "areAclsUpToDate(String[] externalAclIDs, long[] changeLevels)";
        if (externalAclIDs == null || changeLevels == null || externalAclIDs.length != changeLevels.length) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            this.logDebug("areAclsUpToDate", "externalAclIDs-length " + externalAclIDs.length + ", changeLevels-length " + changeLevels.length);
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.areAclsUpToDate(String[] externalAclIDs, long[] changeLevels)");
                try {
                    String[] internalAclIDs = this.uncommittedGetInternalAclIDs(conn, externalAclIDs);
                    boolean[] result = this.uncommittedAreAclsUpToDate(conn, internalAclIDs, changeLevels);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    boolean[] blArray = result;
                    Object var11_16 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return blArray;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var11_17 = null;
                if (conn == null || connReleased) break block13;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    protected String getPoolID() {
        return this.m_poolID;
    }

    private IPrincipal getPrincipal(String id) {
        block4: {
            try {
                if (id.startsWith("ROLE")) {
                    IRoleFactory roleFactory = UMFactory.getRoleFactory();
                    if (roleFactory != null) {
                        AttributeList pa = new AttributeList(false);
                        pa.addAttribute("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                        return ((RoleFactory)roleFactory).getRoleWithoutExistenceCheck(id, pa);
                    }
                    break block4;
                }
                return UMFactory.getPrincipalFactory().getPrincipal(id);
            }
            catch (UMException e) {
                trace.infoT("getPrincipal(String)", "Can't get principal " + id, e);
                return null;
            }
        }
        return null;
    }

    private void checkInsertInitialPermissions(Connection conn) throws AclPersistenceException {
        String mn = "checkInsertInitialPermissions(Connection conn)";
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            if (!this.uncommittedCheckInitialPermissions(conn)) {
                this.uncommittedInsertInitialPermissions(conn);
            }
            if (!this.uncommittedCheckInitialSupportedPermissions(conn)) {
                this.uncommittedInsertInitialSupportedPermissions(conn);
            }
            if (!jtaUsed) {
                conn.commit();
            }
        }
        catch (Exception e) {
            try {
                if (!jtaUsed) {
                    conn.rollback();
                }
            }
            catch (SQLException sqlException) {
                trace.infoT(mn, sqlException);
            }
            AclPersistenceException ape = new AclPersistenceException(e);
            trace.infoT(mn, e);
            throw ape;
        }
    }

    private AclRec uncommittedGetAcl(Connection connection, String externalAclID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedGetAcl(Connection connection, String externalAclID)";
        AclRec result = null;
        String query = "SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(externalAclID, 0), 2)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    String objectType = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_OBJECT_TYPE_COL)));
                    long changeLevel = queryResult.m_result.getLong(ACL_CHANGE_LEVEL_COL);
                    result = new AclRec(externalAclID, objectType, changeLevel);
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private String uncommittedGetInternalAclIDFromEntryID(Connection connection, String entryID) throws SQLException {
        String mn = "uncommittedGetInternalAclIDFromEntryID(Connection connection, String entryID)";
        String result = null;
        String query = "SELECT \"RID\" FROM \"UME_ACL_ACLENTRY\" WHERE \"ID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(1, entryID);
        SqlResult queryResult = this.query(connection, st, 0, null, -1);
        if (queryResult != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private AclRec[] uncommittedGetAcls(Connection connection, String[] internalIDs, String[] externalIDs) throws SQLException {
        String mn = "uncommittedGetAcls(Connection connection, String[] internalIDs, String[] externalIDs)";
        int MAX_ACLS_PER_QUERY = 100;
        if (internalIDs.length == 0) {
            return new AclRec[0];
        }
        AclRec[] result = new AclRec[internalIDs.length];
        int i = 0;
        while (i < internalIDs.length) {
            int takeCount = this.min(internalIDs.length - i, 100);
            String[] internalTakeIDs = new String[takeCount];
            String[] externalTakeIDs = new String[takeCount];
            int k = 0;
            while (k < takeCount) {
                internalTakeIDs[k] = internalIDs[i + k];
                externalTakeIDs[k] = externalIDs[i + k];
                ++k;
            }
            AclRec[] acls = this.uncommittedGetAclsFromDB(connection, internalTakeIDs, externalTakeIDs);
            int k2 = 0;
            while (k2 < takeCount) {
                result[i + k2] = acls[k2];
                ++k2;
            }
            i += 100;
        }
        return result;
    }

    private AclRec[] uncommittedGetAclsFromDB(Connection connection, String[] internalAclIDs, String[] externalAclIDs) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedGetAclsFromDB(Connection connection, String[] internalAclIDs, String[] externalAclIDs)";
        if (internalAclIDs.length == 0) {
            return new AclRec[0];
        }
        StringBuffer query = new StringBuffer(150);
        query.append("SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND (");
        HashMap<String, Integer> idIndices = new HashMap<String, Integer>(internalAclIDs.length);
        int i = 0;
        while (i < internalAclIDs.length) {
            idIndices.put(externalAclIDs[i], new Integer(i));
            if (i > 0) {
                query.append(" OR ( ");
            }
            String s = Escape.escapeSqlString(externalAclIDs[i], 0);
            query.append("\"HASH\"=");
            query.append(s.hashCode());
            query.append(" AND \"RID\"='");
            query.append(s);
            query.append("'");
            if (i > 0) {
                query.append(")");
            }
            ++i;
        }
        query.append(")");
        AclRec[] result = new AclRec[internalAclIDs.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = null;
            ++i2;
        }
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                while (queryResult.m_result.next()) {
                    String aclID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                    String objectType = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_OBJECT_TYPE_COL)));
                    long changeLevel = queryResult.m_result.getLong(ACL_CHANGE_LEVEL_COL);
                    Integer indexObj = (Integer)idIndices.get(aclID);
                    if (indexObj == null) continue;
                    int index = indexObj;
                    result[index] = new AclRec(externalAclIDs[index], objectType, changeLevel);
                }
                Object var18_16 = null;
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedIsAclUpToDate(Connection connection, String internalAclID, long changeLevel) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedIsAclUpToDate(Connection connection, String internalAclID, long changeLevel)";
        boolean result = false;
        String query = "SELECT \"CHANGE_LEVEL\" FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    long dbLevel = queryResult.m_result.getLong(ACL_CHANGE_LEVEL_COL);
                    result = dbLevel == changeLevel;
                }
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean[] uncommittedAreAclsUpToDate(Connection connection, String[] internalIDs, long[] changeLevels) throws SQLException {
        String mn = "uncommittedAreAclsUpToDate(Connection connection, String[] internalIDs, long[] changeLevels)";
        int MAX_ACLS_PER_QUERY = 100;
        if (internalIDs.length == 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[internalIDs.length];
        int i = 0;
        while (i < internalIDs.length) {
            int takeCount = this.min(internalIDs.length - i, 100);
            String[] internalTakeIDs = new String[takeCount];
            long[] changeTakeLevels = new long[takeCount];
            int k = 0;
            while (k < takeCount) {
                internalTakeIDs[k] = internalIDs[i + k];
                changeTakeLevels[k] = changeLevels[i + k];
                ++k;
            }
            boolean[] flags = this.uncommittedAreAclsUpToDateInDB(connection, internalTakeIDs, changeTakeLevels);
            int k2 = 0;
            while (k2 < takeCount) {
                result[i + k2] = flags[k2];
                ++k2;
            }
            i += 100;
        }
        return result;
    }

    private boolean[] uncommittedAreAclsUpToDateInDB(Connection connection, String[] internalAclIDs, long[] changeLevels) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedAreAclsUpToDateInDB(Connection connection, String[] internalAclIDs, long[] changeLevels)";
        if (internalAclIDs.length == 0) {
            return new boolean[0];
        }
        StringBuffer query = new StringBuffer(150);
        query.append("SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND (");
        HashMap<String, Integer> idIndices = new HashMap<String, Integer>(internalAclIDs.length);
        int i = 0;
        while (i < internalAclIDs.length) {
            idIndices.put(internalAclIDs[i], new Integer(i));
            if (i > 0) {
                query.append(" OR (");
            }
            String s = Escape.escapeSqlString(internalAclIDs[i], 0);
            query.append("\"HASH\"=");
            query.append(s.hashCode());
            query.append(" AND \"RID\"='");
            query.append(s);
            query.append("'");
            if (i > 0) {
                query.append(")");
            }
            ++i;
        }
        query.append(")");
        boolean[] result = new boolean[internalAclIDs.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = false;
            ++i2;
        }
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                while (queryResult.m_result.next()) {
                    String aclID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                    long dbLevel = queryResult.m_result.getLong(ACL_CHANGE_LEVEL_COL);
                    Integer indexObj = (Integer)idIndices.get(aclID);
                    if (indexObj == null) continue;
                    int index = indexObj;
                    boolean bl = result[index] = dbLevel == changeLevels[index];
                }
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private void uncommittedIncreaseAclChangeLevel(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedIncreaseAclChangeLevel(Connection connection, String internalAclID)";
        String query = "UPDATE \"UME_ACL_ACL\" SET \"CHANGE_LEVEL\"=\"CHANGE_LEVEL\"+1 WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        String s = Escape.escapeSqlString(internalAclID, 0);
        st.setInt(2, s.hashCode());
        st.setString(3, s);
        this.update(connection, st);
    }

    private boolean uncommittedCheckAcl(Connection connection, String internalAclID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedCheckAcl(Connection connection, String internalAclID)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedSetAclEntrySortIndex(Connection connection, String aclEntryID, int sortIndex) throws SQLException {
        String mn = "uncommittedSetAclEntrySortIndex(Connection connection, String aclEntryID, int sortIndex)";
        String query = "UPDATE \"UME_ACL_ACLENTRY\" SET \"SORT_INDEX\" = ? WHERE \"ID\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setInt(1, sortIndex);
        st.setString(2, aclEntryID);
        return this.update(connection, st, 0, null, -1) > 0;
    }

    private boolean uncommittedSetAclEntryPropagation(Connection connection, String aclEntryID, boolean propagate) throws SQLException {
        String mn = "uncommittedSetAclEntryPropagation(Connection connection, String aclEntryID, boolean propagate)";
        String query = "UPDATE \"UME_ACL_ACLENTRY\" SET \"IS_PROPAGATED\" = ? WHERE \"ID\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setInt(1, propagate ? 1 : 0);
        st.setString(2, aclEntryID);
        return this.update(connection, st, 0, null, -1) > 0;
    }

    private boolean uncommittedCheckAclEntries(Connection connection, String internalAclID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedCheckAclEntries(Connection connection, String internalAclID)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedCheckPermission(Connection connection, String permissionName) throws SQLException {
        String mn = "uncommittedCheckPermission(Connection connection, String permissionName)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = ? AND \"PERMISSION_NAMEH\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(2, Escape.escapeSqlString(permissionName, 127));
        st.setLong(3, Util.getHash(permissionName));
        SqlResult queryResult = this.query(connection, st);
        if (queryResult != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private IAclEntryList uncommittedGetAclEntries(Connection connection, String internalAclID) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        String mn = "uncommittedGetAclEntries(Connection connection, String internalAclID)";
        AclEntryList result = new AclEntryList();
        SqlResult queryResult = this.uncommittedGetAclEntriesFromDB(connection, internalAclID);
        if (queryResult != null) {
            class EntryData {
                public String m_aclEntryID;
                public String m_internalAclID;
                public String m_principalName;
                public int m_principalType;
                public int m_sortIndex;
                public boolean m_negative;
                public boolean m_propagated;
                public String m_permissionName;
                private final /* synthetic */ JDBCDatabaseConnectionUncached this$0;

                EntryData(JDBCDatabaseConnectionUncached this$0) {
                    this.this$0 = this$0;
                }
            }
            ArrayList<EntryData> entryDataList = new ArrayList<EntryData>(50);
            try {
                while (queryResult.m_result.next()) {
                    EntryData entryData = new EntryData(this);
                    entryData.m_aclEntryID = queryResult.m_result.getString("ID");
                    entryData.m_internalAclID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                    entryData.m_principalName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PRINCIPAL_NAME_COL)));
                    entryData.m_principalType = queryResult.m_result.getInt(ACL_PRINCIPAL_TYPE_COL);
                    entryData.m_sortIndex = queryResult.m_result.getInt(ACL_SORT_INDEX_COL);
                    entryData.m_negative = queryResult.m_result.getInt(ACL_IS_NEGATIVE_COL) != 0;
                    entryData.m_propagated = queryResult.m_result.getInt(ACL_IS_PROPAGATED_COL) != 0;
                    entryData.m_permissionName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_NAME_COL)));
                    entryDataList.add(entryData);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            Iterator iterator = entryDataList.iterator();
            while (iterator.hasNext()) {
                EntryData entryData = (EntryData)iterator.next();
                try {
                    IPrincipal newPrincipal = this.getPrincipal(entryData.m_principalName);
                    if (newPrincipal == null) continue;
                    IAclPermission permission = this.uncommittedGetPermission(connection, entryData.m_permissionName);
                    JDBCAclEntry entry = new JDBCAclEntry(this, newPrincipal, entryData.m_negative, permission, entryData.m_sortIndex, entryData.m_propagated);
                    entry.setIDs(entryData.m_aclEntryID, entryData.m_internalAclID);
                    result.add(entry);
                }
                catch (InvalidClassException e) {
                    trace.infoT(mn, (Throwable)((Object)e));
                }
            }
        }
        return result;
    }

    private IAclEntryList[] uncommittedGetAclEntries(Connection connection, AclRec[] acls) throws SQLException {
        class EntryData {
            public String m_aclEntryID;
            public String m_internalAclID;
            public String m_principalName;
            public int m_principalType;
            public int m_sortIndex;
            public boolean m_negative;
            public boolean m_propagated;
            public String m_permissionName;
            private final /* synthetic */ JDBCDatabaseConnectionUncached this$0;

            EntryData(JDBCDatabaseConnectionUncached this$0) {
                this.this$0 = this$0;
            }
        }
        EntryData entryData;
        String mn = "uncommittedGetAclEntries(Connection connection, AclRec[] acls)";
        int MAX_IDS_PER_QUERY = 100;
        if (acls.length == 0) {
            return new IAclEntryList[0];
        }
        HashMap entriesTable = new HashMap(acls.length);
        int i = 0;
        while (i < acls.length) {
            if (acls[i] != null) {
                entriesTable.put(acls[i].getExternalAclID(), new LinkedList());
            }
            ++i;
        }
        String[] consolidatedIDs = new String[entriesTable.size()];
        Iterator entriesTableIterator = entriesTable.keySet().iterator();
        int consolidatedIdx = 0;
        while (entriesTableIterator.hasNext()) {
            consolidatedIDs[consolidatedIdx++] = (String)entriesTableIterator.next();
        }
        int i2 = 0;
        while (i2 < consolidatedIDs.length) {
            int takeCount = this.min(consolidatedIDs.length - i2, 100);
            String[] internalTakeIDs = new String[takeCount];
            int k = 0;
            while (k < takeCount) {
                internalTakeIDs[k] = consolidatedIDs[i2 + k];
                ++k;
            }
            SqlResult queryResult = this.uncommittedGetAclEntriesFromDB(connection, internalTakeIDs);
            if (queryResult != null) {
                Object var18_22;
                try {
                    while (queryResult.m_result.next()) {
                        entryData = new EntryData(this);
                        entryData.m_aclEntryID = queryResult.m_result.getString("ID");
                        entryData.m_internalAclID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                        entryData.m_principalName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PRINCIPAL_NAME_COL)));
                        entryData.m_principalType = queryResult.m_result.getInt(ACL_PRINCIPAL_TYPE_COL);
                        entryData.m_sortIndex = queryResult.m_result.getInt(ACL_SORT_INDEX_COL);
                        entryData.m_negative = queryResult.m_result.getInt(ACL_IS_NEGATIVE_COL) != 0;
                        entryData.m_propagated = queryResult.m_result.getInt(ACL_IS_PROPAGATED_COL) != 0;
                        entryData.m_permissionName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_NAME_COL)));
                        LinkedList entries = (LinkedList)entriesTable.get(entryData.m_internalAclID);
                        if (entries == null) continue;
                        entries.add(entryData);
                    }
                    var18_22 = null;
                }
                catch (Throwable throwable) {
                    var18_22 = null;
                    queryResult.close();
                    throw throwable;
                }
                queryResult.close();
                {
                }
            }
            i2 += 100;
        }
        IAclEntryList[] result = new AclEntryList[acls.length];
        int i3 = 0;
        while (i3 < acls.length) {
            if (acls[i3] != null) {
                result[i3] = new AclEntryList();
                LinkedList entries = (LinkedList)entriesTable.get(acls[i3].getExternalAclID());
                Iterator entriesIterator = entries.iterator();
                while (entriesIterator.hasNext()) {
                    entryData = (EntryData)entriesIterator.next();
                    try {
                        IPrincipal principal = this.getPrincipal(entryData.m_principalName);
                        if (principal == null) continue;
                        IAclPermission permission = this.uncommittedGetPermission(connection, entryData.m_permissionName);
                        JDBCAclEntry aclEntry = new JDBCAclEntry(this, principal, entryData.m_negative, permission, entryData.m_sortIndex, entryData.m_propagated);
                        aclEntry.setIDs(entryData.m_aclEntryID, entryData.m_internalAclID);
                        ((AclEntryList)result[i3]).add(aclEntry);
                    }
                    catch (InvalidClassException e) {
                        trace.infoT(mn, (Throwable)((Object)e));
                    }
                }
            } else {
                result[i3] = null;
            }
            ++i3;
        }
        return result;
    }

    private SqlResult uncommittedGetAclEntriesFromDB(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedGetAclEntriesFromDB(Connection connection, String internalAclID)";
        String query = "SELECT * FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=? ORDER BY \"SORT_INDEX\"";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        return this.query(connection, st, 1, Escape.escapeSqlString(internalAclID, 0), 2);
    }

    private SqlResult uncommittedGetAclEntriesFromDB(Connection connection, String[] internalAclIDs) throws SQLException {
        String mn = "uncommittedGetAclEntriesFromDB(Connection connection, String[] internalAclIDs)";
        if (internalAclIDs.length == 0) {
            return null;
        }
        StringBuffer query = new StringBuffer(180);
        query.append("SELECT * FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND (");
        int i = 0;
        while (i < internalAclIDs.length) {
            if (i > 0) {
                query.append(" OR (");
            }
            String s = Escape.escapeSqlString(internalAclIDs[i], 0);
            query.append("\"HASH\"=");
            query.append(s.hashCode());
            query.append(" AND \"RID\" = '");
            query.append(s);
            query.append("'");
            if (i > 0) {
                query.append(")");
            }
            ++i;
        }
        query.append(")  ORDER BY \"SORT_INDEX\"");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.query(connection, query.toString());
    }

    private List uncommittedGetAffectedAclIDs(Connection connection, String permissionName) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedGetAffectedAclIDs(Connection connection, String permissionName)";
        LinkedList<String> result = new LinkedList<String>();
        StringBuffer query = new StringBuffer(130);
        query.append("SELECT DISTINCT \"RID\" FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                while (queryResult.m_result.next()) {
                    result.add(this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL))));
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedAddAcl(Connection connection, String internalAclID, IObjectType objectType) throws SQLException {
        String mn = "uncommittedAddAcl(Connection connection, String internalAclID, IObjectType objectType)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        String t = s;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        StringBuffer query = new StringBuffer(300);
        query.append("INSERT INTO \"UME_ACL_ACL\" ( \"OWNERID\", \"HASH\", \"RID\", \"RIDSTART\", \"RIDSTARTH\", \"OBJECT_TYPE\", \"LOCKING_USER\", \"CHANGE_LEVEL\" ) VALUES (?,");
        query.append(s.hashCode());
        query.append(",'");
        query.append(s);
        query.append("','");
        query.append(t);
        query.append("',");
        query.append(Util.getHash(t));
        query.append(",'");
        query.append(Escape.escapeSqlString(objectType.getName(), 127));
        query.append("','" + null + "',0)");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String uncommittedAddAclEntry(Connection connection, String internalAclID, JDBCAclEntry aclEntry) throws SQLException {
        String mn = "uncommittedAddAclEntry(Connection connection, String internalAclID, JDBCAclEntry aclEntry)";
        String ret = null;
        IPrincipal principal = aclEntry.getPrincipal();
        if (principal == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        JDBCPermission permission = (JDBCPermission)aclEntry.getPermission();
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        String s = Escape.escapeSqlString(internalAclID, 0);
        String t = s;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        Statement st = null;
        try {
            try {
                String acePK = UUID.createUUID().toString();
                String query = "INSERT INTO \"UME_ACL_ACLENTRY\" ( \"ID\", \"OWNERID\", \"HASH\", \"RID\", \"RIDSTART\", \"PRINCIPAL_NAME\", \"PRINCIPAL_TYPE\", \"SORT_INDEX\", \"IS_NEGATIVE\", \"IS_PROPAGATED\", \"PERMISSION_NAME\", \"RIDSTARTH\" ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
                if (trace.beInfo()) {
                    trace.infoT(mn, query);
                }
                st = connection.prepareStatement(query);
                st.setString(1, acePK);
                st.setInt(2, this.m_owner);
                st.setInt(3, s.hashCode());
                st.setString(4, s);
                st.setString(5, t);
                st.setString(6, Escape.escapeSqlString(principal.getUniqueID(), 255));
                st.setInt(7, -1);
                st.setInt(8, aclEntry.getSortIndex());
                if (aclEntry.isNegative()) {
                    st.setInt(9, 1);
                } else {
                    st.setInt(9, 0);
                }
                if (aclEntry.isPropagated()) {
                    st.setInt(10, 1);
                } else {
                    st.setInt(10, 0);
                }
                st.setString(11, Escape.escapeSqlString(permission.getName(), 127));
                st.setLong(12, Util.getHash(t));
                st.executeUpdate();
                ret = acePK;
                st.close();
                return ret;
            }
            catch (AclPersistenceException e) {
                trace.infoT(mn, (Throwable)((Object)e));
                Object var14_17 = null;
                if (st == null) return ret;
                st.close();
                return ret;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (st == null) throw throwable;
            st.close();
            throw throwable;
        }
    }

    private boolean uncommittedRemoveAclEntry(Connection connection, String aclEntryID) throws SQLException {
        String mn = "uncommittedRemoveAclEntry(Connection connection, String aclEntryID)";
        StringBuffer query = new StringBuffer(100);
        query.append("DELETE FROM \"UME_ACL_ACLENTRY\" WHERE \"ID\" = '");
        query.append(aclEntryID);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString(), 0) > 0;
    }

    private boolean uncommittedIsOwner(Connection connection, String internalAclID, IPrincipal owner) throws SQLException {
        String mn = "uncommittedIsOwner(Connection connection, String internalAclID, IPrincipal owner)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=? AND \"PRINCIPAL_NAME\"=? AND \"PRINCIPAL_TYPE\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(4, Escape.escapeSqlString(owner.getUniqueID(), 255));
        st.setInt(5, -1);
        SqlResult queryResult = this.query(connection, st, 1, Escape.escapeSqlString(internalAclID, 0), 2);
        if (queryResult != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedIsLastOwner(Connection connection, String internalAclID, IPrincipal owner) throws SQLException {
        return this.uncommittedIsLastOwner(connection, internalAclID, owner.getUniqueID());
    }

    private boolean uncommittedIsLastOwner(Connection connection, String internalAclID, String ownerID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedIsLastOwner(Connection connection, String internalAclID, String ownerID)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                String name;
                if (queryResult.m_result.next() && ownerID.equals(name = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PRINCIPAL_NAME_COL)))) && !queryResult.m_result.next()) {
                    result = true;
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private IPrincipalList uncommittedGetOwners(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedGetOwners(Connection connection, String internalAclID)";
        PrincipalList result = new PrincipalList();
        SqlResult queryResult = this.uncommittedGetOwnersFromDB(connection, internalAclID);
        if (queryResult != null) {
            try {
                while (queryResult.m_result.next()) {
                    String principalName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PRINCIPAL_NAME_COL)));
                    IPrincipal owner = this.getPrincipal(principalName);
                    if (owner == null) continue;
                    result.add(owner);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private IPrincipalList[] uncommittedGetOwners(Connection connection, AclRec[] acls) throws SQLException {
        String mn = "uncommittedGetOwners(Connection connection, AclRec[] acls)";
        int MAX_IDS_PER_QUERY = 100;
        if (acls.length == 0) {
            return new IPrincipalList[0];
        }
        HashMap<String, PrincipalList> ownerTable = new HashMap<String, PrincipalList>(acls.length);
        int i = 0;
        while (i < acls.length) {
            if (acls[i] != null) {
                ownerTable.put(acls[i].getExternalAclID(), new PrincipalList());
            }
            ++i;
        }
        String[] consolidatedIDs = new String[ownerTable.size()];
        Iterator ownerTableIterator = ownerTable.keySet().iterator();
        int consolidatedIdx = 0;
        while (ownerTableIterator.hasNext()) {
            consolidatedIDs[consolidatedIdx++] = (String)ownerTableIterator.next();
        }
        int i2 = 0;
        while (i2 < consolidatedIDs.length) {
            int takeCount = this.min(consolidatedIDs.length - i2, 100);
            String[] internalTakeIDs = new String[takeCount];
            int k = 0;
            while (k < takeCount) {
                internalTakeIDs[k] = consolidatedIDs[i2 + k];
                ++k;
            }
            SqlResult queryResult = this.uncommittedGetOwnersFromDB(connection, internalTakeIDs);
            if (queryResult != null) {
                Object var20_21;
                try {
                    while (queryResult.m_result.next()) {
                        PrincipalList owners;
                        String id = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                        String principalName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PRINCIPAL_NAME_COL)));
                        IPrincipal owner = this.getPrincipal(principalName);
                        if (owner == null || (owners = (PrincipalList)ownerTable.get(id)) == null) continue;
                        owners.add(owner);
                    }
                    var20_21 = null;
                }
                catch (Throwable throwable) {
                    var20_21 = null;
                    queryResult.close();
                    throw throwable;
                }
                queryResult.close();
                {
                }
            }
            i2 += 100;
        }
        IPrincipalList[] result = new IPrincipalList[acls.length];
        int i3 = 0;
        while (i3 < acls.length) {
            result[i3] = acls[i3] != null ? (IPrincipalList)ownerTable.get(acls[i3].getExternalAclID()) : null;
            ++i3;
        }
        return result;
    }

    private boolean uncommittedCheckOwners(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedCheckOwners(Connection connection, String internalAclID)";
        boolean result = false;
        SqlResult queryResult = this.uncommittedGetOwnersFromDB(connection, internalAclID);
        if (queryResult != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private SqlResult uncommittedGetOwnersFromDB(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedGetOwnersFromDB(Connection connection, String internalAclID)";
        String query = "SELECT * FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        return this.query(connection, st, 1, Escape.escapeSqlString(internalAclID, 0), 2);
    }

    private SqlResult uncommittedGetOwnersFromDB(Connection connection, String[] internalAclIDs) throws SQLException {
        String mn = "uncommittedGetOwnersFromDB(Connection connection, String[] internalAclIDs)";
        if (internalAclIDs.length == 0) {
            return null;
        }
        StringBuffer query = new StringBuffer(150);
        query.append("SELECT * FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND (");
        int i = 0;
        while (i < internalAclIDs.length) {
            if (i > 0) {
                query.append(" OR (");
            }
            String s = Escape.escapeSqlString(internalAclIDs[i], 0);
            query.append("\"HASH\"=");
            query.append(s.hashCode());
            query.append(" AND \"RID\" = '");
            query.append(s);
            query.append("'");
            if (i > 0) {
                query.append(")");
            }
            ++i;
        }
        query.append(")");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.query(connection, query.toString());
    }

    private boolean uncommittedAddOwner(Connection connection, String internalAclID, IPrincipal owner) throws SQLException {
        String mn = "uncommittedAddOwner(Connection connection, String internalAclID, IPrincipal owner)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        String t = s;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        StringBuffer query = new StringBuffer(280);
        query.append("INSERT INTO \"UME_ACL_OWNER\" ( \"OWNERID\", \"HASH\", \"RID\", \"RIDSTART\", \"RIDSTARTH\", \"PRINCIPAL_NAME\", \"PRINCIPAL_TYPE\" ) VALUES (?,");
        query.append(s.hashCode());
        query.append(",'");
        query.append(s);
        query.append("','");
        query.append(t);
        query.append("',");
        query.append(Util.getHash(t));
        query.append(",'");
        query.append(Escape.escapeSqlString(owner.getUniqueID(), 255));
        query.append("',-1)");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemoveOwner(Connection connection, String internalAclID, IPrincipal owner) throws SQLException {
        return this.uncommittedRemoveOwner(connection, internalAclID, owner.getUniqueID());
    }

    private boolean uncommittedRemoveOwner(Connection connection, String internalAclID, String ownerID) throws SQLException {
        String mn = "uncommittedRemoveOwner(Connection connection, String internalAclID, String ownerID)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        StringBuffer query = new StringBuffer(150);
        query.append("DELETE FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(s.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(s);
        query.append("' AND \"PRINCIPAL_NAME\" = '");
        query.append(Escape.escapeSqlString(ownerID, 255));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemoveOwnerGlobal(Connection connection, String ownerID) throws SQLException {
        String mn = "uncommittedRemoveOwnerGlobal(Connection connection, String ownerID, int ownerType)";
        StringBuffer query = new StringBuffer(70);
        query.append("DELETE FROM \"UME_ACL_OWNER\" WHERE \"PRINCIPAL_NAME\" = '");
        query.append(Escape.escapeSqlString(ownerID, 255));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString(), 0) > 0;
    }

    private IAclPermissionList uncommittedGetPermissionMembers(Connection connection, String permissionName) throws SQLException {
        String mn = "uncommittedGetPermissionMembers(Connection connection, String permissionName)";
        if (permissionName.equals("fullcontrol")) {
            return this.uncommittedGetAllPermissionsNotFullControl(connection);
        }
        AclPermissionList result = new AclPermissionList();
        String query = "SELECT * FROM \"UME_ACL_PERM_MEM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(2, Escape.escapeSqlString(permissionName, 127));
        SqlResult queryResult = this.query(connection, st);
        if (queryResult != null) {
            LinkedList<String> members = new LinkedList<String>();
            try {
                while (queryResult.m_result.next()) {
                    members.add(this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_MEMBER_COL))));
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                String memberName = (String)iterator.next();
                IAclPermission permission = this.uncommittedGetPermission(connection, memberName);
                if (permission == null) continue;
                result.add(permission);
            }
        }
        return result;
    }

    private IAclPermissionList uncommittedGetAllPermissionsNotFullControl(Connection connection) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedGetAllPermissionsNotFullControl(Connection connection)";
        AclPermissionList result = new AclPermissionList();
        String query = "SELECT * FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query))) != null) {
            class PermissionRec {
                public String m_name;
                public boolean m_predefined;
                private final /* synthetic */ JDBCDatabaseConnectionUncached this$0;

                PermissionRec(JDBCDatabaseConnectionUncached this$0) {
                    this.this$0 = this$0;
                }
            }
            LinkedList<PermissionRec> foundPermissions = new LinkedList<PermissionRec>();
            try {
                while (queryResult.m_result.next()) {
                    boolean predefined;
                    String name = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_NAME_COL)));
                    boolean bl = predefined = queryResult.m_result.getInt(ACL_IS_PREDEFINED_COL) != 0;
                    if ("fullcontrol".equals(name)) continue;
                    PermissionRec rec = new PermissionRec(this);
                    rec.m_name = name;
                    rec.m_predefined = predefined;
                    foundPermissions.add(rec);
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            Iterator iterator = foundPermissions.iterator();
            while (iterator.hasNext()) {
                PermissionRec rec = (PermissionRec)iterator.next();
                IAclPermissionList members = this.uncommittedGetPermissionMembers(connection, rec.m_name);
                result.add(new JDBCPermission(this, rec.m_name, rec.m_predefined, members));
            }
        }
        return result;
    }

    private void uncommittedRemoveOwners(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedRemoveOwners(Connection connection, String internalAclID)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        StringBuffer query = new StringBuffer(140);
        query.append("DELETE FROM \"UME_ACL_OWNER\" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(s.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(s);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        this.update(connection, query.toString());
    }

    private void uncommittedRemoveAclEntries(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedRemoveAclEntries(Connection connection, String internalAclID)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        StringBuffer query = new StringBuffer(140);
        query.append("DELETE FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(s.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(s);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        this.update(connection, query.toString());
    }

    private void uncommittedRemoveAclEntriesGlobal(Connection connection, String principalID) throws SQLException {
        String mn = "uncommittedRemoveAclEntriesGlobal(Connection connection, String principalID, int principalType)";
        StringBuffer query = new StringBuffer(140);
        query.append("DELETE FROM \"UME_ACL_ACLENTRY\" WHERE \"PRINCIPAL_NAME\" = '");
        query.append(Escape.escapeSqlString(principalID, 255));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        this.update(connection, query.toString(), 0);
    }

    private void uncommittedInsertInitialPermissions(Connection connection) throws SQLException {
        String mn = "uncommittedInsertInitialPermissions(Connection connection)";
        this.uncommittedAddPermission(connection, "fullcontrol", true);
    }

    private void uncommittedInsertInitialSupportedPermissions(Connection connection) throws SQLException {
        String mn = "uncommittedInsertInitialSupportedPermissions(Connection connection)";
        this.uncommittedAddSupportedPermission(connection, "fullcontrol", "leaf");
        this.uncommittedAddSupportedPermission(connection, "fullcontrol", "node");
    }

    private boolean uncommittedCheckInitialPermissions(Connection connection) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedCheckInitialPermissions(Connection connection)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, query)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedCheckInitialSupportedPermissions(Connection connection) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedCheckInitialSupportedPermissions(Connection connection)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_SUP_PERM\" WHERE \"OWNERID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, query)) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedIsSupportedPermission(Connection connection, String permissionName, String objectTypeName) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedIsSupportedPermission(Connection connection, String permissionName, String objectTypeName)";
        boolean result = false;
        StringBuffer query = new StringBuffer(220);
        query.append("SELECT * FROM \"UME_ACL_SUP_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("' AND \"OBJECT_TYPE\" = '");
        query.append(Escape.escapeSqlString(objectTypeName, 127));
        query.append("' AND \"PERMISSION_NAMEH\" = ");
        query.append(Util.getHash(permissionName));
        query.append(" AND \"OBJECT_TYPEH\" = ");
        query.append(Util.getHash(objectTypeName));
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private IAclPermissionList uncommittedGetSupportedPermissions(Connection connection, String objectTypeName) throws SQLException {
        String mn = "uncommittedGetSupportedPermissions(Connection connection, String objectTypeName)";
        AclPermissionList result = new AclPermissionList();
        String query = "SELECT * FROM \"UME_ACL_SUP_PERM\" WHERE \"OWNERID\"=? AND \"OBJECT_TYPE\" = ? AND \"OBJECT_TYPEH\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(2, Escape.escapeSqlString(objectTypeName, 127));
        st.setLong(3, Util.getHash(objectTypeName));
        SqlResult queryResult = this.query(connection, st);
        if (queryResult != null) {
            class PermissionData {
                public String m_name;
                private final /* synthetic */ JDBCDatabaseConnectionUncached this$0;

                PermissionData(JDBCDatabaseConnectionUncached this$0) {
                    this.this$0 = this$0;
                }
            }
            PermissionData permissionData;
            LinkedList<PermissionData> permissionDataList = new LinkedList<PermissionData>();
            try {
                while (queryResult.m_result.next()) {
                    String permissionName = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_NAME_COL)));
                    permissionData = new PermissionData(this);
                    permissionData.m_name = permissionName;
                    permissionDataList.add(permissionData);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            Iterator iterator = permissionDataList.iterator();
            while (iterator.hasNext()) {
                permissionData = (PermissionData)iterator.next();
                IAclPermission permission = this.uncommittedGetPermission(connection, permissionData.m_name);
                if (permission == null) continue;
                result.add(permission);
            }
        }
        if (result != null) {
            this.cacheAddSupportedPermissions(objectTypeName, result);
        }
        return result;
    }

    private IAclPermission uncommittedGetPermission(Connection connection, String permissionName) throws SQLException {
        String mn = "uncommittedGetPermission(Connection connection, String permissionName)";
        IAclPermission permission = this.cacheGetPermission(permissionName);
        if (permission != null) {
            return permission;
        }
        JDBCPermission result = null;
        String query = "SELECT * FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = ? AND \"PERMISSION_NAMEH\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(2, Escape.escapeSqlString(permissionName, 127));
        st.setLong(3, Util.getHash(permissionName));
        String name = null;
        boolean predefined = false;
        SqlResult queryResult = this.query(connection, st);
        if (queryResult != null) {
            try {
                if (queryResult.m_result.next()) {
                    name = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_PERMISSION_NAME_COL)));
                    predefined = queryResult.m_result.getInt(ACL_IS_PREDEFINED_COL) != 0;
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        if (name != null) {
            IAclPermissionList members = this.uncommittedGetPermissionMembers(connection, name);
            result = new JDBCPermission(this, name, predefined, members);
            this.cacheAddPermission(result);
        }
        return result;
    }

    private boolean uncommittedIsUsedPermission(Connection connection, String permissionName) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedIsUsedPermission(Connection connection, String permissionName)";
        boolean result = false;
        StringBuffer query = new StringBuffer(110);
        query.append("SELECT * FROM \"UME_ACL_ACLENTRY\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                if (queryResult.m_result.next()) {
                    result = true;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private boolean uncommittedAddPermission(Connection connection, String permissionName, boolean isPredefined) throws SQLException {
        String mn = "uncommittedAddPermission(Connection connection, String permissionName, boolean isPredefined)";
        StringBuffer query = new StringBuffer(170);
        query.append("INSERT INTO \"UME_ACL_PERM\" (\"OWNERID\", \"PERMISSION_NAME\", \"IS_PREDEFINED\", \"PERMISSION_NAMEH\" ) VALUES (?,'");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("',");
        query.append(isPredefined ? "1" : "0");
        query.append(",");
        query.append(Util.getHash(permissionName));
        query.append(")");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemovePermission(Connection connection, String permissionName) throws SQLException {
        String mn = "uncommittedRemovePermission(Connection connection, String permissionName)";
        this.cacheRemovePermission(permissionName);
        StringBuffer query = new StringBuffer(120);
        query.append("DELETE FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("' AND \"PERMISSION_NAMEH\" = ");
        query.append(Util.getHash(permissionName));
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedAddSupportedPermission(Connection connection, String permissionName, String objectTypeName) throws SQLException {
        String mn = "uncommittedAddSupportedPermission(Connection connection, String permissionName, String objectTypeName)";
        StringBuffer query = new StringBuffer(200);
        query.append("INSERT INTO \"UME_ACL_SUP_PERM\" (\"OWNERID\", \"PERMISSION_NAME\", \"OBJECT_TYPE\", \"PERMISSION_NAMEH\", \"OBJECT_TYPEH\" ) VALUES (?,'");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("','");
        query.append(Escape.escapeSqlString(objectTypeName, 127));
        query.append("',");
        query.append(Util.getHash(permissionName));
        query.append(",");
        query.append(Util.getHash(objectTypeName));
        query.append(")");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemoveSupportedPermission(Connection connection, String permissionName, String objectTypeName) throws SQLException {
        String mn = "uncommittedRemoveSupportedPermission(Connection connection, String permissionName, String objectTypeName)";
        StringBuffer query = new StringBuffer(220);
        query.append("DELETE FROM \"UME_ACL_SUP_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("' AND \"OBJECT_TYPE\" = '");
        query.append(Escape.escapeSqlString(objectTypeName, 127));
        query.append("' AND \"PERMISSION_NAMEH\" = ");
        query.append(Util.getHash(permissionName));
        query.append(" AND \"OBJECT_TYPEH\" = ");
        query.append(Util.getHash(objectTypeName));
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedAddPermissionMember(Connection connection, String permissionName, String memberName) throws SQLException {
        String mn = "uncommittedAddPermissionMember(Connection connection, String permissionName, String memberName)";
        StringBuffer query = new StringBuffer(140);
        query.append("INSERT INTO \"UME_ACL_PERM_MEM\" (\"OWNERID\", \"PERMISSION_NAME\", \"MEMBER_NAME\") VALUES (?,'");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("','");
        query.append(Escape.escapeSqlString(memberName, 127));
        query.append("')");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemovePermissionMember(Connection connection, String permissionName, String memberName) throws SQLException {
        String mn = "uncommittedRemovePermissionMember(Connection connection, String permissionName, String memberName)";
        StringBuffer query = new StringBuffer(150);
        query.append("DELETE FROM \"UME_ACL_PERM_MEM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("' AND \"MEMBER_NAME\" = '");
        query.append(Escape.escapeSqlString(memberName, 127));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedRemovePermissionMembers(Connection connection, String permissionName) throws SQLException {
        String mn = "uncommittedRemovePermissionMembers(Connection connection, String permissionName)";
        StringBuffer query = new StringBuffer(100);
        query.append("DELETE FROM \"UME_ACL_PERM_MEM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(permissionName, 127));
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedIsPredefinedPermission(Connection connection, String name) throws SQLException {
        SqlResult queryResult;
        String mn = "uncommittedIsPredefinedPermission(Connection connection, String name)";
        boolean result = false;
        StringBuffer query = new StringBuffer(140);
        query.append("SELECT * FROM \"UME_ACL_PERM\" WHERE \"OWNERID\"=? AND \"PERMISSION_NAME\" = '");
        query.append(Escape.escapeSqlString(name, 127));
        query.append("' AND \"PERMISSION_NAMEH\" = ");
        query.append(Util.getHash(name));
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        if ((queryResult = this.query(connection, query.toString())) != null) {
            try {
                if (queryResult.m_result.next() && queryResult.m_result.getInt(ACL_IS_PREDEFINED_COL) != 0) {
                    result = true;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private void uncommittedRemoveAcl(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedRemoveAcl(Connection connection, String internalAclID)";
        String s = Escape.escapeSqlString(internalAclID, 0);
        StringBuffer query = new StringBuffer(140);
        query.append("DELETE FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(s.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(s);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        this.update(connection, query.toString());
    }

    private boolean uncommittedLockAcl(Connection connection, String internalAclID, IPrincipal lockingUser) throws SQLException {
        String mn = "uncommittedLockAcl(Connection connection, String internalAclID, IPrincipal lockingUser)";
        String query = "UPDATE \"UME_ACL_ACL\" SET \"LOCKING_USER\" = ? WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(1, Escape.escapeSqlString(lockingUser.getUniqueID(), 255));
        return this.update(connection, st, 2, Escape.escapeSqlString(internalAclID, 0), 3) > 0;
    }

    private boolean uncommittedUnlockAcl(Connection connection, String internalAclID) throws SQLException {
        String mn = "uncommittedUnlockAcl(Connection connection, String internalAclID)";
        String query = "UPDATE \"UME_ACL_ACL\" SET \"LOCKING_USER\" = ?  WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        PreparedStatement st = connection.prepareStatement(query);
        st.setString(1, "");
        return this.update(connection, st, 2, Escape.escapeSqlString(internalAclID, 0), 3) > 0;
    }

    private boolean uncommittedIsAclLocked(Connection connection, String internalAclID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedIsAclLocked(Connection connection, String internalAclID)";
        boolean result = false;
        String query = "SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\"=?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                String userID;
                if (queryResult.m_result.next() && (userID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_LOCKING_USER_COL)))) != null) {
                    result = userID.length() > 0;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private IUser uncommittedGetAclLockingUser(Connection connection, String internalAclID) throws SQLException {
        PreparedStatement st;
        SqlResult queryResult;
        String mn = "uncommittedGetAclLockingUser(Connection connection, String internalAclID)";
        IUser result = null;
        String query = "SELECT * FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"HASH\"=? AND \"RID\" = ?";
        if (trace.beInfo()) {
            trace.infoT(mn, query);
        }
        if ((queryResult = this.query(connection, st = connection.prepareStatement(query), 1, Escape.escapeSqlString(internalAclID, 0), 2)) != null) {
            try {
                String userID;
                if (queryResult.m_result.next() && (userID = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_LOCKING_USER_COL)))) != null && userID.length() > 0) {
                    result = (IUser)this.getPrincipal(userID);
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private String[] uncommittedGetInternalAclIDs(Connection connection, String[] externalAclIDs) throws SQLException {
        String mn = "uncommittedGetInternalAclIDs(Connection connection, String[] externalAclIDs)";
        if (externalAclIDs == null) {
            throw new IllegalArgumentException();
        }
        if (externalAclIDs.length == 0) {
            return new String[0];
        }
        String[] result = new String[externalAclIDs.length];
        int i = 0;
        while (i < externalAclIDs.length) {
            result[i] = Escape.escapeSqlString(externalAclIDs[i], 0);
            ++i;
        }
        return result;
    }

    private boolean uncommittedChangeAclID_in_AclTable(Connection connection, String oldID, String newID) throws SQLException {
        String mn = "uncommittedChangeAclID_in_AclTable(Connection connection, String oldID, String newID)";
        String o = Escape.escapeSqlString(oldID, 0);
        String n = Escape.escapeSqlString(newID, 0);
        String t = n;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        StringBuffer query = new StringBuffer(320);
        query.append("UPDATE \"UME_ACL_ACL\" SET \"HASH\"=");
        query.append(n.hashCode());
        query.append(", \"RID\" = '");
        query.append(n);
        query.append("', \"RIDSTART\"='");
        query.append(t);
        query.append("', \"RIDSTARTH\"=");
        query.append(Util.getHash(t));
        query.append(" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(o.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(o);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedChangeAclID_in_AclEntryTable(Connection connection, String oldID, String newID) throws SQLException {
        String mn = "uncommittedChangeAclID_in_AclEntryTable(Connection connection, String oldID, String newID)";
        String o = Escape.escapeSqlString(oldID, 0);
        String n = Escape.escapeSqlString(newID, 0);
        String t = n;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        StringBuffer query = new StringBuffer(320);
        query.append("UPDATE \"UME_ACL_ACLENTRY\" SET \"HASH\"=");
        query.append(n.hashCode());
        query.append(", \"RID\" = '");
        query.append(n);
        query.append("', \"RIDSTART\"='");
        query.append(t);
        query.append("', \"RIDSTARTH\"=");
        query.append(Util.getHash(t));
        query.append(" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(o.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(o);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private boolean uncommittedChangeAclID_in_OwnerTable(Connection connection, String oldID, String newID) throws SQLException {
        String mn = "uncommittedChangeAclID_in_OwnerTable(Connection connection, String oldID, String newID)";
        String o = Escape.escapeSqlString(oldID, 0);
        String n = Escape.escapeSqlString(newID, 0);
        String t = n;
        if (t.length() > 255) {
            t = t.substring(0, 255);
        }
        StringBuffer query = new StringBuffer(320);
        query.append("UPDATE \"UME_ACL_OWNER\" SET \"HASH\"=");
        query.append(n.hashCode());
        query.append(", \"RID\" = '");
        query.append(n);
        query.append("', \"RIDSTART\"='");
        query.append(t);
        query.append("', \"RIDSTARTH\"=");
        query.append(Util.getHash(t));
        query.append(" WHERE \"OWNERID\"=? AND \"HASH\"=");
        query.append(o.hashCode());
        query.append(" AND \"RID\" = '");
        query.append(o);
        query.append("'");
        if (trace.beInfo()) {
            trace.infoT(mn, query.toString());
        }
        return this.update(connection, query.toString()) > 0;
    }

    private int update(Connection connection, String sql) throws SQLException {
        return this.update(connection, sql, 1);
    }

    private int update(Connection connection, String sql, int owner) throws SQLException {
        String mn = "update(Connection connection, String sql, int owner)";
        int result = 0;
        PreparedStatement statement = connection.prepareStatement(sql);
        if (statement != null) {
            try {
                if (owner > 0) {
                    statement.setInt(owner, this.m_owner);
                }
                result = statement.executeUpdate();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                statement.close();
                throw throwable;
            }
            statement.close();
            {
            }
        }
        return result;
    }

    private int update(Connection connection, PreparedStatement st) throws SQLException {
        return this.update(connection, st, 1, null, -1);
    }

    private int update(Connection connection, PreparedStatement st, int owner, String rid, int ridIndex) throws SQLException {
        String mn = "update(Connection connection, PreparedStatement st, int owner, String rid, int ridIndex)";
        int result = 0;
        if (st != null) {
            try {
                if (owner > 0) {
                    st.setInt(owner, this.m_owner);
                }
                if (rid != null) {
                    st.setInt(ridIndex, rid.hashCode());
                    st.setString(ridIndex + 1, rid);
                }
                result = st.executeUpdate();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                st.close();
                throw throwable;
            }
            st.close();
            {
            }
        }
        return result;
    }

    private SqlResult query(Connection connection, String sql) throws SQLException {
        return this.query(connection, sql, 1);
    }

    private SqlResult query(Connection connection, String sql, int owner) throws SQLException {
        String mn = "query(Connection connection, String sql, int owner)";
        SqlResult result = new SqlResult();
        PreparedStatement st = null;
        try {
            st = connection.prepareStatement(sql);
            if (owner > 0) {
                st.setInt(owner, this.m_owner);
            }
            result.m_statement = st;
            result.m_result = st.executeQuery();
        }
        catch (SQLException e) {
            try {
                if (result.m_result != null) {
                    result.m_result.close();
                }
            }
            catch (SQLException sqlex) {
                trace.infoT(mn, sqlex);
            }
            try {
                if (result.m_statement != null) {
                    result.m_statement.close();
                }
            }
            catch (SQLException sqlex) {
                trace.infoT(mn, sqlex);
            }
            throw e;
        }
        if (result.m_statement == null || result.m_result == null) {
            if (result.m_result != null) {
                result.m_result.close();
            }
            if (result.m_statement != null) {
                result.m_statement.close();
            }
            return null;
        }
        return result;
    }

    private SqlResult query(Connection connection, PreparedStatement st) throws SQLException {
        return this.query(connection, st, 1, null, -1);
    }

    private SqlResult query(Connection connection, PreparedStatement st, int owner, String rid, int ridIndex) throws SQLException {
        String mn = "query(Connection connection, PreparedStatement st, int owner, String rid, int ridIndex)";
        SqlResult result = new SqlResult();
        try {
            if (owner > 0) {
                st.setInt(owner, this.m_owner);
            }
            if (rid != null) {
                st.setInt(ridIndex, rid.hashCode());
                st.setString(ridIndex + 1, rid);
            }
            result.m_statement = st;
            result.m_result = st.executeQuery();
        }
        catch (SQLException e) {
            try {
                if (result.m_result != null) {
                    result.m_result.close();
                }
            }
            catch (SQLException sqlex) {
                trace.infoT(mn, sqlex);
            }
            try {
                if (result.m_statement != null) {
                    result.m_statement.close();
                }
            }
            catch (SQLException sqlex) {
                trace.infoT(mn, sqlex);
            }
            throw e;
        }
        if (result.m_statement == null || result.m_result == null) {
            if (result.m_result != null) {
                result.m_result.close();
            }
            if (result.m_statement != null) {
                result.m_statement.close();
            }
            return null;
        }
        return result;
    }

    private String cacheGetPermissionKey(String name) {
        StringBuffer result = new StringBuffer(this.m_applicationID);
        result.append(SEPARATOR);
        result.append(this.m_managerID);
        result.append("-p-");
        result.append(name);
        return result.toString();
    }

    private IAclPermission cacheGetPermission(String name) {
        if (this.m_permissionCache == null) {
            return null;
        }
        return (IAclPermission)this.m_permissionCache.get(this.cacheGetPermissionKey(name));
    }

    private IAclPermission cacheAddPermission(IAclPermission permission) {
        if (this.m_permissionCache == null) {
            return permission;
        }
        try {
            this.m_permissionCache.put(this.cacheGetPermissionKey(permission.getName()), permission);
        }
        catch (Exception e) {
            trace.infoT("cacheAddPermission", "permission cache error", e);
        }
        return permission;
    }

    private void cacheRemovePermission(String permissionName) {
        if (this.m_permissionCache == null) {
            return;
        }
        this.m_permissionCache.invalidate(this.cacheGetPermissionKey(permissionName));
    }

    private String cacheGetSupportedPermissionsKey(String objectTypeName) {
        StringBuffer result = new StringBuffer(this.m_applicationID);
        result.append(SEPARATOR);
        result.append(this.m_managerID);
        result.append("-s-");
        result.append(objectTypeName);
        return result.toString();
    }

    private IAclPermissionList cacheAddSupportedPermissions(String objectTypeName, IAclPermissionList permissions) {
        if (this.m_permissionCache == null) {
            return permissions;
        }
        this.m_permissionCache.put(this.cacheGetSupportedPermissionsKey(objectTypeName), permissions);
        return permissions;
    }

    private IAclPermissionList cacheGetSupportedPermissions(String objectTypeName) {
        if (this.m_permissionCache == null) {
            return null;
        }
        return (IAclPermissionList)this.m_permissionCache.get(this.cacheGetSupportedPermissionsKey(objectTypeName));
    }

    private boolean isPermissionMember(IAclPermission parent, IAclPermission child) throws AclPersistenceException {
        IAclPermissionList children = parent.getMembers();
        IAclPermissionListIterator iterator = children.iterator();
        while (iterator.hasNext()) {
            IAclPermission listChild = iterator.next();
            if (listChild.equals(child)) {
                return true;
            }
            if (!this.isPermissionMember(listChild, child)) continue;
            return true;
        }
        return false;
    }

    private int min(int i, int k) {
        return i < k ? i : k;
    }

    private String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    private void logDebug(String method, String logText) {
        trace.debugT(method, this.getLogText(logText));
    }

    private String getLogText(String logText) {
        StringBuffer s = new StringBuffer();
        s.append('[');
        s.append(this.m_applicationID);
        s.append(',');
        s.append(this.m_managerID);
        s.append("(" + this.m_owner + ")");
        s.append(',');
        s.append(this.m_poolID);
        s.append("] ");
        s.append(logText);
        return s.toString();
    }

    public List getAllAcls() throws AclPersistenceException {
        String mn = "getAllAcls()";
        if (trace.beDebug()) {
            this.logDebug("getAllAcls()", "entering");
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAllAcls()");
                try {
                    List result = this.uncommittedGetAllAcls(conn);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    List list = result;
                    Object var8_12 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return list;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var8_13 = null;
                if (conn == null || connReleased) break block12;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    private List uncommittedGetAllAcls(Connection conn) throws SQLException {
        String mn = "uncommittedGetAllAcls(Connection conn)";
        String query = "SELECT \"RID\" FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=?";
        SqlResult queryResult = this.query(conn, query);
        ArrayList<String> result = new ArrayList<String>();
        String aclId = null;
        if (queryResult != null) {
            try {
                while (queryResult.m_result.next()) {
                    aclId = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                    result.add(aclId);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    private List uncommittedSearchAcls(Connection conn, String internalId) throws SQLException {
        String condition;
        String mn = "uncommittedSearchAcls(Connection conn, String internalId)";
        if (internalId.startsWith("*") || internalId.endsWith("*")) {
            condition = " LIKE ";
        } else if (internalId.equals("")) {
            internalId = "*";
            condition = " LIKE ";
        } else {
            condition = " = ";
        }
        internalId = internalId.replace('*', '%');
        StringBuffer query = new StringBuffer(120);
        query.append("SELECT \"RID\" FROM \"UME_ACL_ACL\" WHERE \"OWNERID\"=? AND \"RID\"");
        query.append(condition);
        query.append("'");
        query.append(internalId);
        query.append("'");
        SqlResult queryResult = this.query(conn, query.toString());
        ArrayList<String> result = new ArrayList<String>();
        String aclId = null;
        if (queryResult != null) {
            try {
                while (queryResult.m_result.next()) {
                    aclId = this.trim(Escape.unescapeSqlString(queryResult.m_result.getString(ACL_RID_COL)));
                    result.add(aclId);
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                queryResult.close();
                throw throwable;
            }
            queryResult.close();
            {
            }
        }
        return result;
    }

    public List searchAcls(String id) throws AclPersistenceException {
        String mn = "searchAcls(String id)";
        if (trace.beDebug()) {
            this.logDebug("searchAcls(String id)", "entering");
        }
        Connection conn = null;
        boolean connReleased = false;
        boolean jtaUsed = this.runningInJTATransaction();
        try {
            try {
                conn = this.conPool.getConnection("JDBCDatabaseConnectionUncached.getAllAcls()");
                try {
                    String internalId = Escape.escapeSqlString(id, 0);
                    List result = this.uncommittedSearchAcls(conn, internalId);
                    if (!jtaUsed) {
                        conn.commit();
                    }
                    List list = result;
                    Object var10_14 = null;
                    if (conn != null && !connReleased) {
                        this.conPool.releaseConnection(conn);
                    }
                    return list;
                }
                catch (Exception e) {
                    try {
                        if (!jtaUsed) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException sqlException) {
                        trace.infoT(mn, sqlException);
                    }
                    AclPersistenceException ape = new AclPersistenceException(e);
                    trace.infoT(mn, e);
                    throw ape;
                }
            }
            catch (ConnectionTimeoutException e) {
                AclPersistenceException ape = new AclPersistenceException((Exception)((Object)e));
                trace.infoT(mn, (Throwable)((Object)e));
                throw ape;
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var10_15 = null;
                if (conn == null || connReleased) break block12;
                this.conPool.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    private class SqlResult {
        public Statement m_statement = null;
        public ResultSet m_result = null;

        private SqlResult() {
        }

        public void close() throws SQLException {
            if (this.m_result != null) {
                this.m_result.close();
            }
            if (this.m_statement != null) {
                this.m_statement.close();
            }
        }
    }

    class AclRec {
        private String m_externalAclID;
        private String m_objectTypeName;
        private long m_changeLevel;

        public AclRec(String externalAclID, String objectTypeName, long changeLevel) {
            String mn = "Inner class: AclRec, Method: Constructor";
            if (trace.bePath()) {
                trace.entering(mn, new Object[]{externalAclID, objectTypeName, new Long(changeLevel)});
            }
            this.m_externalAclID = externalAclID;
            this.m_objectTypeName = objectTypeName;
            this.m_changeLevel = changeLevel;
            if (trace.bePath()) {
                trace.exiting(mn);
            }
        }

        public String getExternalAclID() {
            return this.m_externalAclID;
        }

        public String getObjectTypeName() {
            return this.m_objectTypeName;
        }

        public long getChangeLevel() {
            return this.m_changeLevel;
        }
    }
}

