/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclLoadClassException;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.HashMap;

public final class JDBCDatabaseConnectionManager {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCDatabaseConnectionManager.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCDatabaseConnectionManager.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static HashMap m_connections = new HashMap();

    public static synchronized JDBCDatabaseConnectionUncached getDatabaseConnection(String applicationID, String managerID, String poolID, ICache permissionCache) throws AclLoadClassException, AclPersistenceException {
        String key;
        JDBCDatabaseConnectionUncached connection;
        String mn = "constructor";
        if (applicationID == null || managerID == null || poolID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{applicationID, managerID, poolID, permissionCache});
        }
        if ((connection = (JDBCDatabaseConnectionUncached)m_connections.get(key = JDBCDatabaseConnectionManager.getConnectionKey(applicationID, managerID, poolID))) != null) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Returning already created connection");
            }
            return connection;
        }
        connection = new JDBCDatabaseConnectionUncached(applicationID, managerID, poolID, permissionCache);
        m_connections.put(key, connection);
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning created connection");
        }
        if (trace.bePath()) {
            trace.exiting(mn);
        }
        return connection;
    }

    private static String getConnectionKey(String applicationID, String managerID, String poolID) {
        String mn = "getConnectionKey(String applicationID, String managerID, String poolID)";
        String SEPARATOR = "~";
        StringBuffer key = new StringBuffer();
        key.append(applicationID);
        key.append("~");
        key.append(managerID);
        key.append("~");
        key.append(poolID);
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning connection key");
        }
        return key.toString();
    }
}

