/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclException;
import com.sap.security.core.acl.imp.wcm.AclExistsException;
import com.sap.security.core.acl.imp.wcm.AclLoadClassException;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAcl;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclManager;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IObjectType;
import com.sap.security.core.acl.imp.wcm.IObjectTypeList;
import com.sap.security.core.acl.imp.wcm.InvalidClassException;
import com.sap.security.core.acl.imp.wcm.InvalidConfigException;
import com.sap.security.core.acl.imp.wcm.NotAuthorizedException;
import com.sap.security.core.acl.imp.wcm.PermissionExistsException;
import com.sap.security.core.acl.imp.wcm.PermissionUsedException;
import com.sap.security.core.acl.imp.wcm.PredefinedPermissionException;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAcl;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAclEntry;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionManager;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCEmptyAcl;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCPermission;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.List;

public final class JDBCAclManager
implements IAclManager {
    private static final String CFG_POOL_KEY = "ume.db.connection_pool_type";
    private static final String CFG_ACL_CACHE_KEY = "ume.acl.cacheid";
    private static final String CFG_PERMISSION_CACHE_KEY = "ume.acl.permission_cacheid";
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAclManager.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAclManager.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    public static final JDBCEmptyAcl emptyAcl = new JDBCEmptyAcl();
    private final JDBCDatabaseConnectionUncached m_databaseConnection;
    private final String m_applicationID;
    private final String m_managerID;
    private ICache m_aclCache = null;
    private ICache m_permissionCache = null;
    private static int m_aclCacheSize;
    private static int m_aclCacheLifeTime;
    private static int m_aclPermCacheSize;
    private static int m_aclPermCacheLifeTime;
    private static boolean m_validateCachedAcls;

    public JDBCAclManager(String applicationID, String managerID) throws AclException, AclLoadClassException, AclPersistenceException, InvalidConfigException {
        String mn = "Constructor";
        if (applicationID == null || managerID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{applicationID, managerID});
        }
        this.m_applicationID = applicationID;
        this.m_managerID = managerID;
        String poolID = null;
        String aclCacheID = null;
        String permissionCacheID = null;
        try {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Getting configuration");
            }
            IUMParameters properties = UMFactory.getProperties();
            poolID = properties.get(CFG_POOL_KEY);
            aclCacheID = properties.get(CFG_ACL_CACHE_KEY, "ume.cache.acl");
            permissionCacheID = properties.get(CFG_PERMISSION_CACHE_KEY, "ume.cache.acl.permissions");
            m_aclCacheSize = properties.getNumber("ume.cache.acl.initial_cache_size", 10000);
            m_aclCacheLifeTime = properties.getNumber("ume.cache.acl.default_caching_time", 1800);
            m_aclPermCacheSize = properties.getNumber("ume.cache.acl.permissions.initial_cache_size", 100);
            m_aclPermCacheLifeTime = properties.getNumber("ume.cache.acl.permissions.default_caching_time", 3600);
            m_validateCachedAcls = properties.getBoolean("ume.acl.validate_cached_acls", false);
        }
        catch (Exception e) {
            InvalidConfigException ice = new InvalidConfigException(e.toString());
            trace.infoT(mn, this.getAclManagerId() + ((Throwable)((Object)ice)).toString(), e);
            throw ice;
        }
        this.createCaches(aclCacheID, permissionCacheID);
        this.m_databaseConnection = JDBCDatabaseConnectionManager.getDatabaseConnection(applicationID, managerID, poolID, this.m_permissionCache);
        if (trace.beDebug()) {
            trace.debugT(mn, "Created Acl Manager");
        }
        if (trace.bePath()) {
            trace.exiting(mn);
        }
    }

    public synchronized IAcl getAcl(String aclID) throws AclPersistenceException {
        JDBCAcl cachedAcl;
        String mn = "getAcl(String aclID)";
        if (aclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "aclID " + aclID);
        }
        if ((cachedAcl = this.getValidAclCache(aclID)) != null) {
            if (cachedAcl instanceof JDBCEmptyAcl) {
                if (trace.beDebug()) {
                    trace.debugT(mn, "Cached ACL is an JDBCEmptyAcl, id: " + aclID);
                }
                return null;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, "ACL is in cache, returning cached ACL, id: " + aclID);
            }
            return cachedAcl;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL is not in cache, getting ACL from DB, caching ACL and returning it, id: " + aclID);
        }
        return this.cacheAddAcl(aclID, this.m_databaseConnection.getAcl(aclID));
    }

    public synchronized IAcl[] getAcls(String[] aclIDs) throws AclPersistenceException {
        String mn = "getAcls(String[] aclIDs)";
        if (aclIDs == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "aclIDs-length " + aclIDs.length);
        }
        if (aclIDs.length == 0) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Returning empty JDBCAcl array");
            }
            return new JDBCAcl[0];
        }
        IAcl[] result = new JDBCAcl[aclIDs.length];
        int missing = this.getValidAclCache(aclIDs, (JDBCAcl[])result);
        if (missing > 0) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Get array with acls that are not cached");
            }
            String[] remainingIDs = new String[missing];
            int pos = 0;
            int i = 0;
            while (i < result.length) {
                if (result[i] == null) {
                    remainingIDs[pos] = aclIDs[i];
                    ++pos;
                }
                ++i;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, "Get acls from db");
            }
            JDBCAcl[] acls = this.m_databaseConnection.getAcls(remainingIDs);
            if (trace.beDebug()) {
                trace.debugT(mn, "Write acls to the cache and to the result array");
            }
            pos = 0;
            int i2 = 0;
            while (i2 < result.length) {
                if (result[i2] == null) {
                    result[i2] = this.cacheAddAcl(remainingIDs[pos], acls[pos]);
                    ++pos;
                } else if (result[i2] instanceof JDBCEmptyAcl) {
                    result[i2] = null;
                }
                ++i2;
            }
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning result");
        }
        return result;
    }

    public IObjectTypeList getSupportedObjectTypes() {
        String mn = "getSupportedObjectTypes()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning supported object types");
        }
        return this.m_databaseConnection.getSupportedObjectTypes();
    }

    public IAclPermissionList getSupportedPermissions(IObjectType objectType) throws AclPersistenceException {
        String mn = "getSupportedPermissions(IObjectType objectType)";
        if (objectType == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning supported permissions for objectType " + objectType.getName());
        }
        return this.m_databaseConnection.getSupportedPermissions(objectType);
    }

    public IAclPermission getPermission(String name) throws AclPersistenceException {
        String mn = "getPermission(String name)";
        if (name == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning permission " + name);
        }
        return this.m_databaseConnection.getPermission(name);
    }

    public boolean isPermissionUsedInAcl(IAclPermission permission) throws AclPersistenceException {
        String mn = "isPermissionUsedInAcl(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning if permission is used: " + permission.getName());
        }
        return this.m_databaseConnection.isPermissionUsedInAcl(permission);
    }

    public List getAffectedAclIDs(IAclPermission permission) throws AclPersistenceException {
        String mn = "getAffectedAclIDs(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "permission " + permission.getName());
        }
        return this.m_databaseConnection.getAffectedAclIDs(permission);
    }

    public boolean isReadOnly() {
        String mn = "isReadOnly()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning false");
        }
        return false;
    }

    public IAclEntry createAclEntry(IPrincipal principal, boolean negative, IAclPermission permission, int sortIndex, boolean propagate) throws AclPersistenceException, InvalidClassException {
        String mn = "createAclEntry(IPrincipal principal, boolean negative, IAclPermission permission, int sortIndex, boolean propagate)";
        if (principal == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "principal " + principal.getUniqueID() + ", negative " + negative + ", permission " + permission.getName() + ", sortIndex " + sortIndex + ", propagate " + propagate);
        }
        if (!(permission instanceof JDBCPermission)) {
            InvalidClassException ice = new InvalidClassException();
            trace.infoT(mn, this.getAclManagerId(), (Throwable)((Object)ice));
            throw ice;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning new JDBCAclEntry");
        }
        return new JDBCAclEntry(this.m_databaseConnection, principal, negative, permission, sortIndex, propagate);
    }

    public synchronized IAcl createAcl(IPrincipal owner, String aclID, IObjectType objectType) throws AclPersistenceException, AclExistsException {
        String mn = "createAcl(IPrincipal owner, String aclID, IObjectType objectType)";
        if (owner == null || aclID == null || objectType == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "owner " + owner.getUniqueID() + ", aclID " + aclID + ", objectType " + objectType.getName());
        }
        return this.cacheAddAcl(aclID, this.m_databaseConnection.createAcl(owner, aclID, objectType));
    }

    public boolean[] checkPermissions(IAcl[] acls, IPrincipal principal, IAclPermission[] permissions) throws AclPersistenceException {
        String mn = "checkPermissions(IAcl[] acls, IPrincipal principal, IAclPermission[] permissions)";
        if (acls == null || principal == null || permissions == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "acls-length " + acls.length + ", principal " + principal.getUniqueID() + ", permissions-length " + permissions.length);
        }
        if (acls.length == 0) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Returning empty array");
            }
            return new boolean[0];
        }
        boolean[] result = new boolean[acls.length];
        if (!(principal instanceof IUser)) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Returning result, Principal not instance of IUser");
            }
            return result;
        }
        if (permissions.length == 0) {
            int i = 0;
            while (i < result.length) {
                result[i] = true;
                ++i;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, "Returning result");
            }
            return result;
        }
        int i = 0;
        while (i < acls.length) {
            result[i] = ((JDBCAcl)acls[i]).checkPermissions(principal, permissions);
            ++i;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning result");
        }
        return result;
    }

    public boolean removeAcl(IPrincipal caller, String aclID) throws AclPersistenceException, NotAuthorizedException {
        String mn = "removeAcl(IPrincipal caller, String aclID)";
        if (caller == null || aclID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        IAcl acl = this.getAcl(aclID);
        if (acl == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "ACL is null, return false");
            }
            return false;
        }
        try {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Try to remove Acl " + aclID);
            }
            return this.removeAcl(caller, acl);
        }
        catch (InvalidClassException e) {
            trace.debugT(mn, "ACL was an JDBCEmptyACL, returning false", (Throwable)((Object)e));
            return false;
        }
    }

    public synchronized boolean removeAcl(IPrincipal caller, IAcl acl) throws AclPersistenceException, InvalidClassException, NotAuthorizedException {
        String mn = "removeAcl(IPrincipal caller, IAcl acl)";
        if (caller == null || acl == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (!(acl instanceof JDBCAcl)) {
            InvalidClassException ice = new InvalidClassException();
            trace.infoT(mn, this.getAclManagerId(), (Throwable)((Object)ice));
            throw ice;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "caller " + caller.getUniqueID() + ", acl " + ((JDBCAcl)acl).getID());
        }
        if (!acl.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclManagerId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (!this.m_databaseConnection.removeAcl(((JDBCAcl)acl).getID())) {
            if (trace.beDebug()) {
                trace.debugT(mn, "ACL could not be removed");
            }
            return false;
        }
        this.cacheRemoveAcl(((JDBCAcl)acl).getID());
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL removed and deleted from cache");
        }
        return true;
    }

    public synchronized void deletePrincipal(String principalID) throws AclPersistenceException {
        String mn = "deletePrincipal(String principalID)";
        if (principalID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        this.m_databaseConnection.deletePrincipal(principalID);
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Deleting principal " + principalID + ", but not Clearing cache" + " due to performance issues; Principal itself should not be used any more");
        }
        this.cacheClearAcls();
    }

    public synchronized void updatePrincipal(String principalID, int principalType) throws AclPersistenceException {
        String mn = "updatePrincipal(String principalID, int principalType)";
        if (principalID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "principalID " + principalID + ", principalType " + principalType);
            trace.debugT(mn, "Clearing cache");
        }
        this.cacheClearAcls();
    }

    public boolean addSupportedPermission(IObjectType objectType, IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException {
        String mn = "addSupportedPermission(IObjectType objectType, IAclPermission permission)";
        if (objectType == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "objectType " + objectType.getName() + ", permission " + permission.getName());
        }
        return this.m_databaseConnection.addSupportedPermission(objectType, permission);
    }

    public boolean removeSupportedPermission(IObjectType objectType, IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removeSupportedPermission(IObjectType objectType, IAclPermission permission)";
        if (objectType == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "objectType " + objectType.getName() + ", permission " + permission.getName());
        }
        return this.m_databaseConnection.removeSupportedPermission(objectType, permission);
    }

    public IAclPermission createPermission(String name) throws AclPersistenceException, PermissionExistsException {
        String mn = "createPermission(String name)";
        if (name == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "name " + name);
        }
        return this.m_databaseConnection.createPermission(name);
    }

    public boolean removePermission(IAclPermission permission) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
        String mn = "removePermission(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "permission " + permission.getName());
        }
        return this.m_databaseConnection.removePermission(permission);
    }

    public synchronized boolean changeAclID(IPrincipal caller, IAcl acl, String newID) throws AclPersistenceException, NotAuthorizedException, AclExistsException {
        String mn = "changeAclID(IPrincipal caller, IAcl acl, String newID)";
        if (caller == null || acl == null || newID == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "caller " + caller.getUniqueID() + ", newID " + newID);
        }
        if (!acl.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclManagerId(), (Throwable)((Object)nae));
            throw nae;
        }
        String oldID = ((JDBCAcl)acl).getID();
        if (!this.m_databaseConnection.changeAclID(oldID, newID)) {
            if (trace.beDebug()) {
                trace.debugT(mn, "ACL id could not be changed");
            }
            return false;
        }
        ((JDBCAcl)acl).setID(newID);
        this.cacheRemoveAcl(oldID);
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL id changed, new id: " + newID + ", old id: " + oldID);
        }
        return true;
    }

    public synchronized void changeMultipleAclIDs(String oldAclIdPrefix, String newAclIdPrefix) throws AclPersistenceException, AclExistsException {
        String mn = "changeMultipleAclIDs(String oldAclIdPrefix, String newAclIdPrefix)";
        if (newAclIdPrefix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "oldAclIdPrefix " + oldAclIdPrefix + ", newAclIdPrefix " + newAclIdPrefix);
        }
        this.m_databaseConnection.changeMultipleAclIDs(oldAclIdPrefix, newAclIdPrefix);
        this.cacheRemoveMultipleAcls(oldAclIdPrefix);
    }

    public synchronized void removeMultipleAcls(String aclIdPrefix) throws AclPersistenceException {
        String mn = "removeMultipleAcls(String aclIdPrefix)";
        if (aclIdPrefix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "aclIdPrefix " + aclIdPrefix);
        }
        this.m_databaseConnection.removeMultipleAcls(aclIdPrefix);
        this.cacheRemoveMultipleAcls(aclIdPrefix);
    }

    public boolean[] areAclsUpToDate(IAcl[] acls) throws AclPersistenceException {
        String mn = "areAclsUpToDate(IAcl[] acls)";
        if (acls == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "acls-length " + acls.length);
        }
        String[] aclIDs = new String[acls.length];
        long[] changeLevels = new long[acls.length];
        int i = 0;
        while (i < acls.length) {
            aclIDs[i] = ((JDBCAcl)acls[i]).getID();
            changeLevels[i] = ((JDBCAcl)acls[i]).getChangeLevel();
            ++i;
        }
        return this.m_databaseConnection.areAclsUpToDate(aclIDs, changeLevels);
    }

    public void clearPermissionCache() {
        String mn = "clearPermissionCache()";
        if (this.m_permissionCache != null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Invalidating permission cache");
            }
            this.m_permissionCache.invalidate();
        }
    }

    private void createCaches(String aclCacheID, String permissionCacheID) {
        String mn = "createCaches(String aclCacheID, String permissionCacheID)";
        if (aclCacheID == null && permissionCacheID == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Not creating cache");
            }
            return;
        }
        if (aclCacheID != null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Creating acl cache");
            }
            this.m_aclCache = InternalUMFactory.getCache(4, m_aclCacheSize, m_aclCacheLifeTime, this.getClass().getName() + "_" + this.m_applicationID + "_m_aclCache");
        }
        if (permissionCacheID != null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Creating permission cache");
            }
            this.m_permissionCache = InternalUMFactory.getCache(4, m_aclPermCacheSize, m_aclPermCacheLifeTime, this.getClass().getName() + "_" + this.m_applicationID + "_m_permissionCache");
        }
    }

    private JDBCAcl cacheAddAcl(String aclID, JDBCAcl acl) throws AclPersistenceException {
        String mn = "cacheAddAcl(String aclID, JDBCAcl acl)";
        if (this.m_aclCache == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "No cache available");
            }
            return null;
        }
        if (acl == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Caching empy ACL");
            }
            this.m_aclCache.put(aclID, emptyAcl);
        } else {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Caching ACL: " + aclID);
            }
            this.m_aclCache.put(aclID, acl);
        }
        return acl;
    }

    public void cacheRemoveAcl(String aclID) {
        String mn = "cacheRemoveAcl(String aclID)";
        if (this.m_aclCache == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, "No cache available");
            }
            return;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Removing ACL from cache, id: " + aclID);
        }
        this.m_aclCache.invalidate(aclID);
    }

    private void cacheClearAcls() {
        String mn = "cacheClearAcls()";
        if (this.m_aclCache == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "No cache available");
            }
            return;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Invalidating ACL cache");
        }
        this.m_aclCache.invalidate();
    }

    private void cacheRemoveMultipleAcls(String rootAclIdPrefix) {
        String mn = "cacheRemoveMultipleAcls(String rootAclIdPrefix)";
        if (this.m_aclCache == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "No cache available");
            }
            return;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Invalidating cache");
        }
        this.m_aclCache.invalidate();
    }

    private JDBCAcl getValidAclCache(String aclID) throws AclPersistenceException {
        String mn = "getValidAclCache(String aclID)";
        if (this.m_aclCache != null) {
            JDBCAcl acl = (JDBCAcl)this.m_aclCache.get(aclID);
            if (acl != null) {
                if (!(acl instanceof JDBCEmptyAcl) && m_validateCachedAcls && !this.m_databaseConnection.isAclUpToDate(acl.getID(), acl.getChangeLevel())) {
                    if (trace.beDebug()) {
                        trace.debugT(mn, this.getAclManagerId() + "Invalidate ACL from cache, id; " + aclID + ", returning null");
                    }
                    this.m_aclCache.invalidate(aclID);
                    return null;
                }
                if (trace.beDebug()) {
                    trace.debugT(mn, this.getAclManagerId() + "Returning ACL from cache, id: " + aclID);
                }
                return acl;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "ACL not in the cache, id: " + aclID + ", returning null");
            }
            return null;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "No cache available, returning null");
        }
        return null;
    }

    private int getValidAclCache(String[] aclIDs, JDBCAcl[] result) throws AclPersistenceException {
        String mn = "getValidAclCache(String[] aclIDs, JDBCAcl[] result)";
        int missing = result.length;
        if (aclIDs.length != result.length) {
            IllegalArgumentException iae = new IllegalArgumentException("parameters sizes differ");
            trace.infoT(mn, this.getAclManagerId(), iae);
            throw iae;
        }
        if (this.m_aclCache != null) {
            int found = 0;
            int i = 0;
            while (i < aclIDs.length) {
                JDBCAcl acl = (JDBCAcl)this.m_aclCache.get(aclIDs[i]);
                if (acl == null) {
                    if (trace.beDebug()) {
                        trace.debugT(mn, this.getAclManagerId() + "ACL not in cache, id: " + aclIDs[i]);
                    }
                } else {
                    if (trace.beDebug()) {
                        trace.debugT(mn, this.getAclManagerId() + "ACL found in cache, id: " + aclIDs[i]);
                    }
                    result[i] = acl;
                    ++found;
                }
                ++i;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, this.getAclManagerId() + "Checking found ACL's");
            }
            if (found > 0 && m_validateCachedAcls) {
                String[] checkIDs = new String[found];
                long[] checkLevels = new long[found];
                int pos = 0;
                int i2 = 0;
                while (i2 < result.length) {
                    JDBCAcl acl = result[i2];
                    if (acl != null) {
                        checkIDs[pos] = aclIDs[i2];
                        checkLevels[pos] = acl.getChangeLevel();
                        ++pos;
                    }
                    ++i2;
                }
                boolean[] upToDateFlags = this.m_databaseConnection.areAclsUpToDate(checkIDs, checkLevels);
                pos = 0;
                int i3 = 0;
                while (i3 < result.length) {
                    JDBCAcl acl = result[i3];
                    if (acl != null && !upToDateFlags[pos]) {
                        if (trace.beDebug()) {
                            trace.debugT(mn, this.getAclManagerId() + "Deleting ACL from cache, id: " + checkIDs[pos]);
                        }
                        this.m_aclCache.invalidate(checkIDs[pos]);
                        --found;
                        result[i3] = null;
                        ++pos;
                    }
                    ++i3;
                }
            }
            missing -= found;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclManagerId() + "Returning number of missing acl's: " + missing);
        }
        return missing;
    }

    private String getAclManagerId() {
        StringBuffer s = new StringBuffer();
        s.append("Manager ID [");
        if (this.m_applicationID != null) {
            s.append(this.m_applicationID);
        } else {
            s.append("null");
        }
        s.append(',');
        if (this.m_managerID != null) {
            s.append(this.m_managerID);
        } else {
            s.append("null");
        }
        s.append("], ");
        return s.toString();
    }

    public List getAllAcls() throws AclPersistenceException {
        String mn = "getAllAcls()";
        if (trace.beDebug()) {
            trace.debugT(mn, "Get all acls from db");
        }
        return this.m_databaseConnection.getAllAcls();
    }

    public List searchAcls(String id) throws AclPersistenceException {
        String mn = "searchAcls(String id)";
        if (trace.beDebug()) {
            trace.debugT(mn, "Get acls from db with search String {0}", new Object[]{id});
        }
        return this.m_databaseConnection.searchAcls(id);
    }
}

