/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.IGroup;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.IRole;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.InvalidClassException;
import com.sap.security.core.acl.imp.wcm.NotAuthorizedException;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAcl;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCPermission;
import com.sap.security.core.imp.Role;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Location;

public final class JDBCAclEntry
implements IAclEntry {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAclEntry.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAclEntry.java#4 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$acl$imp$wcm$jdbc$JDBCAclEntry == null ? (class$com$sap$security$core$acl$imp$wcm$jdbc$JDBCAclEntry = JDBCAclEntry.class$("com.sap.security.core.acl.imp.wcm.jdbc.JDBCAclEntry")) : class$com$sap$security$core$acl$imp$wcm$jdbc$JDBCAclEntry));
    private String m_ID = null;
    private String m_aclID = null;
    private JDBCAcl m_acl = null;
    private JDBCDatabaseConnectionUncached m_databaseConnection = null;
    private IPrincipal m_principal = null;
    private boolean m_negative = false;
    private IAclPermission m_permission = null;
    private boolean m_propagate = false;
    private int m_sortIndex = 0;
    static /* synthetic */ Class class$com$sap$security$core$acl$imp$wcm$jdbc$JDBCAclEntry;

    public JDBCAclEntry(JDBCDatabaseConnectionUncached databaseConnection, IPrincipal principal, boolean negative, IAclPermission permission, int sortIndex, boolean propagate) throws InvalidClassException {
        String mn = "Constructor (with IAclPermission)";
        if (databaseConnection == null || principal == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (!(permission instanceof JDBCPermission)) {
            InvalidClassException ice = new InvalidClassException();
            trace.infoT(mn, (Throwable)((Object)ice));
            throw ice;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "principal " + principal.getUniqueID() + ", negative " + negative + ", permission " + ((JDBCPermission)permission).getName() + ", sortIndex " + sortIndex + ", propagate " + propagate);
        }
        this.init(databaseConnection, principal, negative, (JDBCPermission)permission, sortIndex, propagate);
    }

    public JDBCAclEntry(JDBCDatabaseConnectionUncached databaseConnection, IPrincipal principal, boolean negative, JDBCPermission permission, int sortIndex, boolean propagate) {
        String mn = "Constructor (with JDBCPermission)";
        if (databaseConnection == null || principal == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "principal " + principal.getUniqueID() + ", negative " + negative + ", permission " + permission.getName() + ", sortIndex " + sortIndex + ", propagate " + propagate);
        }
        this.init(databaseConnection, principal, negative, permission, sortIndex, propagate);
    }

    public void setSortIndex(IPrincipal caller, int sortIndex) throws AclPersistenceException, NotAuthorizedException {
        String mn = "setSortIndex(IPrincipal caller, int sortIndex)";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "caller " + caller.getUniqueID() + ", sortIndex " + sortIndex);
        }
        if (this.m_ID == null || this.m_aclID == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, "ACE is not part of an ACL");
            }
            this.m_sortIndex = sortIndex;
            return;
        }
        if (caller == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAceId(), iae);
            throw iae;
        }
        JDBCAcl acl = this.m_databaseConnection.getAcl(this.m_aclID);
        if (acl == null || !acl.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAceId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (this.m_databaseConnection.setAclEntrySortIndex(this.m_ID, sortIndex)) {
            this.m_sortIndex = sortIndex;
            if (this.m_acl != null) {
                if (trace.beDebug()) {
                    trace.debugT(mn, "Reloading ACL Entries");
                }
                this.m_acl.reloadAclEntries();
            }
        }
    }

    public void setPropagation(IPrincipal caller, boolean propagate) throws AclPersistenceException, NotAuthorizedException {
        String mn = "setPropagation(IPrincipal caller, boolean propagate)";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "caller " + caller.getUniqueID() + ", propagate " + propagate);
        }
        if (this.m_ID == null || this.m_aclID == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, "ACE is not part of an ACL");
            }
            this.m_propagate = propagate;
            return;
        }
        if (caller == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAceId(), iae);
            throw iae;
        }
        JDBCAcl acl = this.m_databaseConnection.getAcl(this.m_aclID);
        if (acl == null || !acl.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAceId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (this.m_databaseConnection.setAclEntryPropagation(this.m_ID, propagate)) {
            this.m_propagate = propagate;
            if (this.m_acl != null) {
                if (trace.beDebug()) {
                    trace.debugT(mn, this.getAceId() + "Reloading ACL Entries");
                }
                this.m_acl.reloadAclEntries();
            }
        }
    }

    public IAclPermission getPermission() {
        String mn = "getPermission()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning permission");
        }
        return this.m_permission;
    }

    public boolean isNegative() {
        String mn = "isNegative()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning if negative");
        }
        return this.m_negative;
    }

    public IPrincipal getPrincipal() {
        String mn;
        block12: {
            mn = "getPrincipal()";
            if (this.m_principal instanceof IGroup) {
                try {
                    this.m_principal = UMFactory.getGroupFactory().getGroup(this.m_principal.getUniqueID());
                }
                catch (UMException ex) {
                    LoggingHelper.traceThrowable((int)100, (Location)this.myLoc, (String)mn, (Throwable)ex);
                    if (trace.beDebug()) {
                        trace.debugT(mn, this.getAceId() + "Getting group fails", ex);
                    }
                    break block12;
                }
            }
            if (this.m_principal instanceof IRole) {
                try {
                    this.m_principal = ((RoleFactory)UMFactory.getRoleFactory()).getRoleWithoutExistenceCheck(this.m_principal.getUniqueID(), Role.ROLE_DEFAULT_ATTRIBUTES);
                }
                catch (UMException ex) {
                    if (trace.beDebug()) {
                        trace.debugT(mn, this.getAceId() + "Getting role fails", ex);
                    }
                    break block12;
                }
            }
            if (this.m_principal instanceof IPrincipalSet) {
                try {
                    this.m_principal = UMFactory.getPrincipalFactory().getPrincipal(this.m_principal.getUniqueID());
                }
                catch (UMException ex) {
                    if (!trace.beDebug()) break block12;
                    trace.debugT(mn, this.getAceId() + "Getting PrincipalSet fails", ex);
                }
            }
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning principal");
        }
        return this.m_principal;
    }

    public boolean isReadOnly() {
        String mn = "isReadOnly()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning false");
        }
        return false;
    }

    public int getSortIndex() throws AclPersistenceException {
        String mn = "getSortIndex()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning sorted index");
        }
        return this.m_sortIndex;
    }

    public boolean isPropagated() throws AclPersistenceException {
        String mn = "isPropagated()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning if is propagated");
        }
        return this.m_propagate;
    }

    public boolean checkPermission(IAclPermission permission) throws AclPersistenceException {
        String mn = "checkPermission(IAclPermission permission)";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "permission " + permission.getName());
        }
        return this.m_permission.isContained(permission);
    }

    protected void setIDs(String id, String aclID) {
        String mn = "setIDs(String id, String aclID)";
        this.m_ID = id;
        this.m_aclID = aclID;
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Set id's");
        }
    }

    protected String getID() {
        String mn = "getID()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning id");
        }
        return this.m_ID;
    }

    protected String getAclID() {
        String mn = "getAclID()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Returning id");
        }
        return this.m_aclID;
    }

    protected void clearIDs() {
        String mn = "clearIDs()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "Clearing Ids");
        }
        this.m_ID = null;
        this.m_aclID = null;
        this.m_acl = null;
    }

    protected void setAcl(JDBCAcl acl) {
        String mn = "setAcl(JDBCAcl acl)";
        this.m_acl = acl;
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAceId() + "ACL set");
        }
    }

    private void init(JDBCDatabaseConnectionUncached databaseConnection, IPrincipal principal, boolean negative, JDBCPermission permission, int sortIndex, boolean propagate) {
        String mn = "init";
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{databaseConnection, principal, new Boolean(negative), permission, new Integer(sortIndex), new Boolean(propagate)});
        }
        this.m_databaseConnection = databaseConnection;
        this.m_principal = principal;
        this.m_negative = negative;
        this.m_permission = permission;
        this.m_sortIndex = sortIndex;
        this.m_propagate = propagate;
        if (trace.beDebug()) {
            trace.debugT(mn, "JDBCAclEntry initialized");
        }
        if (trace.bePath()) {
            trace.exiting(mn);
        }
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof JDBCAclEntry)) {
            return false;
        }
        JDBCAclEntry x = (JDBCAclEntry)another;
        try {
            return this.getPermission().equals(x.getPermission()) && this.getPrincipal().equals((Object)x.getPrincipal());
        }
        catch (Exception ignore) {
            LoggingHelper.traceThrowable((int)100, (Location)this.myLoc, (String)"equals", (Throwable)ignore);
            return false;
        }
    }

    public int hashCode() {
        return this.getPrincipal().hashCode() + this.getPermission().hashCode();
    }

    private String getAceId() {
        StringBuffer s = new StringBuffer();
        s.append("ACE ID: [");
        if (this.m_ID != null) {
            s.append(this.m_ID);
        } else {
            s.append("null");
        }
        s.append("], ACL ID: [");
        if (this.m_aclID != null) {
            s.append(this.m_aclID);
        } else {
            s.append("null");
        }
        s.append("], ");
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

