/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm.jdbc;

import com.sap.security.api.IGroup;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.IUser;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclEntryList;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.AlreadyAssignedToAclException;
import com.sap.security.core.acl.imp.wcm.IAcl;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclEntryList;
import com.sap.security.core.acl.imp.wcm.IAclEntryListIterator;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IAclPermissionListIterator;
import com.sap.security.core.acl.imp.wcm.IObjectType;
import com.sap.security.core.acl.imp.wcm.IPrincipalList;
import com.sap.security.core.acl.imp.wcm.IPrincipalListIterator;
import com.sap.security.core.acl.imp.wcm.InvalidClassException;
import com.sap.security.core.acl.imp.wcm.LastOwnerException;
import com.sap.security.core.acl.imp.wcm.NotAuthorizedException;
import com.sap.security.core.acl.imp.wcm.PermissionNotSupportedException;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAclEntry;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCDatabaseConnectionUncached;
import com.sap.security.core.util.IUMTrace;
import java.util.List;

public class JDBCAcl
implements IAcl {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAcl.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/wcm/jdbc/JDBCAcl.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private JDBCDatabaseConnectionUncached m_databaseConnection = null;
    private String m_aclID = null;
    private IObjectType m_objectType = null;
    private IPrincipalList m_owners;
    private IAclEntryList m_entries;
    private long m_changeLevel = 0L;

    public JDBCAcl(JDBCDatabaseConnectionUncached databaseConnection, String aclID, IObjectType objectType, IPrincipalList owners, IAclEntryList entries, long changeLevel) {
        String mn = "Public constructor";
        if (databaseConnection == null || aclID == null || objectType == null || owners == null || entries == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, iae);
            throw iae;
        }
        if (trace.bePath()) {
            trace.entering(mn, new Object[]{databaseConnection, aclID, objectType, owners, entries});
        }
        this.m_aclID = aclID;
        if (trace.beDebug()) {
            trace.debugT("JDBCAcl", "objectType " + objectType.getName() + ", changeLevel " + changeLevel);
        }
        this.m_databaseConnection = databaseConnection;
        this.m_objectType = objectType;
        this.m_owners = owners;
        this.m_entries = entries;
        this.m_changeLevel = changeLevel;
        this.setEntriesAcl();
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Created JDBCAcl");
        }
        if (trace.bePath()) {
            trace.exiting(mn);
        }
    }

    protected JDBCAcl() {
        String mn = "Protected constructor";
        if (trace.beDebug()) {
            trace.debugT(mn, "Creating empy JDBCAcl");
        }
        this.m_owners = null;
        this.m_entries = null;
    }

    public IAclEntryList getEntries() throws AclPersistenceException {
        String mn = "getEntries()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning entries");
        }
        return this.m_entries;
    }

    public IAclEntryList getEntries(IPrincipal principal) throws AclPersistenceException {
        String mn = "getEntries(IPrincipal principal)";
        if (principal == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "principal " + principal.getUniqueID());
        }
        AclEntryList result = new AclEntryList();
        IAclEntryListIterator iterator = this.m_entries.iterator();
        while (iterator.hasNext()) {
            JDBCAclEntry entry = (JDBCAclEntry)iterator.next();
            if (!entry.getPrincipal().equals((Object)principal)) continue;
            result.add(entry);
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning entries");
        }
        return result;
    }

    public boolean isReadOnly() {
        String mn = "isReadOnly()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning false");
        }
        return false;
    }

    public boolean isOwner(IPrincipal principal) throws AclPersistenceException {
        String mn = "isOwner(IPrincipal principal)";
        if (principal == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "principal " + principal.getUniqueID());
        }
        IPrincipalListIterator iterator = this.m_owners.iterator();
        while (iterator.hasNext()) {
            IPrincipal listOwner = iterator.next();
            if (!listOwner.equals((Object)principal)) continue;
            trace.debugT(mn, "Principal is owner");
            return true;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Principal is not owner");
        }
        return false;
    }

    public String getID() {
        String mn = "getID()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning id");
        }
        return this.m_aclID;
    }

    public IPrincipalList getOwners() throws AclPersistenceException {
        String mn = "getOwners()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning owners");
        }
        return this.m_owners;
    }

    public boolean isLocked() throws AclPersistenceException {
        String mn = "isLocked()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning if ACL is locked");
        }
        return this.m_databaseConnection.isAclLocked(this.m_aclID);
    }

    public IPrincipal getLockingUser() throws AclPersistenceException {
        String mn = "getLockingUser()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning locking user");
        }
        return this.m_databaseConnection.getAclLockingUser(this.m_aclID);
    }

    public List getDescendantsWithAcl(String postFix) throws AclPersistenceException {
        String mn = "getDescendantsWithAcl(String postFix)";
        if (postFix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "postFix " + postFix);
        }
        return this.m_databaseConnection.getDescendantsWithAcl(this.m_aclID + postFix);
    }

    public boolean isAuthorized(IPrincipal principal) throws AclPersistenceException {
        String mn = "isAuthorized(IPrincipal principal)";
        if (principal == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "principal " + principal.getUniqueID());
        }
        if (!(principal instanceof IUser)) {
            trace.debugT(mn, "Principal is not authorized");
            return false;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Principal is authorized");
        }
        return true;
    }

    public boolean addEntry(IPrincipal caller, IAclEntry aclEntry) throws AclPersistenceException, InvalidClassException, NotAuthorizedException, AlreadyAssignedToAclException, PermissionNotSupportedException {
        String id;
        String mn = "addEntry(IPrincipal caller, IAclEntry aclEntry)";
        if (caller == null || aclEntry == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (!(aclEntry instanceof JDBCAclEntry)) {
            InvalidClassException ice = new InvalidClassException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)ice));
            throw ice;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID() + ", aclEntryID " + ((JDBCAclEntry)aclEntry).getID());
        }
        if (!this.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (!this.isPermissionSupported(aclEntry.getPermission())) {
            PermissionNotSupportedException pnse = new PermissionNotSupportedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)pnse));
            throw pnse;
        }
        if (this.m_entries != null) {
            IAclEntryListIterator it = this.m_entries.iterator();
            while (it.hasNext()) {
                IAclEntry entry = it.next();
                if (!entry.equals(aclEntry)) continue;
                trace.debugT(mn, "ACL Entry already existing");
                return false;
            }
        }
        if ((id = this.m_databaseConnection.addAclEntry(this.m_aclID, (JDBCAclEntry)aclEntry)) == null) {
            if (trace.beDebug()) {
                trace.debugT(mn, "ACL Entry could not be added");
            }
            return false;
        }
        ((JDBCAclEntry)aclEntry).setIDs(id, this.m_aclID);
        ((JDBCAclEntry)aclEntry).setAcl(this);
        this.m_entries = this.m_databaseConnection.getAclEntries(this.m_aclID);
        this.setEntriesAcl();
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL Entry added");
        }
        return true;
    }

    public boolean removeEntry(IPrincipal caller, IAclEntry aclEntry) throws AclPersistenceException, InvalidClassException, NotAuthorizedException {
        String mn = "removeEntry(IPrincipal caller, IAclEntry aclEntry)";
        if (caller == null || aclEntry == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (!(aclEntry instanceof JDBCAclEntry)) {
            InvalidClassException ice = new InvalidClassException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)ice));
            throw ice;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID() + ", aclEntryID " + ((JDBCAclEntry)aclEntry).getID());
        }
        if (!this.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (!this.m_databaseConnection.removeAclEntry((JDBCAclEntry)aclEntry)) {
            trace.debugT(mn, "ACL Entry could not be removed");
            return false;
        }
        ((JDBCAclEntry)aclEntry).clearIDs();
        this.m_entries = this.m_databaseConnection.getAclEntries(this.m_aclID);
        this.setEntriesAcl();
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL Entry removed");
        }
        return true;
    }

    public boolean addOwner(IPrincipal caller, IPrincipal principal) throws AclPersistenceException, NotAuthorizedException {
        String mn = "addOwner(IPrincipal caller, IPrincipal principal)";
        if (caller == null || principal == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID() + ", principal " + principal.getUniqueID());
        }
        if (!this.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, (Throwable)((Object)nae));
            throw nae;
        }
        if (!this.m_databaseConnection.addOwner(this.m_aclID, principal)) {
            trace.debugT(mn, "ACL Owner could not be added");
            return false;
        }
        this.m_owners = this.m_databaseConnection.getOwners(this.m_aclID);
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL Owner added");
        }
        return true;
    }

    public boolean removeOwner(IPrincipal caller, IPrincipal owner) throws AclPersistenceException, NotAuthorizedException, LastOwnerException {
        String mn = "removeOwner(IPrincipal caller, IPrincipal owner)";
        if (caller == null || owner == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID() + ", owner " + owner.getUniqueID());
        }
        if (!this.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (!this.m_databaseConnection.removeOwner(this.m_aclID, owner)) {
            trace.debugT(mn, "ACL Owner could not be removed");
            return false;
        }
        this.m_owners = this.m_databaseConnection.getOwners(this.m_aclID);
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL Owner removed");
        }
        return true;
    }

    public boolean checkPermission(IPrincipal principal, IAclPermission permission) throws AclPersistenceException {
        String mn = "checkPermission(IPrincipal principal, IAclPermission permission)";
        if (principal == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "principal " + principal.getUniqueID() + ", permission " + permission.getName());
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Perform basicCheckPermission");
        }
        return this.basicCheckPermission(principal, permission);
    }

    public boolean checkPermissions(IPrincipal principal, IAclPermission[] permissions) throws AclPersistenceException {
        String mn = "checkPermissions(IPrincipal principal, IAclPermission[] permissions)";
        if (principal == null || permissions == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "principal " + principal.getUniqueID() + ", permissions-length " + permissions.length);
        }
        int i = 0;
        while (i < permissions.length) {
            if (!this.basicCheckPermission(principal, permissions[i])) {
                trace.debugT(mn, "BasicCheckPermission fails");
                return false;
            }
            ++i;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Principal has the specified permission for this ACL");
        }
        return true;
    }

    public boolean lock(IPrincipal caller) throws AclPersistenceException, NotAuthorizedException {
        String mn = "lock(IPrincipal caller)";
        if (caller == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID());
        }
        if (!this.isAuthorized(caller)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)nae));
            throw nae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Locking ACL");
        }
        return this.m_databaseConnection.lockAcl(this.m_aclID, caller);
    }

    public void unlock(IPrincipal caller) throws AclPersistenceException, NotAuthorizedException {
        IUser lockingUser;
        String mn = "unlock(IPrincipal caller)";
        if (caller == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "caller " + caller.getUniqueID());
        }
        if ((lockingUser = this.m_databaseConnection.getAclLockingUser(this.m_aclID)) == null || !caller.equals((Object)lockingUser)) {
            NotAuthorizedException nae = new NotAuthorizedException();
            trace.infoT(mn, this.getAclId(), (Throwable)((Object)nae));
            throw nae;
        }
        trace.debugT(mn, "Unlocking ACL");
        this.m_databaseConnection.unlockAcl(this.m_aclID);
    }

    public boolean hasDescendantsWithAcl(String postFix) throws AclPersistenceException {
        String mn = "hasDescendantsWithAcl(String postFix)";
        if (postFix == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "postFix " + postFix);
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Returning descendants");
        }
        return this.m_databaseConnection.hasDescendantsWithAcl(this.m_aclID + postFix);
    }

    public boolean isUpToDate() throws AclPersistenceException {
        String mn = "isUpToDate()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning if ACL is up to date");
        }
        return this.m_databaseConnection.isAclUpToDate(this.m_aclID, this.m_changeLevel);
    }

    protected void setID(String id) throws AclPersistenceException {
        String mn = "setID(String id)";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "id " + id);
        }
        this.m_aclID = id;
        IAclEntryListIterator entryIterator = this.m_entries.iterator();
        while (entryIterator.hasNext()) {
            JDBCAclEntry entry = (JDBCAclEntry)entryIterator.next();
            entry.setIDs(entry.getID(), id);
            entry.setAcl(this);
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Set id");
        }
    }

    protected long getChangeLevel() throws AclPersistenceException {
        String mn = "getChangeLevel()";
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Returning Change level");
        }
        return this.m_changeLevel;
    }

    protected void reloadAclEntries() throws AclPersistenceException {
        String mn = "reloadAclEntries()";
        this.m_entries = this.m_databaseConnection.getAclEntries(this.m_aclID);
        this.setEntriesAcl();
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Reloaded ACL Entries");
        }
    }

    private boolean basicCheckPermission(IPrincipal caller, IAclPermission permission) throws AclPersistenceException {
        String mn = "basicCheckPermission(IPrincipal caller, IAclPermission permission)";
        if (caller == null || permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, this.getAclId() + "Checking caller: " + caller.getUniqueID() + " on permission: " + permission.toString());
        }
        IAclEntryListIterator entryIterator = this.m_entries.iterator();
        while (entryIterator.hasNext()) {
            IAclEntry listEntry = entryIterator.next();
            IPrincipal listPrincipal = listEntry.getPrincipal();
            if (!this.containsPrincipal(listPrincipal, caller) || !listEntry.checkPermission(permission)) continue;
            if (listEntry.isNegative()) {
                if (trace.beDebug()) {
                    trace.debugT(mn, "ACL Entry is negative");
                }
                return false;
            }
            if (trace.beDebug()) {
                trace.debugT(mn, "Permission check successful");
            }
            return true;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Permission check not successful");
        }
        return false;
    }

    private boolean isPermissionSupported(IAclPermission permission) throws AclPersistenceException {
        String mn = "isPermissionSupported(IAclPermission permission)";
        if (permission == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        IAclPermissionList permissions = this.m_databaseConnection.getSupportedPermissions(this.m_objectType);
        IAclPermissionListIterator iterator = permissions.iterator();
        while (iterator.hasNext()) {
            IAclPermission listPermission = iterator.next();
            if (!listPermission.equals(permission)) continue;
            trace.debugT(mn, this.getAclId() + "Permission is supported");
            return true;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Permission is not supported");
        }
        return false;
    }

    private boolean containsPrincipal(IPrincipal principal, IPrincipal caller) {
        String mn = "containsPrincipal(IPrincipal principal, IPrincipal caller)";
        if (principal == null || caller == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            trace.infoT(mn, this.getAclId(), iae);
            throw iae;
        }
        if (principal.equals((Object)caller)) {
            trace.debugT(mn, "Principal equals caller");
            return true;
        }
        if ((caller instanceof IUser || caller instanceof IGroup) && principal instanceof IPrincipalSet && ((IPrincipalSet)principal).isMember(caller.getUniqueID(), true)) {
            if (trace.beDebug()) {
                trace.debugT(mn, "Caller " + caller.getUniqueID() + " is member of principal" + principal.getUniqueID());
            }
            return true;
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "Principal is not member");
        }
        return false;
    }

    private void setEntriesAcl() {
        String mn = "setEntriesAcl()";
        IAclEntryListIterator entryIterator = this.m_entries.iterator();
        while (entryIterator.hasNext()) {
            JDBCAclEntry entry = (JDBCAclEntry)entryIterator.next();
            entry.setAcl(this);
        }
        if (trace.beDebug()) {
            trace.debugT(mn, "ACL Entries set");
        }
    }

    private String getAclId() {
        StringBuffer s = new StringBuffer();
        s.append("ACL ID: [");
        if (this.m_aclID != null) {
            s.append(this.m_aclID);
        } else {
            s.append("null");
        }
        s.append("], ");
        return s.toString();
    }
}

