/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp.wcm;

import com.sap.security.api.IPrincipal;
import com.sap.security.core.acl.imp.wcm.AclExistsException;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAcl;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IObjectType;
import com.sap.security.core.acl.imp.wcm.IObjectTypeList;
import com.sap.security.core.acl.imp.wcm.InvalidClassException;
import com.sap.security.core.acl.imp.wcm.NotAuthorizedException;
import com.sap.security.core.acl.imp.wcm.PermissionExistsException;
import com.sap.security.core.acl.imp.wcm.PermissionUsedException;
import com.sap.security.core.acl.imp.wcm.PredefinedPermissionException;
import java.util.List;

public interface IAclManager {
    public IAclEntry createAclEntry(IPrincipal var1, boolean var2, IAclPermission var3, int var4, boolean var5) throws AclPersistenceException, InvalidClassException;

    public IAcl createAcl(IPrincipal var1, String var2, IObjectType var3) throws AclPersistenceException, AclExistsException;

    public IAcl getAcl(String var1) throws AclPersistenceException;

    public IAcl[] getAcls(String[] var1) throws AclPersistenceException;

    public boolean[] checkPermissions(IAcl[] var1, IPrincipal var2, IAclPermission[] var3) throws AclPersistenceException;

    public boolean removeAcl(IPrincipal var1, String var2) throws AclPersistenceException, NotAuthorizedException;

    public boolean removeAcl(IPrincipal var1, IAcl var2) throws AclPersistenceException, InvalidClassException, NotAuthorizedException;

    public void deletePrincipal(String var1) throws AclPersistenceException;

    public void updatePrincipal(String var1, int var2) throws AclPersistenceException;

    public IObjectTypeList getSupportedObjectTypes() throws AclPersistenceException;

    public IAclPermissionList getSupportedPermissions(IObjectType var1) throws AclPersistenceException;

    public IAclPermission getPermission(String var1) throws AclPersistenceException;

    public boolean addSupportedPermission(IObjectType var1, IAclPermission var2) throws AclPersistenceException, PredefinedPermissionException;

    public boolean removeSupportedPermission(IObjectType var1, IAclPermission var2) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException;

    public IAclPermission createPermission(String var1) throws AclPersistenceException, PermissionExistsException;

    public boolean removePermission(IAclPermission var1) throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException;

    public boolean isPermissionUsedInAcl(IAclPermission var1) throws AclPersistenceException;

    public List getAffectedAclIDs(IAclPermission var1) throws AclPersistenceException;

    public boolean changeAclID(IPrincipal var1, IAcl var2, String var3) throws AclPersistenceException, NotAuthorizedException, AclExistsException;

    public void changeMultipleAclIDs(String var1, String var2) throws AclPersistenceException, AclExistsException;

    public void removeMultipleAcls(String var1) throws AclPersistenceException;

    public boolean isReadOnly() throws AclPersistenceException;

    public boolean[] areAclsUpToDate(IAcl[] var1) throws AclPersistenceException;

    public void cacheRemoveAcl(String var1);

    public List getAllAcls() throws AclPersistenceException;

    public List searchAcls(String var1) throws AclPersistenceException;
}

