/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.IUser;
import com.sap.security.api.RoleListener;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.acl.PermissionStatus;
import com.sap.security.api.srvUser.IServiceUserFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.ACLRoleListener;
import com.sap.security.core.acl.imp.Acl;
import com.sap.security.core.acl.imp.AclManagerPermission;
import com.sap.security.core.acl.imp.wcm.AclException;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAcl;
import com.sap.security.core.acl.imp.wcm.IAclManager;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IAclPermissionList;
import com.sap.security.core.acl.imp.wcm.IAclPermissionListIterator;
import com.sap.security.core.acl.imp.wcm.ObjectType;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAclManager;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class AclManager
implements com.sap.security.api.acl.IAclManager {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclManager.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    public static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclManager.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    private static final ObjectType LEAF_OBJECT_TYPE = new ObjectType("leaf");
    private IAclManager wcmAclManager = null;
    protected static String serviceUserID = null;

    public synchronized void initialize(Properties properties) throws UMException {
    }

    public void init(String applicationId) throws UMException {
        try {
            if (this.wcmAclManager == null) {
                this.wcmAclManager = new JDBCAclManager(applicationId, "default");
                this.addPermission("owner", null);
                UMFactory.getRoleFactory().registerListener((RoleListener)new ACLRoleListener(this), 2);
            } else {
                trace.warningT("init(String)", "ACL manager is already initialized!");
            }
        }
        catch (AclException exc) {
            trace.errorT("init(String)", (Throwable)((Object)exc));
            throw new UMException("AclManager couldn't be initialized because of " + ((Throwable)((Object)exc)).toString());
        }
    }

    public static void registerServiceUser(String uniqueID) throws UMException {
        IServiceUserFactory srvUserF;
        if (uniqueID != null && (srvUserF = UMFactory.getServiceUserFactory()).isServiceUser(uniqueID)) {
            serviceUserID = uniqueID;
            trace.infoT("registerServiceUser(String)", "Registered service user: " + uniqueID);
            return;
        }
        throw new UMException("Registration of service user failed: " + uniqueID);
    }

    public int getMaxObjectIdLength() {
        return 255;
    }

    public int getMaxPermissionNameLength() {
        return 127;
    }

    public com.sap.security.api.acl.IAcl createAcl(IPrincipal caller, String objectId) throws UMException {
        String methodName = "createAcl(IPrincipal, String)";
        try {
            IAcl wcmAcl = this.wcmAclManager.createAcl(caller, objectId, LEAF_OBJECT_TYPE);
            if (wcmAcl == null) {
                return null;
            }
            Acl newAcl = new Acl(wcmAcl, this.wcmAclManager);
            if (newAcl.createAclEntry(caller, caller, "owner", false) == null) {
                trace.errorT("createAcl(IPrincipal, String)", "Couldn't assign the owner permission to the owner!");
            }
            if (SecurityAudit.isLogged("ACL.CREATE")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("owner", caller.getUniqueID());
                SecurityAudit.log("ACL.CREATE", objectId, details);
            }
            return newAcl;
        }
        catch (AclException exc) {
            trace.errorT("createAcl(IPrincipal, String)", (Throwable)((Object)exc));
            throw new UMException(((Throwable)((Object)exc)).toString());
        }
    }

    public com.sap.security.api.acl.IAcl getAcl(String objectId) throws UMException {
        try {
            IAcl wcmAcl = this.wcmAclManager.getAcl(objectId);
            if (wcmAcl == null) {
                return null;
            }
            return new Acl(wcmAcl, this.wcmAclManager);
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getAcl(String)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public com.sap.security.api.acl.IAcl[] getAcls(String[] objectIds) throws UMException {
        try {
            IAcl[] wcmAcls = this.wcmAclManager.getAcls(objectIds);
            com.sap.security.api.acl.IAcl[] sapallAcls = new Acl[wcmAcls.length];
            int i = 0;
            while (i < wcmAcls.length) {
                sapallAcls[i] = wcmAcls[i] == null ? null : new Acl(wcmAcls[i], this.wcmAclManager);
                ++i;
            }
            return sapallAcls;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getAcls(String[])", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean removeAcl(IPrincipal caller, String objectId) throws UMException {
        String methodName = "removeAcl(IPrincipal, String)";
        try {
            boolean success = this.wcmAclManager.removeAcl(caller, objectId);
            if (success && SecurityAudit.isLogged("ACL.DELETE")) {
                SecurityAudit.log("ACL.DELETE", objectId, null);
            }
            return success;
        }
        catch (AclException exc) {
            trace.errorT("removeAcl(IPrincipal, String)", (Throwable)((Object)exc));
            throw new UMException(((Throwable)((Object)exc)).toString());
        }
    }

    public boolean removeAcl(IPrincipal caller, com.sap.security.api.acl.IAcl acl) throws UMException {
        String methodName = "removeAcl(IPrincipal, IAcl)";
        try {
            boolean success = this.wcmAclManager.removeAcl(caller, acl.getObjectId());
            if (success && SecurityAudit.isLogged("ACL.DELETE")) {
                SecurityAudit.log("ACL.DELETE", acl.getObjectId(), null);
            }
            return success;
        }
        catch (AclException exc) {
            trace.errorT("removeAcl(IPrincipal, IAcl)", (Throwable)((Object)exc));
            throw new UMException(((Throwable)((Object)exc)).toString());
        }
    }

    public boolean removeAcls(IPrincipal caller, String[] objectIds) throws UMException {
        String methodName = "removeAcls(IPrincipal, String[])";
        boolean status = true;
        try {
            int i = 0;
            while (i < objectIds.length) {
                if (!this.wcmAclManager.removeAcl(caller, objectIds[i])) {
                    status = false;
                } else if (SecurityAudit.isLogged("ACL.DELETE")) {
                    SecurityAudit.log("ACL.DELETE", objectIds[i], null);
                }
                ++i;
            }
        }
        catch (AclException exc) {
            trace.errorT("removeAcls(IPrincipal, String[])", (Throwable)((Object)exc));
            throw new UMException(((Throwable)((Object)exc)).toString());
        }
        return status;
    }

    public boolean hasPermission(String objectId, IPrincipal principal, String permission) throws UMException {
        String methodName = "hasPermission(String, IPrincipal, String)";
        try {
            if (principal == null) {
                String message = "Invalid parameter - principal is 'null'!";
                trace.warningT("hasPermission(String, IPrincipal, String)", message);
                throw new UMException(message);
            }
            IAclPermission aclPermission = this.wcmAclManager.getPermission(permission);
            if (aclPermission == null) {
                String message = "Invalid parameter - permission doesn't exist: " + permission;
                trace.warningT("hasPermission(String, IPrincipal, String)", message);
                throw new UMException(message);
            }
            if (serviceUserID != null && serviceUserID.equals(principal.getUniqueID())) {
                if (trace.beInfo()) {
                    trace.infoT("hasPermission(String, IPrincipal, String)", "Principal is the registered service user -> has all ACL permissions");
                }
                return true;
            }
            IAcl wcmAcl = this.wcmAclManager.getAcl(objectId);
            if (wcmAcl == null || !wcmAcl.checkPermission(principal, aclPermission)) {
                if (principal instanceof IUser && ((IUser)principal).hasPermission((Permission)new AclManagerPermission(permission))) {
                    if (trace.beDebug()) {
                        trace.debugT("hasPermission(String, IPrincipal, String)", principal.getDisplayName() + " has AclManagerPermission " + permission + " on object " + objectId);
                    }
                    return true;
                }
                if (trace.beDebug()) {
                    trace.debugT("hasPermission(String, IPrincipal, String)", principal.getDisplayName() + " doesn't have permission " + permission + " on object " + objectId);
                }
                return false;
            }
            if (trace.beDebug()) {
                trace.debugT("hasPermission(String, IPrincipal, String)", principal.getDisplayName() + " has permission " + permission + " on object " + objectId);
            }
            return true;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("hasPermission(String, IPrincipal, String)", (Throwable)((Object)ape));
            throw new UMException((Throwable)((Object)ape));
        }
    }

    public boolean isAllowed(String objectId, IPrincipal principal, String permission) throws UMException {
        boolean result = this.hasPermission(objectId, principal, permission);
        if (result) {
            if (SecurityAudit.isLogged("ACCESS.OK")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Principal", principal.getUniqueID());
                details.put("Permission", permission);
                SecurityAudit.log("ACCESS.OK", objectId, details);
            }
        } else if (SecurityAudit.isLogged("ACCESS.ERROR")) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Principal", principal.getUniqueID());
            details.put("Permission", permission);
            SecurityAudit.log("ACCESS.ERROR", objectId, details);
        }
        return result;
    }

    public boolean isAllowed(String[] objectIds, IPrincipal principal, String permission) throws UMException {
        String methodName = "isAllowed(String[], IPrincipal, String)";
        boolean allowed = true;
        try {
            if (principal == null) {
                String message = "Invalid parameter - principal is 'null'!";
                trace.warningT("isAllowed(String[], IPrincipal, String)", message);
                throw new UMException(message);
            }
            IAclPermission aclPermission = this.wcmAclManager.getPermission(permission);
            if (aclPermission == null) {
                String message = "Invalid parameter - permission doesn't exist: " + permission;
                trace.warningT("isAllowed(String[], IPrincipal, String)", message);
                throw new UMException(message);
            }
            StringBuffer ids = new StringBuffer();
            int i = 0;
            while (i < objectIds.length) {
                if (i != 0) {
                    ids.append(", ");
                }
                ids.append(objectIds[i]);
                ++i;
            }
            if (serviceUserID != null && serviceUserID.equals(principal.getUniqueID())) {
                if (trace.beInfo()) {
                    trace.infoT("isAllowed(String[], IPrincipal, String)", "Principal is the registered service user -> has all ACL permissions");
                }
                return true;
            }
            IAcl[] wcmAcls = this.wcmAclManager.getAcls(objectIds);
            IAclPermission wcmPermission = this.wcmAclManager.getPermission(permission);
            int i2 = 0;
            while (i2 < wcmAcls.length) {
                if (wcmAcls[i2] == null || !wcmAcls[i2].checkPermission(principal, wcmPermission)) {
                    allowed = false;
                    break;
                }
                ++i2;
            }
            if (allowed) {
                if (SecurityAudit.isLogged("ACCESS.OK")) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Principal", principal.getUniqueID());
                    details.put("Permission", permission);
                    SecurityAudit.log("ACCESS.OK", ids.toString(), details);
                }
                return true;
            }
            if (principal instanceof IUser && ((IUser)principal).hasPermission((Permission)new AclManagerPermission(permission))) {
                if (SecurityAudit.isLogged("ACCESS.OK")) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Principal", principal.getUniqueID());
                    details.put("Permission", permission);
                    SecurityAudit.log("ACCESS.OK", ids.toString(), details);
                }
                return true;
            }
            if (SecurityAudit.isLogged("ACCESS.ERROR")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Principal", principal.getUniqueID());
                details.put("Permission", permission);
                SecurityAudit.log("ACCESS.ERROR", ids.toString(), details);
            }
            return false;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("isAllowed(String[], IPrincipal, String)", (Throwable)((Object)ape));
            throw new UMException((Throwable)((Object)ape));
        }
    }

    public boolean addPermission(String permission, List members) throws UMException {
        String methodName = "addPermission(...)";
        try {
            if (this.wcmAclManager.getPermission(permission) != null) {
                trace.infoT("addPermission(...)", "Permission: " + permission + " already exists!");
                return false;
            }
            IAclPermission newPermission = this.wcmAclManager.createPermission(permission);
            if (!this.wcmAclManager.addSupportedPermission(LEAF_OBJECT_TYPE, newPermission)) {
                trace.warningT("addPermission(...)", "Permission " + permission + " couldn't be added!");
                return false;
            }
            if (trace.beDebug()) {
                trace.debugT("addPermission(...)", "Permission " + permission + " created.");
            }
            if (members != null) {
                int i = 0;
                while (i < members.size()) {
                    IAclPermission memberPerm = this.wcmAclManager.getPermission((String)members.get(i));
                    if (memberPerm == null) {
                        trace.warningT("addPermission(...)", "Couldn't add member " + (String)members.get(i) + " to permission " + permission);
                    } else {
                        newPermission.addMember(memberPerm);
                        if (trace.beDebug()) {
                            trace.debugT("addPermission(...)", "Member " + (String)members.get(i) + " added to permission " + permission);
                        }
                    }
                    ++i;
                }
            }
            ((JDBCAclManager)this.wcmAclManager).clearPermissionCache();
            return true;
        }
        catch (AclException exc) {
            trace.errorT("addPermission(...)", (Throwable)((Object)exc));
            throw new UMException("Couldn't add permission " + permission + " because of " + ((Throwable)((Object)exc)).toString());
        }
    }

    public boolean addPermissionMember(String permission, String member) throws UMException {
        String methodName = "addPermissionMember(...)";
        try {
            IAclPermission perm = null;
            perm = this.wcmAclManager.getPermission(permission);
            if (perm == null) {
                trace.infoT("addPermissionMember(...)", "Permission: " + permission + " doesn't exists!");
                return false;
            }
            IAclPermission memberPerm = this.wcmAclManager.getPermission(member);
            if (memberPerm == null) {
                trace.warningT("addPermissionMember(...)", "Member permission " + member + " doesn't exist!");
                return false;
            }
            if (perm.isMember(memberPerm)) {
                trace.infoT("addPermissionMember(...)", member + " is already a member of permission " + permission);
            } else {
                perm.addMember(memberPerm);
                if (trace.beDebug()) {
                    trace.debugT("addPermissionMember(...)", "Member " + member + " added to permission " + permission);
                }
                ((JDBCAclManager)this.wcmAclManager).clearPermissionCache();
            }
            return true;
        }
        catch (AclException exc) {
            trace.errorT("addPermissionMember(...)", (Throwable)((Object)exc));
            throw new UMException("Couldn't add permission member " + member + " because of " + ((Throwable)((Object)exc)).toString());
        }
    }

    public boolean removePermission(String permission) throws UMException {
        String methodName = "removePermission(String)";
        try {
            IAclPermission perm = this.wcmAclManager.getPermission(permission);
            if (perm == null) {
                trace.infoT("removePermission(String)", "Permission " + permission + " not found!");
                return false;
            }
            if (this.wcmAclManager.removeSupportedPermission(LEAF_OBJECT_TYPE, perm) && this.wcmAclManager.removePermission(perm)) {
                if (trace.beDebug()) {
                    trace.debugT("removePermission(String)", "Permission " + permission + " removed!");
                }
                ((JDBCAclManager)this.wcmAclManager).clearPermissionCache();
                return true;
            }
            trace.infoT("removePermission(String)", "Permission" + permission + " couldn't be removed!");
            return false;
        }
        catch (AclException exc) {
            trace.errorT("removePermission(String)", (Throwable)((Object)exc));
            throw new UMException("Couldn't remove permission " + permission + " because of " + ((Throwable)((Object)exc)).toString());
        }
    }

    public List getPermissions(String objectType) throws UMException {
        String methodName = "getPermissions(String)";
        if (objectType == null) {
            throw new IllegalArgumentException("objectType must not be null!");
        }
        List allPerm = this.getAllPermissions();
        boolean globalPermissions = objectType.length() == 0;
        int i = allPerm.size() - 1;
        while (i >= 0) {
            int separatorIdx = ((String)allPerm.get(i)).indexOf(46);
            if (globalPermissions) {
                if (separatorIdx != -1) {
                    allPerm.remove(i);
                }
            } else if (separatorIdx < 0 || !objectType.equals(((String)allPerm.get(i)).substring(0, separatorIdx))) {
                allPerm.remove(i);
            }
            --i;
        }
        if (globalPermissions) {
            trace.infoT("getPermissions(String)", "Got all global permissions.");
        } else {
            trace.infoT("getPermissions(String)", "Got all permissions for object type: " + objectType);
        }
        return allPerm;
    }

    public List getAllPermissions() throws UMException {
        String methodName = "getAllPermissions()";
        try {
            IAclPermissionList allPermList = this.wcmAclManager.getSupportedPermissions(LEAF_OBJECT_TYPE);
            int size = allPermList.size();
            ArrayList<String> allPerm = new ArrayList<String>(size);
            IAclPermissionListIterator permissions = allPermList.iterator();
            int i = 0;
            while (i < size) {
                allPerm.add(permissions.next().getName());
                ++i;
            }
            trace.infoT("getAllPermissions()", "Got all permissions");
            return allPerm;
        }
        catch (AclException exc) {
            trace.errorT("getAllPermissions()", "Couldn't get all permissions", (Throwable)((Object)exc));
            throw new UMException("Couldn't get all permissions because of " + ((Throwable)((Object)exc)).toString());
        }
    }

    public PermissionStatus getPermissionStatus(String objectId, IPrincipal principal, String permission) throws UMException {
        com.sap.security.api.acl.IAcl acl = this.getAcl(objectId);
        if (acl == null) {
            return PermissionStatus.IS_UNDEFINED;
        }
        if (acl.isOwner(principal) || acl.isAllowed(principal, permission)) {
            return PermissionStatus.IS_ALLOWED;
        }
        return PermissionStatus.IS_DENIED;
    }

    public void deletePrincipal(IPrincipal principal) throws UMException {
        if (principal == null) {
            throw new UMException("principal is NULL!");
        }
        this.deletePrincipal(principal.getUniqueID());
    }

    public void deletePrincipal(String principalID) throws UMException {
        try {
            this.wcmAclManager.deletePrincipal(principalID);
        }
        catch (AclPersistenceException ape) {
            trace.errorT("deletePrincipal(String)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public List getAllAcls() throws UMException {
        try {
            return this.wcmAclManager.getAllAcls();
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getAllAcls()", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public List searchAcls(String id) throws UMException {
        try {
            return this.wcmAclManager.searchAcls(id);
        }
        catch (AclPersistenceException ape) {
            trace.errorT("searchAcls(String id)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean removePermissionMember(String permission, String member) throws UMException {
        String methodName = "removePermissionMember(String permission, String member)";
        IAclPermission parent = this.wcmAclManager.getPermission(permission);
        if (parent == null) {
            String message = "Invalid parameter - permission doesn't exist: " + permission;
            trace.warningT(methodName, message);
            throw new UMException(message);
        }
        IAclPermission child = this.wcmAclManager.getPermission(member);
        if (child == null) {
            String message = "Invalid parameter - permission doesn't exist: " + permission;
            trace.warningT(methodName, message);
            throw new UMException(message);
        }
        return parent.removeMember(child);
    }

    public List getPermissionMembers(String permission) throws UMException {
        String methodName = "getPermissionMembers(String permission)";
        IAclPermission parent = this.wcmAclManager.getPermission(permission);
        if (parent == null) {
            String message = "Invalid parameter - permission doesn't exist: " + permission;
            trace.warningT(methodName, message);
            throw new UMException(message);
        }
        IAclPermissionList wcmList = parent.getMembers();
        IAclPermissionListIterator wcmIt = wcmList.iterator();
        ArrayList<String> members = new ArrayList<String>(wcmList.size());
        while (wcmIt.hasNext()) {
            members.add(wcmIt.next().getName());
        }
        return members;
    }
}

