/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.UMException;
import com.sap.security.api.acl.IAcl;
import com.sap.security.api.acl.IAclEntry;
import com.sap.security.api.acl.IAclHierarchy;
import com.sap.security.api.acl.IAclManager;
import com.sap.security.api.acl.PermissionStatus;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.Iterator;
import java.util.List;

public class AclHierarchy
implements IAclHierarchy {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclHierarchy.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclHierarchy.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private IAclManager manager;

    public AclHierarchy(IAclManager manager) {
        this.manager = manager;
    }

    public boolean isAllowed(String[] objectIds, IPrincipal principal, String permission) throws UMException {
        int i = 0;
        while (i < objectIds.length) {
            if (this.manager.getPermissionStatus(objectIds[i], principal, permission) == PermissionStatus.IS_ALLOWED) {
                return true;
            }
            if (this.manager.getPermissionStatus(objectIds[i], principal, permission) == PermissionStatus.IS_DENIED) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void propagade(IPrincipal caller, String rootObjectID, String[] childrenObjectIds) throws UMException {
        IAcl rootAcl = this.manager.getAcl(rootObjectID);
        List rootAclEntries = rootAcl.getAclEntries();
        int i = 0;
        while (i < childrenObjectIds.length) {
            IAcl childAcl = this.manager.getAcl(childrenObjectIds[i]);
            Iterator childAclEntriesIterator = childAcl.getAclEntries().iterator();
            while (childAclEntriesIterator.hasNext()) {
                IAclEntry childAclEntry = (IAclEntry)childAclEntriesIterator.next();
                if (!childAclEntry.isInherited()) continue;
                childAcl.removeAclEntry(caller, childAclEntry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < childrenObjectIds.length) {
            IAcl childAcl = this.manager.getAcl(childrenObjectIds[i2]);
            Iterator rootAclEntriesIterator = rootAclEntries.iterator();
            while (rootAclEntriesIterator.hasNext()) {
                IAclEntry rootAclEntry = (IAclEntry)rootAclEntriesIterator.next();
                childAcl.createAclEntry(caller, rootAclEntry.getPrincipal(), rootAclEntry.getPermission(), true);
            }
            ++i2;
        }
    }

    public void checkPermission(String[] objectIds, IPrincipal principal, String permission) throws UMException {
        if (!this.isAllowed(objectIds, principal, permission)) {
            trace.errorT("checkPermission(objectIds, principal, permission)", "UMException");
            throw new UMException("Principal has no permission to perform this action.");
        }
    }
}

