/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclManager;
import com.sap.security.core.util.IUMTrace;

public class AclEntry
implements com.sap.security.api.acl.IAclEntry {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclEntry.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/AclEntry.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private IAclEntry wcmAclEntry;
    private IAclManager wcmAclManager;

    protected AclEntry(IAclEntry wcmAclEntry, IAclManager wcmAclManager) throws UMException {
        if (wcmAclEntry == null || wcmAclManager == null) {
            throw new UMException("wcmAclEntry or wcmAclManager is null!");
        }
        this.wcmAclManager = wcmAclManager;
        this.wcmAclEntry = wcmAclEntry;
    }

    public IPrincipal getPrincipal() {
        String methodName = "getPrincipal()";
        try {
            return this.wcmAclEntry.getPrincipal();
        }
        catch (UMException ume) {
            trace.errorT("getPrincipal()", ume);
            return null;
        }
    }

    public String getPermission() {
        try {
            return this.wcmAclEntry.getPermission().getName();
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getPermission()", (Throwable)((Object)ape));
            return null;
        }
    }

    public boolean isAllowed(String permission) {
        try {
            return this.wcmAclEntry.checkPermission(this.wcmAclManager.getPermission(permission));
        }
        catch (AclPersistenceException ape) {
            trace.errorT("isAllowed(String)", (Throwable)((Object)ape));
            return false;
        }
    }

    public boolean isInherited() {
        try {
            return this.wcmAclEntry.isPropagated();
        }
        catch (AclPersistenceException ape) {
            trace.errorT("isInherited()", (Throwable)((Object)ape));
            return false;
        }
    }

    public IAclEntry getWcmAclEntry() {
        return this.wcmAclEntry;
    }
}

