/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.acl.imp;

import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.acl.imp.AclEntry;
import com.sap.security.core.acl.imp.AclManager;
import com.sap.security.core.acl.imp.AclManagerPermission;
import com.sap.security.core.acl.imp.wcm.AclException;
import com.sap.security.core.acl.imp.wcm.AclPersistenceException;
import com.sap.security.core.acl.imp.wcm.IAcl;
import com.sap.security.core.acl.imp.wcm.IAclEntry;
import com.sap.security.core.acl.imp.wcm.IAclEntryListIterator;
import com.sap.security.core.acl.imp.wcm.IAclManager;
import com.sap.security.core.acl.imp.wcm.IAclPermission;
import com.sap.security.core.acl.imp.wcm.IPrincipalListIterator;
import com.sap.security.core.acl.imp.wcm.jdbc.JDBCAcl;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Acl
implements com.sap.security.api.acl.IAcl {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/Acl.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    public static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/acl/imp/Acl.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    private IAcl wcmAcl;
    private IAclManager wcmAclManager;

    protected Acl(IAcl wcmAcl, IAclManager wcmAclManager) throws UMException {
        if (wcmAcl == null || wcmAclManager == null) {
            throw new UMException("wcmAcl or wcmAclManager is null!");
        }
        this.wcmAcl = wcmAcl;
        this.wcmAclManager = wcmAclManager;
    }

    public boolean addOwner(IPrincipal caller, IPrincipal principal) throws UMException {
        String methodName = "addOwner(IPrincipal, IPrincipal)";
        try {
            if (this.wcmAcl.addOwner(caller, principal)) {
                if (this.createAclEntry(caller, principal, "owner", false) == null) {
                    if (trace.beInfo()) {
                        trace.infoT("addOwner(IPrincipal, IPrincipal)", principal.getUniqueID() + " is already owner of ACL: " + this.getObjectId());
                    }
                    return true;
                }
                if (SecurityAudit.isLogged("ACL.MODIFY")) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("added owner", principal.getUniqueID());
                    SecurityAudit.log("ACL.MODIFY", this.getObjectId(), details);
                }
                return true;
            }
            return false;
        }
        catch (AclException ape) {
            trace.errorT("addOwner(IPrincipal, IPrincipal)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean removeOwner(IPrincipal caller, IPrincipal principal) throws UMException {
        String methodName = "removeOwner(IPrincipal, IPrincipal)";
        try {
            if (this.wcmAcl.removeOwner(caller, principal)) {
                List aclEntries = this.getAclEntries(principal);
                int i = 0;
                while (i < aclEntries.size()) {
                    com.sap.security.api.acl.IAclEntry aclEntry = (com.sap.security.api.acl.IAclEntry)aclEntries.get(i);
                    if (aclEntry.getPermission().equals("owner")) {
                        if (!this.removeAclEntry(caller, aclEntry)) {
                            trace.errorT("removeOwner(IPrincipal, IPrincipal)", "Couldn't remove the owner permission - ACL: " + this.getObjectId() + ", owner: " + principal.getUniqueID());
                        } else {
                            if (SecurityAudit.isLogged("ACL.MODIFY")) {
                                HashMap<String, String> details = new HashMap<String, String>();
                                details.put("removed owner", principal.getUniqueID());
                                SecurityAudit.log("ACL.MODIFY", this.getObjectId(), details);
                            }
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
        catch (AclException ape) {
            trace.errorT("removeOwner(IPrincipal, IPrincipal)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean isOwner(IPrincipal principal) throws UMException {
        try {
            return this.wcmAcl.isOwner(principal);
        }
        catch (AclPersistenceException ape) {
            trace.errorT("isOwner(IPrincipal)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public List getOwners() throws UMException {
        try {
            IPrincipalListIterator iterator = this.wcmAcl.getOwners().iterator();
            ArrayList<IPrincipal> principals = new ArrayList<IPrincipal>();
            while (iterator.hasNext()) {
                principals.add(iterator.next());
            }
            return principals;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getOwners()", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public com.sap.security.api.acl.IAclEntry createAclEntry(IPrincipal caller, IPrincipal principal, String permission, boolean isInherited) throws UMException {
        String methodName = "createAclEntry(IPrincipal, IPrincipal, String, boolean)";
        try {
            int sortIndex = principal instanceof IPrincipalSet ? 1 : 0;
            IAclEntry aclEntry = this.wcmAclManager.createAclEntry(principal, false, this.wcmAclManager.getPermission(permission), sortIndex, isInherited);
            boolean success = this.wcmAcl.addEntry(caller, aclEntry);
            if (trace.beDebug()) {
                trace.debugT("createAclEntry(IPrincipal, IPrincipal, String, boolean)", "Removing ACL from cache, ACL ID: " + this.wcmAcl.getID());
            }
            this.wcmAclManager.cacheRemoveAcl(this.wcmAcl.getID());
            if (success) {
                if (SecurityAudit.isLogged("ACL.MODIFY")) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("added ACE (principal)", principal.getUniqueID());
                    details.put("added ACE (permission)", permission);
                    SecurityAudit.log("ACL.MODIFY", this.getObjectId(), details);
                }
                return new AclEntry(aclEntry, this.wcmAclManager);
            }
            return null;
        }
        catch (AclException ape) {
            trace.errorT("createAclEntry(IPrincipal, IPrincipal, String, boolean)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean removeAclEntry(IPrincipal caller, com.sap.security.api.acl.IAclEntry aclEntry) throws UMException {
        String methodName = "removeAclEntry(IPrincipal, IAclEntry)";
        try {
            boolean success = this.wcmAcl.removeEntry(caller, ((AclEntry)aclEntry).getWcmAclEntry());
            if (trace.beDebug()) {
                trace.debugT("removeAclEntry(IPrincipal, IAclEntry)", "Removing ACL from cache, ACL ID: " + this.wcmAcl.getID());
            }
            this.wcmAclManager.cacheRemoveAcl(this.wcmAcl.getID());
            if (success && SecurityAudit.isLogged("ACL.MODIFY")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("removed ACE (principal)", aclEntry.getPrincipal().getUniqueID());
                details.put("removed ACE (permission)", aclEntry.getPermission());
                SecurityAudit.log("ACL.MODIFY", this.getObjectId(), details);
            }
            return success;
        }
        catch (AclException ape) {
            trace.errorT("removeAclEntry(IPrincipal, IAclEntry)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public void resetAcl(IPrincipal caller) throws UMException {
        String methodName = "resetAcl(IPrincipal)";
        try {
            IAclEntryListIterator iterator = this.wcmAcl.getEntries().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                IAclEntry entry = iterator.next();
                if (entry.getPermission().getName().equals("owner")) continue;
                this.wcmAcl.removeEntry(caller, entry);
                ++count;
            }
            if (SecurityAudit.isLogged("ACL.MODIFY")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Reset ACL", count + " ACE's removed");
                SecurityAudit.log("ACL.MODIFY", this.getObjectId(), details);
            }
            if (trace.beDebug()) {
                trace.debugT("resetAcl(IPrincipal)", "Removing ACL from cache, ACL ID: " + this.wcmAcl.getID());
            }
            this.wcmAclManager.cacheRemoveAcl(this.wcmAcl.getID());
        }
        catch (AclException ape) {
            trace.errorT("resetAcl(IPrincipal)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public List getAclEntries() throws UMException {
        try {
            IAclEntryListIterator iterator = this.wcmAcl.getEntries().iterator();
            ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
            while (iterator.hasNext()) {
                aclEntries.add(new AclEntry(iterator.next(), this.wcmAclManager));
            }
            return aclEntries;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getAclEntries()", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public List getAclEntries(IPrincipal principal) throws UMException {
        try {
            IAclEntryListIterator iterator = this.wcmAcl.getEntries(principal).iterator();
            ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
            while (iterator.hasNext()) {
                aclEntries.add(new AclEntry(iterator.next(), this.wcmAclManager));
            }
            return aclEntries;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("getAclEntries(IPrincipal)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean hasPermission(IPrincipal principal, String permission) throws UMException {
        String methodName = "hasPermission(IPrincipal, String)";
        try {
            if (principal == null) {
                String message = "Invalid parameter - principal is 'null'!";
                trace.warningT("hasPermission(IPrincipal, String)", message);
                throw new UMException(message);
            }
            IAclPermission aclPermission = this.wcmAclManager.getPermission(permission);
            if (aclPermission == null) {
                String message = "Invalid parameter - permission doesn't exist: " + permission;
                trace.warningT("hasPermission(IPrincipal, String)", message);
                throw new UMException(message);
            }
            if (AclManager.serviceUserID != null && AclManager.serviceUserID.equals(principal.getUniqueID())) {
                if (trace.beInfo()) {
                    trace.infoT("hasPermission(IPrincipal, String)", "Principal is the registered service user -> has all ACL permissions");
                }
                return true;
            }
            if (this.wcmAcl.checkPermission(principal, aclPermission)) {
                if (trace.beDebug()) {
                    trace.debugT("hasPermission(IPrincipal, String)", principal.getDisplayName() + " has permission " + permission);
                }
                return true;
            }
            if (principal instanceof IUser && ((IUser)principal).hasPermission((Permission)new AclManagerPermission(permission))) {
                if (trace.beDebug()) {
                    trace.debugT("hasPermission(IPrincipal, String)", principal.getDisplayName() + " has AclManagerPermission " + permission);
                }
                return true;
            }
            if (trace.beDebug()) {
                trace.debugT("hasPermission(IPrincipal, String)", principal.getDisplayName() + " doesn't have permission " + permission);
            }
            return false;
        }
        catch (AclPersistenceException ape) {
            trace.errorT("hasPermission(IPrincipal, String)", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public boolean isAllowed(IPrincipal principal, String permission) throws UMException {
        boolean result = this.hasPermission(principal, permission);
        if (result) {
            if (SecurityAudit.isLogged("ACCESS.OK")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Principal", principal.getUniqueID());
                details.put("Permission", permission);
                SecurityAudit.log("ACCESS.OK", this.getObjectId(), details);
            }
        } else if (SecurityAudit.isLogged("ACCESS.ERROR")) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Principal", principal.getUniqueID());
            details.put("Permission", permission);
            SecurityAudit.log("ACCESS.ERROR", this.getObjectId(), details);
        }
        return result;
    }

    public String getObjectId() {
        return ((JDBCAcl)this.wcmAcl).getID();
    }

    public boolean changeObjectID(IPrincipal caller, String objectId) throws UMException {
        try {
            String oldObjectId = this.getObjectId();
            boolean success = this.wcmAclManager.changeAclID(caller, this.wcmAcl, objectId);
            if (success && SecurityAudit.isLogged("ACL.MODIFY")) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("changed objectID", oldObjectId);
                SecurityAudit.log("ACL.MODIFY", objectId, details);
            }
            return success;
        }
        catch (AclException ape) {
            trace.errorT("Exception", (Throwable)((Object)ape));
            throw new UMException(((Throwable)((Object)ape)).toString());
        }
    }

    public com.sap.security.api.acl.IAcl prepare() throws UMException {
        throw new UMException("Method not yet implemented");
    }

    public void commit() throws UMException {
        throw new UMException("Method not yet implemented");
    }
}

