/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core;

import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.logon.AuthSchemePrincipal;
import com.sap.security.api.session.SessionFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.IEngineResourceHelper;
import com.sap.security.core.logon.imp.AuthSchemeFactory;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.datasource.imp.DataBaseConnectionPool;
import com.sap.security.core.persistence.datasource.imp.J2EEConnectionPool;
import com.sap.security.core.persistence.datasource.imp.J2EEUserTransactionPool;
import com.sap.security.core.role.IServiceRepository;
import com.sap.security.core.session.imp.DefaultSAPSessionFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.Subject;

public class InternalUMFactory {
    public static final int DISTRIBUTABLE_CACHE = 0;
    public static final int SOFT_REFERENCE_CACHE = 1;
    public static final int MOST_RECENTLY_USED_CACHE = 2;
    public static final int NO_CACHE = 3;
    public static final int DEFAULT_CACHE = 4;
    public static final String DISTRIBUTABLE_CACHE_SYMBOL = "distributableCache";
    public static final String SOFT_REFERENCE_CACHE_SYMBOL = "softreferenceCache";
    public static final String MOST_RECENTLY_USED_CACHE_SYMBOL = "mostRecentlyUsedCache";
    public static final String NO_CACHE_CACHE_SYMBOL = "noCache";
    public static final String DEFAULT_CACHE_PROPERTY = "ume.cache.default_cache";
    public static final String SOFTREFERENCE_CACHE_CLASS_PROPERTY = "ume.cache.soft_reference_cache_class";
    public static final String MOSTRECENTLYUSED_CACHE_CLASS_PROPERTY = "ume.cache.most_recently_used_cache_class";
    public static final String DISTRIBUTABLE_CACHE_CLASS_PROPERTY = "ume.cache.distributable_cache_class";
    public static final String NO_CACHE_CACHE_CLASS_PROPERTY = "ume.cache.no_cache_class";
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/InternalUMFactory.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static String _trace;
    private static String _softCache;
    private static String _mostRecentlyUsedCache;
    private static String _distributableCache;
    private static String _noCache;
    private static AuthSchemeFactory _authSchemeFactory;
    private static SessionFactory _sessionFactory;
    private static IServiceRepository _serviceRepository;
    private static Class _serviceRepositoryClass;
    private static IEngineResourceHelper _ierh;
    private static String _httpsPort;
    static /* synthetic */ Class class$com$sap$security$core$role$imp$xml$XMLServiceRepository;
    static /* synthetic */ Class class$com$sap$security$api$UMFactory;
    static /* synthetic */ Class class$com$sap$security$core$InternalUMFactory;

    public static ICache getCache(int type, int initialSize, int maxLifeTimeInSeconds, String owner) {
        return InternalUMFactory.getCache(type, initialSize, maxLifeTimeInSeconds, owner, true);
    }

    public static ICache getCache(int type, int initialSize, int maxLifeTimeInSeconds, String owner, boolean userNotification) {
        ICache mCache = null;
        String className = null;
        switch (type) {
            case 0: {
                className = _distributableCache;
                break;
            }
            case 1: {
                className = _softCache;
                break;
            }
            case 2: {
                className = _mostRecentlyUsedCache;
                break;
            }
            case 3: {
                className = _noCache;
                break;
            }
            default: {
                String defaultCache = UMFactory.getProperties().get(DEFAULT_CACHE_PROPERTY, DISTRIBUTABLE_CACHE_SYMBOL);
                if (defaultCache.equalsIgnoreCase(DISTRIBUTABLE_CACHE_SYMBOL)) {
                    className = _distributableCache;
                    break;
                }
                if (defaultCache.equalsIgnoreCase(SOFT_REFERENCE_CACHE_SYMBOL)) {
                    className = _softCache;
                    break;
                }
                if (defaultCache.equalsIgnoreCase(MOST_RECENTLY_USED_CACHE_SYMBOL)) {
                    className = _mostRecentlyUsedCache;
                    break;
                }
                if (!defaultCache.equalsIgnoreCase(NO_CACHE_CACHE_SYMBOL)) break;
                className = _noCache;
            }
        }
        try {
            Class<?> c = Class.forName(className);
            mCache = (ICache)c.newInstance();
            mCache.initialize(initialSize, maxLifeTimeInSeconds, owner, userNotification);
        }
        catch (ClassNotFoundException cnfex) {
            throw new UMRuntimeException((Throwable)cnfex);
        }
        catch (InstantiationException instex) {
            throw new UMRuntimeException((Throwable)instex);
        }
        catch (IllegalAccessException ilaex) {
            throw new UMRuntimeException((Throwable)ilaex);
        }
        return mCache;
    }

    public static String getDatabaseVendor() {
        IConnectionPool cp = InternalUMFactory.getJdbcConnectionPool();
        if (cp != null) {
            return cp.getDatabaseVendor();
        }
        return "Not accessible";
    }

    public static J2EEUserTransactionPool getUserTransactionPool() {
        Class clazz = class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = InternalUMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory;
        synchronized (clazz) {
            IUMParameters props = UMFactory.getProperties();
            IUMTrace mTrace = InternalUMFactory.getTrace("InternalUMFactory");
            String connectionPool = props.get("ume.db.connection_pool_type");
            if (connectionPool == null) {
                throw new UMRuntimeException("Property \"ume.db.connection_pool_type\" was not found in the properties file");
            }
            if (connectionPool.equalsIgnoreCase("internal")) {
                boolean xaTransactionsUsed = props.getBoolean("ume.db.connection_pool.internal.xatransactions_used", false);
                if (mTrace.beInfo()) {
                    mTrace.infoT("getJdbcConnectionPool", "Using XATransactions: " + xaTransactionsUsed);
                }
                if (!xaTransactionsUsed) {
                    J2EEUserTransactionPool j2EEUserTransactionPool = null;
                    return j2EEUserTransactionPool;
                }
                try {
                    J2EEUserTransactionPool j2EEUserTransactionPool = new J2EEUserTransactionPool();
                    return j2EEUserTransactionPool;
                }
                catch (Exception ex) {
                    throw new UMRuntimeException((Throwable)ex);
                }
            }
            boolean xaTransactionsUsed = props.getBoolean("ume.db.connection_pool.j2ee.xatransactions_used", false);
            if (mTrace.beInfo()) {
                mTrace.infoT("getJdbcConnectionPool", "Using XATransactions: " + xaTransactionsUsed);
            }
            if (!xaTransactionsUsed) {
                J2EEUserTransactionPool ex = null;
                return ex;
            }
            try {
                J2EEUserTransactionPool ex = new J2EEUserTransactionPool();
                return ex;
            }
            catch (Exception ex) {
                throw new UMRuntimeException((Throwable)ex);
            }
        }
    }

    public static IConnectionPool getJdbcConnectionPool() {
        Class clazz = class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = InternalUMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory;
        synchronized (clazz) {
            final IUMParameters props = UMFactory.getProperties();
            IUMTrace mTrace = InternalUMFactory.getTrace("InternalUMFactory");
            String connectionPool = props.get("ume.db.connection_pool_type");
            if (connectionPool == null) {
                throw new UMRuntimeException("Property \"ume.db.connection_pool_type\" was not found in the properties file");
            }
            if (connectionPool.equalsIgnoreCase("internal")) {
                String dataBaseDriver = props.get("ume.db.jdbc_driver");
                String dataBaseUser = props.get("ume.db.jdbc_user");
                String dataBasePassword = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return props.getPassword("ume.db.jdbc_password");
                    }
                });
                String dataBaseUrl = props.get("ume.db.jdbc_url");
                int cpMinSize = props.getNumber("ume.db.connection_pool.internal.minsize", 1);
                int cpMaxSize = props.getNumber("ume.db.connection_pool.internal.maxsize", 30);
                int cpMaxIdleConnections = props.getNumber("ume.db.connection_pool.internal.max_idle_connections", 5);
                int cpMaxIdleTime = props.getNumber("ume.db.connection_pool.internal.max_connection_idle_time", 600000);
                int cpMaxWaitTime = props.getNumber("ume.db.connection_pool.internal.max_wait_process_time", 600000);
                int cpMonitorInterval = props.getNumber("ume.db.connection_pool.internal.monitor_interval", -1);
                int cpConnectRetrials = props.getNumber("ume.db.connection_pool.internal.connect_retrials", 0);
                int cpReleaseInterval = props.getNumber("ume.db.connection_pool.internal.max_connection_usage_time", 600000);
                int cpReleaseCheckInterval = props.getNumber("ume.db.connection_pool.internal.max_connection_usage_time_check_interval", 60000);
                String cpLogPath = props.getFile("ume.db.connection_pool.internal.monitor_path", ".");
                boolean xaTransactionsUsed = props.getBoolean("ume.db.connection_pool.internal.xatransactions_used", false);
                boolean isUnicode = props.getBoolean("ume.db.connection_pool.internal.is_unicode", true);
                boolean isOracleNativeDriverUsed = props.getBoolean("ume.db.connection_pool.internal.oracle_native_driver_used", false);
                if (mTrace.beInfo()) {
                    mTrace.infoT("getJdbcConnectionPool", "Using database driver: " + dataBaseDriver);
                    mTrace.infoT("getJdbcConnectionPool", "Using database url: " + dataBaseUrl);
                    mTrace.infoT("getJdbcConnectionPool", "Using XATransactions: " + xaTransactionsUsed);
                    mTrace.infoT("getJdbcConnectionPool", "Using Unicode: " + isUnicode);
                    mTrace.infoT("getJdbcConnectionPool", "Using Oracle native driver: " + isOracleNativeDriverUsed);
                    mTrace.infoT("getJdbcConnectionPool", "Using database user: " + dataBaseUser);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool Minsize: " + cpMinSize);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool Maxsize: " + cpMaxSize);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool MaxIdleConnections: " + cpMaxIdleConnections);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool MaxIdleTime: " + cpMaxIdleTime);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool MaxWaitTime: " + cpMaxWaitTime);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool MonitorInterval: " + cpMonitorInterval);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool ConnectionRetrials: " + cpConnectRetrials);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool ConnectionReleaseInterval: " + cpReleaseInterval);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool ConnectionReleaseCheckInterval: " + cpReleaseCheckInterval);
                    mTrace.infoT("getJdbcConnectionPool", "Connection pool MonitorPath: " + cpLogPath);
                }
                Hashtable<String, String> mConnectionParameters = new Hashtable<String, String>();
                mConnectionParameters.put("ume.db.jdbc_driver", dataBaseDriver);
                mConnectionParameters.put("ume.db.jdbc_url", dataBaseUrl);
                mConnectionParameters.put("ume.db.jdbc_user", dataBaseUser);
                mConnectionParameters.put("ume.db.jdbc_password", dataBasePassword);
                try {
                    DataBaseConnectionPool dataBaseConnectionPool = new DataBaseConnectionPool("InternalConnectionPool_" + System.currentTimeMillis() + "_cp", cpMinSize, cpMaxSize, cpMaxIdleConnections, cpMaxIdleTime, cpMaxWaitTime, mConnectionParameters, cpConnectRetrials, cpReleaseInterval, cpReleaseCheckInterval, xaTransactionsUsed, isUnicode, isOracleNativeDriverUsed);
                    return dataBaseConnectionPool;
                }
                catch (Exception ex) {
                    throw new UMRuntimeException((Throwable)ex);
                }
            }
            try {
                boolean xaTransactionsUsed = props.getBoolean("ume.db.connection_pool.j2ee.xatransactions_used", false);
                boolean jtaTransactionsSupported = props.getBoolean("ume.db.connection_pool.j2ee.jta_transaction_support_enabled", false);
                boolean isUnicode = props.getBoolean("ume.db.connection_pool.j2ee.is_unicode", true);
                boolean isOracleNativeDriverUsed = props.getBoolean("ume.db.connection_pool.j2ee.oracle_native_driver_used", false);
                if (mTrace.beInfo()) {
                    mTrace.infoT("getJdbcConnectionPool", "Using XATransactions: " + xaTransactionsUsed);
                    mTrace.infoT("getJdbcConnectionPool", "Supporting JTATransactions: " + jtaTransactionsSupported);
                    mTrace.infoT("getJdbcConnectionPool", "Using Unicode: " + isUnicode);
                    mTrace.infoT("getJdbcConnectionPool", "Using Oracle native driver used: " + isOracleNativeDriverUsed);
                    mTrace.infoT("getJdbcConnectionPool", "Try to lookup: " + connectionPool);
                }
                J2EEConnectionPool j2EEConnectionPool = new J2EEConnectionPool(connectionPool, xaTransactionsUsed, jtaTransactionsSupported, isUnicode, isOracleNativeDriverUsed);
                return j2EEConnectionPool;
            }
            catch (Exception ex) {
                throw new UMRuntimeException((Throwable)ex);
            }
        }
    }

    public static IUMTrace getTrace(String versionString, String additionalName) {
        return InternalUMFactory.getTrace(versionString);
    }

    public static IUMTrace getTrace(String versionString) {
        try {
            IUMTrace tracer = (IUMTrace)InternalUMFactory.instantiateClass(_trace);
            if (tracer == null) {
                tracer = (IUMTrace)InternalUMFactory.instantiateClass("com.sap.security.core.util.imp.UMTrace");
            }
            tracer.init(versionString);
            return tracer;
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e);
        }
    }

    private static Object instantiateClass(String className) throws Exception {
        Object obj = null;
        Class<?> c = Class.forName(className);
        obj = c.newInstance();
        return obj;
    }

    public static IServiceRepository getServiceRepository() {
        Class clazz = class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = InternalUMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory;
        synchronized (clazz) {
            if (_serviceRepository == null) {
                try {
                    _serviceRepository = (IServiceRepository)_serviceRepositoryClass.newInstance();
                }
                catch (Exception e) {
                    System.err.println("getServiceRepository() -> Failed for class: " + _serviceRepositoryClass.getName());
                    throw new UMRuntimeException((Throwable)e, "getServiceRepository() failed");
                }
            }
            IServiceRepository iServiceRepository = _serviceRepository;
            return iServiceRepository;
        }
    }

    public static AuthSchemeFactory getAuthSchemeFactory() {
        if (_authSchemeFactory == null) {
            String moduleFile = UMFactory.getProperties().get("login.authschemes.definition.file", "authschemes.xml");
            _authSchemeFactory = new AuthSchemeFactory(UMFactory.getProperties().getInputStream(moduleFile));
        }
        return _authSchemeFactory;
    }

    public static SessionFactory getSessionFactory() {
        if (_sessionFactory == null) {
            ClassLoader cl = null;
            try {
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((class$com$sap$security$core$InternalUMFactory == null ? (class$com$sap$security$core$InternalUMFactory = InternalUMFactory.class$("com.sap.security.core.InternalUMFactory")) : class$com$sap$security$core$InternalUMFactory).getClassLoader());
                    _sessionFactory = SessionFactory.getInstance((Properties)UMFactory.getProperties().getProperties());
                }
                catch (Exception ex) {
                    IUMTrace mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
                    if (mTrace != null && mTrace.beDebug()) {
                        mTrace.debugT("getSessionFactory", "getSessionFactory() -> Failed for SessionFactory class: " + ex.getMessage(), ex);
                    }
                    _sessionFactory = DefaultSAPSessionFactory.getInstance(UMFactory.getProperties().getProperties());
                    Object var4_2 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                }
                Object var4_1 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
        }
        return _sessionFactory;
    }

    public static IEngineResourceHelper getEngineResourceHelper() {
        return _ierh;
    }

    public static void setEngineResourceHelper(IEngineResourceHelper ierh) {
        _ierh = ierh;
    }

    public static String getUserThreadAttribute() {
        Subject subject;
        IEngineResourceHelper ierh = InternalUMFactory.getEngineResourceHelper();
        if (ierh != null && (subject = ierh.getCurrentSubject()) != null) {
            Iterator<Principal> it = subject.getPrincipals().iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                if (p instanceof AuthSchemePrincipal) continue;
                return p.getName();
            }
        }
        return null;
    }

    public static String getHttpsPort() {
        return _httpsPort;
    }

    public static void setHttpsPort(String port) {
        _httpsPort = port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _authSchemeFactory = null;
        _sessionFactory = null;
        _serviceRepository = null;
        _httpsPort = null;
        _trace = UMFactory.getProperties().get("traceClass", "com.sap.security.core.util.imp.UMTrace");
        _softCache = UMFactory.getProperties().get(SOFTREFERENCE_CACHE_CLASS_PROPERTY, "com.sap.security.core.util.cache.SoftCache");
        _noCache = UMFactory.getProperties().get(NO_CACHE_CACHE_CLASS_PROPERTY, "com.sap.security.core.util.cache.NoCachingCache");
        _mostRecentlyUsedCache = UMFactory.getProperties().get(MOSTRECENTLYUSED_CACHE_CLASS_PROPERTY, "com.sap.security.core.util.cache.MostRecentlyUsedCache");
        _distributableCache = UMFactory.getProperties().get(DISTRIBUTABLE_CACHE_CLASS_PROPERTY, "com.sap.security.core.util.cache.BaseTechCacheWrapper");
        _serviceRepositoryClass = class$com$sap$security$core$role$imp$xml$XMLServiceRepository == null ? (class$com$sap$security$core$role$imp$xml$XMLServiceRepository = InternalUMFactory.class$("com.sap.security.core.role.imp.xml.XMLServiceRepository")) : class$com$sap$security$core$role$imp$xml$XMLServiceRepository;
    }
}

