/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.model.projects.proxy.impl;

import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.model.projects.impl.WebServiceProject;
import com.sap.ide.ws.model.projects.proxy.IProxyProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ProxyProject
extends WebServiceProject
implements IProxyProject {
    ProxyProject(IProject project) {
        super(project);
    }

    public static IProxyProject getInstance(IProject project) {
        if (project != null && project.isAccessible() && WebServiceFilterFactory.isStandaloneProxyOrStandaloneProxyDCProject((IProject)project)) {
            return new ProxyProject(project);
        }
        return null;
    }

    public IFile[] getClientApiJarFiles() {
        if (this.isDcProject()) {
            ArrayList foundFiles = new ArrayList();
            IFolder genFolder = this.getProject().getFolder("gen");
            if (genFolder != null && genFolder.exists()) {
                this.searchResourceByFilter(genFolder, foundFiles, new WebServiceProject.ResourceFilter(){

                    public boolean accept(IResource resource) {
                        return resource instanceof IFile && resource.getName().endsWith("ClientAPI.jar");
                    }
                });
            }
            return foundFiles.toArray(new IFile[foundFiles.size()]);
        }
        IFile file = this.getProject().getFile(this.getProject().getName() + "ClientAPI.jar");
        if (file.exists()) {
            return new IFile[]{file};
        }
        return null;
    }
}

