/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.model.projects.proxy.impl;

import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.model.projects.impl.WebServiceProject;
import com.sap.ide.ws.model.projects.proxy.IDeployableProxyProject;
import com.sap.ide.ws.model.projects.proxy.IProxyProject;
import com.sap.ide.ws.model.projects.proxy.impl.ProxyProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DeployableProxyProject
extends ProxyProject
implements IDeployableProxyProject {
    DeployableProxyProject(IProject project) {
        super(project);
    }

    public static IProxyProject getInstance(IProject project) {
        if (project != null && project.isAccessible() && WebServiceFilterFactory.isDeployableProxyOrDeployableProxyDCProject((IProject)project)) {
            return new DeployableProxyProject(project);
        }
        return null;
    }

    public IFile getDeployableArchiveFile() {
        if (this.isDcProject()) {
            ArrayList foundFiles = new ArrayList();
            IFolder genFolder = this.getProject().getFolder("gen");
            if (genFolder != null && genFolder.exists()) {
                this.searchResourceByFilter(genFolder, foundFiles, new WebServiceProject.ResourceFilter(){

                    public boolean accept(IResource resource) {
                        return resource instanceof IFile && resource.getName().endsWith(".ear") && resource.getParent().getName().equals("deploy");
                    }
                });
            }
            if (foundFiles.size() > 0) {
                return foundFiles.toArray(new IFile[foundFiles.size()])[0];
            }
        }
        return null;
    }
}

