/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.model.projects.java.impl;

import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.model.projects.impl.WebServiceProject;
import com.sap.ide.ws.model.projects.java.IJavaProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class JavaProject
extends WebServiceProject
implements IJavaProject {
    JavaProject(IProject project) {
        super(project);
    }

    public static IJavaProject getInstance(IProject project) {
        if (project != null && project.isAccessible() && WebServiceFilterFactory.isJavaOrJavaDcProject((IProject)project)) {
            return new JavaProject(project);
        }
        return null;
    }

    public IFile getDeployableArchiveFile() {
        if (this.isDcProject()) {
            ArrayList foundFiles = new ArrayList();
            IFolder genFolder = this.getProject().getFolder("gen");
            if (genFolder != null && genFolder.exists()) {
                this.searchResourceByFilter(genFolder, foundFiles, new WebServiceProject.ResourceFilter(){

                    public boolean accept(IResource resource) {
                        return resource instanceof IFile && resource.getName().endsWith(".ear") && resource.getParent().getName().equals("deploy");
                    }
                });
            }
            if (foundFiles.size() > 0) {
                return foundFiles.toArray(new IFile[foundFiles.size()])[0];
            }
        }
        return null;
    }
}

