/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.model.projects.impl;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.model.projects.IWebServiceProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class WebServiceProject
implements IWebServiceProject {
    protected static final String DC_BUILD_OUTPUT_FOLDER = "gen";
    protected static final String CLIENT_API_JAR_NAME = "ClientAPI.jar";
    private IProject mProject;

    public WebServiceProject(IProject project) {
        this.mProject = project;
    }

    public IProject getProject() {
        return this.mProject;
    }

    public String getProjectName() {
        return this.mProject.getName();
    }

    public boolean isDcProject() {
        return WebServiceFilterFactory.isDcProject((IProject)this.getProject());
    }

    protected void searchResourceByFilter(IFolder root, ArrayList list, ResourceFilter filter) {
        IResource[] resources = new IResource[]{};
        try {
            resources = root.members();
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        int i = 0;
        while (i < resources.length) {
            if (filter.accept(resources[i])) {
                list.add(resources[i]);
            }
            if (resources[i] instanceof IFolder) {
                this.searchResourceByFilter((IFolder)resources[i], list, filter);
            }
            ++i;
        }
    }

    protected abstract class ResourceFilter {
        protected ResourceFilter() {
        }

        public abstract boolean accept(IResource var1);
    }
}

