/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.wizards;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.wizards.DocGenWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class SelectPeripheralsWizardPage
extends WizardPage {
    private static DocGenResources rb = DocGenWizard.rb;
    private Text textProjectName = null;
    protected List listPeripheralsAvailable = null;
    protected List listPeripheralsAdded = null;
    private Button buttonAdd = null;
    private Button buttonRemove = null;
    private IStructuredSelection selection;
    private IProject project = null;

    public SelectPeripheralsWizardPage(String pageName, IProject project, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite compositeMain = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        compositeMain.setLayout((Layout)layout);
        compositeMain.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(compositeMain);
        this.createPeripheralsGroup(compositeMain);
        this.buttonAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectPeripheralsWizardPage.this.addPeripheral();
            }
        });
        this.buttonRemove.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectPeripheralsWizardPage.this.removePeripheral();
            }
        });
        this.listPeripheralsAvailable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectPeripheralsWizardPage.this.enableDisableComponents();
            }
        });
        this.listPeripheralsAdded.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectPeripheralsWizardPage.this.enableDisableComponents();
            }
        });
        this.initialize();
        this.enableDisableComponents();
        this.setControl((Control)compositeMain);
        this.listPeripheralsAvailable.setFocus();
        parent.pack();
        if (this.buttonRemove.getSize().x > this.buttonAdd.getSize().x) {
            this.buttonAdd.setSize(this.buttonRemove.getSize());
        } else {
            this.buttonRemove.setSize(this.buttonAdd.getSize());
        }
    }

    public String getProjectName() {
        return this.textProjectName.getText();
    }

    public String[] getAddedPeripherals() {
        return this.listPeripheralsAdded.getItems();
    }

    public String[] getRemovedPeripherals() {
        return this.listPeripheralsAvailable.getItems();
    }

    private void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        projectGroup.setLayout((Layout)new GridLayout(2, false));
        projectGroup.setLayoutData((Object)new GridData(768));
        Label labelProjectHeader = new Label(projectGroup, 0);
        labelProjectHeader.setText(rb.getString("select_peripheral.page.current_project"));
        this.textProjectName = new Text(projectGroup, 8);
        this.textProjectName.setLayoutData((Object)new GridData(768));
    }

    private void createPeripheralsGroup(Composite parent) {
        Composite compositeMain = new Composite(parent, 0);
        compositeMain.setLayoutData((Object)new GridData(1808));
        compositeMain.setLayout((Layout)new GridLayout(3, false));
        Label separator = new Label(compositeMain, 258);
        separator.setLayoutData((Object)this.getGridData(768, 3));
        Composite compositePeripheralsAvailable = new Composite(compositeMain, 0);
        compositePeripheralsAvailable.setLayoutData((Object)new GridData(1808));
        compositePeripheralsAvailable.setLayout((Layout)new GridLayout(1, false));
        Label labelPeripheralsAvailable = new Label(compositePeripheralsAvailable, 0);
        labelPeripheralsAvailable.setText(rb.getString("select_peripheral.page.peripherals_available"));
        labelPeripheralsAvailable.setLayoutData((Object)this.getGridData(0, 1));
        this.listPeripheralsAvailable = new List(compositePeripheralsAvailable, 2050);
        this.listPeripheralsAvailable.setLayoutData((Object)this.getGridData(1808, 1));
        Composite compositeButtons = new Composite(compositeMain, 0);
        compositeButtons.setLayout((Layout)new GridLayout(1, false));
        this.buttonAdd = new Button(compositeButtons, 0);
        this.buttonAdd.setLayoutData((Object)this.getGridData(0, 1));
        this.buttonAdd.setText(rb.getString("select_peripheral.page.button.add"));
        this.buttonAdd.setToolTipText(rb.getString("select_peripheral.page.button.tooltip.add"));
        this.buttonRemove = new Button(compositeButtons, 0);
        this.buttonRemove.setLayoutData((Object)this.getGridData(0, 1));
        this.buttonRemove.setText(rb.getString("select_peripheral.page.button.remove"));
        this.buttonRemove.setToolTipText(rb.getString("select_peripheral.page.button.tooltip.remove"));
        Composite compositePeripheralsAdded = new Composite(compositeMain, 0);
        compositePeripheralsAdded.setLayoutData((Object)new GridData(1808));
        compositePeripheralsAdded.setLayout((Layout)new GridLayout(1, false));
        Label labelPeripheralAdded = new Label(compositePeripheralsAdded, 0);
        labelPeripheralAdded.setText(rb.getString("select_peripheral.page.peripherals_added"));
        labelPeripheralAdded.setLayoutData((Object)this.getGridData(0, 1));
        this.listPeripheralsAdded = new List(compositePeripheralsAdded, 2050);
        this.listPeripheralsAdded.setLayoutData((Object)this.getGridData(1808, 1));
    }

    protected void initialize() {
        if (this.project != null) {
            this.textProjectName.setText(this.project.getName());
            this.fillPeripheralLists(this.project);
        }
    }

    protected abstract void fillPeripheralLists(IProject var1);

    private void addPeripheral() {
        String[] selectedPeripherals = this.listPeripheralsAvailable.getSelection();
        int i = 0;
        while (i < selectedPeripherals.length) {
            this.listPeripheralsAdded.add(selectedPeripherals[i]);
            this.listPeripheralsAvailable.remove(selectedPeripherals[i]);
            ++i;
        }
        this.enableDisableComponents();
    }

    private void removePeripheral() {
        String[] selectedPeripherals = this.listPeripheralsAdded.getSelection();
        int i = 0;
        while (i < selectedPeripherals.length) {
            this.listPeripheralsAvailable.add(selectedPeripherals[i]);
            this.listPeripheralsAdded.remove(selectedPeripherals[i]);
            ++i;
        }
        this.enableDisableComponents();
    }

    private GridData getGridData(int style, int horizontalSpan) {
        GridData gridData = new GridData(style);
        gridData.horizontalSpan = horizontalSpan;
        return gridData;
    }

    protected void enableDisableComponents() {
        this.buttonAdd.setEnabled(this.listPeripheralsAvailable.getSelection().length > 0);
        this.buttonRemove.setEnabled(this.listPeripheralsAdded.getSelection().length > 0);
        super.setPageComplete(this.listPeripheralsAdded.getItemCount() > 0);
    }
}

