/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.wizards;

import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.DriverRequirementsDocument;
import com.sap.ip.me.mdk.pios.docgen.editors.DRDEditor;
import com.sap.ip.me.mdk.pios.docgen.wizards.ConfigureDRDWizardPage;
import com.sap.ip.me.mdk.pios.docgen.wizards.DocGenWizard;
import com.sap.ip.me.mdk.pios.docgen.wizards.NewDRDWizardPage;
import com.sap.ip.me.mdk.pios.docgen.wizards.SelectPeripheralsWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CreateModifyDRDWizard
extends DocGenWizard
implements INewWizard {
    private SelectPeripheralsWizardPage wizardPage;

    public CreateModifyDRDWizard() {
        super("");
    }

    public void addPages() {
        IProject project = DocumentGeneratorPlugin.getDefault().getProject(this.selection);
        if (project == null) {
            this.wizardPage = new NewDRDWizardPage(this.selection, project);
            super.setWindowTitle(DocGenWizard.rb.getString("new_drd.tittle"));
            this.wizardPage.setPageComplete(false);
            this.wizardPage.setErrorMessage(DocGenWizard.rb.getString("select_peripheral.error.no_project_selected"));
        } else if (!DocumentGeneratorPlugin.getDefault().containsDRD(project)) {
            this.wizardPage = new NewDRDWizardPage(this.selection, project);
            super.setWindowTitle(DocGenWizard.rb.getString("new_drd.tittle"));
        } else {
            this.wizardPage = new ConfigureDRDWizardPage(this.selection, project);
            super.setWindowTitle(DocGenWizard.rb.getString("config_drd.tittle"));
        }
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean doFinish(IProgressMonitor monitor) throws DocumentGeneratorException {
        if (this.wizardPage instanceof NewDRDWizardPage) {
            return this.createNewDRD(monitor);
        }
        return this.configureDRD(monitor);
    }

    private boolean createNewDRD(IProgressMonitor monitor) throws DocumentGeneratorException {
        String projectName = this.wizardPage.getProjectName();
        String[] peripherals = this.wizardPage.getAddedPeripherals();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new DocumentGeneratorException(DocGenWizard.rb.getString("new_drd.error.project_not_found", new String[]{projectName}));
        }
        final IFile file = DocumentGeneratorPlugin.getDefault().getDRDFile(project);
        monitor.beginTask(DocGenWizard.rb.getString("new_drd.monitor.task_name"), peripherals.length * 2);
        DriverRequirementsDocument driverRequirementsDocument = new DriverRequirementsDocument(project);
        int i = 0;
        while (i < peripherals.length) {
            monitor.subTask(DocGenWizard.rb.getString("new_drd.monitor.subtask.adding_peripheral", new String[]{peripherals[i]}));
            driverRequirementsDocument.addPeripheral(peripherals[i]);
            monitor.worked(1);
            ++i;
        }
        driverRequirementsDocument.save(file, monitor);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor(file);
                }
                catch (PartInitException e) {
                    MessageDialog.openWarning(null, (String)DocGenWizard.rb.getString("new_drd.messagedialog.error_initializing_editor.tittle"), (String)DocGenWizard.rb.getString("new_drd.messagedialog.error_initializing_editor.message", new String[]{e.getMessage()}));
                }
            }
        });
        return true;
    }

    private boolean configureDRD(IProgressMonitor monitor) throws DocumentGeneratorException {
        String projectName = this.wizardPage.getProjectName();
        String[] addedPeripherals = this.wizardPage.getAddedPeripherals();
        String[] removedPeripherals = this.wizardPage.getRemovedPeripherals();
        DriverRequirementsDocument driverRequirementsDocument = ((ConfigureDRDWizardPage)this.wizardPage).getDriverRequirementsDocument();
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new DocumentGeneratorException(DocGenWizard.rb.getString("config_drd.error.project_not_found", new String[]{projectName}));
        }
        final IFile file = DocumentGeneratorPlugin.getDefault().getDRDFile(project);
        monitor.beginTask(DocGenWizard.rb.getString("config_drd.monitor.task_name"), addedPeripherals.length * 2 + removedPeripherals.length + 1);
        monitor.subTask(DocGenWizard.rb.getString("config_drd.monitor.subtask.removing_peripherals"));
        int i = 0;
        while (i < removedPeripherals.length) {
            if (driverRequirementsDocument.containsPeripheral(removedPeripherals[i])) {
                driverRequirementsDocument.removePeripheral(removedPeripherals[i]);
            }
            monitor.worked(1);
            ++i;
        }
        monitor.subTask(DocGenWizard.rb.getString("config_drd.monitor.subtask.adding_peripherals"));
        int i2 = 0;
        while (i2 < addedPeripherals.length) {
            if (!driverRequirementsDocument.containsPeripheral(addedPeripherals[i2])) {
                driverRequirementsDocument.addPeripheral(addedPeripherals[i2]);
            }
            monitor.worked(1);
            ++i2;
        }
        driverRequirementsDocument.save(file, monitor);
        monitor.subTask(DocGenWizard.rb.getString("config_drd.monitor.subtask.update_editor"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    DRDEditor drdEditor = DocumentGeneratorPlugin.getDefault().getDRDEditor(project);
                    if (drdEditor != null) {
                        page.closeEditor((IEditorPart)drdEditor, false);
                        page.openEditor(file);
                    }
                }
                catch (PartInitException e) {
                    MessageDialog.openWarning((Shell)CreateModifyDRDWizard.this.getShell(), (String)DocGenWizard.rb.getString("config_drd.messagedialog.error_updating_editor.tittle"), (String)DocGenWizard.rb.getString("config_drd.messagedialog.error_updating_editor.message", new String[]{e.getMessage()}));
                }
            }
        });
        monitor.worked(1);
        return true;
    }
}

