/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.wizards;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.DriverRequirementsDocument;
import com.sap.ip.me.mdk.pios.docgen.PeripheralManager;
import com.sap.ip.me.mdk.pios.docgen.attributes.Peripheral;
import com.sap.ip.me.mdk.pios.docgen.editors.DRDEditor;
import com.sap.ip.me.mdk.pios.docgen.wizards.DocGenWizard;
import com.sap.ip.me.mdk.pios.docgen.wizards.SelectPeripheralsWizardPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ConfigureDRDWizardPage
extends SelectPeripheralsWizardPage {
    private DriverRequirementsDocument driverRequirementsDocument = null;
    private static DocGenResources rb = DocGenWizard.rb;

    public ConfigureDRDWizardPage(IStructuredSelection selection, IProject project) {
        super(rb.getString("config_drd.page.name"), project, selection);
        this.setTitle(rb.getString("config_drd.page.tittle"));
        this.setDescription(rb.getString("config_drd.page.description"));
        this.setImageDescriptor(DocumentGeneratorPlugin.getDefault().getImageDescriptor(rb.getString("image.configure_drd_header")));
    }

    public DriverRequirementsDocument getDriverRequirementsDocument() {
        return this.driverRequirementsDocument;
    }

    protected void fillPeripheralLists(IProject project) {
        DRDEditor drdEditor = DocumentGeneratorPlugin.getDefault().getDRDEditor(project);
        if (drdEditor != null) {
            this.addPeripherals(drdEditor.getDriverRequirementsDocument());
        } else {
            IFile file;
            try {
                file = DocumentGeneratorPlugin.getDefault().getDRDFile(project);
            }
            catch (DocumentGeneratorException e1) {
                this.setErrorMessage(rb.getString("config_drd.page.error.no_drd_in_project"));
                this.setPageComplete(false);
                return;
            }
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        DRDEditor drdEditor = (DRDEditor)page.openEditor(file);
                        ConfigureDRDWizardPage.this.addPeripherals(drdEditor.getDriverRequirementsDocument());
                    }
                    catch (PartInitException e) {
                        MessageDialog.openWarning(null, (String)rb.getString("new_drd.messagedialog.error_initializing_editor.tittle"), (String)rb.getString("new_drd.messagedialog.error_initializing_editor.message", new String[]{e.getMessage()}));
                    }
                }
            });
        }
    }

    private final void addPeripherals(DriverRequirementsDocument driverRequirementsDocument) {
        this.driverRequirementsDocument = driverRequirementsDocument;
        if (driverRequirementsDocument.isDirty()) {
            this.setMessage(rb.getString("config_drd.page.warning.drd_not_saved"), 2);
        }
        ArrayList drdPeripherals = driverRequirementsDocument.getPeripheralList();
        int i = 0;
        while (i < drdPeripherals.size()) {
            this.listPeripheralsAdded.add(((Peripheral)drdPeripherals.get(i)).getName());
            ++i;
        }
        ArrayList installedPeripherals = PeripheralManager.getInstance().getInstalled();
        int i2 = 0;
        while (i2 < installedPeripherals.size()) {
            boolean found = false;
            int j = 0;
            while (j < drdPeripherals.size()) {
                if (installedPeripherals.get(i2).equals(((Peripheral)drdPeripherals.get(j)).getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.listPeripheralsAvailable.add((String)installedPeripherals.get(i2));
            }
            ++i2;
        }
    }
}

