/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.editors;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocGenResourcesManager;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.DriverRequirementsDocument;
import com.sap.ip.me.mdk.pios.docgen.attributes.Attribute;
import com.sap.ip.me.mdk.pios.docgen.attributes.Option;
import com.sap.ip.me.mdk.pios.docgen.attributes.Peripheral;
import com.sap.ip.me.mdk.pios.docgen.attributes.Property;
import com.sap.ip.me.mdk.pios.docgen.editors.CheckboxTreeViewerEx;
import com.sap.ip.me.mdk.pios.docgen.editors.PropertiesTreeContentProvider;
import com.sap.ip.me.mdk.pios.docgen.editors.WorspaceListener;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class DRDEditor
extends EditorPart {
    private TabFolder tabFolder = null;
    private DriverRequirementsDocument driverRequirementsDocument;
    private Label listDescription = null;
    private boolean dirty = false;
    private IFile drdFile = null;
    private DocGenResources rb = DocGenResourcesManager.getInstance().getResourceBundle("editors");

    public void createPartControl(Composite parent) {
        SashForm formProperties = new SashForm(parent, 512);
        formProperties.setLayout((Layout)new FillLayout(512));
        formProperties.setFont(parent.getFont());
        this.tabFolder = new TabFolder((Composite)formProperties, 0);
        this.listDescription = new Label((Composite)formProperties, 64);
        formProperties.setWeights(new int[]{6, 1});
        ArrayList peripherals = this.driverRequirementsDocument.getPeripheralList();
        int i = 0;
        while (i < peripherals.size()) {
            Peripheral peripheral = (Peripheral)peripherals.get(i);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(peripheral.toString());
            item.setImage(peripheral.getIcon());
            Composite composite = new Composite((Composite)this.tabFolder, 0);
            composite.setLayout((Layout)new FillLayout());
            CheckboxTreeViewerEx treeProperties = new CheckboxTreeViewerEx(composite, 770);
            treeProperties.setContentProvider((IContentProvider)new PropertiesTreeContentProvider(peripheral.getProperties()));
            treeProperties.setInput(ResourcesPlugin.getWorkspace());
            composite.pack();
            item.setControl((Control)composite);
            treeProperties.expandAll();
            treeProperties.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DRDEditor.this.treeNodeSelected((Attribute)((StructuredSelection)event.getSelection()).getFirstElement());
                }
            });
            treeProperties.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    DRDEditor.this.attributeChecked((Attribute)event.getElement(), event.getChecked(), (CheckboxTreeViewer)event.getSource());
                }
            });
            treeProperties.setSelection((ISelection)new StructuredSelection((Object)peripheral));
            ArrayList properties = ((Peripheral)peripherals.get(i)).getProperties();
            int j = 0;
            while (j < properties.size()) {
                ArrayList options = ((Property)properties.get(i)).getOptions();
                if (options.size() > 0) {
                    this.setParentState((Option)options.get(0), treeProperties);
                }
                ++j;
            }
            if (properties.size() > 0) {
                this.setParentState((Property)properties.get(0), treeProperties);
            }
            ++i;
        }
        this.listDescription.setText("");
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DRDEditor.this.listDescription.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DRDEditor.this.listDescription.setText("");
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WorspaceListener());
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        if (this.driverRequirementsDocument != null) {
            try {
                monitor.beginTask(this.rb.getString("drd_editor.monitor.task"), this.driverRequirementsDocument.getPeripheralList().size());
                this.driverRequirementsDocument.save(this.drdFile, monitor);
                monitor.done();
                this.dirty = false;
                this.driverRequirementsDocument.setDirty(false);
                this.firePropertyChange(257);
            }
            catch (DocumentGeneratorException ex) {
                MessageDialog.openError(null, (String)this.rb.getString("drd_editor.messagedialog.error_saving_drd.tittle"), (String)this.rb.getString("drd_editor.messagedialog.error_saving_drd.message", new String[]{ex.getMessage()}));
                DocumentGeneratorPlugin.getDefault().logError("Error Saving Driver Requirements Document", ex);
            }
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        try {
            this.driverRequirementsDocument = this.doSetInput(input);
            this.dirty = this.driverRequirementsDocument.isDirty();
        }
        catch (CoreException coreex) {
            DocumentGeneratorPlugin.getDefault().logError("Error Opening Driver Requirements Document", coreex);
            throw new PartInitException(this.rb.getString("drd_editor.error_opening_editor"), (Throwable)coreex);
        }
        catch (DocumentGeneratorException ioex) {
            DocumentGeneratorPlugin.getDefault().logError("Error Opening Driver Requirements Document", ioex);
            throw new PartInitException(this.rb.getString("drd_editor.error_opening_editor"), (Throwable)ioex);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public DriverRequirementsDocument getDriverRequirementsDocument() {
        return this.driverRequirementsDocument;
    }

    public void setDirty(boolean dirty) {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    private DriverRequirementsDocument doSetInput(IEditorInput input) throws CoreException, DocumentGeneratorException {
        IFileEditorInput fileInput = null;
        if (input != null) {
            super.setInput(input);
            this.setTitle(this.rb.getString("drd_editor.tittle"));
            try {
                fileInput = (IFileEditorInput)input;
            }
            catch (Exception exc) {
                throw new PartInitException(this.rb.getString("drd_editor.invalid_editor_input"));
            }
            this.drdFile = fileInput.getFile();
            return new DriverRequirementsDocument(this.drdFile.getContents(), this.drdFile.getProject());
        }
        return null;
    }

    private void treeNodeSelected(Attribute selectedNode) {
        if (selectedNode != null) {
            this.listDescription.setText(selectedNode.getLongDescription());
        }
    }

    private void attributeChecked(Attribute requirement, boolean value, CheckboxTreeViewer tree) {
        if (requirement instanceof Property) {
            requirement.setRequired(value);
            this.enableProperty((Property)requirement, value, tree);
            this.setParentState(requirement, tree);
        } else if (requirement instanceof Option) {
            requirement.setRequired(value);
            this.setParentState(requirement, tree);
            this.setParentState(requirement.getParent(), tree);
        } else {
            requirement.setRequired(value);
            requirement.setPartiallyRequired(false);
            ArrayList properties = ((Peripheral)requirement).getProperties();
            int i = 0;
            while (i < properties.size()) {
                this.enableProperty((Property)properties.get(i), value, tree);
                ++i;
            }
            tree.update((Object)requirement, null);
        }
        this.dirty = true;
        this.driverRequirementsDocument.setDirty(true);
        this.firePropertyChange(257);
    }

    private void enableProperty(Property property, boolean value, CheckboxTreeViewer tree) {
        property.setRequired(value);
        ArrayList options = property.getOptions();
        int i = 0;
        while (i < options.size()) {
            ((Option)options.get(i)).setRequired(value);
            tree.update(options.get(i), null);
            ++i;
        }
        property.setPartiallyRequired(false);
        tree.update((Object)property, null);
    }

    private void setParentState(Attribute attribute, CheckboxTreeViewer tree) {
        ArrayList brothers = null;
        brothers = attribute instanceof Option ? ((Property)attribute.getParent()).getOptions() : ((Peripheral)attribute.getParent()).getProperties();
        boolean allSelected = true;
        boolean nonSelected = true;
        boolean onePartiallyRequired = false;
        int i = 0;
        while (i < brothers.size()) {
            Attribute brother = (Attribute)brothers.get(i);
            if (!brother.isRequired() && !brother.isPartiallyRequired()) {
                allSelected = false;
            } else if (brother.isPartiallyRequired()) {
                nonSelected = false;
                onePartiallyRequired = true;
            } else {
                nonSelected = false;
            }
            ++i;
        }
        if (allSelected && !onePartiallyRequired) {
            attribute.getParent().setRequired(true);
            attribute.getParent().setPartiallyRequired(false);
        } else if (nonSelected) {
            attribute.getParent().setRequired(false);
            attribute.getParent().setPartiallyRequired(false);
        } else {
            attribute.getParent().setRequired(false);
            attribute.getParent().setPartiallyRequired(true);
        }
        tree.update((Object)attribute.getParent(), null);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.tabFolder != null) {
            this.tabFolder.setFocus();
        }
    }
}

