/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.attributes;

import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.PeripheralManager;
import com.sap.ip.me.mdk.pios.docgen.attributes.Attribute;
import com.sap.ip.me.mdk.pios.docgen.attributes.Property;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Image;

public class Peripheral
extends Attribute {
    private ArrayList properties = null;
    private ResourceBundle resourceBundle = null;
    private Image peripheralIcon = null;

    public Peripheral(String peripheralName) throws DocumentGeneratorException {
        this.name = peripheralName;
        this.properties = new ArrayList();
        this.resourceBundle = PeripheralManager.getInstance().getPeripheralResourceBundle(this.name);
        this.peripheralIcon = PeripheralManager.getInstance().getPeripheralIcon(this.name);
    }

    public ArrayList getProperties() {
        return this.properties;
    }

    public Property getProperty(String propertyName) {
        int i = 0;
        while (i < this.properties.size()) {
            Property property = (Property)this.properties.get(i);
            if (property.getName().equals(propertyName)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public Image getIcon() {
        return this.peripheralIcon;
    }

    public String ToXml() {
        StringBuffer sXml = new StringBuffer("<peripheral ");
        sXml.append("type=\"" + this.getName() + "\">");
        this.appendAttributeNode(sXml, this.properties);
        sXml.append("</peripheral>");
        return sXml.toString();
    }

    protected ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void appendAttributeNode(StringBuffer sXml, ArrayList attributes) {
        int i = 0;
        while (i < attributes.size()) {
            Attribute req = (Attribute)attributes.get(i);
            sXml.append(req.ToXml());
            ++i;
        }
    }

    public String toString() {
        return this.getResourceBundle().getString(this.name);
    }
}

