/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen.actions;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocGenResourcesManager;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class LaunchEmulatorAction
implements IWorkbenchWindowActionDelegate {
    private static boolean emulatorRunning = false;
    private IWorkbenchWindow window;
    private IStructuredSelection selection = null;
    private DocGenResources rb = DocGenResourcesManager.getInstance().getResourceBundle("actions");
    private EmulatorProcess emulatorProc = null;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void run(IAction action) {
        if (emulatorRunning) {
            MessageDialog.openError(null, (String)this.rb.getString("launch_emulator.error_dialog.tittle"), (String)this.rb.getString("launch_emulator.error_dialog.emulator_already_running"));
            return;
        }
        String javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw";
        this.emulatorProc = new EmulatorProcess(javaHome, DocumentGeneratorPlugin.getDefault().find((IPath)new Path("emulator")).getPath());
        this.emulatorProc.start();
    }

    class EmulatorShutdownProcess
    extends Thread {
        private Process proc = null;

        public EmulatorShutdownProcess(Process proc) {
            this.proc = proc;
        }

        public void run() {
            if (emulatorRunning) {
                BufferedOutputStream bos = new BufferedOutputStream(this.proc.getOutputStream());
                byte[] cmd = new byte[]{99, 108, 111, 115, 101};
                try {
                    bos.write(cmd);
                    bos.flush();
                    emulatorRunning = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class EmulatorProcess
    extends Thread {
        private String javaExec = null;
        private String emulatorHome = null;

        public EmulatorProcess(String javaExec, String emulatorHome) {
            this.javaExec = javaExec;
            this.emulatorHome = emulatorHome;
        }

        public void run() {
            try {
                Process proc = Runtime.getRuntime().exec(this.javaExec + " -DPERIPHERAL_EMULATOR_HOME=. -cp .\\startup.jar pios.emulator.utils.StaticClassLoader .\\lib pios.emulator.PEmulator ", null, new File(this.emulatorHome));
                emulatorRunning = true;
                Runtime.getRuntime().addShutdownHook(new EmulatorShutdownProcess(proc));
                proc.waitFor();
                emulatorRunning = false;
            }
            catch (IOException ex) {
                MessageDialog.openError(null, (String)LaunchEmulatorAction.this.rb.getString("launch_emulator.error_dialog.tittle"), (String)LaunchEmulatorAction.this.rb.getString("launch_emulator.error_dialog.error_launching_emulator", new String[]{ex.getMessage()}));
            }
            catch (InterruptedException ex) {
                emulatorRunning = false;
            }
        }
    }
}

