/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocGenResourcesManager;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.PeripheralInfo;
import com.sap.ip.me.mdk.pios.docgen.PeripheralInfoHandler;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;

public class PeripheralManager {
    private static PeripheralManager instance = null;
    private ArrayList peripherals = null;
    private DocGenResources rb = DocGenResourcesManager.getInstance().getResourceBundle("document_generator");

    private PeripheralManager() {
        this.peripherals = new ArrayList();
        URL path = DocumentGeneratorPlugin.getDefault().find((IPath)new Path("peripheral_types"));
        File peripheralsPath = new File(path.getFile());
        File[] templateFiles = peripheralsPath.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String fileName = pathname.getAbsolutePath();
                String extension = fileName.substring(pathname.getAbsolutePath().lastIndexOf(46) + 1);
                return extension.equals("xml");
            }
        });
        PeripheralInfoHandler peripheralInfoHandler = new PeripheralInfoHandler();
        int i = 0;
        while (i < templateFiles.length) {
            try {
                PeripheralInfo peripheralInfo = peripheralInfoHandler.parseDoc(templateFiles[i]);
                this.peripherals.add(peripheralInfo);
            }
            catch (DocumentGeneratorException ex) {
                DocumentGeneratorPlugin.getDefault().logError("Unable to load peripheral: " + templateFiles[i].getName(), ex);
                MessageDialog.openError(null, (String)this.rb.getString("pm.messagedialog.error_loading_peripheral.tittle"), (String)this.rb.getString("pm.messagedialog.error_loading_peripheral.message", new String[]{templateFiles[i].getName()}));
            }
            ++i;
        }
    }

    public ArrayList getInstalled() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.peripherals.size()) {
            result.add(((PeripheralInfo)this.peripherals.get(i)).getName());
            ++i;
        }
        return result;
    }

    public String getPeripheralTemplatePath(String peripheralName) throws DocumentGeneratorException {
        PeripheralInfo peripheralInfo = this.getPeripheral(peripheralName);
        if (peripheralInfo == null) {
            throw new DocumentGeneratorException(this.rb.getString("pm.peripheral_not_found", new String[]{peripheralName}));
        }
        URL path = DocumentGeneratorPlugin.getDefault().find((IPath)new Path("peripheral_types"));
        File peripheralFile = new File(path.getFile() + File.separator + peripheralInfo.getTemplateFileName());
        return peripheralFile.getAbsolutePath();
    }

    public ResourceBundle getPeripheralResourceBundle(String peripheralName) throws DocumentGeneratorException {
        PeripheralInfo peripheralInfo = this.getPeripheral(peripheralName);
        if (peripheralInfo == null) {
            throw new DocumentGeneratorException(this.rb.getString("pm.peripheral_not_found", new String[]{peripheralName}));
        }
        return peripheralInfo.getResourceBundle();
    }

    public Image getPeripheralIcon(String peripheralName) throws DocumentGeneratorException {
        PeripheralInfo peripheralInfo = this.getPeripheral(peripheralName);
        if (peripheralInfo == null) {
            throw new DocumentGeneratorException(this.rb.getString("pm.peripheral_not_found", new String[]{peripheralName}));
        }
        return peripheralInfo.getImage();
    }

    public static PeripheralManager getInstance() {
        if (instance == null) {
            instance = new PeripheralManager();
        }
        return instance;
    }

    private PeripheralInfo getPeripheral(String peripheralName) {
        PeripheralInfo peripheralInfo = null;
        int i = 0;
        while (i < this.peripherals.size()) {
            if (((PeripheralInfo)this.peripherals.get(i)).getName().equalsIgnoreCase(peripheralName)) {
                peripheralInfo = (PeripheralInfo)this.peripherals.get(i);
                break;
            }
            ++i;
        }
        return peripheralInfo;
    }
}

