/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen;

import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PeripheralInfo {
    private String name;
    private String templateFileName;
    private Image image;
    private String version;
    private ResourceBundle resourceBundle;

    public PeripheralInfo(String name, String templateFileName, String imageName, String version, String resourceBundleFileName) throws DocumentGeneratorException {
        this.name = name;
        this.templateFileName = templateFileName;
        this.image = this.createImage(imageName);
        this.version = version;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.ip.me.mdk.pios.docgen.language.peripherals." + name.toLowerCase(), Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            DocumentGeneratorPlugin.getDefault().logError("Getting for: " + Locale.US, ex);
            this.resourceBundle = ResourceBundle.getBundle("com.sap.ip.me.mdk.pios.docgen.language.peripherals." + name.toLowerCase(), Locale.US);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public Image getImage() {
        return this.image;
    }

    public String getVersion() {
        return this.version;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private Image createImage(String imageName) {
        URL imageURL = DocumentGeneratorPlugin.getDefault().find((IPath)new Path("peripheral_types" + File.separator + imageName));
        if (imageURL == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)imageURL).createImage();
    }
}

