/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.attributes.Attribute;
import com.sap.ip.me.mdk.pios.docgen.attributes.Option;
import com.sap.ip.me.mdk.pios.docgen.attributes.Peripheral;
import com.sap.ip.me.mdk.pios.docgen.attributes.Property;
import java.util.ArrayList;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DriverRequirementsDocumentParser
extends DefaultHandler {
    private String version = null;
    private ArrayList peripheralList;
    private Peripheral currentPeripheral;
    private Property currentProperty;
    private Option currentOption;
    private DocGenResources rb = null;
    private boolean isDirty = false;

    public DriverRequirementsDocumentParser(DocGenResources rb) {
        this.rb = rb;
    }

    public ArrayList parseDoc(InputSource in) throws Exception {
        this.peripheralList = new ArrayList();
        SAXParser parser = new SAXParser();
        parser.setContentHandler((ContentHandler)this);
        parser.setErrorHandler((ErrorHandler)this);
        parser.parse(in);
        return this.peripheralList;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        if (elementName.equalsIgnoreCase("peripherals")) {
            this.version = attributes.getValue("version");
        } else if (elementName.equalsIgnoreCase("peripheral")) {
            String peripheralName = attributes.getValue("type");
            try {
                this.currentPeripheral = new Peripheral(peripheralName);
            }
            catch (DocumentGeneratorException ex) {
                MessageDialog.openInformation(null, (String)this.rb.getString("drd.header"), (String)this.rb.getString("drd.peripheral_not_found", new String[]{peripheralName}));
                DocumentGeneratorPlugin.getDefault().logError("Unable to load peripheral: " + peripheralName, ex);
                this.currentPeripheral = null;
                this.isDirty = true;
            }
        } else if (elementName.equalsIgnoreCase("prop")) {
            if (this.currentPeripheral != null) {
                this.currentProperty = new Property(attributes.getValue("name"), this.currentPeripheral);
                this.setRequired(this.currentProperty, attributes);
            } else {
                this.currentProperty = null;
            }
        } else if (elementName.equalsIgnoreCase("option")) {
            if (this.currentProperty != null) {
                this.currentOption = new Option(attributes.getValue("name"), this.currentProperty);
                this.setRequired(this.currentOption, attributes);
            } else {
                this.currentOption = null;
            }
        }
    }

    public void endElement(String uri, String elementName, String qName) {
        if (elementName.equalsIgnoreCase("peripheral")) {
            if (this.currentPeripheral != null) {
                this.peripheralList.add(this.currentPeripheral);
                this.currentPeripheral = null;
            }
        } else if (elementName.equalsIgnoreCase("prop")) {
            if (this.currentProperty != null) {
                this.currentPeripheral.getProperties().add(this.currentProperty);
                this.currentProperty = null;
            }
        } else if (elementName.equalsIgnoreCase("option") && this.currentOption != null) {
            this.currentProperty.getOptions().add(this.currentOption);
            this.currentOption = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    public void endDocument() {
    }

    private void setRequired(Attribute req, Attributes attributes) {
        String required = attributes.getValue("required");
        boolean bRequired = false;
        if (required != null && required.equalsIgnoreCase("yes")) {
            bRequired = true;
        }
        req.setRequired(bRequired);
    }
}

