/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen;

import com.sap.ip.me.mdk.pios.docgen.DocGenResources;
import com.sap.ip.me.mdk.pios.docgen.DocGenResourcesManager;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorPlugin;
import com.sap.ip.me.mdk.pios.docgen.DriverRequirementsDocumentParser;
import com.sap.ip.me.mdk.pios.docgen.PeripheralManager;
import com.sap.ip.me.mdk.pios.docgen.attributes.Peripheral;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.InputSource;

public class DriverRequirementsDocument {
    public static final String PERIPHERALS = "peripherals";
    public static final String VERSION = "version";
    public static final String PERIPHERAL = "peripheral";
    public static final String PERIPHERAL_TYPE = "type";
    public static final String PERIPHERAL_PROP = "prop";
    public static final String PERIPHERAL_ATTRIB_REQUIRED = "required";
    public static final String PERIPHERAL_ATTRIB_NAME = "name";
    public static final String PERIPHERAL_OPTION = "option";
    private ArrayList peripheralList;
    private DocGenResources rb = DocGenResourcesManager.getInstance().getResourceBundle("document_generator");
    private IProject project = null;
    private boolean isDirty = false;
    private String version = null;

    public DriverRequirementsDocument(IProject project) {
        this.peripheralList = new ArrayList();
        this.project = project;
    }

    public DriverRequirementsDocument(InputStream drdInStream, IProject project) throws DocumentGeneratorException {
        if (drdInStream == null) {
            throw new DocumentGeneratorException("Invalid Driver Requirements Document input stream.");
        }
        DriverRequirementsDocumentParser parser = new DriverRequirementsDocumentParser(this.rb);
        this.peripheralList = this.parseDocument(parser, drdInStream);
        this.version = parser.getVersion();
        this.project = project;
        this.isDirty = parser.isDirty();
    }

    public void addPeripheral(String peripheralName) throws DocumentGeneratorException {
        if (this.getPeripheral(peripheralName) != null) {
            throw new DocumentGeneratorException(this.rb.getString("drd.peripheral_already_exists", new String[]{peripheralName}));
        }
        this.peripheralList.add(this.getPeripheralFromTemplate(peripheralName));
    }

    public IProject getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version;
    }

    public ArrayList getPeripheralList() {
        return this.peripheralList;
    }

    public boolean containsPeripheral(String peripheralName) {
        return this.getPeripheral(peripheralName) != null;
    }

    public void removePeripheral(String peripheralName) {
        Peripheral peripheral = this.getPeripheral(peripheralName);
        if (peripheral != null) {
            ((AbstractCollection)this.peripheralList).remove(peripheral);
        }
    }

    /*
     * Loose catch block
     */
    public void save(IFile file, IProgressMonitor monitor) throws DocumentGeneratorException {
        block15: {
            BufferedInputStream bis;
            ByteArrayInputStream bais;
            block13: {
                if (file == null) {
                    throw new DocumentGeneratorException(this.rb.getString("drd.save.invalid_file"));
                }
                monitor.subTask(this.rb.getString("drd.save.monitor.task"));
                StringBuffer xmlDocument = new StringBuffer();
                xmlDocument.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                xmlDocument.append("<peripherals version=\"" + DocumentGeneratorPlugin.getDefault().getDescriptor().getVersionIdentifier().toString() + "\">");
                int n = 0;
                while (n < this.peripheralList.size()) {
                    Peripheral perreq = (Peripheral)this.peripheralList.get(n);
                    xmlDocument.append(perreq.ToXml());
                    monitor.worked(1);
                    ++n;
                }
                xmlDocument.append("</peripherals>");
                bais = null;
                bis = null;
                bais = new ByteArrayInputStream(xmlDocument.toString().getBytes("UTF-8"));
                bis = new BufferedInputStream(bais);
                if (file.exists()) {
                    file.setContents((InputStream)bis, true, true, null);
                    break block13;
                }
                file.create((InputStream)bis, true, null);
            }
            Object var9_7 = null;
            try {
                bis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                bais.close();
            }
            catch (Exception ex) {}
            break block15;
            {
                catch (Exception ex) {
                    monitor.setCanceled(true);
                    throw new DocumentGeneratorException(this.rb.getString("drd.save.cannot_save", new String[]{file.getName()}), ex);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    bis.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    bais.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private Peripheral getPeripheral(String peripheralName) {
        int n = 0;
        while (n < this.peripheralList.size()) {
            Peripheral perreq = (Peripheral)this.peripheralList.get(n);
            if (peripheralName.equalsIgnoreCase(perreq.getName())) {
                return perreq;
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList parseDocument(DriverRequirementsDocumentParser parser, InputStream drdInStream) throws DocumentGeneratorException {
        BufferedInputStream bis = null;
        InputSource is = null;
        ArrayList peripherals = null;
        try {
            try {
                bis = new BufferedInputStream(drdInStream);
                is = new InputSource(bis);
                peripherals = parser.parseDoc(is);
            }
            catch (Exception ex) {
                throw new DocumentGeneratorException("Error parsing Driver Requirements Document", ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                bis.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        bis.close();
        return peripherals;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Peripheral getPeripheralFromTemplate(String peripheralName) throws DocumentGeneratorException {
        String templatePath = PeripheralManager.getInstance().getPeripheralTemplatePath(peripheralName);
        DriverRequirementsDocumentParser parser = new DriverRequirementsDocumentParser(this.rb);
        FileInputStream fis = null;
        try {
            try {
                Peripheral peripheral;
                fis = new FileInputStream(templatePath);
                ArrayList peripherals = this.parseDocument(parser, fis);
                if (peripherals.size() <= 0) {
                    throw new DocumentGeneratorException(this.rb.getString("drd.unable_to_parse_peripheral", new String[]{peripheralName}));
                }
                Peripheral peripheral2 = peripheral = (Peripheral)peripherals.get(0);
                Object var9_9 = null;
                try {
                    fis.close();
                    return peripheral2;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return peripheral2;
            }
            catch (FileNotFoundException ex) {
                throw new DocumentGeneratorException(this.rb.getString("drd.template_not_found", new String[]{peripheralName}), ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (Exception ex) {
                throw throwable;
            }
            fis.close();
            throw throwable;
        }
    }
}

