/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.pios.docgen;

import com.sap.ip.me.mdk.pios.docgen.DocumentGeneratorException;
import com.sap.ip.me.mdk.pios.docgen.PeripheralManager;
import com.sap.ip.me.mdk.pios.docgen.editors.DRDEditor;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DocumentGeneratorPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.sap.ip.me.mdk.pios.docgen";
    public static final String APP_ROOT = "app-root";
    public static final String DOCUMENT_NAME = "DriverRequirementDocument.xml";
    public static final String MDK_PLUGIN_ID = "com.sap.ip.me.mdk.developmentTools";
    private static DocumentGeneratorPlugin plugin;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    public DocumentGeneratorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        PeripheralManager.getInstance();
    }

    public static DocumentGeneratorPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String imageName) {
        URL imageURL = this.find((IPath)new Path(imageName));
        if (imageURL == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)imageURL);
    }

    public IProject getProject(IStructuredSelection selection) {
        IProject project = null;
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IAdaptable) {
                IProject proj = (IProject)((IAdaptable)obj).getAdapter(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = DocumentGeneratorPlugin.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject);
                if (proj != null) {
                    if (proj.isOpen()) {
                        project = proj;
                    }
                } else if (obj instanceof IFile) {
                    IFile file = (IFile)((IAdaptable)obj).getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = DocumentGeneratorPlugin.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
                    project = file.getProject();
                } else if (obj instanceof IFolder) {
                    IFolder folder = (IFolder)((IAdaptable)obj).getAdapter(class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = DocumentGeneratorPlugin.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder);
                    project = folder.getProject();
                }
            }
        } else {
            IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (workbenchPart instanceof DRDEditor) {
                project = ((DRDEditor)workbenchPart).getDriverRequirementsDocument().getProject();
            }
        }
        return project;
    }

    public void logError(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(4, ID, 0, message, exception));
    }

    public DRDEditor getDRDEditor(IProject project) {
        DRDEditor drdEditor = null;
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (workbenchWindows != null) {
            int i = 0;
            while (i < workbenchWindows.length) {
                IWorkbenchPage[] workbenchPages = workbenchWindows[i].getPages();
                int n = 0;
                while (n < workbenchPages.length) {
                    IEditorReference[] editorReferences = workbenchPages[n].getEditorReferences();
                    int j = 0;
                    while (j < editorReferences.length) {
                        DRDEditor drdEditorTmp;
                        if (editorReferences[j].getEditor(false) instanceof DRDEditor && project == (drdEditorTmp = (DRDEditor)editorReferences[j].getEditor(false)).getDriverRequirementsDocument().getProject()) {
                            drdEditor = drdEditorTmp;
                        }
                        ++j;
                    }
                    ++n;
                }
                ++i;
            }
        }
        return drdEditor;
    }

    public void closeDRDEditorForProject(IProject project) {
        try {
            final DRDEditor drdEditor = this.getDRDEditor(project);
            if (drdEditor != null) {
                drdEditor.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        workbenchPage.closeEditor((IEditorPart)drdEditor, false);
                    }
                });
            }
        }
        catch (Exception ex) {
            DocumentGeneratorPlugin.getDefault().logError("Error closing the Driver Requirements Document", ex);
        }
    }

    public IFile getDRDFile(IProject project) throws DocumentGeneratorException {
        IFolder folder = project.getFolder(APP_ROOT);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException ex) {
                this.logError("Error creating 'app-root' folder.", ex);
                throw new DocumentGeneratorException("Error creating 'app-root' folder");
            }
        }
        return folder.getFile((IPath)new Path(DOCUMENT_NAME));
    }

    public boolean containsDRD(IProject project) {
        IFolder folder = project.getFolder(APP_ROOT);
        if (!folder.exists()) {
            return false;
        }
        IFile drdFile = folder.getFile((IPath)new Path(DOCUMENT_NAME));
        return drdFile.exists();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

