/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.GridLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.ResolutionModel;

public final class SetupResolutionTab
extends JPanel {
    private JList choices;

    public SetupResolutionTab() {
        super(new GridLayout(1, 1));
        this.createResolutionPanel();
        this.choices.ensureIndexIsVisible(this.choices.getSelectedIndex());
    }

    private void createResolutionPanel() {
        this.choices = new JList(ResolutionModel.getActiveList());
        this.choices.setSelectedValue(ResolutionModel.getCurrentResolution(), true);
        if (this.choices.isSelectionEmpty() && ResolutionModel.getActiveList().size() > 0) {
            this.choices.setSelectedIndex(0);
        }
        JScrollPane jScrollPane = new JScrollPane(this.choices, 22, 30);
        this.add(jScrollPane);
    }

    public String getTitle() {
        return ResolutionModel.getTitle();
    }

    public void onOK() {
        if (this.choices.isSelectionEmpty()) {
            return;
        }
        DeviceCapability deviceCapability = (DeviceCapability)this.choices.getSelectedValue();
        ResolutionModel.setCurrentResolution(deviceCapability);
        ResolutionModel.store();
    }
}

