/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.EmulatedMedia;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.Margin;
import pios.emulator.ui.GBC;

public final class SetupMediaTab
extends JPanel
implements ListSelectionListener {
    private static final String PAPERCOUNT = PrinterPerf.getResourceString("SetupMediaTab_PaperCount");
    private static final String PAPERLENGTH = PrinterPerf.getResourceString("SetupMediaTab_PaperLength");
    private static final String SIZE = PrinterPerf.getResourceString("SetupMediaTab_Size");
    private static final String MARGIN = PrinterPerf.getResourceString("SetupMediaTab_Margin");
    private static final String PREPRINT = PrinterPerf.getResourceString("SetupMediaTab_Preprint");
    private static final String INVALID = PrinterPerf.getResourceString("SetupMediaTab_Invalid") + " ";
    private static final String VALIDRANGE = PrinterPerf.getResourceString("SetupMediaTab_ValidRange");
    private static final char PAPER_MNEMONIC = PrinterPerf.getResourceString("SetupMediaTab_Paper.MNEMONIC").charAt(0);
    private JList choices;
    private JLabel selectedMediaSize = new JLabel(" ");
    private JLabel selectedMediaMargin = new JLabel(" ");
    private JLabel selectedMediaPreprint = new JLabel(" ");
    private JTextField paperCount = new JTextField();
    private JTextField paperLength = new JTextField();
    private JComboBox paperLengthUnits = new JComboBox<String>(MediaModel.getLengthUnits());
    private boolean continusePrinting;
    private static int paperCountMax;
    private static int paperCountMin;
    private static int paperLengthMax;
    private static int paperLengthMin;
    private static String VALID_PAPER_COUNT;
    private static String[] VALID_PAPER_LENGTH;

    private void initializeConstants() {
        PreferenceModel preferenceModel = PreferenceModel.getInstance();
        paperCountMin = preferenceModel.getIntProperty("papercount.min");
        paperCountMax = preferenceModel.getIntProperty("pagecount.max");
        paperLengthMin = preferenceModel.getIntProperty("continuous.paper.length.min");
        paperLengthMax = preferenceModel.getIntProperty("continuous.paper.length.max");
        VALID_PAPER_COUNT = VALIDRANGE + "(" + paperCountMin + "," + paperCountMax + ")";
        String string = MediaModel.getLengthUnits()[0];
        SetupMediaTab.VALID_PAPER_LENGTH[0] = VALIDRANGE + "(" + paperLengthMin + string + "," + paperLengthMax + string + ")";
        string = MediaModel.getLengthUnits()[1];
        SetupMediaTab.VALID_PAPER_LENGTH[1] = VALIDRANGE + "(" + this.inchToCM(paperLengthMin) + string + "," + this.inchToCM(paperLengthMax) + string + ")";
    }

    public SetupMediaTab() {
        super(new GridLayout(1, 2));
        this.initializeConstants();
        this.continusePrinting = MediaModel.getContinuousPrinting();
        this.createSelectionList();
        this.createDetailPanel();
        this.valueChanged(null);
        this.choices.ensureIndexIsVisible(this.choices.getSelectedIndex());
    }

    private void createSelectionList() {
        this.choices = new JList(MediaModel.getActiveList());
        JScrollPane jScrollPane = new JScrollPane(this.choices, 22, 30);
        this.add(jScrollPane);
        this.choices.addListSelectionListener(this);
        this.choices.setSelectedValue(MediaModel.getCurrentMediaName(), true);
        if (this.choices.isSelectionEmpty() && MediaModel.getActiveList().size() > 0) {
            this.choices.setSelectedIndex(0);
        }
    }

    private void createDetailPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(0, 5, 0, 0));
        if (MediaModel.getContinuousPrinting()) {
            JLabel jLabel = new JLabel(PAPERLENGTH);
            jLabel.setDisplayedMnemonic(PAPER_MNEMONIC);
            jLabel.setLabelFor(this.paperLength);
            jPanel2.add((Component)jLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 0, 0, 0));
            jPanel2.add((Component)this.paperLength, new GBC(1, 0, 1, 1, 100.0, 0.0, 17, 2, 10, 5, 0, 0));
            jPanel2.add((Component)this.paperLengthUnits, new GBC(2, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 0, 0, 0));
        } else {
            JLabel jLabel = new JLabel(PAPERCOUNT);
            jLabel.setDisplayedMnemonic(PAPER_MNEMONIC);
            jLabel.setLabelFor(this.paperCount);
            jPanel2.add((Component)jLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 0, 0, 0));
            jPanel2.add((Component)this.paperCount, new GBC(1, 0, 1, 1, 50.0, 0.0, 17, 2, 10, 5, 0, 10));
        }
        jPanel2.add((Component)new JLabel(SIZE), new GBC(0, 1, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.selectedMediaSize, new GBC(1, 1, 1, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 10));
        this.selectedMediaSize.setToolTipText(EmulatedMedia.getSizeTip());
        jPanel2.add((Component)new JLabel(MARGIN), new GBC(0, 2, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.selectedMediaMargin, new GBC(1, 2, 2, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 0));
        this.selectedMediaMargin.setToolTipText(Margin.getTip());
        jPanel2.add((Component)new JLabel(PREPRINT), new GBC(0, 3, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 0));
        jPanel2.add((Component)this.selectedMediaPreprint, new GBC(1, 3, 2, 1, 0.0, 0.0, 17, 0, 10, 5, 0, 0));
        this.selectedMediaPreprint.setToolTipText(EmulatedMedia.getPreprintTip());
        jPanel.add((Component)jPanel2, "North");
    }

    public String getTitle() {
        return MediaModel.getTitle();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.choices.isSelectionEmpty()) {
            return;
        }
        String string = (String)this.choices.getSelectedValue();
        EmulatedMedia emulatedMedia = MediaModel.getMedia(string);
        this.paperCount.setText(Integer.toString(MediaModel.getPageCount()));
        this.paperLengthUnits.setSelectedIndex(MediaModel.getLengthUnitIndex());
        this.paperLength.setText(Integer.toString(MediaModel.getContinuousPaperLength()));
        this.selectedMediaSize.setText(emulatedMedia.getSizeString());
        this.selectedMediaMargin.setText(emulatedMedia.getMarginString());
        this.selectedMediaPreprint.setText(emulatedMedia.getPreprintString());
    }

    private int inchToCM(int n) {
        return (int)Math.ceil((double)n * 2.54);
    }

    private int getTextInteger(JTextField jTextField) {
        try {
            return Integer.parseInt(jTextField.getText());
        }
        catch (Exception exception) {
            return Integer.MIN_VALUE;
        }
    }

    private boolean validateIntegerRange(JTextField jTextField, int n, int n2) {
        int n3 = this.getTextInteger(jTextField);
        return n3 >= n && n3 <= n2;
    }

    public boolean validateChecked() {
        if (!this.validateIntegerRange(this.paperCount, paperCountMin, paperCountMax)) {
            JOptionPane.showMessageDialog(this, INVALID + PAPERCOUNT + this.paperCount.getText() + "\n" + VALID_PAPER_COUNT, this.getTitle(), 0);
            return false;
        }
        int n = this.paperLengthUnits.getSelectedIndex();
        int n2 = paperLengthMin;
        int n3 = paperLengthMax;
        if (0 != n) {
            n2 = this.inchToCM(n2);
            n3 = this.inchToCM(n3);
        }
        if (!this.validateIntegerRange(this.paperLength, n2, n3)) {
            JOptionPane.showMessageDialog(this, INVALID + PAPERLENGTH + this.paperLength.getText() + " " + this.paperLengthUnits.getSelectedItem() + "\r\n" + VALID_PAPER_LENGTH[n], this.getTitle(), 0);
            return false;
        }
        return true;
    }

    public void onOK() {
        if (this.choices.isSelectionEmpty()) {
            return;
        }
        MediaModel.setPageCount(Integer.parseInt(this.paperCount.getText()));
        MediaModel.setPapaerLength(Integer.parseInt(this.paperLength.getText()), this.paperLengthUnits.getSelectedIndex());
        MediaModel.setCurrentMediaName((String)this.choices.getSelectedValue());
        MediaModel.store();
    }

    static {
        VALID_PAPER_COUNT = null;
        VALID_PAPER_LENGTH = new String[2];
    }
}

