/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.setups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.setups.EscapeDialog;
import pios.emulator.printer.setups.SetupDefaultFontTab;
import pios.emulator.printer.setups.SetupMediaTab;
import pios.emulator.printer.setups.SetupResolutionTab;
import pios.emulator.ui.Accessability;
import pios.emulator.ui.PResourceBundle;

public final class SetupDialog
extends EscapeDialog
implements ActionListener {
    private static final String OK;
    private static final String CANCEL;
    private static final String PRINTERSETUP;
    private static final char MEDIA_MNEMONIC;
    private static final char DEFAULT_FONT_MNEMONIC;
    private static final char RESOLUTION_MNEMONIC;
    private JButton ok = new JButton(OK);
    private JButton cancel = new JButton(CANCEL);
    SetupMediaTab mediaTab;
    SetupDefaultFontTab defaultFontTab;
    SetupResolutionTab resolutionTab;
    private JTabbedPane tabbedPane = null;

    public SetupDialog(JFrame jFrame) {
        super(jFrame, PRINTERSETUP, true);
        this.setLocationRelativeTo(jFrame);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.ok.addActionListener(this);
        this.ok.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel.addActionListener(this);
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        this.getContentPane().add((Component)jPanel, "South");
        this.tabbedPane = new JTabbedPane();
        this.mediaTab = new SetupMediaTab();
        this.tabbedPane.addTab(this.mediaTab.getTitle(), null, this.mediaTab, "");
        this.defaultFontTab = new SetupDefaultFontTab();
        this.tabbedPane.addTab(this.defaultFontTab.getTitle(), null, this.defaultFontTab, "");
        this.resolutionTab = new SetupResolutionTab();
        this.tabbedPane.addTab(this.resolutionTab.getTitle(), null, this.resolutionTab, "");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.unifyButtonSize();
        this.pack();
    }

    private void unifyButtonSize() {
        JButton[] jButtonArray = new JButton[]{this.ok, this.cancel};
        Accessability.setButtonsPreferredSize((JButton[])jButtonArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok)) {
            this.onOK();
        } else if (actionEvent.getSource().equals(this.cancel)) {
            this.onCancel();
        }
    }

    private void onOK() {
        if (!this.mediaTab.validateChecked()) {
            this.tabbedPane.setSelectedComponent(this.mediaTab);
            return;
        }
        this.mediaTab.onOK();
        this.defaultFontTab.onOK();
        this.resolutionTab.onOK();
        if (PreferenceModel.getInstance().getBooleanProperty("reset.on.setup.change")) {
            PrinterEngine.reset();
        }
        this.onCancel();
    }

    private void onCancel() {
        this.setVisible(false);
    }

    protected void onEscape() {
        this.onCancel();
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        OK = pResourceBundle.getString("SetupDialog_OK");
        CANCEL = pResourceBundle.getString("SetupDialog_Cancel");
        PRINTERSETUP = pResourceBundle.getString("SetupDialog_PrinterSetup");
        MEDIA_MNEMONIC = pResourceBundle.getString("SetupDialog_Media.MNEMONIC").charAt(0);
        DEFAULT_FONT_MNEMONIC = pResourceBundle.getString("SetupDialog_DefaultFont.MNEMONIC").charAt(0);
        RESOLUTION_MNEMONIC = pResourceBundle.getString("SetupDialog_Resolution.MNEMONIC").charAt(0);
    }
}

